/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.task.AbstractDataPush;
import kd.isc.iscb.platform.core.task.DataPushUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.StringUtil;

public class PushDataCompParametersOfDay
extends AbstractDataPush {
    private static final Log logger = LogFactory.getLog(PushDataCompParametersOfDay.class);

    @Override
    public void pushData() {
        List objectList = QueryServiceHelper.queryPrimaryKeys((String)"isc_data_comp", null, null, (int)-1);
        int max = 300;
        List lists = Lists.partition((List)objectList, (int)max);
        for (List list : lists) {
            this.pushDataCompInfo(list);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushDataCompInfo(List<Object> dataCompIds) {
        ObjectReader<DataRow> dataCompReader = null;
        ArrayList<Object> dataList = new ArrayList<Object>(dataCompIds.size());
        Connection cn = this.getConnection();
        try {
            dataCompReader = this.getDataCompReader(dataCompIds, cn);
            DataRow dataRow = (DataRow)dataCompReader.read();
            while (dataRow != null) {
                Map<String, Object> dataCompInfo = this.getDataCompInfo(dataRow);
                dataList.add(dataCompInfo);
                dataRow = (DataRow)dataCompReader.read();
            }
        }
        catch (Exception e) {
            logger.warn("PushDataCompParametersOfDay:\u7ec4\u88c5\u6570\u636e\u5bf9\u6bd4\u65b9\u6848\u62a5\u8868\u4fe1\u606f\u5931\u8d25\uff1a" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
        }
        finally {
            DbUtil.close(dataCompReader);
            DbUtil.close((Connection)cn);
        }
        if (!dataList.isEmpty()) {
            DataPushUtil.pushData(dataList);
        }
    }

    private ObjectReader<DataRow> getDataCompReader(List<Object> schemaIds, Connection cn) {
        StringBuilder querySql = new StringBuilder();
        int idCount = schemaIds.size();
        ArrayList<Integer> types = new ArrayList<Integer>(idCount);
        querySql.append("select A.fid,A.fnumber,B.fname,A.fstrategy,A.fdata_copy, A.ftrigger,A.fauto_compensate , A.fisv,A.fsource_trace,A.fsource_tenant,A.fprotect_level from t_isc_data_comp  A  LEFT JOIN t_isc_data_comp_l B ON A.fid = B.fid AND B.flocaleid = 'zh_CN' WHERE A.fid IN (");
        for (int i = 0; i < idCount; ++i) {
            if (i == 0) {
                querySql.append('?');
            } else {
                querySql.append(", ?");
            }
            types.add(-5);
        }
        querySql.append(')');
        return DbUtil.executeQuery((Connection)cn, (String)querySql.toString(), schemaIds, types);
    }

    private Map<String, Object> getDataCompInfo(DataRow dataRow) {
        HashMap<String, Object> dataCompInfo = new HashMap<String, Object>(12);
        dataCompInfo.put("event_name", "t_isc_datacomp_parameters");
        PushDataCompParametersOfDay.setHeadInfo(dataCompInfo);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("datacomp_id", dataRow.get((Object)"fid"));
        map.put("fname", dataRow.get((Object)"fname"));
        map.put("fnumber", dataRow.get((Object)"fnumber"));
        map.put("fstrategy", this.cast2Desc(dataRow.get((Object)"fstrategy")));
        map.put("fdata_copy", dataRow.get((Object)"fdata_copy"));
        map.put("ftrigger", dataRow.get((Object)"ftrigger"));
        map.put("fisv", dataRow.get((Object)"fisv"));
        map.put("fprotect_level", dataRow.get((Object)"fprotect_level"));
        map.put("fsource_trace", dataRow.get((Object)"fsource_trace"));
        map.put("fsource_tenant", dataRow.get((Object)"fsource_tenant"));
        map.put("fauto_compensate", this.cast2Str(dataRow.get((Object)"fauto_compensate")));
        dataCompInfo.put("var", map);
        return dataCompInfo;
    }

    private String cast2Str(Object str) {
        if ("1".equals(str)) {
            return "\u662f";
        }
        return "\u5426";
    }

    private String cast2Desc(Object str) {
        if ("CheckExist".equals(str)) {
            return "\u76ee\u6807\u5355\u662f\u5426\u5b58\u5728";
        }
        if ("CheckUpdate".equals(str)) {
            return "\u76ee\u6807\u5355\u662f\u5426\u66f4\u65b0";
        }
        return D.s((Object)str);
    }
}

