/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.task.AbstractDataPush;
import kd.isc.iscb.platform.core.task.DataPushUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;

public class PushSchemaParametersOfDay
extends AbstractDataPush {
    private static final Log logger = LogFactory.getLog(PushSchemaParametersOfDay.class);

    @Override
    public void pushData() {
        List schemaIds = QueryServiceHelper.queryPrimaryKeys((String)"isc_data_copy", null, null, (int)-1);
        int max = 300;
        List schemaIdLists = Lists.partition((List)schemaIds, (int)max);
        for (List schemaIdList : schemaIdLists) {
            this.pushSchemaInfo(schemaIdList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushSchemaInfo(List<Object> schemaIds) {
        int size = schemaIds.size();
        Connection cn = this.getConnection();
        ObjectReader<DataRow> schemaReader = null;
        ArrayList<Object> dataList = new ArrayList<Object>(size);
        try {
            schemaReader = this.getSchemaReader(schemaIds, size, cn);
            DataRow schema = (DataRow)schemaReader.read();
            while (schema != null) {
                Map<String, Object> schemaInfo = this.getSchemaInfo(schema);
                dataList.add(schemaInfo);
                schema = (DataRow)schemaReader.read();
            }
        }
        catch (Exception e) {
            logger.warn("PushSchemaParametersOfDay:\u7ec4\u88c5\u96c6\u6210\u65b9\u6848\u62a5\u8868\u4fe1\u606f\u5931\u8d25\uff1a" + e);
        }
        finally {
            DbUtil.close(schemaReader);
            DbUtil.close((Connection)cn);
        }
        if (dataList.size() > 0) {
            DataPushUtil.pushData(dataList);
        }
    }

    private ObjectReader<DataRow> getSchemaReader(List<Object> schemaIds, int size, Connection cn) {
        StringBuilder querySql = new StringBuilder();
        ArrayList<Object> values = new ArrayList<Object>(size);
        ArrayList<Integer> types = new ArrayList<Integer>(size);
        querySql.append("SELECT A.fid,B.fname,A.fnumber,A.frecord_oid_log,A.frecord_oid_mappings,A.fsupports_file_copy,A.fmode FROM T_ISCB_DATA_COPY A LEFT JOIN T_ISCB_DATA_COPY_L B ON A.fid = B.fid AND B.flocaleid = 'zh_CN' WHERE A.fid IN (");
        for (int i = 0; i < size; ++i) {
            querySql.append('?');
            if (i < size - 1) {
                querySql.append(',');
            }
            values.add(schemaIds.get(i));
            types.add(-5);
        }
        querySql.append(')');
        return DbUtil.executeQuery((Connection)cn, (String)querySql.toString(), values, types);
    }

    private Map<String, Object> getSchemaInfo(DataRow schema) {
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        HashMap<String, Object> schemaInfo = new HashMap<String, Object>(16);
        PushSchemaParametersOfDay.setHeadInfo(map);
        map.put("event_name", "t_isc_schema_parameters");
        schemaInfo.put("schema_id", schema.get((Object)"fid"));
        schemaInfo.put("schema_name", schema.get((Object)"fname"));
        schemaInfo.put("schema_number", schema.get((Object)"fnumber"));
        schemaInfo.put("record_oid_log", this.cast2Str(schema.get((Object)"frecord_oid_log")));
        schemaInfo.put("record_oid_mappings", this.cast2Str(schema.get((Object)"frecord_oid_mappings")));
        schemaInfo.put("supports_file_copy", this.cast2Str(schema.get((Object)"fsupports_file_copy")));
        schemaInfo.put("mode", this.getModeValue(D.s((Object)schema.get((Object)"fmode"))));
        map.put("var", schemaInfo);
        return map;
    }

    private String cast2Str(Object str) {
        if ("1".equals(str)) {
            return "\u662f";
        }
        return "\u5426";
    }

    private String getModeValue(String str) {
        if (null == str) {
            return "\u9519\u8bef\u65f6\u4e2d\u6b62";
        }
        String name = null;
        switch (str) {
            case "RequiresTransaction": {
                name = "\u5355\u4e2a\u4e8b\u52a1";
                break;
            }
            case "BreakOnError": {
                name = "\u9519\u8bef\u65f6\u4e2d\u6b62";
                break;
            }
            case "ResumeOnError": {
                name = "\u9519\u8bef\u65f6\u5ffd\u7565";
                break;
            }
            default: {
                name = str;
            }
        }
        return name;
    }
}

