/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task.dataone;

import com.google.common.collect.Lists;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.platform.core.task.AbstractDataPush;
import kd.isc.iscb.platform.core.task.DataPushUtil;
import kd.isc.iscb.platform.core.task.dataone.Const;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.io.ObjectReader;

public class PushApiInvokeOfDay
extends AbstractDataPush
implements Const {
    private static final String className = "PushApiInvokeOfDay";
    private static final Log logger = LogFactory.getLog(PushApiInvokeOfDay.class);

    @Override
    public void pushData() {
        List apiInvokeIds = QueryServiceHelper.queryPrimaryKeys((String)"isc_api_invoke_stat", null, null, (int)-1);
        logger.info("PushApiInvokeOfDay:\u67e5\u8be2API\u8c03\u7528\u603b\u4e2a\u6570\uff1a" + apiInvokeIds.size());
        int max = 300;
        List apiInvokeIdsList = Lists.partition((List)apiInvokeIds, (int)max);
        for (List apiInvokeIdList : apiInvokeIdsList) {
            this.pushInfo(apiInvokeIdList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushInfo(List<Object> list) {
        int size = list.size();
        ArrayList<Object> dataList = new ArrayList<Object>(size);
        Connection cn = this.getConnection();
        ObjectReader<DataRow> reader = null;
        try {
            reader = this.getReader(cn, list, size);
            DataRow row = (DataRow)reader.read();
            while (row != null) {
                Map<String, Object> info = this.getInfo(row);
                dataList.add(info);
                row = (DataRow)reader.read();
            }
        }
        catch (Exception e) {
            logger.warn("PushApiInvokeOfDay :\u7ec4\u88c5API\u8c03\u7528\u62a5\u8868\u4fe1\u606f\u5931\u8d25\uff1a" + e);
        }
        finally {
            DbUtil.close(reader);
            DbUtil.close((Connection)cn);
        }
        int dataSize = dataList.size();
        if (dataSize > 0) {
            DataPushUtil.pushData(dataList);
        }
        logger.info("PushApiInvokeOfDay :\u672c\u6279\u6b21\u63a8\u9001API\u4e2a\u6570\uff1a" + dataSize);
    }

    private Map<String, Object> getInfo(DataRow api) {
        HashMap<String, Object> map = new HashMap<String, Object>(14);
        PushApiInvokeOfDay.setHeadInfo(map);
        map.put("event_name", "t_isc_api_invokeinfo");
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("api_id", api.get((Object)"fid"));
        info.put("api_type", api.get((Object)"fapi_type"));
        info.put("api_number", api.get((Object)"fapi_number"));
        info.put("api_name", api.get((Object)"fapi_name"));
        info.put("api_state", api.get((Object)"fapi_state"));
        info.put("invoke_count", api.get((Object)"finvoke_count"));
        info.put("success_count", api.get((Object)"fsuccess_count"));
        info.put("failed_count", api.get((Object)"ffailed_count"));
        info.put("last_invoke_time", api.get((Object)"flast_invoke_time"));
        map.put("var", info);
        return map;
    }

    private ObjectReader<DataRow> getReader(Connection cn, List<Object> apiIdList, int size) {
        StringBuilder querySql = new StringBuilder();
        ArrayList<Object> values = new ArrayList<Object>(size);
        ArrayList<Integer> types = new ArrayList<Integer>(size);
        querySql.append("select fid,fapi_type,fapi_number,fapi_name,fapi_state , finvoke_count,fsuccess_count,ffailed_count,flast_invoke_time from t_isc_api_invoke_stat  where fid in (");
        for (int i = 0; i < size; ++i) {
            querySql.append('?');
            if (i < size - 1) {
                querySql.append(',');
            }
            values.add(apiIdList.get(i));
            types.add(-5);
        }
        querySql.append(')');
        return DbUtil.executeQuery((Connection)cn, (String)querySql.toString(), values, types);
    }
}

