/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task.week;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.task.AbstractDataPush;
import kd.isc.iscb.platform.core.task.DataPushUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.StringUtil;

public class PushDataStreamTriggerParams
extends AbstractDataPush {
    private static final Log logger = LogFactory.getLog(PushDataStreamTriggerParams.class);

    @Override
    public void pushData() {
        this.pushDataStreamTriggerInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushDataStreamTriggerInfo() {
        ObjectReader<DataRow> reader = null;
        ArrayList<Object> dataList = new ArrayList<Object>(500);
        Connection cn = this.getConnection();
        try {
            reader = this.getReader(cn);
            DataRow tempRow = (DataRow)reader.read();
            if (tempRow == null) {
                return;
            }
            Map<String, Object> temp = this.getDataStreamTriggerInfo(tempRow);
            DataRow dataRow = (DataRow)reader.read();
            while (dataRow != null) {
                Map var = (Map)temp.get("var");
                if (var.get("fid").equals(dataRow.get((Object)"fid"))) {
                    var.put("fconnector_name", var.get("fconnector_name") + "," + dataRow.get((Object)"fconnector_name"));
                    temp.put("var", var);
                } else {
                    dataList.add(temp);
                    temp = this.getDataStreamTriggerInfo(dataRow);
                    if (dataList.size() >= 500) {
                        DataPushUtil.pushData(dataList);
                        dataList.clear();
                    }
                }
                dataRow = (DataRow)reader.read();
            }
            dataList.add(temp);
        }
        catch (Exception e) {
            logger.warn("DataStreamTriggerParams:\u7ec4\u88c5\u6570\u636e\u6d41\u542f\u52a8\u65b9\u6848\u62a5\u8868\u4fe1\u606f\u5931\u8d25\uff1a" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
        }
        finally {
            DbUtil.close(reader);
            DbUtil.close((Connection)cn);
        }
        if (!dataList.isEmpty()) {
            DataPushUtil.pushData(dataList);
        }
    }

    private ObjectReader<DataRow> getReader(Connection cn) {
        String querySql = "select A.fid,A.fnumber,A.fname,A.fmax_threads,A.fwork_area_size, A.flog_level,A.fcheckpoint ,            A.fmax_retry_times,A.fretry_interval,A.ffailed_notice,A.fsuccess_notice,B.fnumber as fjob_mutex ,A.fevent_type,C.fconnector_name                from t_iscx_datax_trigger  A left join t_isc_job_mutex B on A.fjob_mutex=B.fid  left join t_iscx_datax_connector C  on A.fid=C.fid order by A.fid ";
        return DbUtil.executeQuery((Connection)cn, (String)querySql, Collections.emptyList(), Collections.emptyList());
    }

    private Map<String, Object> getDataStreamTriggerInfo(DataRow dataRow) {
        HashMap<String, Object> info = new HashMap<String, Object>(12);
        info.put("event_name", "t_iscx_trigger_params_w");
        PushDataStreamTriggerParams.setHeadInfo(info);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("fid", dataRow.get((Object)"fid"));
        map.put("ftrigger_name", dataRow.get((Object)"fname"));
        map.put("ftrigger_number", dataRow.get((Object)"fnumber"));
        map.put("fevent_model", dataRow.get((Object)"fevent_type"));
        map.put("fmax_threads", dataRow.get((Object)"fmax_threads"));
        map.put("fconnector_name", dataRow.get((Object)"fconnector_name"));
        map.put("fwork_area_size", dataRow.get((Object)"fwork_area_size"));
        map.put("flog_level", dataRow.get((Object)"flog_level"));
        map.put("fcheckpoint", dataRow.get((Object)"fcheckpoint"));
        map.put("fmax_retry_times", dataRow.get((Object)"fmax_retry_times"));
        map.put("fretry_interval", dataRow.get((Object)"fretry_interval"));
        map.put("fjob_mutex", dataRow.get((Object)"fjob_mutex"));
        map.put("ffailed_notice", D.l((Object)dataRow.get((Object)"ffailed_notice")) == 0L ? "no" : "yes");
        map.put("fsuccess_notice", D.l((Object)dataRow.get((Object)"fsuccess_notice")) == 0L ? "no" : "yes");
        info.put("var", map);
        return info;
    }
}

