/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task.week;

import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.task.AbstractDataPush;
import kd.isc.iscb.platform.core.task.DataPushUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.StringUtil;

public class PushScriptConsumeTime
extends AbstractDataPush {
    private static final Log logger = LogFactory.getLog(PushScriptConsumeTime.class);

    @Override
    public void pushData() {
        this.pushInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushInfo() {
        ArrayList<Object> dataList = new ArrayList<Object>(300);
        Connection cn = this.getConnection();
        ObjectReader<DataRow> reader = null;
        try {
            int dataSize;
            reader = this.getReader(cn);
            int i = 0;
            DataRow row = (DataRow)reader.read();
            while (row != null) {
                if (D.l((Object)row.get((Object)"week_avg_consume_time")) > 1000L) {
                    Map<String, Object> info = this.getInfo(row);
                    dataList.add(info);
                    if (++i >= 10) break;
                }
                row = (DataRow)reader.read();
            }
            if ((dataSize = dataList.size()) > 0) {
                DataPushUtil.pushData(dataList);
            }
        }
        catch (Exception e) {
            logger.warn("PushScriptConsumeTime:\u7ec4\u88c5\u811a\u672c\u8017\u65f6\u4fe1\u606f\u5931\u8d25\uff1a" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
        }
        finally {
            DbUtil.close(reader);
            DbUtil.close((Connection)cn);
        }
    }

    private Map<String, Object> getInfo(DataRow row) {
        HashMap<String, Object> info = new HashMap<String, Object>(8);
        PushScriptConsumeTime.setHeadInfo(info);
        info.put("event_name", "t_isc_res_consume_stat");
        HashMap<String, Object> map = new HashMap<String, Object>(8);
        map.put("fres_type", row.get((Object)"fres_type"));
        map.put("fres_number", row.get((Object)"fres_number"));
        map.put("fremark", row.get((Object)"fremark"));
        map.put("week_avg_consume_time", row.get((Object)"week_avg_consume_time"));
        info.put("var", map);
        return info;
    }

    private ObjectReader<DataRow> getReader(Connection cn) {
        ArrayList<Timestamp> values = new ArrayList<Timestamp>(1);
        ArrayList<Integer> types = new ArrayList<Integer>(1);
        values.add(DataPushUtil.getMidNightTime(7));
        types.add(93);
        String querySql = " select fres_type,fres_number,fremark,sum(favg_consume_time)/count(favg_consume_time) as week_avg_consume_time from t_isc_res_consume_stat                  where frecord_time > ? and favg_consume_time > 0 group by fres_number,fres_type,fremark ORDER BY week_avg_consume_time desc  ";
        return DbUtil.executeQuery((Connection)cn, (String)querySql, values, types);
    }
}

