/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.Modify;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.apic.ApiCommonUtil;
import kd.isc.iscb.formplugin.apic.ApiTestFormUtil;
import kd.isc.iscb.formplugin.dc.tree.ApiTreeUtil;
import kd.isc.iscb.formplugin.sf.ScriptTextUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.OpenApiServiceUtil;
import kd.isc.iscb.platform.core.api.ApiClassify;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public abstract class AbstractApiFormPlugin
extends AbstractFormPlugin {
    public static final String DISABLE_API = "disableApi";
    protected static final Set<String> UPDATE_OPERATIONS = new HashSet<String>(16);
    protected static final Set<String> TEST = new HashSet<String>(Arrays.asList("api_test", "test", "do_test"));
    protected static final Set<String> SHOW_LOG = new HashSet<String>(Arrays.asList("show_log", "view_log"));
    protected static final Set<String> GEN_PDF = new HashSet<String>(Arrays.asList("gen_pdf", "generate_doc", "generate_pdf"));
    protected static final Set<String> ENABLE = new HashSet<String>(Arrays.asList("enable_btn", "bar_enable", "enable"));
    protected static final Set<String> DISABLE = new HashSet<String>(Arrays.asList("enable_btn", "bar_disable", "disable"));
    public static final String GEN_WORD = "generate_word";
    protected static final Set<String> AUTH = new HashSet<String>(Arrays.asList("authorize", "showauthlist"));
    public static final String IN_DIGEST = "in_digest";
    public static final String OUT_DIGEST = "out_digest";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{IN_DIGEST, OUT_DIGEST});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        long id = D.l((Object)this.getModel().getValue("id"));
        if (id <= 0L && UPDATE_OPERATIONS.contains(operationKey)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u6570\u636e\uff0c\u518d\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"AbstractApiFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        String entityName = this.getModel().getDataEntityType().getName();
        if (args.getSource() instanceof Save) {
            if (OpenApiServiceUtil.hasEnable(id, entityName)) {
                this.disable(args);
            } else {
                this.validateNumber(args);
            }
        } else if ("modify".equals(operationKey)) {
            ApiCommonUtil.setCancelFromEnable(this, args, entityName, ResManager.loadKDString((String)"API\u7981\u7528\u540e\u624d\u80fd\u4fee\u6539\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"AbstractApiFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if (this.isSuccess(evt)) {
            String entityName = this.getModel().getDataEntityType().getName();
            String operateKey = evt.getOperateKey();
            Object id = this.getModel().getValue("id");
            if ("authorize".equals(operateKey)) {
                DynamicObject api = BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName);
                OpenApiServiceUtil.authorize(this, api);
            } else if ("showauthlist".equals(operateKey)) {
                OpenApiServiceUtil.showAuthList(this, entityName);
            } else if ("enable".equals(operateKey)) {
                this.getView().setStatus(OperationStatus.VIEW);
            } else if (TEST.contains(operateKey)) {
                try {
                    this.apiTest(this.getView(), id);
                }
                catch (Exception e) {
                    FormOpener.showErrorMessage(this.getView(), e);
                }
            } else if (GEN_PDF.contains(operateKey)) {
                this.generatePdf(Collections.singletonList(id), this.getView());
            } else if (GEN_WORD.equals(operateKey)) {
                this.generateXml(Collections.singletonList(id), this.getView());
            } else if ("inputs_edit".equals(operateKey)) {
                ApiCommonUtil.showFastEdit(this, D.l((Object)id), "inputs", true, ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570", (String)"AbstractApiFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), entityName);
            } else if ("outputs_edit".equals(operateKey)) {
                ApiCommonUtil.showFastEdit(this, D.l((Object)id), "outputs", false, ResManager.loadKDString((String)"\u8f93\u51fa\u53c2\u6570", (String)"AbstractApiFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), entityName);
            } else if (evt.getSource() instanceof Save) {
                this.getView().setStatus(OperationStatus.VIEW);
                this.getView().cacheFormShowParameter();
                this.getView().setVisible(Boolean.TRUE, UPDATE_OPERATIONS.toArray(new String[0]));
            } else if (evt.getSource() instanceof Modify) {
                this.getView().setStatus(OperationStatus.EDIT);
                this.getView().setVisible(Boolean.FALSE, UPDATE_OPERATIONS.toArray(new String[0]));
            } else if ("disable".equals(operateKey)) {
                this.getView().setVisible(Boolean.TRUE, UPDATE_OPERATIONS.toArray(new String[0]));
            } else if (SHOW_LOG.contains(operateKey)) {
                ApiCommonUtil.openLog(this, evt);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        String key = ((Control)src).getKey();
        if (IN_DIGEST.equals(key) || OUT_DIGEST.equals(key)) {
            ScriptTextUtil.openDigestScriptForm(this.getModel().getValue(key), this, key, key);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("fast_returns".equals(actionId)) {
            ApiCommonUtil.returnDataToApi(this, evt);
        } else if (IN_DIGEST.equals(actionId) || OUT_DIGEST.equals(actionId)) {
            ScriptTextUtil.retryScriptFormCallBack(evt, this, this.getModel(), actionId);
        }
    }

    protected abstract void generateXml(List<Object> var1, IFormView var2);

    protected abstract void generatePdf(List<Object> var1, IFormView var2);

    private void disable(BeforeDoOperationEventArgs args) {
        args.setCancel(true);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(DISABLE_API, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"API\u7981\u7528\u540e\u624d\u80fd\u4fdd\u5b58\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"AbstractApiFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        if (DISABLE_API.equals(evt.getCallBackId())) {
            this.getView().invokeOperation("disable");
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().setVisible(Boolean.FALSE, UPDATE_OPERATIONS.toArray(new String[0]));
            this.getView().invokeOperation("refresh");
        }
    }

    public void afterBindData(EventObject e) {
        String entityId = ((BillView)e.getSource()).getEntityId();
        if ("isc_apic_by_dc_schema".equals(entityId) || "isc_apic_by_dc_trigger".equals(entityId) || "isc_apic_by_meta_schema".equals(entityId) || "isc_apic_by_vc".equals(entityId) || "isc_apic_for_external_api".equals(entityId)) {
            ApiTreeUtil.setCategory(this.getView());
        }
    }

    private void validateNumber(BeforeDoOperationEventArgs args) {
        String number = D.s((Object)this.getModel().getValue("number"));
        if (!OpenApiServiceUtil.isValid(number)) {
            this.getView().showTipNotification(OpenApiServiceUtil.getApiNumberPatternTips());
            args.setCancel(true);
        }
    }

    protected boolean isSuccess(AfterDoOperationEventArgs evt) {
        OperationResult result = evt.getOperationResult();
        return result != null && result.isSuccess();
    }

    protected void apiTest(IFormView view, Object pk) throws Exception {
        String entityName = view instanceof ListView ? ((ListView)view).getBillFormId() : this.getModel().getDataEntityType().getName();
        if ("isc_apic_script_x".equals(entityName)) {
            entityName = "isc_apic_script";
        }
        if ("isc_apic_script".equals(entityName) && !QueryServiceHelper.exists((String)entityName, (Object)pk)) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5728\u5f00\u653e\u5e73\u53f0->\u7b2c\u4e09\u65b9\u63a5\u53e3->API\u767b\u8bb0,\u6267\u884c\u542f\u7528/\u7981\u7528\u64cd\u4f5c,\u5c06API\u53d1\u5e03\u5230\u96c6\u6210\u7ba1\u7406,\u518d\u6267\u884c\u6d4b\u8bd5\u3002", (String)"AbstractApiFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject api = BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityName);
        if (!api.getBoolean("enable")) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528API\u540e\u518d\u6267\u884c\u6d4b\u8bd5\u3002", (String)"AbstractApiFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        if (!"isc_apic_mservice".equals(entityName) && !"isc_apic_script".equals(entityName) && !"isc_apic_by_sf".equals(entityName) && OpenApiServiceUtil.checkIllegalDbLink(api, view)) {
            return;
        }
        Map<String, Object> inputs = this.getTestInputParams(api);
        DynamicObject link = this.getLink();
        ApiTestFormUtil.openTestForm(view, api, ApiClassify.getPrefix((String)entityName), inputs, link);
    }

    protected abstract Map<String, Object> getTestInputParams(DynamicObject var1) throws Exception;

    private DynamicObject getLink() {
        DynamicObject link = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_database_link", (QFilter[])new QFilter[]{new QFilter("database_type", "=", (Object)"self")});
        if (link == null) {
            throw new IscBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u5f53\u524d\u8d26\u5957\u8fde\u63a5\uff0c\u65e0\u6cd5\u6d4b\u8bd5\uff0c\u8bf7\u81f3\u5c11\u5efa\u7acb\u4e00\u4e2a\u5f53\u524d\u8d26\u5957\u8fde\u63a5.", (String)"AbstractApiFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        return link;
    }

    protected void afterDoOperationExt(AfterDoOperationEventArgs evt) {
        if (this.isSuccess(evt)) {
            String operateKey = evt.getOperateKey();
            if (evt.getSource() instanceof Save) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_modify"});
            } else if (evt.getSource() instanceof Modify) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
            } else if (UPDATE_OPERATIONS.contains(operateKey)) {
                this.getView().setStatus(OperationStatus.VIEW);
            }
        }
    }

    protected void confirmCallBackExt(MessageBoxClosedEvent evt) {
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        if (DISABLE_API.equals(evt.getCallBackId())) {
            this.getView().invokeOperation("modify");
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_modify"});
        }
    }

    static {
        UPDATE_OPERATIONS.addAll(ENABLE);
        UPDATE_OPERATIONS.addAll(DISABLE);
        UPDATE_OPERATIONS.addAll(TEST);
        UPDATE_OPERATIONS.addAll(GEN_PDF);
        UPDATE_OPERATIONS.add(GEN_WORD);
        UPDATE_OPERATIONS.addAll(AUTH);
    }
}

