/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.OpenApiServiceUtil;
import kd.isc.iscb.platform.core.apic.IscLogFactory;
import kd.isc.iscb.util.dt.D;

public class ApiCommonUtil
extends AbstractFormPlugin {
    public static final String ROOT = "$ISC";

    public static Map<String, Map<String, Object>> getEntityProperties(IFormView view, String entityName) {
        boolean isInput = false;
        if ("inputs".equals(entityName)) {
            isInput = true;
        }
        DynamicObjectCollection entries = view.getModel().getDataEntity(true).getDynamicObjectCollection(entityName);
        HashMap<String, Map<String, Object>> map = new HashMap<String, Map<String, Object>>(entries.size());
        for (DynamicObject entry : entries) {
            String default_value;
            String name = isInput ? D.s((Object)entry.get("input_field")) : D.s((Object)entry.get("output_field"));
            String type = isInput ? D.s((Object)entry.get("input_data_type")) : D.s((Object)entry.get("output_data_type"));
            boolean isArray = isInput ? D.x((Object)entry.get("input_is_array")) : D.x((Object)entry.get("output_is_array"));
            boolean required = isInput && D.x((Object)entry.get("required"));
            String description = isInput ? D.s((Object)entry.get("input_description")) : D.s((Object)entry.get("output_description"));
            String string = default_value = isInput ? D.s((Object)entry.get("default_value")) : "";
            String dataName = name;
            if (dataName == null) continue;
            if (dataName.contains(".")) {
                dataName = dataName.substring(dataName.lastIndexOf(46) + 1);
            }
            HashMap<String, Object> data = new HashMap<String, Object>(5);
            data.put("name", dataName);
            data.put("type", type);
            data.put("isArray", isArray);
            data.put("required", required);
            data.put("description", description);
            data.put("default_value", default_value);
            map.put(name, data);
        }
        return map;
    }

    public static TreeNode getInitTreeFromProps(Map<String, Map<String, Object>> map) {
        TreeNode root = new TreeNode("", ROOT, ResManager.loadKDString((String)"\u5168\u90e8", (String)"ApiCommonUtil_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        HashMap<String, String> rootData = new HashMap<String, String>();
        rootData.put("name", ResManager.loadKDString((String)"\u5168\u90e8", (String)"ApiCommonUtil_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        rootData.put("type", "STRUCT");
        rootData.put("isArray", "");
        rootData.put("required", "");
        rootData.put("description", ResManager.loadKDString((String)"\u865a\u62df\u6839\u8282\u70b9", (String)"ApiCommonUtil_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        rootData.put("default_value", "");
        root.setData(rootData);
        if (map == null) {
            return root;
        }
        HashMap<String, List<Map<String, Object>>> newMap = new HashMap<String, List<Map<String, Object>>>();
        newMap.put(ROOT, new ArrayList());
        for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
            String key = entry.getKey();
            if (key.contains(".")) {
                int lastIndexOf = key.lastIndexOf(46);
                String parentKey = key.substring(0, lastIndexOf);
                if (map.get(parentKey) == null) continue;
                String newKey = "$ISC." + parentKey;
                newMap.computeIfAbsent(newKey, k -> new ArrayList());
                ((List)newMap.get(newKey)).add(entry.getValue());
                continue;
            }
            ((List)newMap.get(ROOT)).add(entry.getValue());
        }
        String parentId = ROOT;
        return ApiCommonUtil.initTreeNodes(newMap, root, parentId, parentId);
    }

    private static TreeNode initTreeNodes(Map<String, List<Map<String, Object>>> newMap, TreeNode root, String parentId, String rootNodeId) {
        List<Map<String, Object>> childList = newMap.get(parentId);
        ArrayList<TreeNode> lists = new ArrayList<TreeNode>(childList.size());
        for (Map<String, Object> childMap : childList) {
            String name = D.s((Object)childMap.get("name"));
            if (name == null) continue;
            String treeNodeId = parentId + "." + name;
            TreeNode node = new TreeNode(parentId, treeNodeId, name.contains(".") ? name.substring(name.lastIndexOf(46) + 1) : name);
            node.setData(childMap);
            List<Map<String, Object>> obj = newMap.get(treeNodeId);
            if (obj != null && !obj.isEmpty()) {
                ApiCommonUtil.initTreeNodes(newMap, node, treeNodeId, rootNodeId);
            }
            lists.add(node);
        }
        root.addChildren(lists);
        return root;
    }

    public static void setEntriesProps(TreeNode rootNode, DynamicObjectCollection entries, String entityName) {
        List children = rootNode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                String nodeId = D.s((Object)child.getId());
                String rootPrefix = "$ISC.";
                if (nodeId == null || !nodeId.contains(rootPrefix)) continue;
                String key = nodeId.replace(rootPrefix, "");
                Map data = (Map)child.getData();
                DynamicObject item = entries.addNew();
                ApiCommonUtil.innerSetProps(entityName, key, data, item);
                ApiCommonUtil.setEntriesProps(child, entries, entityName);
            }
        }
    }

    public static void innerSetProps(String entityName, String key, Map<String, Object> data, DynamicObject item) {
        if ("inputs".equals(entityName)) {
            item.set("input_field", (Object)key);
            item.set("input_data_type", data.get("type"));
            item.set("input_is_array", data.get("isArray"));
            item.set("required", data.get("required"));
            item.set("input_description", data.get("description"));
            item.set("default_value", data.get("default_value"));
        } else if ("outputs".equals(entityName)) {
            item.set("output_field", (Object)key);
            item.set("output_data_type", data.get("type"));
            item.set("output_is_array", data.get("isArray"));
            item.set("output_description", data.get("description"));
        }
    }

    public static TreeNode getNodeById(TreeNode rootnode, Object nodeId) {
        List children = rootnode.getChildren();
        if (nodeId == null) {
            return null;
        }
        if (nodeId.equals(rootnode.getId())) {
            return rootnode;
        }
        if (children != null) {
            for (TreeNode child : children) {
                TreeNode node = ApiCommonUtil.getNodeById(child, nodeId);
                if (node == null) continue;
                return node;
            }
        }
        return null;
    }

    public static void expandAllParentNodes(TreeNode rootnode, TreeView tree) {
        List children = rootnode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                ApiCommonUtil.expandAllParentNodes(child, tree);
            }
            tree.expand(rootnode.getId());
        }
    }

    public static void deleteNodeData(TreeNode rootnode, String focusNodeId) {
        List children = rootnode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                if (focusNodeId.equals(child.getId())) {
                    rootnode.deleteChildNode(focusNodeId);
                    return;
                }
                ApiCommonUtil.deleteNodeData(child, focusNodeId);
            }
        }
    }

    public static void updateFromParent(TreeNode rootNode, String newId) {
        List children = rootNode.getChildren();
        if (children != null) {
            for (TreeNode child : children) {
                child.setParentid(newId);
                Object data = child.getData();
                if (data instanceof Map) {
                    Object text = ((Map)data).get("name");
                    child.setId(newId + "." + text);
                }
                ApiCommonUtil.updateFromParent(child, child.getId());
            }
        }
    }

    public static boolean getAllowedEdit(long id, String entityName, IFormView view) {
        DynamicObject api;
        Object enable;
        BillShowParameter billShowParameter = (BillShowParameter)view.getFormShowParameter();
        boolean isView = billShowParameter.getBillStatus().equals((Object)BillOperationStatus.VIEW);
        if (isView) {
            return false;
        }
        boolean isAllowedEdit = true;
        if (id > 0L && "1".equals(enable = (api = BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName)).get("enable"))) {
            isAllowedEdit = false;
        }
        return isAllowedEdit;
    }

    public static boolean setCancelFromEnable(AbstractFormPlugin form, BeforeDoOperationEventArgs e, String apiaName, String s) {
        if (OpenApiServiceUtil.hasEnable(form.getView().getModel().getValue("id"), apiaName)) {
            e.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("disableApi", (IFormPlugin)form);
            form.getView().showConfirm(s, MessageBoxOptions.YesNo, confirmCallBacks);
            return true;
        }
        return false;
    }

    public static void showFastEdit(AbstractFormPlugin form, long id, String entriesName, boolean isInput, String title, String entityName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map<String, Map<String, Object>> properties = ApiCommonUtil.getEntityProperties(form.getView(), entriesName);
        TreeNode initTreeFromProps = ApiCommonUtil.getInitTreeFromProps(properties);
        params.put("node", initTreeFromProps);
        boolean isAllowedEdit = ApiCommonUtil.getAllowedEdit(id, entityName, form.getView());
        params.put("isAllowedEdit", isAllowedEdit);
        params.put("isInput", isInput);
        FormOpener.showForm(form, "isc_body_import_editor", title, params, "fast_returns");
    }

    public static void returnDataToApi(AbstractFormPlugin form, ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (returnData instanceof Map) {
            String fast_editor = D.s(((Map)returnData).get("fast_editor"));
            String entityName = D.s(((Map)returnData).get("entity_name"));
            boolean modity = D.x(((Map)returnData).get("modity"));
            if (!modity) {
                return;
            }
            if (fast_editor != null) {
                TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)fast_editor, TreeNode.class);
                DynamicObjectCollection entries = form.getView().getModel().getDataEntity(true).getDynamicObjectCollection(entityName);
                entries.clear();
                ApiCommonUtil.setEntriesProps(rootNode, entries, entityName);
                form.getView().updateView(entityName);
            }
        }
    }

    public static void openLog(AbstractFormPlugin form, AfterDoOperationEventArgs evt) {
        Object id = FormOpener.getSelectedId(form, evt);
        if (id != null) {
            if (IscLogFactory.shouldSaveToEs()) {
                List<QFilter> qFilters = ApiCommonUtil.buildFilterForEs(form, id);
                FormOpener.openBillList(form, "isc_es_log_item", qFilters);
            } else {
                FormOpener.showList(form, "isc_apic_log", "api.id", id);
            }
        }
    }

    public static void openLogFormForApiTask(AbstractFormPlugin form, AfterDoOperationEventArgs evt, String entityName) {
        Object id = FormOpener.getSelectedId(form, evt);
        if (id != null) {
            DynamicObject apiTaskSchema = BusinessDataServiceHelper.loadSingle((Object)id, (String)entityName);
            if (IscLogFactory.shouldSaveToEs()) {
                List<QFilter> filters = ApiCommonUtil.buildFiltersForEs(apiTaskSchema);
                FormOpener.openBillList(form, "isc_es_log_item", filters);
            } else {
                FormOpener.showList(form, "isc_apic_log", "api.id", apiTaskSchema.getLong("api_id"));
            }
        }
    }

    private static List<QFilter> buildFiltersForEs(DynamicObject apiTaskSchema) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        filters.add(new QFilter("billtype", "=", (Object)"isc_apic_log"));
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)apiTaskSchema.get("api_id"), (String)apiTaskSchema.getString("api_type"), (String)"number");
        filters.add(new QFilter("keywords", "like", (Object)("%" + obj.getString("number") + "%")));
        return filters;
    }

    private static List<QFilter> buildFilterForEs(AbstractFormPlugin form, Object id) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter qFilter = new QFilter("billtype", "=", (Object)"isc_apic_log");
        filters.add(qFilter);
        String entity = form.getView() instanceof IListView ? ((IListView)form.getView()).getBillFormId() : form.getView().getModel().getDataEntityType().getName();
        DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)entity, (String)"number");
        filters.add(new QFilter("keywords", "like", (Object)("%" + obj.getString("number") + "%")));
        return filters;
    }
}

