/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.isc.iscb.formplugin.apic.ApiCommonUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;

public class BodyImportEditorFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener {
    private static final String KEY_TREEVIEW = "treeviewap";
    private static final String CURRENT_NODE_ID = "CURRENT_NODE_ID";
    private static final String CURRENT_NODE_PARENTID = "CURRENT_NODE_PARENTID";
    private static final String ROOT = "ROOT";
    private static final String TEMP_ID = "$ISC_TEMP_ID";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String nodeStr = D.s(params.get("node"));
        this.getView().setVisible(Boolean.valueOf(D.x(params.get("isInput"))), new String[]{"field_default_value", "field_required"});
        boolean isAllowedEdit = D.x(params.get("isAllowedEdit"));
        this.getView().setEnable(Boolean.valueOf(isAllowedEdit), new String[]{"flexpanelap", "fieldconfigflex"});
        this.initTree(nodeStr);
        if (isAllowedEdit) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"btnok"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnok"});
        }
    }

    private void initTree(String nodeStr) {
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        if (nodeStr != null) {
            TreeNode treeNode = (TreeNode)SerializationUtils.fromJsonString((String)nodeStr, TreeNode.class);
            tree.addNode(treeNode);
            tree.updateNode(treeNode);
            tree.focusNode(treeNode);
            tree.expand(treeNode.getId());
            this.getPageCache().put(CURRENT_NODE_ID, treeNode.getId());
            this.getPageCache().put(CURRENT_NODE_PARENTID, treeNode.getParentid());
            this.setFieldConfigFlex(treeNode);
            ApiCommonUtil.expandAllParentNodes(treeNode, tree);
            this.getPageCache().put(ROOT, SerializationUtils.toJsonString((Object)treeNode));
        }
        this.getView().updateView();
    }

    private void setFieldConfigFlex(TreeNode treeNode) {
        Object data = treeNode.getData();
        if (data instanceof Map) {
            Map map = (Map)data;
            this.getModel().setValue("field_name", map.get("name"));
            this.getModel().setValue("field_type", map.get("type"));
            this.getModel().setValue("field_default_value", map.get("default_value"));
            this.getModel().setValue("field_desc", map.get("description"));
            this.getModel().setValue("field_is_array", map.get("isArray"));
            this.getModel().setValue("field_required", map.get("required"));
        }
        String current = this.getPageCache().get(CURRENT_NODE_ID);
        this.getView().setEnable(Boolean.valueOf(!this.isRoot(current)), new String[]{"field_name", "field_type", "field_default_value", "field_desc", "field_is_array", "field_required"});
    }

    private boolean isRoot(String current) {
        return "$ISC".equals(current);
    }

    private Map<String, Object> getDataFromFlex() {
        String newName = D.s((Object)this.getModel().getValue("field_name"));
        HashMap<String, Object> map = new HashMap<String, Object>(6);
        map.put("name", newName);
        map.put("type", D.s((Object)this.getModel().getValue("field_type")));
        map.put("default_value", D.s((Object)this.getModel().getValue("field_default_value")));
        map.put("description", D.s((Object)this.getModel().getValue("field_desc")));
        map.put("isArray", D.x((Object)this.getModel().getValue("field_is_array")));
        map.put("required", D.x((Object)this.getModel().getValue("field_required")));
        return map;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getPageCache().remove(ROOT);
        this.getPageCache().remove(CURRENT_NODE_ID);
        this.getPageCache().remove(CURRENT_NODE_PARENTID);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        TreeNode rootNode;
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        Object nodeId = evt.getNodeId();
        if (this.onlyViewNode(nodeId, rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(ROOT), TreeNode.class))) {
            return;
        }
        TreeNode lastNode = null;
        String lastNodeId = this.getPageCache().get(CURRENT_NODE_ID);
        if (lastNodeId != null) {
            lastNode = ApiCommonUtil.getNodeById(rootNode, lastNodeId);
            if (this.isLegal()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8282\u70b9\u5b57\u6bb5\u540d\u3001\u6570\u636e\u7c7b\u578b\u53ca\u5b57\u6bb5\u63cf\u8ff0\u3002", (String)"BodyImportEditorFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                tree.focusNode(lastNode);
                return;
            }
            if (this.saveLastNodeProps(rootNode, lastNode)) {
                return;
            }
        }
        if (nodeId.equals(lastNodeId) && lastNode != null) {
            nodeId = lastNode.getId();
        }
        this.getPageCache().put(CURRENT_NODE_ID, D.s((Object)nodeId));
        TreeNode clickNode = ApiCommonUtil.getNodeById(rootNode, nodeId);
        if (clickNode != null) {
            this.setFieldConfigFlex(clickNode);
            this.getPageCache().put(CURRENT_NODE_PARENTID, clickNode.getParentid());
        }
        tree.updateNode(rootNode);
        ApiCommonUtil.expandAllParentNodes(rootNode, tree);
        tree.focusNode(clickNode);
        this.getPageCache().put(ROOT, SerializationUtils.toJsonString((Object)rootNode));
        this.getView().updateView();
    }

    private boolean onlyViewNode(Object nodeId, TreeNode rootNode) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (!D.x(params.get("isAllowedEdit"))) {
            TreeNode checkNode = ApiCommonUtil.getNodeById(rootNode, nodeId);
            if (checkNode != null) {
                this.setFieldConfigFlex(checkNode);
                this.getPageCache().put(CURRENT_NODE_ID, D.s((Object)nodeId));
                this.getPageCache().put(CURRENT_NODE_PARENTID, checkNode.getParentid());
            }
            return true;
        }
        return false;
    }

    private boolean saveLastNodeProps(TreeNode rootNode, TreeNode lastNode) {
        if (lastNode != null) {
            if (this.isNodeExists(rootNode, lastNode)) {
                return true;
            }
            this.setNodeDataFromFlex(lastNode);
        }
        return false;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate oper;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && "delete_node".equalsIgnoreCase((oper = (AbstractOperate)args.getSource()).getOperateKey())) {
            List children;
            String currentId = this.getPageCache().get(CURRENT_NODE_ID);
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(ROOT), TreeNode.class);
            if ("$ISC".equals(currentId)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6811\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664", (String)"BodyImportEditorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            TreeNode currentNode = ApiCommonUtil.getNodeById(rootNode, currentId);
            if (currentNode != null && (children = currentNode.getChildren()) != null && children.size() != 0) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("ok", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u8be5\u5b57\u6bb5\u5c06\u4f1a\u540c\u65f6\u5220\u9664\u6240\u5305\u542b\u7684\u5206\u5f55\u5b57\u6bb5\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u5220\u9664\uff1f", (String)"BodyImportEditorFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (evt.getResult() == MessageBoxResult.Yes) {
            TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
            String currentId = this.getPageCache().get(CURRENT_NODE_ID);
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(ROOT), TreeNode.class);
            this.deleteNode(tree, currentId, rootNode);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        String currentId = this.getPageCache().get(CURRENT_NODE_ID);
        TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(ROOT), TreeNode.class);
        if ("add_node".equals(operateKey)) {
            if (this.addNode(tree, currentId, rootNode)) {
                return;
            }
        } else if ("delete_node".equalsIgnoreCase(operateKey)) {
            if ("$ISC".equals(currentId)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6811\u6839\u8282\u70b9\u4e0d\u5141\u8bb8\u5220\u9664", (String)"BodyImportEditorFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            this.deleteNode(tree, currentId, rootNode);
        } else if ("json_import".equals(operateKey)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("entityName", "isc_body_import_editor");
            FormOpener.showForm(this, "isc_import_json2dataset", null, params, "json_returns");
        }
        this.getView().updateView();
    }

    private boolean addNode(TreeView tree, String currentId, TreeNode rootNode) {
        TreeNode parentNode;
        TreeNode currentNode = ApiCommonUtil.getNodeById(rootNode, currentId);
        if (this.isLegal()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8282\u70b9\u5b57\u6bb5\u540d\u3001\u6570\u636e\u7c7b\u578b\u53ca\u5b57\u6bb5\u63cf\u8ff0\u3002", (String)"BodyImportEditorFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return true;
        }
        if (this.saveLastNodeProps(rootNode, currentNode)) {
            return true;
        }
        String fieldType = D.s((Object)this.getModel().getValue("field_type"));
        if (!"STRUCT".equals(fieldType) && (parentNode = ApiCommonUtil.getNodeById(rootNode, this.getPageCache().get(CURRENT_NODE_PARENTID))) != null) {
            this.getPageCache().put(CURRENT_NODE_ID, parentNode.getId());
            this.getPageCache().put(CURRENT_NODE_PARENTID, parentNode.getParentid());
        }
        this.resetFlexAfterNewNode();
        this.newTempNode(tree, rootNode);
        return false;
    }

    private void deleteNode(TreeView tree, String currentId, TreeNode rootNode) {
        ApiCommonUtil.deleteNodeData(rootNode, currentId);
        tree.updateNode(rootNode);
        ApiCommonUtil.expandAllParentNodes(rootNode, tree);
        TreeNode parentNode = ApiCommonUtil.getNodeById(rootNode, this.getPageCache().get(CURRENT_NODE_PARENTID));
        if (parentNode != null) {
            tree.focusNode(parentNode);
            this.getPageCache().put(CURRENT_NODE_ID, parentNode.getId());
            this.getPageCache().put(CURRENT_NODE_PARENTID, parentNode.getParentid());
            this.setFieldConfigFlex(parentNode);
        }
        this.getPageCache().put(ROOT, SerializationUtils.toJsonString((Object)rootNode));
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String action = closedCallBackEvent.getActionId();
        if (action.equals("json_returns") && (returnData = closedCallBackEvent.getReturnData()) instanceof Map) {
            Object jsonEditerTag = ((Map)returnData).get("jsonEditerTag");
            this.initTree(D.s(jsonEditerTag));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        Map parents = this.getView().getFormShowParameter().getCustomParams();
        if (src instanceof Button && "btnok".equals(((Button)src).getKey())) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
            TreeNode rootNode = (TreeNode)SerializationUtils.fromJsonString((String)this.getPageCache().get(ROOT), TreeNode.class);
            TreeNode lastNode = null;
            String lastNodeId = this.getPageCache().get(CURRENT_NODE_ID);
            if (lastNodeId != null) {
                lastNode = ApiCommonUtil.getNodeById(rootNode, lastNodeId);
                if (this.isLegal()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8282\u70b9\u5b57\u6bb5\u540d\u3001\u6570\u636e\u7c7b\u578b\u53ca\u5b57\u6bb5\u63cf\u8ff0\u3002", (String)"BodyImportEditorFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    tree.focusNode(lastNode);
                    return;
                }
                if (this.saveLastNodeProps(rootNode, lastNode)) {
                    return;
                }
            }
            params.put("fast_editor", SerializationUtils.toJsonString((Object)rootNode));
            params.put("entity_name", D.x(parents.get("isInput")) ? "inputs" : "outputs");
            params.put("modity", D.x(parents.get("isAllowedEdit")));
            this.getView().returnDataToParent(params);
            this.getView().close();
        }
    }

    private void newTempNode(TreeView tree, TreeNode rootnode) {
        String newNodeID = this.getPageCache().get(CURRENT_NODE_ID) + "." + D.s((Object)TEMP_ID);
        TreeNode newTempNode = new TreeNode(this.getPageCache().get(CURRENT_NODE_ID), newNodeID, ResManager.loadKDString((String)"\u672a\u547d\u540d", (String)"BodyImportEditorFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        TreeNode parentNode = ApiCommonUtil.getNodeById(rootnode, this.getPageCache().get(CURRENT_NODE_ID));
        if (parentNode != null) {
            parentNode.addChild(newTempNode);
        }
        tree.updateNode(rootnode);
        ApiCommonUtil.expandAllParentNodes(rootnode, tree);
        tree.expand(rootnode.getId());
        tree.focusNode(newTempNode);
        this.getPageCache().put(CURRENT_NODE_ID, newTempNode.getId());
        this.getPageCache().put(CURRENT_NODE_PARENTID, newTempNode.getParentid());
        this.getPageCache().put(ROOT, SerializationUtils.toJsonString((Object)rootnode));
        this.setFieldConfigFlex(newTempNode);
    }

    private void resetFlexAfterNewNode() {
        this.getModel().setValue("field_name", null);
        this.getModel().setValue("field_type", null);
        this.getModel().setValue("field_default_value", null);
        this.getModel().setValue("field_desc", null);
        this.getModel().setValue("field_is_array", (Object)Boolean.FALSE);
        this.getModel().setValue("field_required", (Object)Boolean.FALSE);
        this.getView().updateView();
    }

    private void setNodeDataFromFlex(TreeNode lastNode) {
        List children;
        Map<String, Object> data = this.getDataFromFlex();
        if (!"STRUCT".equals(D.s((Object)this.getModel().getValue("field_type"))) && (children = lastNode.getChildren()) != null) {
            this.deleteChildNode(lastNode, children);
        }
        String name = D.s((Object)data.get("name"));
        String id = lastNode.getId();
        id = this.getNewId(name, id);
        lastNode.setId(id);
        lastNode.setData(data);
        lastNode.setText(name);
        ApiCommonUtil.updateFromParent(lastNode, id);
        this.getPageCache().put(CURRENT_NODE_ID, lastNode.getId());
        this.getPageCache().put(CURRENT_NODE_PARENTID, lastNode.getParentid());
    }

    private String getNewId(String name, String id) {
        if (id != null && id.contains(".")) {
            id = id.substring(0, id.lastIndexOf(46) + 1) + name;
        }
        return id;
    }

    private void deleteChildNode(TreeNode lastNode, List<TreeNode> children) {
        ArrayList<String> nodeIdLists = new ArrayList<String>(children.size());
        for (TreeNode child : children) {
            nodeIdLists.add(child.getId());
        }
        for (String nodeIdList : nodeIdLists) {
            lastNode.deleteChildNode(nodeIdList);
        }
    }

    private boolean isNodeExists(TreeNode rootnode, TreeNode clickNode) {
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        TreeNode parentNode = ApiCommonUtil.getNodeById(rootnode, clickNode.getParentid());
        List children = parentNode != null ? parentNode.getChildren() : null;
        String clickNodeId = clickNode.getId();
        return children != null && this.innerCheck(clickNode, tree, children, clickNodeId);
    }

    private boolean innerCheck(TreeNode clickNode, TreeView tree, List<TreeNode> children, String clickNodeId) {
        for (TreeNode child : children) {
            if (child.getId().equals(clickNodeId)) continue;
            Object name = ((Map)child.getData()).get("name");
            if (!D.s((Object)this.getModel().getValue("field_name")).equals(name)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8282\u70b9\u201c\u5b57\u6bb5\u540d\u201d\u5728\u540c\u7ea7\u8282\u70b9\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u5f53\u524d\u8282\u70b9\u5b57\u6bb5\u540d\u3002", (String)"BodyImportEditorFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(2500));
            tree.focusNode(clickNode);
            return true;
        }
        return false;
    }

    private boolean isLegal() {
        String fieldName = D.s((Object)this.getModel().getValue("field_name"));
        String fieldType = D.s((Object)this.getModel().getValue("field_type"));
        String fieldDesc = D.s((Object)this.getModel().getValue("field_desc"));
        return fieldName == null || fieldType == null || fieldDesc == null;
    }
}

