/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.apic.ApiCommonUtil;
import kd.isc.iscb.formplugin.util.EventLogUtil;
import kd.isc.iscb.formplugin.util.ExportUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.api.ApiEventTriggerUtil;

public class CallApiByEvtListPlugin
extends AbstractListPlugin {
    private static final String META_NUMBER = "isc_call_api_by_evt";

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        ListSelectedRowCollection dataCollection = evt.getListSelectedData();
        if (evt.getSource() instanceof AbstractOperate && dataCollection.size() > 0) {
            AbstractOperate operate = (AbstractOperate)evt.getSource();
            String operateKey = operate.getOperateKey();
            try {
                if ("enable".equals(operateKey)) {
                    Object[] primaryKeyValues = dataCollection.getPrimaryKeyValues();
                    this.attachEvents(primaryKeyValues);
                } else if ("disable".equals(operateKey) || "delete".equals(operateKey)) {
                    Object[] primaryKeyValues = dataCollection.getPrimaryKeyValues();
                    this.detachEvents(primaryKeyValues);
                }
            }
            catch (Exception e) {
                evt.setCancel(true);
                FormOpener.showErrorMessage(this.getView(), e);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operationKey = evt.getOperateKey();
        try {
            if ("export".equalsIgnoreCase(operationKey)) {
                List pkIds = evt.getOperationResult().getSuccessPkIds();
                ExportUtil.exportDts((AbstractFormPlugin)this, pkIds, META_NUMBER);
            } else if ("import".equalsIgnoreCase(operationKey)) {
                FormOpener.openImportForm((IFormPlugin)this, this.getView(), META_NUMBER);
            } else if ("export_zip".equalsIgnoreCase(operationKey)) {
                ExportUtil.exportZip((AbstractFormPlugin)this, evt, META_NUMBER);
            } else if ("show_capi_log".equalsIgnoreCase(operationKey)) {
                ApiCommonUtil.openLogFormForApiTask((AbstractFormPlugin)this, evt, META_NUMBER);
            } else if ("show_event_log".equalsIgnoreCase(operationKey)) {
                EventLogUtil.showEventLogList((AbstractFormPlugin)this, "A", FormOpener.getSelectedId((AbstractFormPlugin)this, evt));
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"iscExportTaskCloseCallBack")) {
            ExportUtil.iscExportTaskCallBack((AbstractFormPlugin)this, evt.getReturnData());
        }
    }

    private void attachEvents(Object[] ids) {
        DynamicObject[] apiEvtTriggers;
        for (DynamicObject apiEvtTrigger : apiEvtTriggers = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)META_NUMBER))) {
            ApiEventTriggerUtil.attachEvents((DynamicObject)apiEvtTrigger);
        }
    }

    private void detachEvents(Object[] ids) {
        DynamicObject[] apiEvtTriggers;
        for (DynamicObject apiEvtTrigger : apiEvtTriggers = BusinessDataServiceHelper.load((Object[])ids, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)META_NUMBER))) {
            ApiEventTriggerUtil.detachEvents((DynamicObject)apiEvtTrigger);
        }
    }
}

