/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.apic.ApiCommonUtil;
import kd.isc.iscb.formplugin.util.ExportUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.dc.mq.ApiRounter;

public class CallApiByMqListPlugin
extends AbstractListPlugin {
    private static final String META_NUMBER = "isc_call_api_by_mq";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        try {
            if ("enable".equals(operateKey) || "disable".equals(operateKey) || "delete".equals(operateKey)) {
                ApiRounter.clearCache();
            }
        }
        catch (Exception e) {
            args.setCancel(true);
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operationKey = evt.getOperateKey();
        try {
            Object id;
            if ("export".equalsIgnoreCase(operationKey)) {
                List pkIds = evt.getOperationResult().getSuccessPkIds();
                ExportUtil.exportDts((AbstractFormPlugin)this, pkIds, META_NUMBER);
            } else if ("import".equalsIgnoreCase(operationKey)) {
                FormOpener.openImportForm((IFormPlugin)this, this.getView(), META_NUMBER);
            } else if ("export_zip".equalsIgnoreCase(operationKey)) {
                ExportUtil.exportZip((AbstractFormPlugin)this, evt, META_NUMBER);
            } else if ("show_capi_log".equalsIgnoreCase(operationKey)) {
                ApiCommonUtil.openLogFormForApiTask((AbstractFormPlugin)this, evt, META_NUMBER);
            } else if ("show_received_log".equalsIgnoreCase(operationKey) && (id = FormOpener.getSelectedId((AbstractFormPlugin)this, evt)) != null) {
                DynamicObject apiInfo = BusinessDataServiceHelper.loadSingle((Object)id, (String)META_NUMBER);
                FormOpener.showList((AbstractFormPlugin)this, "isc_mq_data_received", "message_queue.id", apiInfo.get("subscriber_id"));
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"iscExportTaskCloseCallBack")) {
            ExportUtil.iscExportTaskCallBack((AbstractFormPlugin)this, evt.getReturnData());
        }
    }
}

