/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic;

import java.sql.Timestamp;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.apic.ApiCommonUtil;
import kd.isc.iscb.formplugin.util.ExportUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.api.ApiTimerTriggerUtil;
import kd.isc.iscb.platform.core.api.TimerParam;
import kd.isc.iscb.util.dt.D;

public class CallApiByTimerListPlugin
extends AbstractListPlugin {
    private static final String META_NUMBER = "isc_call_api_by_timer";

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        ListSelectedRowCollection dataCollection = evt.getListSelectedData();
        if (evt.getSource() instanceof AbstractOperate && dataCollection.size() > 0) {
            AbstractOperate operate = (AbstractOperate)evt.getSource();
            String operateKey = operate.getOperateKey();
            try {
                if ("enable".equalsIgnoreCase(operateKey)) {
                    this.enableApiTimer(dataCollection);
                } else if ("disable".equalsIgnoreCase(operateKey)) {
                    this.disableApiTimer(dataCollection);
                }
            }
            catch (Exception e) {
                evt.setCancel(true);
                FormOpener.showErrorMessage(this.getView(), e);
            }
        }
    }

    private void disableApiTimer(ListSelectedRowCollection dataCollection) {
        Object[] primaryKeyValues;
        for (Object id : primaryKeyValues = dataCollection.getPrimaryKeyValues()) {
            ApiTimerTriggerUtil.disableTrigger((String)D.s((Object)id));
        }
    }

    private void enableApiTimer(ListSelectedRowCollection dataCollection) {
        Object[] primaryKeyValues;
        for (Object id : primaryKeyValues = dataCollection.getPrimaryKeyValues()) {
            DynamicObject dyo = BusinessDataServiceHelper.loadSingle((Object)id, (String)META_NUMBER);
            Timestamp startTime = D.t((Object)dyo.get("start_time"));
            Timestamp endTime = D.t((Object)dyo.get("end_time"));
            String interval = D.s((Object)dyo.get("interval"));
            String cronExpr = D.s((Object)dyo.get("cron_expr"));
            TimerParam timerParam = new TimerParam(cronExpr, startTime, endTime, interval);
            ApiTimerTriggerUtil.enableTrigger((String)dyo.getString("id"), (String)dyo.getString("name"), (String)dyo.getString("exe_job_user"), (TimerParam)timerParam);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        String operationKey = evt.getOperateKey();
        try {
            if ("export".equalsIgnoreCase(operationKey)) {
                List pkIds = evt.getOperationResult().getSuccessPkIds();
                ExportUtil.exportDts((AbstractFormPlugin)this, pkIds, META_NUMBER);
            } else if ("import".equalsIgnoreCase(operationKey)) {
                FormOpener.openImportForm((IFormPlugin)this, this.getView(), META_NUMBER);
            } else if ("export_zip".equalsIgnoreCase(operationKey)) {
                ExportUtil.exportZip((AbstractFormPlugin)this, evt, META_NUMBER);
            } else if ("show_capi_log".equalsIgnoreCase(operationKey)) {
                ApiCommonUtil.openLogFormForApiTask((AbstractFormPlugin)this, evt, META_NUMBER);
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"iscExportTaskCloseCallBack")) {
            ExportUtil.iscExportTaskCallBack((AbstractFormPlugin)this, evt.getReturnData());
        }
    }
}

