/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.mvc.bill.BillView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.apic.AbstractApiFormPlugin;
import kd.isc.iscb.formplugin.apic.Util;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.cache.data.DataCopySchema;
import kd.isc.iscb.platform.core.connector.apic.doc.ExportDocForDataCopySchemaAPI;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ExportSchemaApiToXml;
import kd.isc.iscb.platform.core.util.ApiToXmlUtil;
import kd.isc.iscb.platform.core.util.ExportAndImportFormUtil;
import kd.isc.iscb.util.dt.D;

public class DataCopySchemaAPIFormPlugin
extends AbstractApiFormPlugin {
    private static final String FIELD_DATA_SOURCE = "data_source";
    private static final String ISC_DATA_COPY = "isc_data_copy";
    private static final String ISC_APIC_BY_DC_SCHEMA = "isc_apic_by_dc_schema";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String BTN_API_TEST = "api_test";
    private static final String FLEXPANELAP = "flexpanelap";
    private static final String PARAM_VIEW = "param_example";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_API_TEST, FLEXPANELAP, PARAM_VIEW});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String prop = e.getProperty().getName();
        long id = D.l((Object)this.getModel().getValue("schema_id"));
        String type = D.s((Object)this.getModel().getValue("type"));
        if (id == 0L) {
            return;
        }
        if ("schema".equals(prop)) {
            DynamicObject dc = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_DATA_COPY, (String)FIELD_DATA_SOURCE);
            this.getModel().setValue("group", dc.get("data_source_id"));
            this.generateNumberAndName(type, dc);
            this.viewParamAndResult(D.l((Object)dc.getPkValue()));
        } else if ("type".equals(prop)) {
            DynamicObject dc = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_DATA_COPY, (String)FIELD_DATA_SOURCE);
            this.generateNumberAndName(type, dc);
            this.viewParamAndResult(D.l((Object)dc.getPkValue()));
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        BillView source;
        BillShowParameter formShowParameter;
        BillOperationStatus billStatus;
        super.afterBindData(e);
        long id = D.l((Object)this.getModel().getValue("schema_id"));
        if (e.getSource() instanceof BillView && (billStatus = (formShowParameter = (BillShowParameter)(source = (BillView)e.getSource()).getFormShowParameter()).getBillStatus()) == BillOperationStatus.VIEW) {
            this.viewParamAndResult(id);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        long id = D.l((Object)this.getModel().getValue("schema_id"));
        if (args.getSource() instanceof Save) {
            this.viewParamAndResult(id);
        }
    }

    private void viewParamAndResult(long schema_id) {
        if (schema_id > 0L) {
            String type = D.s((Object)this.getModel().getValue("type"));
            DynamicObject schema = DataCopySchema.get((long)schema_id);
            DynamicObject srcMeta = BusinessDataServiceHelper.loadSingle((Object)schema.getDynamicObject("source_schema").getPkValue(), (String)"isc_metadata_schema");
            DynamicObject tarMeta = BusinessDataServiceHelper.loadSingle((Object)schema.getDynamicObject("target_schema").getPkValue(), (String)"isc_metadata_schema");
            DynamicObjectCollection param_entity = this.getModel().getDataEntity().getDynamicObjectCollection("param_entryentity");
            if (DataCopySchemaAPIFormPlugin.setParams(type, schema, srcMeta, param_entity)) {
                return;
            }
            this.getModel().getDataEntity(true).set("param_entryentity", (Object)param_entity);
            this.getView().updateView("param_entryentity");
            DynamicObjectCollection result_entity = this.getModel().getDataEntity().getDynamicObjectCollection("result_entryentity");
            result_entity.clear();
            this.setResult(type, schema, tarMeta, result_entity);
            this.getModel().getDataEntity(true).set("result_entryentity", (Object)result_entity);
            this.getView().updateView("result_entryentity");
            DynamicObject api = this.getModel().getDataEntity();
            String res = Util.getJson(api, type, schema, 0L);
            Markdown mk = (Markdown)this.getView().getControl("json_expr");
            mk.setText("```json \n" + res + " \n");
        }
    }

    private void setResult(String type, DynamicObject schema, DynamicObject tarMeta, DynamicObjectCollection result_entity) {
        if ("TRANSFER".equals(type) || "PULL".equals(type)) {
            DynamicObjectCollection collection = schema.getDynamicObjectCollection("mapping_entries");
            for (DynamicObject it : collection) {
                String tarDesc;
                String dataType;
                String mappingTarColumn = it.getString("mapping_tar_column");
                if (mappingTarColumn.isEmpty()) continue;
                List alias = ApiToXmlUtil.getAlias((DynamicObject)schema);
                int i = mappingTarColumn.indexOf(46);
                if (!alias.isEmpty() && i > 0 && alias.contains(mappingTarColumn.substring(0, i))) {
                    DynamicObject smeta = ApiToXmlUtil.getMetaByAlias((DynamicObject)schema, (String)mappingTarColumn.substring(0, i));
                    dataType = ApiToXmlUtil.getProperty((DynamicObject)smeta, (String)mappingTarColumn.substring(i + 1), (String)"data_type");
                    tarDesc = ApiToXmlUtil.getProperty((DynamicObject)smeta, (String)mappingTarColumn.substring(i + 1), (String)"prop_label");
                } else {
                    dataType = ApiToXmlUtil.getProperty((DynamicObject)tarMeta, (String)mappingTarColumn, (String)"data_type");
                    tarDesc = ApiToXmlUtil.getProperty((DynamicObject)tarMeta, (String)mappingTarColumn, (String)"prop_label");
                }
                DynamicObject aNew = result_entity.addNew();
                aNew.set("res_field", (Object)mappingTarColumn);
                if (dataType != null) {
                    aNew.set("res_type", (Object)ApiToXmlUtil.translateType((String)dataType));
                }
                aNew.set("res_remark", (Object)tarDesc);
            }
        } else {
            this.fullResult(result_entity, "id", ResManager.loadKDString((String)"\u4e3b\u952e", (String)"DataCopySchemaAPIFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.fullResult(result_entity, "type", ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b", (String)"DataCopySchemaAPIFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.fullResult(result_entity, "srcId", ResManager.loadKDString((String)"\u6e90\u5355id", (String)"DataCopySchemaAPIFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.fullResult(result_entity, "tarId", ResManager.loadKDString((String)"\u76ee\u6807\u5355id", (String)"DataCopySchemaAPIFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.fullResult(result_entity, "errorMessage", ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"DataCopySchemaAPIFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public static boolean setParams(String type, DynamicObject schema, DynamicObject srcMeta, DynamicObjectCollection param_entity) {
        if ("EXECUTE".equals(type) || "PULL".equals(type)) {
            DynamicObjectCollection collection = schema.getDynamicObjectCollection("param_entries");
            if (collection.size() > 0) {
                param_entity.clear();
                for (DynamicObject object : collection) {
                    DynamicObject aNew = param_entity.addNew();
                    aNew.set("param_field", object.get("params_name"));
                    aNew.set("param_remark", object.get("params_remark"));
                    aNew.set("param_type", (Object)ApiToXmlUtil.translateType((String)D.s((Object)object.get("params_data_type"))));
                }
            }
        } else if ("PUSH".equals(type) || "TRANSFER".equals(type)) {
            DynamicObjectCollection collection = schema.getDynamicObjectCollection("mapping_entries");
            for (DynamicObject it : collection) {
                String dataType;
                String srcDesc;
                String mappingSrcColumn = it.getString("mapping_src_column");
                if (mappingSrcColumn.isEmpty()) continue;
                int i = mappingSrcColumn.indexOf(46);
                List alias = ApiToXmlUtil.getAlias((DynamicObject)schema);
                if (!alias.isEmpty() && i > 0 && alias.contains(mappingSrcColumn.substring(0, i))) {
                    DynamicObject smeta = ApiToXmlUtil.getMetaByAlias((DynamicObject)schema, (String)mappingSrcColumn.substring(0, i));
                    srcDesc = ApiToXmlUtil.getProperty((DynamicObject)smeta, (String)mappingSrcColumn.substring(i + 1), (String)"prop_label");
                    dataType = ApiToXmlUtil.getProperty((DynamicObject)smeta, (String)mappingSrcColumn.substring(i + 1), (String)"data_type");
                } else {
                    dataType = ApiToXmlUtil.getProperty((DynamicObject)srcMeta, (String)mappingSrcColumn, (String)"data_type");
                    srcDesc = ApiToXmlUtil.getProperty((DynamicObject)srcMeta, (String)mappingSrcColumn, (String)"prop_label");
                }
                DynamicObject aNew = param_entity.addNew();
                aNew.set("param_field", (Object)mappingSrcColumn);
                if (dataType != null) {
                    aNew.set("param_type", (Object)ApiToXmlUtil.translateType((String)dataType));
                }
                aNew.set("param_remark", (Object)srcDesc);
            }
        } else {
            return true;
        }
        return false;
    }

    private void fullResult(DynamicObjectCollection result_entity, String field, String content) {
        DynamicObject aNew = result_entity.addNew();
        aNew.set("res_field", (Object)field);
        aNew.set("res_type", (Object)ResManager.loadKDString((String)"\u5b57\u7b26\u4e32", (String)"DataCopySchemaAPIFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        aNew.set("res_remark", (Object)content);
    }

    private void generateNumberAndName(String type, DynamicObject dc) {
        if (type != null) {
            if ("TRANSFER".equals(type) || "PUSH".equals(type)) {
                this.getModel().setValue("max_count", (Object)1000);
                this.getModel().setValue("ignore_error", (Object)Boolean.FALSE);
            }
            this.getModel().setValue(NUMBER, (Object)(dc.getString(NUMBER).replaceAll("[^0-9a-zA-Z_-]", "_") + "_" + type));
            this.getModel().setValue(NAME, (Object)(dc.getString(NAME) + "_" + type));
        }
    }

    @Override
    protected Map<String, Object> getTestInputParams(DynamicObject api) {
        DynamicObject dataCopy = BusinessDataServiceHelper.loadSingle((Object)api.get("schema_id"), (String)ISC_DATA_COPY);
        return Util.getDataCopyInputParams(api.getString("type"), dataCopy);
    }

    @Override
    protected void generateXml(List<Object> successPkIds, IFormView view) {
        DynamicObject[] datacopyApis;
        for (DynamicObject api : datacopyApis = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ISC_APIC_BY_DC_SCHEMA))) {
            try {
                new ExportSchemaApiToXml(api).export(view);
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(view, e);
            }
        }
    }

    @Override
    protected void generatePdf(List<Object> successPkIds, IFormView view) {
        for (Object id : successPkIds) {
            DynamicObject schemaApi = BusinessDataServiceHelper.loadSingle((Object)id, (String)ISC_APIC_BY_DC_SCHEMA);
            try {
                String filePath = ExportDocForDataCopySchemaAPI.generateDoc((DynamicObject)schemaApi);
                String fileName = ExportAndImportFormUtil.getDownloadFileName((DynamicObject)schemaApi);
                ExportAndImportFormUtil.download((IFormView)view, (String)filePath, (String)(fileName + ".pdf"));
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(view, e);
            }
        }
    }
}

