/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.apic.AbstractApiFormPlugin;
import kd.isc.iscb.formplugin.apic.OPERATION;
import kd.isc.iscb.formplugin.apic.ObjType;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.apic.doc.ExportDocForMetaSchemaAPI;
import kd.isc.iscb.platform.core.connector.apic.doc.JsonSampleUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ExportMetaApiToXml;
import kd.isc.iscb.platform.core.connector.apic.doc.meta.MetaApiDocBuilder;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.platform.core.util.ExportAndImportFormUtil;
import kd.isc.iscb.util.connector.server.MetaType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class MetaSchemaAsAPIFormPlugin
extends AbstractApiFormPlugin
implements CellClickListener {
    private static final String DATA_SCHEMA = "data_schema";
    private static final String INPUT_IS_JUDGE_KEY = "input_is_judge_key";
    private static final String INPUT_IS_REQUIRED = "input_is_required";
    private static final String INPUT_IS_PK = "input_is_pk";
    private static final String FULL_NAME = "full_name";
    private static final String CACHE_ERROR_FIELDS = "errorFields";
    private static final String FILL_INPUT_FIELDS = "fill_input_fields";
    private static final String TYPE_STRING = "string";
    private static final String TYPE2 = "type";
    private static final String PROP_LABEL = "prop_label";
    private static final String PROP_NAME = "prop_name";
    private static final String ENTRIES_PROP_ENTRYENTITY = "prop_entryentity";
    private static final String PARAM_TYPE_FIELD_SUFFIX = "_field";
    private static final String ISC_APIC_BY_META_SCHEMA = "isc_apic_by_meta_schema";
    private static final String FILTER_VALUE = "filter_value";
    private static final String TAB_CUS_FILTER = "tabcusfilter";
    private static final String METADATA2 = "metadata";
    private static final String ENTRIES2 = "ENTRIES";
    private static final String REQUIRED = "required";
    private static final String IS_PRIMARY_KEY2 = "is_primary_key";
    private static final String DATA_TYPE2 = "data_type";
    private static final String OUTPUT_DESCRIPTION2 = "output_description";
    private static final String INPUT_DESCRIPTION2 = "input_description";
    private static final String OUTPUT_FIELD2 = "output_field";
    private static final String INPUT_FIELD2 = "input_field";
    private static final String OUTPUT_DATA_TYPE2 = "output_data_type";
    private static final String INPUT_DATA_TYPE2 = "input_data_type";
    private static final String OUTPUTS2 = "outputs";
    private static final String INPUTS2 = "inputs";
    private static final String OP_RESULT_TYPE = "isc_operation_result_type";
    private static final String BATCH_ADD = "batch_add";
    private static final String INPUTS = "inputs";
    private static final String OUTPUTS = "outputs";
    private static final String INPUT = "input";
    private static final String OUTPUT = "output";
    private static final String IS_PRIMARY_KEY = "is_primary_key";
    private static final String OUTPUT_DATA_TYPE = "output_data_type";
    private static final String INPUT_DATA_TYPE = "input_data_type";
    private static final String METADATA_ID = "metadata_id";
    private static final String TYPE = "$type";
    private static final String OPERATOR = "operation";
    private static final String OUTPUT_DESCRIPTION = "output_description";
    private static final String INPUT_DESCRIPTION = "input_description";
    private static final String INPUT_FIELD = "input_field";
    private static final String OUTPUT_FIELD = "output_field";
    private static final String ISC_METADATA_SCHEMA = "isc_metadata_schema";
    private static final String DATA_TYPE = "data_type";
    private static final String FULL_NUMBER = "full_number";
    private static final String ENTRIES = "ENTRIES";
    private static final String DISABLE_API = "disableApi";
    private static final String METADATA = "metadata";
    private static final String FILTER_ENTRIES = "filter_entries";
    private static final String FILTER_FIELD = "filter_column";
    private static final int SHOW_TIP_MS = 5000;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid inputs = (EntryGrid)this.getView().getControl("inputs");
        EntryGrid outputs = (EntryGrid)this.getView().getControl("outputs");
        inputs.addCellClickListener((CellClickListener)this);
        outputs.addCellClickListener((CellClickListener)this);
        EntryGrid filterEntries = (EntryGrid)this.getView().getControl(FILTER_ENTRIES);
        filterEntries.addCellClickListener((CellClickListener)this);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener(new TabSelectListener(){

            public void tabSelected(TabSelectEvent event) {
                if (MetaSchemaAsAPIFormPlugin.TAB_CUS_FILTER.equals(event.getTabKey())) {
                    MetaSchemaAsAPIFormPlugin.this.setFilterValueCombo();
                }
            }
        });
    }

    private void trimEntryFiled(String entryName, String filed) {
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(entryName);
        boolean hasBlank = false;
        for (DynamicObject object : collection) {
            String trimField;
            String field = object.getString(filed);
            if (Objects.equals(field, trimField = D.s((Object)field))) continue;
            object.set(filed, (Object)trimField);
            hasBlank = true;
        }
        if (hasBlank) {
            this.getView().updateView(entryName);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            if (!this.checkEntity(INPUT) || !this.checkEntity(OUTPUT)) {
                args.setCancel(true);
                return;
            }
            this.trimEntryFiled(FILTER_ENTRIES, FILTER_VALUE);
            this.trimEntryFiled(FILTER_ENTRIES, FILTER_FIELD);
            this.trimEntryFiled("inputs", "input_field");
            this.trimEntryFiled("outputs", "output_field");
            Object value = this.getModel().getValue(OPERATOR);
            if (OPERATION.QUERY.name().equals(value) || OPERATION.SQL_EXECUTE_R.name().equals(value)) {
                DynamicObjectCollection outputs = this.getModel().getDataEntity(true).getDynamicObjectCollection("outputs");
                if (outputs == null || outputs.isEmpty()) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u64cd\u4f5c\u8f93\u51fa\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"MetaSchemaAsAPIFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), OPERATION.getDesc(D.s((Object)value))), Integer.valueOf(5000));
                    args.setCancel(true);
                    return;
                }
                if (this.hasJudgeInput()) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u64cd\u4f5c\u8f93\u5165\u4e0d\u652f\u6301\u5206\u5f55\u6570\u636e\u7c7b\u578b\u5b57\u6bb5", (String)"MetaSchemaAsAPIFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), OPERATION.getDesc(D.s((Object)value))), Integer.valueOf(5000));
                    args.setCancel(true);
                    return;
                }
                if (this.hasJudgeOutput(outputs)) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u64cd\u4f5c\u8f93\u51fa\u4e0d\u652f\u6301\u5206\u5f55\u6570\u636e\u7c7b\u578b\u5b57\u6bb5", (String)"MetaSchemaAsAPIFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), OPERATION.getDesc(D.s((Object)value))), Integer.valueOf(5000));
                    args.setCancel(true);
                    return;
                }
                DynamicObjectCollection filters = this.getModel().getDataEntity(true).getDynamicObjectCollection(FILTER_ENTRIES);
                if (!CollectionUtils.isEmpty((Collection)filters)) {
                    DynamicObjectCollection inputs = this.getModel().getDataEntity(true).getDynamicObjectCollection("inputs");
                    HashSet<String> set = new HashSet<String>(inputs.size());
                    for (DynamicObject input : inputs) {
                        set.add(input.getString("input_field"));
                    }
                    for (DynamicObject filter : filters) {
                        String filterColumn = filter.getString(FILTER_FIELD);
                        String filterValue = filter.getString(FILTER_VALUE);
                        if (StringUtil.isEmpty((String)filterColumn) || StringUtil.isEmpty((String)filterValue)) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6761\u4ef6\u7684\u6761\u4ef6\u5b57\u6bb5\u548c\u6bd4\u8f83\u53d8\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (String)"MetaSchemaAsAPIFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
                            args.setCancel(true);
                            return;
                        }
                        if (set.contains(filterValue)) continue;
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6761\u4ef6\u7684\u6761\u4ef6\u5b57\u6bb5\u201c%s\u201d\u6bd4\u8f83\u53d8\u91cf\u4e0d\u5b58\u5728", (String)"MetaSchemaAsAPIFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), filterColumn), Integer.valueOf(5000));
                        args.setCancel(true);
                        return;
                    }
                }
                this.removeSaveDataType();
            } else if (OPERATION.EXECUTE.name().equals(value)) {
                long metadataId = this.getModel().getDataEntity().getLong(METADATA_ID);
                DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)metadataId, (String)ISC_METADATA_SCHEMA);
                String typeName = meta.getString(TYPE2);
                if (MetaType.QUERY.name().equalsIgnoreCase(typeName)) {
                    return;
                }
                this.resetOutputsByExecuteAction(meta);
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"%s\u64cd\u4f5c\u4f1a\u81ea\u52a8\u5e26\u51fa\u6240\u6709\u8f93\u51fa\u53c2\u6570", (String)"MetaSchemaAsAPIFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), value));
            } else {
                if (!this.checkInputs(args)) {
                    return;
                }
                this.resetOutputsByNotQueryAction(value);
            }
        }
    }

    private boolean checkEntity(String type) {
        String title = INPUT.equals(type) ? ResManager.loadKDString((String)"\u8f93\u5165", (String)"MetaSchemaAsAPIFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8f93\u51fa", (String)"MetaSchemaAsAPIFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        String field = type + PARAM_TYPE_FIELD_SUFFIX;
        DynamicObjectCollection entries = this.getFieldEntries(type);
        if (entries.stream().anyMatch(it -> StringUtil.isEmpty((String)it.getString(field)))) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u53c2\u6570\u5b58\u5728\u5b57\u6bb5\u540d\u4e3a\u7a7a", (String)"MetaSchemaAsAPIFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), title), Integer.valueOf(5000));
            return false;
        }
        HashSet<String> set = new HashSet<String>(entries.size());
        HashSet<String> existSet = new HashSet<String>(entries.size());
        for (DynamicObject entity : entries) {
            String fieldValue = entity.getString(field);
            if (!set.add(fieldValue)) {
                existSet.add(fieldValue);
            }
            if (!fieldValue.contains(".")) continue;
            String str = fieldValue.substring(0, fieldValue.lastIndexOf(46));
            int points = StringUtil.count((String)str, (String)".");
            Supplier<Stream> supplier = () -> entries.stream().map(it -> it.getString(field));
            boolean b = points == 0 ? supplier.get().anyMatch(it -> !it.contains(".")) : supplier.get().anyMatch(it -> it.startsWith(str.substring(0, str.lastIndexOf(46))) && StringUtil.count((String)it, (String)".") == points);
            if (b) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u53c2\u6570\uff1a%2$s \u6ca1\u6709\u6dfb\u52a0\u4e0a\u7ea7\u5b57\u6bb5\uff0c\u8bf7\u81f3\u5c11\u6dfb\u52a0\u4e00\u4e2a\u548c%3$s\u76f8\u540c\u5c42\u7ea7\u7684\u5b57\u6bb5\u3002", (String)"MetaSchemaAsAPIFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), title, fieldValue, str), Integer.valueOf(5000));
            return false;
        }
        if (!existSet.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u53c2\u6570\uff1a%2$s \u5b58\u5728\u91cd\u590d\u5b57\u6bb5", (String)"MetaSchemaAsAPIFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), title, Arrays.toString(existSet.toArray())), Integer.valueOf(5000));
        }
        return true;
    }

    private void removeSaveDataType() {
        DynamicObjectCollection outputs = this.getModel().getDataEntity(true).getDynamicObjectCollection("outputs");
        Iterator iterator = outputs.iterator();
        while (iterator.hasNext()) {
            DynamicObject obj = (DynamicObject)iterator.next();
            if (!OP_RESULT_TYPE.equals(obj.getString("output_description"))) continue;
            iterator.remove();
            break;
        }
        this.getModel().getDataEntity(true).set("outputs", (Object)outputs);
        this.getView().updateView("outputs");
    }

    private boolean checkInputs(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection inputs = this.getModel().getDataEntity(true).getDynamicObjectCollection("inputs");
        if (inputs == null || inputs.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u64cd\u4f5c\u7684\u8f93\u5165\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"MetaSchemaAsAPIFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.getModel().getValue(OPERATOR)), Integer.valueOf(5000));
            args.setCancel(true);
            return false;
        }
        for (DynamicObject input : inputs) {
            if (!input.getString("input_data_type").contains("ENTRIES")) continue;
            String prefix = input.getString("input_field") + ".";
            if (!inputs.stream().noneMatch(it -> it.getString("input_field").startsWith(prefix) && !it.getString("input_field").replaceFirst(prefix, "").contains("."))) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u64cd\u4f5c\u7684\u8f93\u5165\u53c2\u6570\u4e2d\u5206\u5f55%2$s\u8bf7\u9009\u62e9\u5177\u4f53\u7684\u5206\u5f55\u5c5e\u6027", (String)"MetaSchemaAsAPIFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.getModel().getValue(OPERATOR), input.get("input_field")), Integer.valueOf(5000));
            args.setCancel(true);
            return false;
        }
        long metadataId = this.getModel().getDataEntity().getLong(METADATA_ID);
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)metadataId, (String)ISC_METADATA_SCHEMA);
        if (OPERATION.EXECUTE.name().equals(this.getModel().getValue(OPERATOR)) || MetaType.EVT_RSC.name().equals(meta.getString(TYPE2))) {
            return true;
        }
        Map<String, Boolean> hasJudgeKeyMap = this.hasJudgeKey(inputs);
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, Boolean> entry : hasJudgeKeyMap.entrySet()) {
            if (!Boolean.FALSE.equals(entry.getValue())) continue;
            set.add(entry.getKey());
        }
        if (!set.isEmpty()) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u64cd\u4f5c\u7684\u8f93\u5165\u53c2\u6570\u672a\u9009\u62e9\u5019\u9009\u952e", (String)"MetaSchemaAsAPIFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.getModel().getValue(OPERATOR)), Integer.valueOf(5000));
            args.setCancel(true);
            return false;
        }
        return true;
    }

    private boolean hasJudgeInput() {
        DynamicObjectCollection inputs = this.getModel().getDataEntity(true).getDynamicObjectCollection("inputs");
        if (inputs == null) {
            return false;
        }
        for (DynamicObject input : inputs) {
            if (input.getString("input_data_type").contains("ENTRIES")) {
                return true;
            }
            String inputField = input.getString("input_field");
            if (!inputField.contains(".")) continue;
            return true;
        }
        return false;
    }

    private boolean hasJudgeOutput(DynamicObjectCollection outputs) {
        if (outputs == null || outputs.isEmpty()) {
            return false;
        }
        for (DynamicObject output : outputs) {
            if (!output.getString("output_data_type").contains("ENTRIES")) continue;
            return true;
        }
        return false;
    }

    private Map<String, Boolean> hasJudgeKey(DynamicObjectCollection inputs) {
        HashMap<String, Boolean> hasJudgeKeyMap = new HashMap<String, Boolean>();
        for (DynamicObject input : inputs) {
            String inputField = input.getString("input_field");
            String key = "ISC_$pk";
            if (inputField.contains(".")) continue;
            Boolean hasJudgeKey = (Boolean)hasJudgeKeyMap.get(key);
            boolean inputIsJudgeKey = input.getBoolean(INPUT_IS_JUDGE_KEY);
            if (hasJudgeKey == null) {
                hasJudgeKeyMap.put(key, inputIsJudgeKey);
                continue;
            }
            if (!Boolean.FALSE.equals(hasJudgeKey)) continue;
            hasJudgeKeyMap.put(key, inputIsJudgeKey);
        }
        return hasJudgeKeyMap;
    }

    private void resetInputsByExecuteAction(DynamicObject meta, boolean isEvtRscType) {
        DynamicObjectCollection inputs = this.getModel().getDataEntity(true).getDynamicObjectCollection("inputs");
        inputs.clear();
        if (isEvtRscType) {
            this.addInputsByMetaEntry(inputs, meta, ENTRIES_PROP_ENTRYENTITY, PROP_NAME, "data_type", PROP_LABEL);
        } else {
            this.addInputsByMetaEntry(inputs, meta, "param_entryentity", "param_number", "param_type", "param_remark");
        }
        this.getModel().getDataEntity(true).set("inputs", (Object)inputs);
        this.getView().updateView("inputs");
    }

    private void addInputsByMetaEntry(DynamicObjectCollection inputs, DynamicObject meta, String entryName, String propName, String propType, String propTitle) {
        DynamicObjectCollection props = meta.getDynamicObjectCollection(entryName);
        for (DynamicObject prop : props) {
            this.addInPutEntry(inputs, prop.getString(propName), prop.getString(propType), prop.getString(propTitle));
        }
    }

    private void resetOutputsByExecuteAction(DynamicObject meta) {
        DynamicObjectCollection outputs = this.getModel().getDataEntity(true).getDynamicObjectCollection("outputs");
        outputs.clear();
        DynamicObjectCollection props = meta.getDynamicObjectCollection("result_entryentity");
        for (DynamicObject prop : props) {
            this.addOutPutEntry(outputs, prop.getString("result_number"), prop.getString("result_type"), prop.getString("result_remark"));
        }
        this.getModel().getDataEntity(true).set("outputs", (Object)outputs);
        this.getView().updateView("outputs");
    }

    private void resetOutputsByNotQueryAction(Object value) {
        DynamicObjectCollection outputs = this.getModel().getDataEntity().getDynamicObjectCollection("outputs");
        DynamicObjectCollection baks = (DynamicObjectCollection)outputs.clone();
        outputs.clear();
        long metadataId = this.getModel().getDataEntity().getLong(METADATA_ID);
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)metadataId, (String)ISC_METADATA_SCHEMA);
        DynamicObjectCollection props = meta.getDynamicObjectCollection(ENTRIES_PROP_ENTRYENTITY);
        ArrayList<String> filedList = new ArrayList<String>();
        for (DynamicObject prop : props) {
            if (!prop.getBoolean("is_primary_key")) continue;
            this.addOutPutEntry(outputs, prop.getString(PROP_NAME), prop.getString("data_type"), prop.getString(PROP_LABEL));
            this.addOutPutEntry(outputs, TYPE2, TYPE_STRING, OP_RESULT_TYPE);
            filedList.add(prop.getString(PROP_NAME));
            filedList.add(TYPE2);
            break;
        }
        this.getModel().getDataEntity(true).set("outputs", (Object)outputs);
        this.getView().updateView("outputs");
        if (baks.size() != outputs.size()) {
            this.getView().showMessage(value + MetaSchemaAsAPIFormPlugin.getOutputTip());
        }
        boolean notEqual = false;
        for (DynamicObject bak : baks) {
            if (filedList.contains(bak.getString("output_field"))) continue;
            notEqual = true;
            break;
        }
        if (notEqual) {
            this.getView().showMessage(value + MetaSchemaAsAPIFormPlugin.getOutputTip());
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        if ("importinputfields".equals(operationKey)) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            FormOpener.showForm(this, "isc_apic_meta_importfield", ResManager.loadKDString((String)"\u5bfc\u5165\u5b57\u6bb5", (String)"MetaSchemaAsAPIFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, FILL_INPUT_FIELDS);
        } else if ("importoutputfields".equals(operationKey)) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            FormOpener.showForm(this, "isc_apic_meta_importfield", ResManager.loadKDString((String)"\u5bfc\u5165\u5b57\u6bb5", (String)"MetaSchemaAsAPIFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, "fill_output_fields");
        }
    }

    private boolean checkData(boolean b, String s) {
        if (b) {
            this.getView().showTipNotification(s, Integer.valueOf(5000));
            return true;
        }
        return false;
    }

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long metadataId = this.getModel().getDataEntity().getLong(METADATA_ID);
        if (metadataId > 0L) {
            String operator = D.s((Object)this.getModel().getValue(OPERATOR));
            DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)metadataId, (String)ISC_METADATA_SCHEMA);
            this.loadOperations(meta);
            this.getModel().setValue(OPERATOR, (Object)operator);
            this.getView().updateView(OPERATOR);
            this.initTab(operator);
        }
    }

    private void initTab(String operator) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        if (OPERATION.QUERY.name().equals(operator) || OPERATION.SQL_EXECUTE_R.name().equals(operator)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{TAB_CUS_FILTER});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{TAB_CUS_FILTER});
        }
        tab.activeTab("tabinput");
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (!"metadata".equals(name) && !OPERATOR.equals(name)) {
            return;
        }
        try {
            if ("metadata".equals(name)) {
                this.handleMetaDataField();
                this.clearInOutPut();
                long metadataId = this.getModel().getDataEntity().getLong(METADATA_ID);
                if (metadataId > 0L) {
                    DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)metadataId, (String)ISC_METADATA_SCHEMA);
                    if (OPERATION.EXECUTE.name().equals(this.getModel().getValue(OPERATOR))) {
                        this.resetInputsByExecuteAction(meta, false);
                        this.resetOutputsByExecuteAction(meta);
                    } else if (MetaType.EVT_RSC.name().equals(meta.getString(TYPE2))) {
                        this.reloadByEvtSrc(meta);
                    }
                }
            }
            String operator = D.s((Object)this.getModel().getValue(OPERATOR));
            Assert.notNull((Object)operator, (String)ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"MetaSchemaAsAPIFormPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.getModel().getDataEntity(true).getDynamicObjectCollection(FILTER_ENTRIES).clear();
            this.getView().updateView(FILTER_ENTRIES);
            this.initTab(operator);
            operator = operator.startsWith("_") ? operator : "_" + operator;
            DynamicObject metadata = (DynamicObject)this.getModel().getValue("metadata");
            this.getModel().setValue("name", (Object)(metadata == null ? "" : metadata.get("name") + operator));
            this.getModel().setValue("number", (Object)(metadata == null ? "" : metadata.getString("number").replaceAll("[^0-9a-zA-Z_-]", "_") + operator));
        }
        catch (Exception e1) {
            FormOpener.showErrorMessage(this.getView(), e1);
        }
    }

    private void reloadByEvtSrc(DynamicObject meta) {
        String fullName = meta.getString(FULL_NAME);
        if (!fullName.startsWith("isc_user_defined_event/")) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u81ea\u5b9a\u4e49\u7c7b\u578b\u7684\u4e8b\u4ef6\u6e90\uff08\u5168\u540d\u4ee5\"%s\"\u5f00\u5934\uff09", (String)"MetaSchemaAsAPIFormPlugin_36", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), "isc_user_defined_event/"));
        }
        this.resetInputsByExecuteAction(meta, true);
    }

    private void setFilterValueCombo() {
        DynamicObjectCollection inputList = this.getModel().getDataEntity(true).getDynamicObjectCollection("inputs");
        ComboEdit comboFilterValue = (ComboEdit)this.getView().getControl(FILTER_VALUE);
        ArrayList<String> inputFieldList = new ArrayList<String>(inputList.size());
        if (!CollectionUtils.isEmpty((Collection)inputList)) {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
            for (DynamicObject input : inputList) {
                String inputField = input.getString("input_field");
                String inputDataType = input.getString("input_data_type");
                if (inputField.contains(".") || inputDataType != null && inputDataType.contains("ENTRIES")) continue;
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(inputField));
                item.setValue(inputField);
                items.add(item);
                inputFieldList.add(inputField);
            }
            comboFilterValue.setComboItems(items);
        } else {
            comboFilterValue.setComboItems(null);
        }
        DynamicObjectCollection filters = this.getModel().getDataEntity(true).getDynamicObjectCollection(FILTER_ENTRIES);
        if (!CollectionUtils.isEmpty((Collection)filters)) {
            for (DynamicObject filter : filters) {
                String filterValue = filter.getString(FILTER_VALUE);
                if (inputFieldList.contains(filterValue)) continue;
                filter.set(FILTER_VALUE, null);
            }
        }
        this.getModel().getDataEntity(true).set(FILTER_ENTRIES, (Object)filters);
        this.getView().updateView(FILTER_ENTRIES);
    }

    private void clearInOutPut() {
        DynamicObjectCollection inputList = this.getModel().getDataEntity().getDynamicObjectCollection("inputs");
        inputList.clear();
        DynamicObjectCollection outputList = this.getModel().getDataEntity().getDynamicObjectCollection("outputs");
        outputList.clear();
        this.getModel().getDataEntity(true).set("inputs", (Object)inputList);
        this.getModel().getDataEntity(true).set("outputs", (Object)outputList);
        this.getView().updateView("inputs");
        this.getView().updateView("outputs");
    }

    private void handleMetaDataField() {
        long metadataId = this.getModel().getDataEntity().getLong(METADATA_ID);
        if (metadataId > 0L) {
            DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)metadataId, (String)ISC_METADATA_SCHEMA);
            this.loadOperations(meta);
            this.updateGroup(meta);
        }
    }

    private void addInPutEntry(DynamicObjectCollection inputs, String fieldName, String dataType, String desc) {
        DynamicObject object1 = inputs.addNew();
        object1.set("input_field", (Object)fieldName);
        object1.set("input_data_type", (Object)dataType);
        object1.set("input_description", (Object)desc);
    }

    private void addOutPutEntry(DynamicObjectCollection outputs, String fieldName, String dataType, String desc) {
        DynamicObject object1 = outputs.addNew();
        object1.set("output_field", (Object)fieldName);
        object1.set("output_data_type", (Object)dataType);
        object1.set("output_description", (Object)desc);
    }

    private void updateGroup(DynamicObject meta) {
        this.getModel().setValue("group", (Object)meta.getLong("group_id"));
        this.getView().updateView("group");
    }

    private void loadOperations(DynamicObject meta) {
        ObjType type = ObjType.valueOf(meta.getString(TYPE2));
        String operator = D.s((Object)this.getModel().getValue(OPERATOR));
        ComboEdit combo = (ComboEdit)this.getView().getControl(OPERATOR);
        List<ComboItem> comboList = type.getComboList(meta);
        combo.setComboItems(comboList);
        if (operator == null) {
            this.getModel().setValue(OPERATOR, (Object)type.getDefaultOperation(comboList));
            this.getView().updateView(OPERATOR);
        }
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        Object operation = this.getModel().getValue(OPERATOR);
        Object returnData = evt.getReturnData();
        if (returnData == null) {
            return;
        }
        if ("get_property".equals(action)) {
            if (!(returnData instanceof List)) throw new IllegalArgumentException(returnData.getClass().getName());
            this.returnList(evt, operation);
            return;
        }
        if (FILTER_FIELD.equals(action)) {
            this.setReturnValues(action, (Map)returnData);
            return;
        }
        if (!FILL_INPUT_FIELDS.equals(action) && !"fill_output_fields".equals(action)) return;
        Object metadataId = this.getModel().getValue(METADATA_ID);
        if (D.l((Object)metadataId) <= 0L) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u96c6\u6210\u5bf9\u8c61\u3002", (String)"MetaSchemaAsAPIFormPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject metadataSchema = BusinessDataServiceHelper.loadSingle((Object)metadataId, (String)ISC_METADATA_SCHEMA);
        if (!(returnData instanceof Map)) return;
        Map data = (Map)returnData;
        String inputStr = D.s(data.get("inputStr"));
        if (inputStr == null) {
            return;
        }
        try {
            List<Map<String, Object>> list = this.getImportFieldsProp(metadataSchema, inputStr);
            Map<String, Map<String, Object>> newMap = this.propListToMap(list);
            this.setImportFieldsByType(newMap, FILL_INPUT_FIELDS.equals(action));
            String errorFields = D.s((Object)this.getPageCache().get(CACHE_ERROR_FIELDS));
            if (errorFields == null) return;
            this.getView().showMessage(errorFields);
            this.getPageCache().remove(CACHE_ERROR_FIELDS);
            return;
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private Map<String, Map<String, Object>> propListToMap(List<Map<String, Object>> list) {
        HashMap<String, Map<String, Object>> newMap = new HashMap<String, Map<String, Object>>(list.size());
        for (Map<String, Object> map : list) {
            newMap.put(D.s((Object)map.get("name")), map);
        }
        return newMap;
    }

    private List<Map<String, Object>> getImportFieldsProp(DynamicObject metadataSchema, String inputStr) {
        StringBuilder errorInfo = new StringBuilder();
        Map<String, List<String>> listMap = this.parseImportFields(inputStr, errorInfo);
        Map<String, Map<String, DynamicObject>> metaMap = this.initMetaMap(metadataSchema, listMap, errorInfo);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(listMap.size());
        for (Map.Entry<String, List<String>> entry : listMap.entrySet()) {
            String key = entry.getKey();
            Map<String, DynamicObject> head = metaMap.get(key);
            if (head == null) continue;
            String parent = key.equals("$") ? "" : this.getFullName(metadataSchema, key, "");
            for (String s : entry.getValue()) {
                DynamicObject item = head.get(s);
                if (item == null) {
                    errorInfo.append(ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"MetaSchemaAsAPIFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(key.equals("$") ? s : key + '.' + s).append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728!\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165;", (String)"MetaSchemaAsAPIFormPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append("\r\n");
                    continue;
                }
                HashMap<String, Object> map = new HashMap<String, Object>(4);
                map.put("name", key.equals("$") ? s : key + "." + s);
                map.put("title", item.getString(PROP_LABEL));
                map.put("data_type", item.getString("data_type"));
                map.put("is_primary_key", item.getString("is_primary_key"));
                map.put(REQUIRED, item.getString(REQUIRED));
                map.put("is_judge_key", Boolean.FALSE);
                map.put(FULL_NAME, parent + item.getString(PROP_LABEL));
                list.add(map);
            }
        }
        this.getPageCache().put(CACHE_ERROR_FIELDS, D.s((Object)errorInfo));
        return list;
    }

    private void setImportFieldsByType(Map<String, Map<String, Object>> hashMap, boolean isInput) {
        DynamicObjectCollection inputs = this.getModel().getDataEntity(true).getDynamicObjectCollection(isInput ? "inputs" : "outputs");
        HashMap<String, DynamicObject> oldMap = new HashMap<String, DynamicObject>(inputs.size());
        for (DynamicObject input : inputs) {
            oldMap.put(input.getString(isInput ? "input_field" : "output_field"), input);
        }
        for (Map.Entry<String, Map<String, Object>> entry : hashMap.entrySet()) {
            String s = entry.getKey();
            if (oldMap.containsKey(s)) continue;
            Map<String, Object> map = entry.getValue();
            DynamicObject item = inputs.addNew();
            item.set(isInput ? "input_field" : "output_field", map.get("name"));
            item.set(isInput ? "input_data_type" : "output_data_type", map.get("data_type"));
            item.set(isInput ? "input_description" : "output_description", s.contains(".") ? map.get(FULL_NAME) : map.get("title"));
            if (!isInput) continue;
            item.set(INPUT_IS_PK, map.get("is_primary_key"));
            item.set(INPUT_IS_REQUIRED, map.get(REQUIRED));
            item.set(INPUT_IS_JUDGE_KEY, map.get("is_judge_key"));
        }
        this.getView().updateView(isInput ? "inputs" : "outputs");
    }

    private void setReturnValues(String action, Map<String, Object> map) {
        Object row = map.get("$row");
        if (row != null) {
            String dataType = D.s((Object)map.get("data_type"));
            if (dataType != null && dataType.contains("ENTRIES")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5206\u5f55\u5b57\u6bb5", (String)"MetaSchemaAsAPIFormPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            int index = D.i((Object)row);
            switch (action) {
                case "filter_column": {
                    String field = D.s((Object)map.get("number"));
                    DynamicObject entry = this.getModel().getEntryRowEntity(FILTER_ENTRIES, index);
                    entry.set(FILTER_FIELD, (Object)field);
                    entry.set("filter_label", map.get("name"));
                    this.getView().updateView(FILTER_ENTRIES);
                    break;
                }
            }
        }
    }

    private void returnList(ClosedCallBackEvent evt, Object operation) {
        List<Map<String, Object>> list = this.getReturnData(evt, operation);
        if (list != null) {
            Map<String, Object> item = list.get(0);
            String type = D.s((Object)item.get(TYPE));
            int index = D.i((Object)item.get("$row"));
            DynamicObjectCollection fieldEntries = this.getFieldEntries(type);
            if (fieldEntries != null) {
                String numberField = type + PARAM_TYPE_FIELD_SUFFIX;
                this.appendFields(list, type, fieldEntries, numberField, index);
                this.deleteEmptyFields(fieldEntries, numberField);
                this.updateView(type);
            }
        }
    }

    private void deleteEmptyFields(DynamicObjectCollection fieldEntries, String numberField) {
        for (int i = fieldEntries.size() - 1; i >= 0; --i) {
            DynamicObject dy = (DynamicObject)fieldEntries.get(i);
            String f = D.s((Object)dy.get(numberField));
            if (f != null) continue;
            fieldEntries.remove(D.i((Object)dy.get("seq")) - 1);
        }
    }

    private List<Map<String, Object>> getReturnData(ClosedCallBackEvent evt, Object operation) {
        List list = (List)evt.getReturnData();
        Map map = (Map)list.get(0);
        Object type = map.get(TYPE);
        if (OPERATION.QUERY.name().equals(operation)) {
            if (INPUT.equals(type) && this.hasEntryFieldSelected(map)) {
                list = null;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u64cd\u4f5c\u6587\u6863\u8f93\u5165\u5c5e\u6027\u4e0d\u652f\u6301\u5206\u5f55\u5b57\u6bb5", (String)"MetaSchemaAsAPIFormPlugin_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            } else if (OUTPUT.equals(type) && "ENTRIES".equals(map.get("data_type"))) {
                list = null;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u64cd\u4f5c\u6587\u6863\u8f93\u51fa\u5c5e\u6027\u4e0d\u652f\u6301\u5206\u5f55\u5b57\u6bb5\uff0c\u8bf7\u9009\u62e9\u5177\u4f53\u7684\u5206\u5f55\u5c5e\u6027", (String)"MetaSchemaAsAPIFormPlugin_24", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
            }
        }
        return list;
    }

    private DynamicObjectCollection getFieldEntries(Object type) {
        DynamicObjectCollection fieldEntries;
        if (INPUT.equals(type)) {
            fieldEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("inputs");
        } else if (OUTPUT.equals(type)) {
            fieldEntries = this.getModel().getDataEntity(true).getDynamicObjectCollection("outputs");
        } else {
            fieldEntries = new DynamicObjectCollection();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u77e5\u7684\u53c2\u6570\u7c7b\u578b", (String)"MetaSchemaAsAPIFormPlugin_25", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(5000));
        }
        return fieldEntries;
    }

    private void appendFields(List<Map<String, Object>> list, String type, DynamicObjectCollection fieldEntries, String numberField, int index) {
        for (int i = 0; i < list.size(); ++i) {
            Map<String, Object> item = list.get(i);
            if (this.hasField(fieldEntries, item, numberField)) continue;
            if (i == 0 || this.nextFieldEmpty(fieldEntries, numberField, ++index)) {
                this.setSingleField(type, fieldEntries, item, index);
                continue;
            }
            this.appendField(type, item, fieldEntries, null);
        }
    }

    private boolean nextFieldEmpty(DynamicObjectCollection fieldEntries, String numberField, int index) {
        return index < fieldEntries.size() && D.s((Object)((DynamicObject)fieldEntries.get(index)).get(numberField)) == null;
    }

    private void setSingleField(String type, DynamicObjectCollection fieldEntries, Map<String, Object> item, int index) {
        DynamicObject field = (DynamicObject)fieldEntries.get(index);
        this.appendField(type, item, fieldEntries, field);
    }

    private void appendField(String type, Map<String, Object> item, DynamicObjectCollection fieldEntries, DynamicObject field) {
        DynamicObject entry;
        DynamicObject dynamicObject = entry = field == null ? fieldEntries.addNew() : field;
        if (INPUT.equals(type)) {
            entry.set("input_field", item.get(FULL_NUMBER));
            entry.set("input_data_type", (Object)this.getSpecificType(item));
            entry.set("input_description", (Object)this.getDesc(item));
            entry.set(INPUT_IS_REQUIRED, (Object)Character.valueOf(D.x((Object)item.get(REQUIRED)) ? (char)'Y' : 'N'));
            entry.set(INPUT_IS_PK, (Object)Character.valueOf(D.x((Object)item.get("is_primary_key")) ? (char)'Y' : 'N'));
        } else {
            String outputField = D.s((Object)item.get(FULL_NUMBER));
            entry.set("output_field", (Object)outputField);
            entry.set("output_data_type", (Object)this.getSpecificType(item));
            entry.set("output_description", (Object)this.getDesc(item));
        }
    }

    private void updateView(Object type) {
        if (INPUT.equals(type)) {
            this.getView().updateView("inputs");
        } else {
            this.getView().updateView("outputs");
        }
    }

    private boolean hasField(DynamicObjectCollection entries, Map<String, Object> item, String numberField) {
        return entries.stream().anyMatch(x -> x.getString(numberField).equals(item.get(FULL_NUMBER)));
    }

    private boolean hasEntryFieldSelected(Map<?, ?> map) {
        return D.s(map.get(FULL_NUMBER)).contains(".") || "ENTRIES".equals(map.get("data_type"));
    }

    private String getSpecificType(Map<?, ?> map) {
        String type = D.s(map.get("data_type"));
        if ("ENUM".equals(type) || "REF".equals(type) || "ENTRIES".equals(type)) {
            type = type + "(" + map.get(DATA_SCHEMA) + ")";
        }
        return type;
    }

    private String getDesc(Map<?, ?> map) {
        return D.s(map.get(FULL_NAME));
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        HashMap<String, Object> param;
        long metadataId = this.getModel().getDataEntity().getLong(METADATA_ID);
        if (this.checkData(metadataId == 0L, ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u96c6\u6210\u5bf9\u8c61", (String)"MetaSchemaAsAPIFormPlugin_26", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]))) {
            return;
        }
        String fieldKey = cellClickEvent.getFieldKey();
        if (OPERATION.EXECUTE.name().equals(this.getModel().getValue(OPERATOR))) {
            DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)metadataId, (String)ISC_METADATA_SCHEMA, (String)TYPE2);
            if (MetaType.QUERY.name().equalsIgnoreCase(meta.getString(TYPE2)) && "input_field".equals(fieldKey)) {
                return;
            }
            if (MetaType.SERVICE.name().equalsIgnoreCase(meta.getString(TYPE2)) && "output_field".equals(fieldKey)) {
                return;
            }
        }
        if ("input_field".equals(fieldKey) || "output_field".equals(fieldKey)) {
            param = new HashMap<String, Object>();
            param.put("id", this.getModel().getValue(METADATA_ID));
            if ("input_field".equals(fieldKey)) {
                param.put(TYPE, INPUT);
            } else {
                param.put(TYPE, OUTPUT);
            }
            param.put(OPERATOR, BATCH_ADD);
            param.put("$row", cellClickEvent.getRow());
            FormOpener.showForm(this, "isc_meta_property_tree", ResManager.loadKDString((String)"\u9009\u62e9\u5bf9\u8c61\u5c5e\u6027", (String)"MetaSchemaAsAPIFormPlugin_27", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, "get_property");
        } else if (FILTER_FIELD.equals(fieldKey)) {
            param = new HashMap(2);
            param.put("id", metadataId);
            param.put("$row", cellClickEvent.getRow());
            FormOpener.showForm(this, "isc_meta_properties", ResManager.loadKDString((String)"\u9009\u62e9\u5143\u6570\u636e\u5c5e\u6027", (String)"MetaSchemaAsAPIFormPlugin_28", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, FILTER_FIELD);
        }
    }

    private Map<String, List<String>> parseImportFields(String str, StringBuilder errorInfo) {
        String[] splits;
        HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
        for (String split : splits = str.split("\n")) {
            String s = D.s((Object)split);
            if (s == null) continue;
            String trim = s.trim();
            int index = trim.lastIndexOf(46);
            if (index < 0) {
                List list = fields.computeIfAbsent("$", v -> new ArrayList());
                list.add(trim);
                continue;
            }
            if (StringUtil.isEmpty((String)trim.split("\\.")[0])) {
                errorInfo.append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5c5e\u6027", (String)"MetaSchemaAsAPIFormPlugin_29", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(trim).append(ResManager.loadKDString((String)"! \u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165;", (String)"MetaSchemaAsAPIFormPlugin_30", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append("\r\n");
                continue;
            }
            String key = trim.substring(0, index);
            String field = trim.substring(index + 1);
            List list = fields.computeIfAbsent(key, v -> new ArrayList());
            list.add(field);
        }
        return fields;
    }

    public Map<String, Map<String, DynamicObject>> initMetaMap(DynamicObject meta, Map<String, List<String>> fieldMap, StringBuilder errorInfo) {
        HashMap<String, Map<String, DynamicObject>> metaMap = new HashMap<String, Map<String, DynamicObject>>();
        Map<String, DynamicObject> propMap = this.getPropertyMap(meta);
        metaMap.put("$", propMap);
        for (String key : fieldMap.keySet()) {
            Map<String, DynamicObject> sub;
            if (key.equals("$") || (sub = this.recurive(meta, propMap, key, errorInfo, key)) == null) continue;
            metaMap.put(key, sub);
        }
        return metaMap;
    }

    private Map<String, DynamicObject> recurive(DynamicObject meta, Map<String, DynamicObject> parent, String fieldName, StringBuilder errorInfo, String key) {
        int index = fieldName.indexOf(46);
        if (index > 0) {
            String parentKey = fieldName.substring(0, index);
            DynamicObject temp = this.getRefMeta(meta, parent, parentKey, errorInfo, key);
            if (temp == null) {
                return null;
            }
            Map<String, DynamicObject> propertyMap = this.getPropertyMap(temp);
            return this.recurive(meta, propertyMap, fieldName.substring(index + 1), errorInfo, key);
        }
        DynamicObject temp = this.getRefMeta(meta, parent, fieldName, errorInfo, key);
        if (temp == null) {
            return null;
        }
        return this.getPropertyMap(temp);
    }

    private String getFullName(DynamicObject meta, String s, String name) {
        Map<String, DynamicObject> entriesProps = this.getEntriesProps(meta);
        int index = s.indexOf(46);
        if (index > 0) {
            String substring = s.substring(0, index);
            DynamicObject object = entriesProps.get(substring);
            String dataSchema = object.getString(DATA_SCHEMA);
            DynamicObject item = JsonSampleUtil.findMetaByDataSchema((DynamicObject)meta, (String)dataSchema);
            String prop_label = object.getString(PROP_LABEL) + ".";
            name = name + this.getFullName(item, s.substring(index + 1), prop_label);
        } else {
            name = name + entriesProps.get(s).getString(PROP_LABEL) + ".";
        }
        return name;
    }

    private Map<String, DynamicObject> getEntriesProps(DynamicObject meta) {
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>();
        DynamicObjectCollection prop_entryentity = meta.getDynamicObjectCollection(ENTRIES_PROP_ENTRYENTITY);
        for (DynamicObject object : prop_entryentity) {
            map.put(object.getString(PROP_NAME), object);
        }
        return map;
    }

    private DynamicObject getRefMeta(DynamicObject meta, Map<String, DynamicObject> parent, String field, StringBuilder errorInfo, String fieldName) {
        DynamicObject prop = parent.get(field);
        if (prop == null) {
            errorInfo.append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5c5e\u6027", (String)"MetaSchemaAsAPIFormPlugin_29", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(field).append(ResManager.loadKDString((String)"! \u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165;", (String)"MetaSchemaAsAPIFormPlugin_30", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append("\r\n");
            return null;
        }
        String dataSchema = D.s((Object)prop.getString(DATA_SCHEMA));
        if (dataSchema == null) {
            errorInfo.append(fieldName).append(ResManager.loadKDString((String)"\u6240\u5173\u8054\u7684\u6570\u636e\u6a21\u578b\u4e3a\u7a7a! \u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165;", (String)"MetaSchemaAsAPIFormPlugin_31", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append("\r\n");
            return null;
        }
        DynamicObject item = JsonSampleUtil.findMetaByDataSchema((DynamicObject)meta, (String)dataSchema);
        if (item.get("id") == null) {
            errorInfo.append(fieldName).append(ResManager.loadKDString((String)"\u4e2d\u672a\u627e\u5230", (String)"MetaSchemaAsAPIFormPlugin_32", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(dataSchema).append(ResManager.loadKDString((String)"\u5bf9\u5e94\u7684\u96c6\u6210\u5bf9\u8c61! \u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165;", (String)"MetaSchemaAsAPIFormPlugin_33", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append("\r\n");
            return null;
        }
        return item;
    }

    private Map<String, DynamicObject> getPropertyMap(DynamicObject meta) {
        DynamicObjectCollection properties = meta.getDynamicObjectCollection(ENTRIES_PROP_ENTRYENTITY);
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(properties.size());
        for (DynamicObject item : properties) {
            map.put(item.getString(PROP_NAME), item);
        }
        return map;
    }

    @Override
    protected Map<String, Object> getTestInputParams(DynamicObject api) {
        JSONObject inputData;
        DynamicObjectCollection inputs = api.getDynamicObjectCollection("inputs");
        JSONObject requires = new HashMap();
        if (!inputs.isEmpty()) {
            MetaApiDocBuilder.existInputsOrOutputs((DynamicObjectCollection)inputs, requires, (String)"input_data_type", (String)"input_field");
        }
        if (OPERATION.EXECUTE.name().equals(api.get(OPERATOR)) || MetaApiDocBuilder.hasFilter((DynamicObject)api)) {
            inputData = requires;
        } else {
            Object metadataId = api.get(METADATA_ID);
            DynamicObject metaSchema = BusinessDataServiceHelper.loadSingle((Object)metadataId, (String)ISC_METADATA_SCHEMA);
            inputData = JsonSampleUtil.toJSONObject((long)metaSchema.getLong("id"), requires);
        }
        return inputData;
    }

    @Override
    protected void generateXml(List<Object> successPkIds, IFormView view) {
        DynamicObject[] metaApis;
        for (DynamicObject api : metaApis = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ISC_APIC_BY_META_SCHEMA))) {
            try {
                new ExportMetaApiToXml(api).export(view);
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(view, e);
            }
        }
    }

    @Override
    protected void generatePdf(List<Object> successPkIds, IFormView view) {
        DynamicObject[] apis;
        for (DynamicObject api : apis = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ISC_APIC_BY_META_SCHEMA))) {
            try {
                String file = ExportDocForMetaSchemaAPI.generateDoc((DynamicObject)api);
                ExportAndImportFormUtil.download((IFormView)view, (String)file, (String)(ExportAndImportFormUtil.getDownloadFileName((DynamicObject)api) + ".pdf"));
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(view, e);
            }
        }
    }

    private static String getOutputTip() {
        return ResManager.loadKDString((String)"\u64cd\u4f5c\u53ea\u4f1a\u8fd4\u56de\u4e3b\u952e\u53ca\u64cd\u4f5c\u4fdd\u5b58\u7c7b\u578b\uff0c\u4e0d\u7b26\u5408\u8981\u6c42\u7684\u8f93\u51fa\u53c2\u6570\u5206\u5f55\u4f1a\u81ea\u52a8\u5220\u9664", (String)"MetaSchemaAsAPIFormPlugin_34", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }
}

