/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.util.Assert;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.apic.AbstractApiFormPlugin;
import kd.isc.iscb.formplugin.apic.Util;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.OpenApiServiceUtil;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.cache.data.ServiceFlow;
import kd.isc.iscb.platform.core.connector.apic.doc.ExportDocForServiceFlowAPI;
import kd.isc.iscb.platform.core.connector.apic.doc.JsonSampleUtil;
import kd.isc.iscb.platform.core.connector.apic.doc.apixml.ExportServiceFlowApiToXml;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.util.ApiToXmlUtil;
import kd.isc.iscb.platform.core.util.ExportAndImportFormUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.flow.core.Variable;
import kd.isc.iscb.util.flow.core.i.model.VariableImpl;

public class ServiceFlowApiFormPlugin
extends AbstractApiFormPlugin {
    private static final String FIELD_NAME = "name";
    private static final String FIELD_NUMBER = "number";
    private static final String GEN_PDF = "gen_pdf";
    private static final String API_TEST = "api_test";
    private static final String GENERATE_WORD = "generate_word";

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{API_TEST});
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject sfApi;
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        long id = D.l((Object)this.getModel().getValue("id"));
        if ((GENERATE_WORD.equals(operationKey) || GEN_PDF.equals(operationKey) || API_TEST.equals(operationKey)) && ServiceFlowApiFormPlugin.checkServiceFlowReleased(sfApi = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_apic_by_sf"), this.getView())) {
            args.setCancel(true);
        }
        if (args.getSource() instanceof Save) {
            long flowid = D.l((Object)this.getModel().getValue("service_flow_id"));
            this.viewParamAndResult(flowid);
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        this.afterDoOperationExt(evt);
    }

    @Override
    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        this.confirmCallBackExt(evt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        long sfId;
        String property = e.getProperty().getName();
        if ("service_flow".equals(property) && (sfId = D.l((Object)this.getModel().getValue("service_flow_id"))) > 0L) {
            DynamicObject sf = BusinessDataServiceHelper.loadSingle((Object)sfId, (String)"isc_service_flow");
            this.getModel().setValue(FIELD_NUMBER, (Object)sf.getString(FIELD_NUMBER).replace('(', '-').replace(')', '-'));
            this.getModel().setValue(FIELD_NAME, (Object)sf.getString(FIELD_NAME));
            this.viewParamAndResult(D.l((Object)sf.getPkValue()));
        }
    }

    @Override
    public void afterBindData(EventObject e) {
        BillView source;
        BillShowParameter formShowParameter;
        BillOperationStatus billStatus;
        super.afterBindData(e);
        long id = D.l((Object)this.getModel().getValue("service_flow_id"));
        if (e.getSource() instanceof BillView && (billStatus = (formShowParameter = (BillShowParameter)(source = (BillView)e.getSource()).getFormShowParameter()).getBillStatus()) == BillOperationStatus.VIEW) {
            this.viewParamAndResult(id);
        }
    }

    private void viewParamAndResult(long flow_id) {
        if (flow_id > 0L) {
            boolean asyn = D.x((Object)this.getModel().getValue("asyn"));
            DynamicObject dynamicObject = ServiceFlow.get((long)flow_id);
            DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("variables");
            if (collection.size() > 0) {
                DynamicObjectCollection param_entity = this.getInputParams(collection);
                this.getModel().getDataEntity(true).set("param_entryentity", (Object)param_entity);
                this.getView().updateView("param_entryentity");
            }
            DynamicObjectCollection result_entity = this.getModel().getDataEntity().getDynamicObjectCollection("result_entryentity");
            if (asyn) {
                result_entity.clear();
                DynamicObject aNew = result_entity.addNew();
                aNew.set("res_field", (Object)"id");
                aNew.set("res_cata", (Object)ResManager.loadKDString((String)"\u7b80\u5355\u503c", (String)"ServiceFlowApiFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                aNew.set("res_type", (Object)ResManager.loadKDString((String)"\u957f\u6574\u6570", (String)"ServiceFlowApiFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                aNew.set("res_remark", (Object)"ID");
                aNew.set("res_multi", (Object)ResManager.loadKDString((String)"\u5426", (String)"ServiceFlowApiFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else {
                result_entity = this.getOutputParams(collection);
            }
            this.getModel().getDataEntity().set("result_entryentity", (Object)result_entity);
            this.getView().updateView("result_entryentity");
            DynamicObject api = this.getModel().getDataEntity();
            String res = Util.getFlowJson(api, collection, asyn);
            Markdown mk = (Markdown)this.getView().getControl("json_expr");
            mk.setText("```json \n" + res + " \n");
        }
    }

    private DynamicObjectCollection getInputParams(DynamicObjectCollection collection) {
        DynamicObjectCollection param_entity = this.getModel().getDataEntity().getDynamicObjectCollection("param_entryentity");
        param_entity.clear();
        for (DynamicObject meta : collection) {
            if (!meta.getBoolean("is_input_param")) continue;
            this.setParamsEntity(param_entity, meta, "param_field", "param_cata", "param_type", "param_remark", "param_multi");
        }
        return param_entity;
    }

    private DynamicObjectCollection getOutputParams(DynamicObjectCollection collection) {
        DynamicObjectCollection result_entity = this.getModel().getDataEntity().getDynamicObjectCollection("result_entryentity");
        result_entity.clear();
        this.fullResult(result_entity, "id", ResManager.loadKDString((String)"\u957f\u6574\u6570", (String)"ServiceFlowApiFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8bid", (String)"ServiceFlowApiFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7b80\u5355\u503c", (String)"ServiceFlowApiFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.fullResult(result_entity, "output", ResManager.loadKDString((String)"\u7ed3\u6784", (String)"ServiceFlowApiFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u8f93\u51fa\u53c2\u6570", (String)"ServiceFlowApiFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7ed3\u6784", (String)"ServiceFlowApiFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        for (DynamicObject meta : collection) {
            if (!meta.getBoolean("is_output_param")) continue;
            this.setParamsEntity(result_entity, meta, "res_field", "res_cata", "res_type", "res_remark", "res_multi");
        }
        return result_entity;
    }

    private void setParamsEntity(DynamicObjectCollection param_entity, DynamicObject meta, String filed, String cata, String type, String remark, String multi) {
        Object category;
        DynamicObject aNew = param_entity.addNew();
        Object var_name = meta.get("var_name");
        if (filed.contains("res")) {
            var_name = "output." + var_name;
        }
        if ("isc_metadata_schema".equalsIgnoreCase(D.s((Object)(category = meta.get("var_category"))))) {
            DynamicObject var_type = (DynamicObject)meta.get("var_type");
            DynamicObject metaSchema = MetaDataSchema.get((long)D.l((Object)var_type.getPkValue()));
            aNew.set(filed, var_name);
            aNew.set(cata, (Object)ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61", (String)"ServiceFlowApiFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            aNew.set(type, (Object)metaSchema.getString(FIELD_NAME));
            aNew.set(remark, meta.get("var_desc"));
            aNew.set(multi, (Object)(meta.getBoolean("is_array") ? ResManager.loadKDString((String)"\u662f", (String)"ServiceFlowApiFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ServiceFlowApiFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])));
            this.parseMetaSchema(param_entity, filed, cata, type, remark, multi, var_name, metaSchema);
        } else if ("isc_type_simple_value".equalsIgnoreCase(D.s((Object)category))) {
            DynamicObject var_type = (DynamicObject)meta.get("var_type");
            aNew.set(type, (Object)var_type.getString(FIELD_NAME));
            aNew.set(filed, var_name);
            aNew.set(cata, (Object)ResManager.loadKDString((String)"\u7b80\u5355\u503c", (String)"ServiceFlowApiFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            aNew.set(remark, meta.get("var_desc"));
            aNew.set(multi, (Object)(meta.getBoolean("is_array") ? ResManager.loadKDString((String)"\u662f", (String)"ServiceFlowApiFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"ServiceFlowApiFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])));
        }
    }

    private void parseMetaSchema(DynamicObjectCollection param_entity, String filed, String cata, String type, String remark, String multi, Object var_name, DynamicObject metaSchema) {
        DynamicObjectCollection list = metaSchema.getDynamicObjectCollection("prop_entryentity");
        for (DynamicObject metaEntry : list) {
            DynamicObject entity = param_entity.addNew();
            String metaName = metaEntry.getString("prop_name");
            String prop_label = metaEntry.getString("prop_label");
            String data_type = ApiToXmlUtil.translateType((String)metaEntry.getString("data_type"));
            entity.set(filed, (Object)(var_name + "." + metaName));
            entity.set(cata, (Object)ResManager.loadKDString((String)"\u7b80\u5355\u503c", (String)"ServiceFlowApiFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            entity.set(type, (Object)data_type);
            entity.set(remark, (Object)prop_label);
            entity.set(multi, (Object)ResManager.loadKDString((String)"\u5426", (String)"ServiceFlowApiFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            if (!ApiToXmlUtil.isEntries((String)metaEntry.getString("data_type"))) continue;
            entity.set(cata, (Object)ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61", (String)"ServiceFlowApiFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            entity.set(multi, (Object)ResManager.loadKDString((String)"\u662f", (String)"ServiceFlowApiFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            DynamicObject metaEntries = JsonSampleUtil.findMetaByDataSchema((DynamicObject)metaSchema, (String)metaEntry.getString("data_schema"));
            this.parseMetaSchema(param_entity, filed, cata, type, remark, multi, var_name + "." + metaName, metaEntries);
        }
    }

    private void fullResult(DynamicObjectCollection result_entity, String field, String type, String content, String cata) {
        DynamicObject aNew = result_entity.addNew();
        aNew.set("res_field", (Object)field);
        aNew.set("res_cata", (Object)cata);
        aNew.set("res_type", (Object)type);
        aNew.set("res_remark", (Object)content);
        aNew.set("res_multi", (Object)ResManager.loadKDString((String)"\u5426", (String)"ServiceFlowApiFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    public static boolean checkServiceFlowReleased(DynamicObject sfApi, IFormView view) {
        long flowId = ServiceFlowParser.findReleasedFlowId((long)sfApi.getLong("service_flow_id"));
        if (D.i((Object)flowId) == 0) {
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u53d1\u5e03\u670d\u52a1\u6d41\u7a0b\uff0c\u672a\u53d1\u5e03\u7684\u670d\u52a1\u6d41\u7a0b\u7f16\u7801\u662f\uff1a%s", (String)"ServiceFlowApiFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), sfApi.getDynamicObject("service_flow").getString(FIELD_NUMBER)));
            return true;
        }
        return false;
    }

    @Override
    protected Map<String, Object> getTestInputParams(DynamicObject api) {
        long flowId = ServiceFlowParser.findReleasedFlowId((long)api.getLong("service_flow_id"));
        return this.getInputData(flowId);
    }

    @Override
    protected void generateXml(List<Object> successPkIds, IFormView view) {
        DynamicObject[] sfApis;
        for (DynamicObject api : sfApis = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"isc_apic_by_sf"))) {
            try {
                new ExportServiceFlowApiToXml(api).export(view);
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(view, e);
            }
        }
    }

    @Override
    protected void generatePdf(List<Object> successPkIds, IFormView view) {
        DynamicObject[] sfApis;
        for (DynamicObject sfApi : sfApis = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"isc_apic_by_sf"))) {
            try {
                Assert.isTrue((boolean)OpenApiServiceUtil.isValid(sfApi.getString(FIELD_NUMBER)), (String)OpenApiServiceUtil.getApiNumberPatternTips());
                String filePath = ExportDocForServiceFlowAPI.generateDoc((DynamicObject)sfApi);
                ExportAndImportFormUtil.download((IFormView)view, (String)filePath, (String)(ExportAndImportFormUtil.getDownloadFileName((DynamicObject)sfApi) + ".pdf"));
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(view, e);
            }
        }
    }

    private Map<String, Object> getInputData(long flowId) {
        List variables = ServiceFlowParser.getFlow((long)flowId).getInputVariables();
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        for (Variable var : variables) {
            String defaultValue;
            String string = defaultValue = var.getInitValue() == null ? null : ((String[])var.getInitValue())[0];
            if (!((VariableImpl)var).isArray()) {
                if (ApiToXmlUtil.isVariant((String)D.s((Object)var.getType()))) {
                    m.put(var.getName(), Collections.emptyMap());
                    continue;
                }
                m.put(var.getName(), defaultValue);
                continue;
            }
            ArrayList<Object> l = new ArrayList<Object>(1);
            if (ApiToXmlUtil.isVariant((String)D.s((Object)var.getType()))) {
                l.add(Collections.emptyMap());
            } else {
                l.add(defaultValue);
            }
            m.put(var.getName(), l);
        }
        return m;
    }
}

