/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic.parse;

import com.alibaba.fastjson.JSON;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.api.DownLoadUtil;
import kd.isc.iscb.platform.core.api.parsers.SwaggerApiParser;
import kd.isc.iscb.platform.core.api.parsers.model.Model;
import kd.isc.iscb.platform.core.api.parsers.model.SwaggerModel;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class ImportSwaggerFormPlugin
extends AbstractFormPlugin
implements UploadListener {
    private static final String PARSE = "parse";
    private static final String FORMAT_TYPE = "format_type";
    private static final String API_ENTITY = "api_entity";
    private static final String API_MODEL_STRING = "apiModelString";
    private static final String CLOSE_CURRENT_WIN = "close_current_win";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanelap");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (PARSE.equals(args.getOperateKey())) {
            try {
                CodeEdit codeEdit = (CodeEdit)this.getView().getControl("codeeditap");
                String text = codeEdit.getText();
                if (D.s((Object)text) != null) {
                    List models = new SwaggerApiParser().parseMulti(text);
                    if (models.size() == 1) {
                        SwaggerModel model = (SwaggerModel)models.get(0);
                        HashMap<String, Object> params = new HashMap<String, Object>(1);
                        params.put("SwaggerString", JSON.toJSONString((Object)model));
                        IFormView parentView = this.getView().getParentView();
                        FormOpener.addNewByParent(this, "isc_apic_webapi", params, parentView);
                    } else {
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        HashMap<String, String> swagger = new HashMap<String, String>(models.size());
                        for (Model mod : models) {
                            SwaggerModel model = (SwaggerModel)mod;
                            swagger.put(model.getUrl() + "/" + model.getMethod(), JSON.toJSONString((Object)model));
                        }
                        params.put("swagger", swagger);
                        FormOpener.showForm(this, "isc_swagger_oper_select", "", params, "isc_swagger_oper_select");
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6216\u9009\u62e9\u6587\u4ef6", (String)"ImportContentFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                }
            }
            catch (Throwable e) {
                String s = ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u6587\u4ef6\u65e0\u6cd5\u6b63\u786e\u89e3\u6790\u6210Swagger\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u9519\u8bef\u7684\u4f20\u5165\u4e86\u975e3.0\u7248\u672c\u7684Swagger\u6587\u4ef6", (String)"ImportContentFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                FormOpener.showErrorMessage(this.getView(), s, ShowStackTraceUtil.getErrorMsg(e));
            }
        }
    }

    public void afterUpload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            String url = (String)((Map)urls[0]).get("url");
            try {
                String data = DownLoadUtil.getData((String)url);
                CodeEdit codeEdit = (CodeEdit)this.getView().getControl("codeeditap");
                codeEdit.setText(data);
            }
            catch (Throwable e) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4eceredis\u7f13\u5b58%s\u4e2d\u83b7\u53d6api\u6a21\u578b\u5185\u5bb9\u5931\u8d25\uff1a", (String)"ImportContentFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), urls[0]), e);
            }
        }
    }
}

