/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic.webapi;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.container.Container;
import kd.bos.form.container.FormRoot;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.apic.webapi.VarItem;
import kd.isc.iscb.platform.core.factory.FactoryManager;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.platform.core.util.MultiLangUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class ConnectionVarsFormPlugin
extends AbstractFormPlugin
implements CellClickListener {
    private static final String VAR_LIST = "var_list";
    private static final String VAR_NAME = "var_name";
    private static final String VAR_DESC = "var_desc";
    private static final String VAR_TYPE = "var_type";
    private static final String VAR_LABEL = "var_label";
    private static final String ROW = "row";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(VAR_LIST);
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        String connType = D.s(params.get("conn_type"));
        String form = FactoryManager.getForm((String)connType);
        List<VarItem> varItems = this.getVarItemListByFormId(form, connType);
        this.initVarEntries(varItems);
        this.getModel().setValue(ROW, (Object)D.i(params.get("$row")));
        this.getView().updateView(VAR_LIST);
    }

    private Map<String, Object> loadClientFormMeta(String form) {
        MetadataService metadataService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String formString = metadataService.loadClientFormMeta(form);
        return (Map)Json.toObject((String)formString);
    }

    public void buildRespList(Map<String, Object> resp, List<VarItem> list, String prefix) {
        for (Map.Entry<String, Object> entry : resp.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof String) {
                list.add(new VarItem(prefix + entry.getKey(), "******", "string", null));
                continue;
            }
            if (!(value instanceof Map)) continue;
            this.buildRespList((Map)value, list, prefix + entry.getKey() + ".");
        }
    }

    private List<VarItem> getVarItemListByFormId(String formId, String connType) {
        ArrayList<VarItem> list = new ArrayList<VarItem>(10);
        this.buildSessionList(list);
        this.buildConntypeList(formId, connType, list);
        return list;
    }

    private void buildSessionList(List<VarItem> list) {
        String webRespBodyStr = (String)this.getView().getFormShowParameter().getCustomParam("webRespBodyStr");
        if (webRespBodyStr != null) {
            this.buildRespList((Map)Json.toObject((String)webRespBodyStr), list, "$session.");
        } else {
            list.add(new VarItem("$session", ResManager.loadKDString((String)"\u4f1a\u8bdd\u4fe1\u606f", (String)"ConnectionVarsFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), "STRUCT", null));
        }
    }

    private void buildConntypeList(String formId, String connType, List<VarItem> list) {
        list.add(new VarItem("$connection", ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e\u5bf9\u8c61", (String)"ConnectionVarsFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), "STRUCT", null));
        if ("isc_database_link_common".equals(formId)) {
            this.prepareList(connType, list);
        } else {
            FormRoot formRoot = FormMetadataCache.getRootControl((String)formId);
            List items = formRoot.getItems();
            Map<String, Object> clientMeta = this.loadClientFormMeta(formId);
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"isc_database_link");
            this.parseItemRecursively(list, items, this.getChildMetas(clientMeta), entityType);
        }
    }

    private void prepareList(String cnTypeNumber, List<VarItem> list) {
        DynamicObject cnType = BusinessDataServiceHelper.loadSingle((String)"isc_connection_type", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)cnTypeNumber)});
        DynamicObjectCollection collection = cnType.getDynamicObjectCollection("entryentity");
        for (DynamicObject object : collection) {
            list.add(new VarItem("$connection." + object.get("params_number"), D.s((Object)object.get("params_name")), D.s((Object)object.get("params_type")), D.s((Object)object.get("desc"))));
        }
    }

    private List<Map<String, Object>> getChildMetas(Map<String, Object> clientMeta) {
        Object meta = clientMeta.get("items");
        if (meta instanceof List) {
            return (List)meta;
        }
        return null;
    }

    private void parseItemRecursively(List<VarItem> list, List<Control> items, List<Map<String, Object>> clientMetas, MainEntityType entityType) {
        for (int i = 0; i < items.size(); ++i) {
            Control item = items.get(i);
            Map<String, Object> meta = clientMetas.get(i);
            if (item instanceof Container) {
                Container container = (Container)item;
                List controls = container.getItems();
                this.parseItemRecursively(list, controls, this.getChildMetas(meta), entityType);
                continue;
            }
            if (!(item instanceof FieldEdit)) continue;
            this.innerAddItem(list, entityType, (FieldEdit)item, meta);
        }
    }

    private void innerAddItem(List<VarItem> list, MainEntityType entityType, FieldEdit item, Map<String, Object> meta) {
        FieldEdit fieldEdit = item;
        String fieldKey = fieldEdit.getFieldKey();
        String typeName = this.getTypeName(entityType, fieldKey);
        if (!"REF".equals(typeName) && !"eas_tips".equals(fieldKey)) {
            list.add(new VarItem("$connection." + fieldKey, this.getFieldDisplayName(meta, fieldKey), typeName, null));
        }
    }

    private String getFieldDisplayName(Map<String, Object> clientMeta, String fieldKey) {
        if (fieldKey.equals(clientMeta.get("id"))) {
            return MultiLangUtil.getMultiLangValue((Object)clientMeta.get("caption"));
        }
        return fieldKey;
    }

    private String getTypeName(MainEntityType entityType, String fieldKey) {
        return CommonUtil.formatDataType((String)entityType.getProperty(fieldKey).getPropertyType().getSimpleName());
    }

    private void initVarEntries(List<VarItem> varList) {
        this.getModel().deleteEntryData(VAR_LIST);
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection(VAR_LIST);
        for (VarItem var : varList) {
            DynamicObject obj = entries.addNew();
            obj.set(VAR_NAME, (Object)var.getName());
            obj.set(VAR_DESC, (Object)var.getDesc());
            obj.set(VAR_TYPE, (Object)var.getType());
            obj.set(VAR_LABEL, (Object)var.getLabel());
        }
    }

    public void cellDoubleClick(CellClickEvent evt) {
        Map<String, Object> data = this.getSelectedRowData(evt.getRow());
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("select".equals(operateKey)) {
            int[] rowNum = ((EntryGrid)this.getView().getControl(VAR_LIST)).getSelectRows();
            if (rowNum == null || rowNum.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u3002", (String)"ConnectionVarsFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            if (rowNum.length == 1) {
                Map<String, Object> selectedRowData = this.getSelectedRowData(rowNum[0]);
                this.getView().returnDataToParent(selectedRowData);
                this.getView().close();
            }
        }
    }

    private Map<String, Object> getSelectedRowData(int row) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(VAR_LIST, row);
        HashMap<String, Object> data = new HashMap<String, Object>(8);
        String varName = rowEntity.getString(VAR_NAME);
        String varDesc = rowEntity.getString(VAR_DESC);
        String varType = rowEntity.getString(VAR_TYPE);
        data.put("$row", this.getModel().getValue(ROW));
        data.put(VAR_NAME, varName);
        data.put(VAR_DESC, varDesc);
        data.put(VAR_TYPE, varType);
        return data;
    }
}

