/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic.webapi;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.id.IDService;
import kd.isc.iscb.platform.core.api.parsers.model.IscFieldType;
import kd.isc.iscb.platform.core.api.quick.FormItem;
import kd.isc.iscb.platform.core.api.quick.HttpItem;
import kd.isc.iscb.platform.core.api.webapi.Const;
import kd.isc.iscb.platform.core.api.webapi.Util;

public class ReqHandler
implements Const {
    public static DynamicObjectCollection initReqBody(String dataText, DynamicObject obj) {
        Map dataMap = Util.getDataMap((String)dataText);
        return ReqHandler.initReqBody(dataMap, obj);
    }

    public static DynamicObjectCollection initReqBody(Map<String, Object> dataMap, DynamicObject obj) {
        DynamicObjectCollection reqBody = obj.getDynamicObjectCollection("web_req_body");
        reqBody.clear();
        if (dataMap != null) {
            for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
                ReqHandler.newReqBodyParamEntry(reqBody, entry.getKey(), entry.getValue(), 0L);
            }
        }
        return reqBody;
    }

    private static void newReqBodyParamEntry(DynamicObjectCollection reqBody, String name, Object value, long pid) {
        DynamicObject bodyParam = ReqHandler.addNewReq(reqBody, name, pid);
        if (value instanceof List) {
            ReqHandler.handleListValueReq((List)value, reqBody, bodyParam);
        } else if (value instanceof Map) {
            ReqHandler.handleMapValueReq((Map)value, reqBody, bodyParam);
        } else {
            ReqHandler.handleBaseValueReq(value, bodyParam);
        }
    }

    private static void handleBaseValueReq(Object value, DynamicObject bodyParam) {
        bodyParam.set("req_b_param_example", value);
        bodyParam.set("req_b_param_type", (Object)Util.getIscFieldTypeFromValue((Object)value).getTypeName());
    }

    private static void handleMapValueReq(Map<String, Object> value, DynamicObjectCollection reqBody, DynamicObject bodyParam) {
        bodyParam.set("req_b_param_type", (Object)IscFieldType.STRUCT.getTypeName());
        for (Map.Entry<String, Object> entry : value.entrySet()) {
            ReqHandler.newReqBodyParamEntry(reqBody, entry.getKey(), entry.getValue(), bodyParam.getLong("id"));
        }
    }

    private static void handleListValueReq(List value, DynamicObjectCollection reqBody, DynamicObject bodyParam) {
        bodyParam.set("req_b_param_is_array", (Object)Boolean.TRUE);
        if (!value.isEmpty()) {
            Object o = value.get(0);
            if (o instanceof Map) {
                ReqHandler.handleMapValueReq((Map)o, reqBody, bodyParam);
            } else {
                bodyParam.set("req_b_param_type", (Object)Util.getIscFieldTypeFromValue(o).getTypeName());
            }
        } else {
            bodyParam.set("req_b_param_type", (Object)IscFieldType.UNKNOWN.getTypeName());
        }
    }

    private static DynamicObject addNewReq(DynamicObjectCollection reqBody, String name, long pid) {
        DynamicObject bodyParam = reqBody.addNew();
        bodyParam.set("id", (Object)IDService.get().genLongId());
        bodyParam.set("pid", (Object)pid);
        bodyParam.set("req_b_param_name", (Object)name);
        bodyParam.set("req_b_param_desc", (Object)name);
        bodyParam.set("req_b_param_required", (Object)Boolean.FALSE);
        return bodyParam;
    }

    public static Object initReqBody(HttpItem httpItem, DynamicObject obj) {
        if (httpItem.bodyIsFormData()) {
            DynamicObjectCollection reqBody = obj.getDynamicObjectCollection("web_req_body");
            reqBody.clear();
            return ReqHandler.initFormBody(httpItem, reqBody);
        }
        return ReqHandler.initReqBody(httpItem.getDataMap(), obj);
    }

    private static DynamicObjectCollection initFormBody(HttpItem httpItem, DynamicObjectCollection reqBody) {
        List formItemList = httpItem.getFormItemList();
        for (FormItem formItem : formItemList) {
            DynamicObject bodyParam = reqBody.addNew();
            bodyParam.set("id", (Object)IDService.get().genLongId());
            bodyParam.set("pid", (Object)0L);
            bodyParam.set("req_b_param_name", (Object)formItem.getKey());
            bodyParam.set("req_b_param_desc", (Object)formItem.getKey());
            bodyParam.set("req_b_param_required", (Object)Boolean.FALSE);
            boolean isFile = formItem.isFile();
            if (isFile) {
                bodyParam.set("req_b_param_type", (Object)IscFieldType.IERP_FILE.getTypeName());
                bodyParam.set("req_b_param_example", (Object)formItem.getFilePath());
                continue;
            }
            bodyParam.set("req_b_param_type", (Object)IscFieldType.STRING.getTypeName());
            bodyParam.set("req_b_param_example", (Object)formItem.getValue());
        }
        return reqBody;
    }
}

