/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic.webapi;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.id.IDService;
import kd.isc.iscb.platform.core.api.parsers.model.IscFieldType;
import kd.isc.iscb.platform.core.api.parsers.model.SwaggerField;
import kd.isc.iscb.platform.core.api.webapi.Const;

public class SwaggerHandler
implements Const {
    public static DynamicObjectCollection initUrlParams(List<SwaggerField> urlFields, DynamicObject obj) {
        DynamicObjectCollection dynamicUrlParams = obj.getDynamicObjectCollection("web_url_params");
        dynamicUrlParams.clear();
        int seq = 1;
        for (SwaggerField urlField : urlFields) {
            DynamicObject dynamicUrlParam = dynamicUrlParams.addNew();
            String urlParamName = urlField.getName();
            String urlParamValue = urlField.getDefaultValue() != null ? urlField.getDefaultValue().toString() : "";
            String urlParamDesc = urlField.getDescription();
            boolean urlParamRequired = urlField.isRequired();
            String urlParamType = SwaggerHandler.mapType(urlField.getType()).getTypeName();
            boolean urlParamIsArray = urlField.isArray();
            dynamicUrlParam.set("id", (Object)IDService.get().genLongId());
            dynamicUrlParam.set("seq", (Object)seq++);
            dynamicUrlParam.set("url_param_name", (Object)urlParamName);
            dynamicUrlParam.set("url_param_value", (Object)urlParamValue);
            dynamicUrlParam.set("url_param_desc", (Object)urlParamDesc);
            dynamicUrlParam.set("url_param_type", (Object)urlParamType);
            dynamicUrlParam.set("url_param_required", (Object)urlParamRequired);
            dynamicUrlParam.set("url_param_is_array", (Object)urlParamIsArray);
        }
        return dynamicUrlParams;
    }

    public static DynamicObjectCollection initHeaders(List<SwaggerField> headerFields, DynamicObject obj) {
        DynamicObjectCollection dynamicHeaders = obj.getDynamicObjectCollection("web_req_header");
        dynamicHeaders.clear();
        int seq = 1;
        for (SwaggerField headerField : headerFields) {
            DynamicObject dynamicHeader = dynamicHeaders.addNew();
            String headerName = headerField.getName();
            String headerValue = headerField.getDefaultValue() != null ? headerField.getDefaultValue().toString() : "";
            String headerDesc = headerField.getDescription();
            boolean headerRequired = headerField.isRequired();
            String headerType = SwaggerHandler.mapType(headerField.getType()).getTypeName();
            dynamicHeader.set("id", (Object)IDService.get().genLongId());
            dynamicHeader.set("seq", (Object)seq++);
            dynamicHeader.set("req_h_param_name", (Object)headerName);
            dynamicHeader.set("req_h_param_value", (Object)headerValue);
            dynamicHeader.set("req_h_param_desc", (Object)headerDesc);
            dynamicHeader.set("req_h_param_required", (Object)headerRequired);
            dynamicHeader.set("req_h_param_type", (Object)headerType);
        }
        return dynamicHeaders;
    }

    public static DynamicObjectCollection initRequestBody(List<SwaggerField> requestBodyFields, DynamicObject obj) {
        DynamicObjectCollection dynamicRequestBody = obj.getDynamicObjectCollection("web_req_body");
        dynamicRequestBody.clear();
        int seq = 1;
        for (SwaggerField requestBodyField : requestBodyFields) {
            SwaggerHandler.initRequestBodyParam(requestBodyField, dynamicRequestBody, Collections.emptyList(), 0L, seq++);
        }
        return dynamicRequestBody;
    }

    private static void initRequestBodyParam(SwaggerField field, DynamicObjectCollection dynamicRequestBody, List<String> requiredProperties, Long parentId, int seq) {
        DynamicObject dynamicReqBodyParam = dynamicRequestBody.addNew();
        String reqBodyParamName = field.getName();
        String reqBodyParamValue = field.getDefaultValue() != null ? field.getDefaultValue().toString() : "";
        String reqBodyParamDesc = field.getDescription();
        boolean reqBodyParamIsArray = field.isArray();
        boolean reqBodyParamRequired = requiredProperties != null && requiredProperties.contains(reqBodyParamName) || field.isRequired();
        String reqBodyParamType = SwaggerHandler.mapType(field.getType()).getTypeName();
        dynamicReqBodyParam.set("id", (Object)IDService.get().genLongId());
        dynamicReqBodyParam.set("seq", (Object)seq);
        dynamicReqBodyParam.set("pid", (Object)parentId);
        dynamicReqBodyParam.set("req_b_param_name", (Object)reqBodyParamName);
        dynamicReqBodyParam.set("req_b_param_value", (Object)reqBodyParamValue);
        dynamicReqBodyParam.set("req_b_param_desc", (Object)reqBodyParamDesc);
        dynamicReqBodyParam.set("req_b_param_is_array", (Object)reqBodyParamIsArray);
        dynamicReqBodyParam.set("req_b_param_required", (Object)reqBodyParamRequired);
        dynamicReqBodyParam.set("req_b_param_type", (Object)reqBodyParamType);
        dynamicReqBodyParam.set("req_b_param_example", field.getExampleValue());
        if (field.getProperties() != null && !field.getProperties().isEmpty()) {
            for (SwaggerField subField : field.getProperties()) {
                SwaggerHandler.initRequestBodyParam(subField, dynamicRequestBody, field.getRequiredProperties(), dynamicReqBodyParam.getLong("id"), seq++);
            }
        }
    }

    public static DynamicObjectCollection initResponseBody(List<SwaggerField> responseBodyFields, DynamicObject obj) {
        DynamicObjectCollection dynamicResponseBody = obj.getDynamicObjectCollection("web_resp_body");
        dynamicResponseBody.clear();
        int seq = 1;
        for (SwaggerField responseBodyField : responseBodyFields) {
            SwaggerHandler.initResponseBodyParam(responseBodyField, dynamicResponseBody, 0L, seq++);
        }
        return dynamicResponseBody;
    }

    private static void initResponseBodyParam(SwaggerField field, DynamicObjectCollection dynamicResponseBody, Long parentId, int seq) {
        DynamicObject dynamicRespBodyParam = dynamicResponseBody.addNew();
        String respBodyParamName = field.getName();
        String respBodyParamValue = field.getDefaultValue() != null ? field.getDefaultValue().toString() : "";
        String respBodyParamDesc = field.getDescription();
        boolean respBodyParamIsArray = field.isArray();
        boolean respBodyParamRequired = field.isRequired();
        String respBodyParamExample = field.getExampleValue() != null ? field.getExampleValue().toString() : "";
        String respBodyParamType = SwaggerHandler.mapType(field.getType()).getTypeName();
        dynamicRespBodyParam.set("id", (Object)IDService.get().genLongId());
        dynamicRespBodyParam.set("seq", (Object)seq);
        dynamicRespBodyParam.set("pid", (Object)parentId);
        dynamicRespBodyParam.set("resp_b_param_name", (Object)respBodyParamName);
        dynamicRespBodyParam.set("resp_b_param_value", (Object)respBodyParamValue);
        dynamicRespBodyParam.set("resp_b_param_desc", (Object)respBodyParamDesc);
        dynamicRespBodyParam.set("resp_b_param_is_array", (Object)respBodyParamIsArray);
        dynamicRespBodyParam.set("resp_b_param_required", (Object)respBodyParamRequired);
        dynamicRespBodyParam.set("resp_b_param_example", (Object)respBodyParamExample);
        dynamicRespBodyParam.set("resp_b_param_type", (Object)respBodyParamType);
        if (field.getProperties() != null && !field.getProperties().isEmpty()) {
            for (SwaggerField subField : field.getProperties()) {
                SwaggerHandler.initResponseBodyParam(subField, dynamicResponseBody, dynamicRespBodyParam.getLong("id"), seq++);
            }
        }
    }

    private static IscFieldType mapType(String swaggerType) {
        if (swaggerType == null) {
            return IscFieldType.UNKNOWN;
        }
        switch (swaggerType.toLowerCase(Locale.ENGLISH)) {
            case "string": {
                return IscFieldType.STRING;
            }
            case "integer": 
            case "int": {
                return IscFieldType.INT;
            }
            case "number": 
            case "decimal": {
                return IscFieldType.DECIMAL;
            }
            case "long": {
                return IscFieldType.LONG;
            }
            case "boolean": {
                return IscFieldType.BOOLEAN;
            }
            case "double": {
                return IscFieldType.DOUBLE;
            }
            case "date-time": 
            case "datetime": {
                return IscFieldType.DATETIME;
            }
        }
        return IscFieldType.UNKNOWN;
    }
}

