/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic.webapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.form.container.Tab;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.api.webapi.WebApi;
import kd.isc.iscb.platform.core.api.webapi.WebApiDispatcher;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.script.Script;

public class WebApiTestFormPlugin
extends AbstractFormPlugin {
    private static final String REQ_BODY = "req_body";
    private static final String REQ_HEAD = "req_head";
    private static final String REQ_URL_PARAMS = "req_urlparam";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.activeTab("tab_body");
    }

    public void afterCreateNewData(EventObject e) {
        long webApiId = D.l((Object)this.getView().getFormShowParameter().getCustomParam("webapi"));
        long oldId = D.l((Object)this.getModel().getValue("webapi_id"));
        if (webApiId > 0L && oldId == 0L) {
            WebApi webApi = WebApi.get((long)webApiId);
            this.getModel().setValue("webapi", (Object)webApi.getId());
            CodeEdit reqBody = (CodeEdit)this.getView().getControl(REQ_BODY);
            reqBody.setText(JSON.toJSONString((Object)webApi.getBodyExample(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            this.getPageCache().put(REQ_BODY, reqBody.getText());
            CodeEdit reqHeader = (CodeEdit)this.getView().getControl(REQ_HEAD);
            reqHeader.setText(JSON.toJSONString((Object)webApi.getHeaderExample(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            this.getPageCache().put(REQ_HEAD, reqBody.getText());
            CodeEdit reqUrlParams = (CodeEdit)this.getView().getControl(REQ_URL_PARAMS);
            reqUrlParams.setText(JSON.toJSONString((Object)webApi.getUrlParamsExample(), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
            this.getPageCache().put(REQ_URL_PARAMS, reqBody.getText());
        }
    }

    private String getReqParams(String codeKey) {
        String value;
        CodeEdit codeEdit = (CodeEdit)this.getView().getControl(codeKey);
        if (codeEdit.getText() == null) {
            value = this.getPageCache().get(codeKey);
        } else {
            value = codeEdit.getText();
            this.getPageCache().put(codeKey, value);
        }
        return value;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        try {
            this.doOperation(args);
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void doOperation(AfterDoOperationEventArgs args) {
        String operateKey = args.getOperateKey();
        if ("test".equals(operateKey)) {
            JSONObject queryParam = JSON.parseObject((String)this.getReqParams(REQ_URL_PARAMS));
            JSONObject head = JSON.parseObject((String)this.getReqParams(REQ_HEAD));
            JSONObject body = JSON.parseObject((String)this.getReqParams(REQ_BODY));
            long webApiId = D.l((Object)this.getModel().getValue("webapi_id"));
            WebApi webApi = WebApi.get((long)webApiId);
            CodeEdit respBody = (CodeEdit)this.getView().getControl("resp_body");
            Object execute = WebApiDispatcher.execute((WebApi)webApi, (Map)body, (Map)head, (Map)queryParam);
            respBody.setText(this.serializeResult(execute));
        }
    }

    private String serializeResult(Object execute) {
        String result;
        if (execute instanceof Map || execute instanceof List) {
            result = JSON.toJSONString((Object)execute, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
        } else {
            result = D.s((Object)execute);
            if (JSON.isValid((String)result)) {
                result = JSON.toJSONString((Object)Script.parseJson((String)result), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue});
            }
        }
        if (result == null) {
            result = "";
        }
        return result;
    }
}

