/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.apic.webapi.privacy;

import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.api.webapi.Const;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class WebApiPrivacyFormPlugin
extends AbstractFormPlugin
implements Const,
HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"privacy_num"});
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("treeentryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String datainfoTag = D.s((Object)this.getModel().getValue("privacy_info_tag"));
        Map dataInfo = (Map)Json.toObject((String)datainfoTag);
        if (dataInfo != null) {
            this.getView().getPageCache().put("hasDiff", "false");
            Map originalFields = (Map)dataInfo.get("fields");
            if (originalFields != null && originalFields.size() > 0) {
                DynamicObject api = (DynamicObject)this.getModel().getValue("api");
                String type = D.s((Object)this.getModel().getValue("type"));
                DynamicObject obj = BusinessDataServiceHelper.loadSingleFromCache((Object)D.l((Object)api.getPkValue()), (String)type);
                if (obj == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5df2\u4e0d\u5b58\u5728\u3002", (String)"WebApiPrivacyFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection webReqBody = obj.getDynamicObjectCollection("web_req_body");
                LinkedHashMap<String, Object> curApiBody = new LinkedHashMap<String, Object>();
                Map<Long, List<Map<String, Object>>> coverToMap = this.coverToMap(webReqBody, false);
                this.returnJson(curApiBody, coverToMap, 0L);
                Map curApiBodyFields = (Map)curApiBody.get("fields");
                this.resetDataInfoByCurApiBody(curApiBodyFields, originalFields);
                DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
                collection.clear();
                this.initApiBody(curApiBodyFields, collection);
                this.getView().updateView("treeentryentity");
                TreeEntryGrid treeentryentity = (TreeEntryGrid)this.getControl("treeentryentity");
                treeentryentity.setCollapse(false);
                if (D.x((Object)this.getView().getPageCache().get("hasDiff")) || originalFields.size() > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524dAPI\u9690\u79c1\u7b56\u7565\u6240\u5f15\u7528\u7684\u539f\u59cb\u3010WebAPI\u3011\u8bf7\u6c42\u4f53\u4fe1\u606f\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u8bf7\u91cd\u65b0\u914d\u7f6e\u5e76\u4fdd\u5b58\u3002", (String)"WebApiPrivacyFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void initApiBody(Map<String, Map<String, Object>> curApiBodyFields, DynamicObjectCollection collection) {
        for (Map.Entry<String, Map<String, Object>> entry : curApiBodyFields.entrySet()) {
            Map<String, Object> curApiBodyField = entry.getValue();
            String paramType = D.s((Object)curApiBodyField.get("req_b_param_type"));
            this.setApiBodyInfo(collection, curApiBodyField);
            if (!"STRUCT".equals(paramType)) continue;
            Map fields = (Map)curApiBodyField.get("fields");
            this.initApiBody(fields, collection);
        }
    }

    private void setApiBodyInfo(DynamicObjectCollection collection, Map<String, Object> curApiBodyField) {
        DynamicObject item = collection.addNew();
        item.set("id", curApiBodyField.get("id"));
        item.set("pid", curApiBodyField.get("pid"));
        String paramType = D.s((Object)curApiBodyField.get("req_b_param_type"));
        item.set("req_b_param_name", curApiBodyField.get("req_b_param_name"));
        item.set("req_b_param_value", curApiBodyField.get("req_b_param_value"));
        item.set("req_b_param_type", (Object)paramType);
        item.set("req_b_param_desc", curApiBodyField.get("req_b_param_desc"));
        item.set("req_b_param_is_array", curApiBodyField.get("req_b_param_is_array"));
        item.set("req_b_param_required", curApiBodyField.get("req_b_param_required"));
        item.set("req_b_param_example", curApiBodyField.get("req_b_param_example"));
        String privacy_num = D.s((Object)curApiBodyField.get("privacy_num"));
        item.set("privacy_num", (Object)privacy_num);
        item.set("privacy_id", curApiBodyField.get("privacy_id"));
        item.set("privacy_name", curApiBodyField.get("privacy_name"));
        if (privacy_num != null) {
            item.set("op", (Object)ResManager.loadKDString((String)"\u67e5\u770b\u6570\u636e\u6807\u7b7e\u8be6\u60c5", (String)"WebApiPrivacyFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("api".equals(name) && e.getChangeSet().length == 1 && e.getChangeSet()[0].getNewValue() != null) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            Object newValueId = newValue.getPkValue();
            String type = D.s((Object)this.getModel().getValue("type"));
            DynamicObject api = BusinessDataServiceHelper.loadSingleFromCache((Object)newValueId, (String)type);
            DynamicObjectCollection webReqBody = api.getDynamicObjectCollection("web_req_body");
            DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
            collection.clear();
            for (DynamicObject item : webReqBody) {
                DynamicObject aNew = collection.addNew();
                aNew.set("id", item.get("id"));
                aNew.set("pid", item.get("pid"));
                aNew.set("req_b_param_name", item.get("req_b_param_name"));
                aNew.set("req_b_param_value", item.get("req_b_param_value"));
                aNew.set("req_b_param_type", item.get("req_b_param_type"));
                aNew.set("req_b_param_desc", item.get("req_b_param_desc"));
                aNew.set("req_b_param_is_array", item.get("req_b_param_is_array"));
                aNew.set("req_b_param_required", item.get("req_b_param_required"));
                aNew.set("req_b_param_example", item.get("req_b_param_example"));
            }
            this.getView().updateView("treeentryentity");
            TreeEntryGrid treeentryentity = (TreeEntryGrid)this.getControl("treeentryentity");
            treeentryentity.setCollapse(false);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if ("save".equals(operationKey)) {
            HashMap<String, Object> dataTag = new HashMap<String, Object>();
            DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
            Map<Long, List<Map<String, Object>>> coverToMap = this.coverToMap(collection, true);
            this.returnJson(dataTag, coverToMap, 0L);
            this.getModel().setValue("privacy_info_tag", (Object)Json.toString(dataTag));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if ("save".equals(operationKey)) {
            // empty if block
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        String key = ((Control)src).getKey();
        if ("privacy_num".equals(key)) {
            FormOpener.showF7(this, "privacy_transdatatag", null, "select_strategy", false, false, true);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection returnData;
        super.closedCallBack(evt);
        if ("select_strategy".equals(evt.getActionId()) && (returnData = (ListSelectedRowCollection)evt.getReturnData()) != null && returnData.size() == 1) {
            ListSelectedRow privacyObj = returnData.get(0);
            EntryGrid treeEntryGrid = (EntryGrid)this.getControl("treeentryentity");
            int[] selectRows = treeEntryGrid.getSelectRows();
            if (selectRows != null && selectRows.length == 1) {
                DynamicObjectCollection treeentryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
                DynamicObject item = (DynamicObject)treeentryentity.get(selectRows[0]);
                item.set("privacy_num", (Object)privacyObj.getNumber());
                item.set("privacy_name", (Object)privacyObj.getName());
                item.set("privacy_id", privacyObj.getPrimaryKeyValue());
                item.set("op", (Object)ResManager.loadKDString((String)"\u67e5\u770b\u6570\u636e\u6807\u7b7e\u8be6\u60c5", (String)"WebApiPrivacyFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                this.getView().updateView("treeentryentity", selectRows[0]);
            }
        }
    }

    private Map<Long, List<Map<String, Object>>> coverToMap(DynamicObjectCollection entryEntity, boolean isCurrentForm) {
        HashMap<Long, List<Map<String, Object>>> struct = new HashMap<Long, List<Map<String, Object>>>();
        for (DynamicObject item : entryEntity) {
            List list;
            Long pid = item.getLong("pid");
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            map.put("id", item.getPkValue());
            map.put("pid", pid);
            map.put("req_b_param_name", item.getString("req_b_param_name"));
            map.put("req_b_param_value", item.getString("req_b_param_value"));
            map.put("req_b_param_type", item.getString("req_b_param_type"));
            map.put("req_b_param_desc", item.getString("req_b_param_desc"));
            map.put("req_b_param_is_array", item.getString("req_b_param_is_array"));
            map.put("req_b_param_required", item.getString("req_b_param_required"));
            map.put("req_b_param_example", item.getString("req_b_param_example"));
            if (isCurrentForm) {
                String privacyName = D.s((Object)item.getString("privacy_name"));
                String privacyNum = D.s((Object)item.getString("privacy_num"));
                String privacyId = D.s((Object)item.getString("privacy_id"));
                if (privacyName != null) {
                    map.put("privacy_name", privacyName);
                }
                if (privacyNum != null) {
                    map.put("privacy_num", privacyNum);
                }
                if (privacyId != null) {
                    map.put("privacy_id", privacyId);
                }
            }
            if ((list = (List)struct.get(pid)) == null) {
                LinkedList<LinkedHashMap<String, Object>> newList = new LinkedList<LinkedHashMap<String, Object>>();
                newList.add(map);
                struct.put(pid, newList);
                continue;
            }
            list.add(map);
        }
        return struct;
    }

    private void returnJson(Map<String, Object> details, Map<Long, List<Map<String, Object>>> coverToMap, Long pid) {
        List<Map<String, Object>> list = coverToMap.get(pid);
        if (list == null) {
            return;
        }
        LinkedHashMap<String, Map<String, Object>> fields = new LinkedHashMap<String, Map<String, Object>>(list.size());
        for (Map<String, Object> map : list) {
            Object type = map.get("req_b_param_type");
            if ("STRUCT".equals(type)) {
                this.returnJson(map, coverToMap, D.l((Object)map.get("id")));
            }
            fields.put(D.s((Object)map.get("req_b_param_name")), map);
        }
        if (!fields.isEmpty()) {
            details.put("fields", fields);
        }
    }

    private void resetDataInfoByCurApiBody(Map<String, Map<String, Object>> curApiBodyFields, Map<String, Map<String, Object>> originalFields) {
        boolean hasDiff = false;
        for (Map.Entry<String, Map<String, Object>> entry : curApiBodyFields.entrySet()) {
            String key = entry.getKey();
            Map<String, Object> curFieldInfo = entry.getValue();
            Map<String, Object> oldFieldInfo = originalFields.get(key);
            if (oldFieldInfo != null) {
                String curFieldType = D.s((Object)curFieldInfo.get("req_b_param_type"));
                String oldFieldType = D.s((Object)oldFieldInfo.get("req_b_param_type"));
                if (curFieldType != null && curFieldType.equals(oldFieldType)) {
                    hasDiff = true;
                    Object privacy_num = oldFieldInfo.get("privacy_num");
                    if (privacy_num != null) {
                        curFieldInfo.put("privacy_id", oldFieldInfo.get("privacy_id"));
                        curFieldInfo.put("privacy_num", privacy_num);
                        curFieldInfo.put("privacy_name", oldFieldInfo.get("privacy_name"));
                    }
                    Map fields = (Map)oldFieldInfo.get("fields");
                    if ("STRUCT".equals(curFieldType)) {
                        this.resetDataInfoByCurApiBody((Map)curFieldInfo.get("fields"), fields);
                    }
                    if (fields == null || fields.isEmpty()) {
                        originalFields.remove(key);
                    }
                }
            }
            IPageCache pageCache = this.getView().getPageCache();
            if (!hasDiff && !D.x((Object)pageCache.get("hasDiff"))) {
                this.getView().getPageCache().put("hasDiff", "true");
            }
            hasDiff = false;
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        if ("op".equals(hyperLinkClickEvent.getFieldName())) {
            int rowIndex = hyperLinkClickEvent.getRowIndex();
            DynamicObjectCollection treeentryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("treeentryentity");
            String privacy_num = D.s((Object)((DynamicObject)treeentryentity.get(rowIndex)).getString("privacy_num"));
            if (privacy_num != null) {
                DynamicObject item = BusinessDataServiceHelper.loadSingle((String)"privacy_transdatatag", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)privacy_num)});
                if (item != null) {
                    FormOpener.showView(this, "privacy_transdatatag", item.getPkValue());
                } else {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a%s \u7684\u6570\u636e\u6807\u7b7e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff0c\u65e0\u6cd5\u67e5\u770b\u3002", (String)"WebApiPrivacyFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), privacy_num));
                }
            }
        }
    }
}

