/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.common.topology;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.common.topology.TopologyFormUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.ischub.topology.ISCEventTopology;
import kd.isc.iscb.platform.core.connector.ischub.topology.impl.IscTopologyEnum;
import kd.isc.iscb.platform.core.sf.Const;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class ResourceTopologyViewFormPlugin
extends AbstractFormPlugin
implements Const {
    private static final String BTNCANCEL = "btncancel";
    private static final String DEFINE_TOPOLOGY = "#define";
    private static final String RESOURCE_ID = "resource_id";
    private static final int NODE_SPACE = 70;
    private static final int NODE_HEIGHT_VALUE = 50;
    private static final int UP_X_VALUE = 100;
    private int DOWN_X_VALUE = 900;
    private static final int SECTOR_OFFSET_VALUE = 0;
    private static final int NODE_ADD_VALUE = 20;
    private static final int NODE_WIDTH = 200;
    private static final int BIG_NODE_WIDTH = 500;

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String op = args.getOperateKey();
        String type = D.s((Object)this.getView().getFormShowParameter().getCustomParam("type"));
        long id = D.l((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        if ("resouce_view".equals(op)) {
            FormOpener.showView(this, type, id);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map<String, Object> define = this.loadDefine();
        this.setEditorData(this, define);
        this.getPageCache().put(DEFINE_TOPOLOGY, Json.toString(define));
    }

    private Map<String, Object> loadDefine() {
        String type = D.s((Object)this.getView().getFormShowParameter().getCustomParam("type"));
        long id = D.l((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        ISCEventTopology topology = IscTopologyEnum.valueOf((String)type).getTopology(id);
        List upStreamList = topology.getUpStreamList();
        List downStreamList = topology.getDownStreamList();
        HashMap<String, Object> define = new HashMap<String, Object>();
        define.put("counts", this.buildCounts(upStreamList, downStreamList));
        Map<String, Object> nodes = this.buildNodes(upStreamList, downStreamList);
        define.put("nodes", nodes);
        define.put("links", this.buildLinks(upStreamList, downStreamList, nodes));
        define.put("$tag", String.valueOf(upStreamList.size() + downStreamList.size() + 1));
        return define;
    }

    private int buildCounts(List<String> upStreamList, List<String> downStreamList) {
        int up = upStreamList.size();
        int down = downStreamList.size();
        return 2 * (up + down) + 1;
    }

    private Map<String, Object> buildNodes(List<String> upStreamList, List<String> downStreamList) {
        HashMap<String, Object> nodes = new HashMap<String, Object>();
        int up = upStreamList.size();
        int down = downStreamList.size();
        int id = 1;
        this.DOWN_X_VALUE = this.calCenterX(up) + 500 + down / 2 * 0;
        if (up >= down) {
            Map<String, Object> node;
            for (String key : upStreamList) {
                node = this.buildOneNode(id, key, this.calUpX(id, up), this.calMaxY(id), "up");
                nodes.put(String.valueOf(id), node);
                ++id;
            }
            for (String key : downStreamList) {
                node = this.buildOneNode(id, key, this.calDownX(id - up, down), this.calMinY(id - up, up, down), "down");
                nodes.put(String.valueOf(id), node);
                ++id;
            }
        } else {
            Map<String, Object> node;
            for (String key : upStreamList) {
                node = this.buildOneNode(id, key, this.calUpX(id, up), this.calMinY(id, down, up), "up");
                nodes.put(String.valueOf(id), node);
                ++id;
            }
            for (String key : downStreamList) {
                node = this.buildOneNode(id, key, this.calDownX(id - up, down), this.calMaxY(id - up), "down");
                nodes.put(String.valueOf(id), node);
                ++id;
            }
        }
        nodes.put(String.valueOf(up + down + 1), this.buildCenterNode(up, down));
        return nodes;
    }

    private Map<String, Object> buildOneNode(int i, String s, int x, int y, String direct) {
        HashMap<String, Object> node = new HashMap<String, Object>(6);
        node.put("id", i);
        node.put("title", TopologyFormUtil.getName(s));
        String[] split = s.split(",");
        node.put("type", split[0]);
        node.put(RESOURCE_ID, split[1]);
        node.put("state", split[2]);
        node.put("direct", direct);
        HashMap<String, Integer> coordinate = new HashMap<String, Integer>(4);
        coordinate.put("x", x);
        coordinate.put("y", y);
        coordinate.put("height", 50);
        coordinate.put("width", 200);
        node.put("coordinate", coordinate);
        return node;
    }

    private Map<String, Object> buildLinks(List<String> upStreamList, List<String> downStreamList, Map<String, Object> nodes) {
        HashMap<String, Object> trans = new HashMap<String, Object>(4);
        int up = upStreamList.size();
        int down = downStreamList.size();
        int center = up + down + 1;
        int lineId = up + down + 2;
        int sourceId = 1;
        while (sourceId <= up) {
            trans.put(String.valueOf(lineId), this.buildUpLink(lineId, sourceId, center, up, nodes));
            ++sourceId;
            ++lineId;
        }
        int k = 1;
        while (k <= down) {
            trans.put(String.valueOf(lineId), this.buildDownLink(lineId, center, k + up, down, up, nodes));
            ++k;
            ++lineId;
        }
        return trans;
    }

    private void setEditorData(AbstractFormPlugin form, Map<String, Object> define) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("editable", Boolean.FALSE);
        data.put("define", define);
        Map nodes = (Map)define.get("nodes");
        Map<String, Object> acts = this.buildActs(nodes);
        data.put("acts", acts);
        Map<String, Object> trans = this.buildTrans(define, nodes);
        data.put("trans", trans);
        data.put("meta.js", "topology.js");
        data.put("flow.js", "flow.js");
        ((CustomControl)form.getControl("editor")).setData(data);
    }

    private Map<String, Object> buildActs(Map<String, Object> nodes) {
        HashMap<String, Object> acts = new HashMap<String, Object>(nodes.size());
        for (Map.Entry<String, Object> node : nodes.entrySet()) {
            Map oneNode = (Map)node.getValue();
            String id = node.getKey();
            Map<String, Object> nodeValue = this.buildTips(oneNode);
            HashMap<String, Object> result = new HashMap<String, Object>(2);
            result.put(id, nodeValue);
            result.put("state", JSON.toJSONString(nodeValue, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}).replaceAll("\t", "    "));
            acts.put(id, result);
        }
        return acts;
    }

    private Map<String, Object> buildTips(Map<String, Object> oneNode) {
        HashMap<String, Object> nodeValue = new HashMap<String, Object>();
        nodeValue.put(ResManager.loadKDString((String)"\u540d\u79f0", (String)"ResourceTopologyViewFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.getObjName(D.s((Object)oneNode.get("type")), D.l((Object)oneNode.get(RESOURCE_ID))));
        nodeValue.put(ResManager.loadKDString((String)"\u7c7b\u578b", (String)"ResourceTopologyViewFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), oneNode.get("type"));
        nodeValue.put(ResManager.loadKDString((String)"\u8d44\u6e90ID", (String)"ResourceTopologyViewFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), oneNode.get(RESOURCE_ID));
        nodeValue.put(ResManager.loadKDString((String)"\u72b6\u6001", (String)"ResourceTopologyViewFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.getStateDesc(oneNode));
        nodeValue.put("direct", oneNode.get("direct"));
        return nodeValue;
    }

    private Map<String, Object> buildTrans(Map<String, Object> define, Map<String, Object> nodes) {
        Map links = (Map)define.get("links");
        HashMap<String, Object> trans = new HashMap<String, Object>(links.size());
        for (Map.Entry link : links.entrySet()) {
            Map oneLink = (Map)link.getValue();
            String target = D.s(oneLink.get("target"));
            String id = (String)link.getKey();
            trans.put(id, D.x(((Map)nodes.get(target)).get("state")));
        }
        return trans;
    }

    private String getObjName(String type, long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject obj = QueryServiceHelper.queryOne((String)type, (String)"name", (QFilter[])new QFilter[]{filter});
        return obj == null ? null : obj.getString("name");
    }

    private String getStateDesc(Map<String, Object> oneNode) {
        return "1".equals(D.s((Object)oneNode.get("state"))) ? ResManager.loadKDString((String)"\u53ef\u7528", (String)"ResourceTopologyViewFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u7981\u7528", (String)"ResourceTopologyViewFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok", BTNCANCEL});
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        if ("cancel".equals(evt.getCallBackId())) {
            this.getView().close();
        }
    }

    private Map<String, Object> buildCenterNode(int up, int down) {
        String type = D.s((Object)this.getView().getFormShowParameter().getCustomParam("type"));
        long id = D.l((Object)this.getView().getFormShowParameter().getCustomParam("id"));
        HashMap<String, Object> node = new HashMap<String, Object>(5);
        node.put("id", up + down + 1);
        node.put("title", TopologyFormUtil.getName(this.getKey(type, id)));
        node.put("type", type);
        node.put(RESOURCE_ID, id);
        node.put("state", this.getState(type, id));
        node.put("direct", "center");
        HashMap<String, Integer> coordinate = new HashMap<String, Integer>(4);
        coordinate.put("x", this.calCenterX(up));
        coordinate.put("y", this.calCenterY(up, down));
        coordinate.put("height", this.calCenterHeight(up, down));
        coordinate.put("width", 200);
        node.put("coordinate", coordinate);
        return node;
    }

    private int calCenterX(int up) {
        return this.calUpX(1, up) + 500;
    }

    private int calCenterHeight(int up, int down) {
        return Math.max(up, down) > 1 ? Math.max(up, down) * 20 + 50 : 50;
    }

    private int calCenterY(int up, int down) {
        return Math.max(up, down) > 1 ? (Math.max(up, down) * 70 + 70) / 2 - Math.max(up, down) * 20 / 2 : 70;
    }

    private Map<String, Object> buildUpLink(int lineId, int sourceId, int center, int up, Map<String, Object> nodes) {
        HashMap<String, Object> tran = new HashMap<String, Object>(5);
        tran.put("id", String.valueOf(lineId));
        tran.put("type", "NormalTransition");
        tran.put("source", String.valueOf(sourceId));
        tran.put("target", String.valueOf(center));
        tran.put("path", this.buildUpPath(up, lineId - center));
        tran.put("title", this.buildLinkTitle(String.valueOf(sourceId), String.valueOf(center), nodes));
        return tran;
    }

    private String buildUpPath(int up, int l) {
        int k = up / 2;
        if (up % 2 == 0) {
            if (l <= k) {
                return "right:0|left:" + ((l - k) * 20 - 10);
            }
            return "right:0|left:" + ((l - k - 1) * 20 + 10);
        }
        return "right:0|left:" + (l - k - 1) * 20;
    }

    private Map<String, Object> buildDownLink(int lineId, int sourceId, int center, int down, int up, Map<String, Object> nodes) {
        HashMap<String, Object> tran = new HashMap<String, Object>(5);
        tran.put("id", String.valueOf(lineId));
        tran.put("type", "NormalTransition");
        tran.put("source", String.valueOf(sourceId));
        tran.put("target", String.valueOf(center));
        tran.put("path", this.buildDownPath(down, lineId - sourceId - up));
        tran.put("title", this.buildLinkTitle(String.valueOf(sourceId), String.valueOf(center), nodes));
        return tran;
    }

    private String buildDownPath(int down, int l) {
        int k = down / 2;
        if (down % 2 == 0) {
            if (l <= k) {
                return "right:" + ((l - k) * 20 - 10) + "|left:0";
            }
            return "right:" + ((l - k - 1) * 20 + 10) + "|left:0";
        }
        return "right:" + (l - k - 1) * 20 + "|left:0";
    }

    private String buildLinkTitle(String sourceId, String targetId, Map<String, Object> nodes) {
        Map source = (Map)nodes.get(sourceId);
        Map target = (Map)nodes.get(targetId);
        String sourceType = D.s(source.get("type"));
        String targetType = D.s(target.get("type"));
        if ("isc_metadata_schema".equals(sourceType)) {
            return ResManager.loadKDString((String)"\u4e8b\u4ef6\u89e6\u53d1", (String)"ResourceTopologyViewFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        if ("isc_metadata_schema".equals(targetType) && D.s(target.get("title")).indexOf("(E)") > 0 && D.s(target.get("title")).indexOf("(E)") < D.s(target.get("title")).indexOf(58)) {
            return ResManager.loadKDString((String)"\u4e8b\u4ef6\u6e90", (String)"ResourceTopologyViewFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private String getKey(String type, long id) {
        return type + ',' + id + ',' + this.getState(type, id);
    }

    private String getState(String type, long id) {
        if (type.equals("isc_job_mutex")) {
            return "1";
        }
        QFilter qFilter = new QFilter("id", "=", (Object)id);
        DynamicObject enable = QueryServiceHelper.queryOne((String)type, (String)"enable", (QFilter[])new QFilter[]{qFilter});
        return enable.getString("enable");
    }

    private int calUpX(int i, int up) {
        int k = up / 2;
        if (up % 2 == 0) {
            if (i <= k) {
                return (k - i) * 0 + 100;
            }
            return (i - k - 1) * 0 + 100;
        }
        return Math.abs(k + 1 - i) * 0 + 100;
    }

    private int calDownX(int i, int down) {
        int k = down / 2;
        if (down % 2 == 0) {
            if (i <= k) {
                return this.DOWN_X_VALUE - (k - i) * 0;
            }
            return this.DOWN_X_VALUE - (i - k - 1) * 0;
        }
        return this.DOWN_X_VALUE - Math.abs(k + 1 - i) * 0;
    }

    private int calMaxY(int i) {
        return i * 70;
    }

    private int calMinY(int l, int max, int min) {
        int cenY = this.calCenterY(max, min);
        int height = this.calCenterHeight(max, min);
        int c = cenY + height / 2;
        if (min == 1) {
            return c - 25;
        }
        if (min == max) {
            return l * 70;
        }
        int k = min / 2;
        if (min % 2 == 0) {
            if (l <= k) {
                return c - (k - l) * 70 - 70 - 10;
            }
            return c + (l - k - 1) * 70 + 10;
        }
        return c - 25 + (l - k - 1) * 70;
    }

    public void customEvent(CustomEventArgs e) {
        super.customEvent(e);
        String event = e.getEventName();
        if ("open_editor".equals(event)) {
            Map map = (Map)Json.toObject((String)e.getEventArgs());
            String type = D.s(map.get("type"));
            if ("NormalTransition".equals(type)) {
                return;
            }
            String nodeId = D.s(map.get("id"));
            Map define = (Map)Json.toObject((String)this.getPageCache().get(DEFINE_TOPOLOGY));
            Map nodes = (Map)define.get("nodes");
            Map node = (Map)nodes.get(nodeId);
            long id = D.l(node.get(RESOURCE_ID));
            FormOpener.showView(this, type, id);
        } else if ("viewSource".equals(e.getEventName())) {
            this.openResourceDiagram(e);
        }
    }

    private void openResourceDiagram(CustomEventArgs e) {
        Map map = (Map)Json.toObject((String)e.getEventArgs());
        String nodeId = D.s(map.get("id"));
        Map define = (Map)Json.toObject((String)this.getPageCache().get(DEFINE_TOPOLOGY));
        Map nodes = (Map)define.get("nodes");
        Map node = (Map)nodes.get(nodeId);
        long resource_id = D.l(node.get(RESOURCE_ID));
        String type = D.s(node.get("type"));
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("type", type);
        params.put("id", resource_id);
        FormOpener.showTabForm(this, "isc_topology_view", TopologyFormUtil.getName(type + ',' + resource_id), params, "");
    }
}

