/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.comp;

import java.sql.Connection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class DataCompExecutionFormPlugin
extends AbstractFormPlugin {
    private static final String END_TIME = "end_time";
    private static final String START_TIME = "start_time";
    private static final String STATE = "state";
    private static final String EXECUTE_COUNT = "execute_count";
    private static final String SOURCE_COUNT = "source_count";
    private static final String DATA_COMP_SYN = "data_comp_syn";
    private static final String DATA_COMP = "data_comp";
    private static final String NUMBER = "number";
    private static final String TAR_NO_SYN_COUNT = "tar_no_syn_count";
    private static final String TAR_NO_EXIST_COUNT = "tar_no_exist_count";
    private static final String ISC_DATA_COMP_EXE = "isc_data_comp_exe";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setStatus(OperationStatus.VIEW);
        Object object = e.getSource();
        if (object instanceof BillView) {
            BillView view = (BillView)object;
            FormShowParameter showParameter = view.getFormShowParameter();
            if (showParameter == null) {
                return;
            }
            Object pkId = ((BillShowParameter)showParameter).getPkId();
            if (pkId != null) {
                DynamicObject execution = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)ISC_DATA_COMP_EXE);
                this.showTips(execution);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        if (StringUtils.equals((CharSequence)"show_log", (CharSequence)operationKey)) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("showType", ShowType.Modal);
            FormOpener.showList(this, "isc_data_comp_exe_det", "data_comp_exe", D.s((Object)FormOpener.getSelectedId(this, evt)), param);
        } else if (StringUtils.equals((CharSequence)"fresh_bill", (CharSequence)operationKey)) {
            String number = D.s((Object)this.getModel().getValue(NUMBER));
            DynamicObject execution = BusinessDataServiceHelper.loadSingle((String)ISC_DATA_COMP_EXE, (String)"strategy,source_count,tar_no_exist_count,tar_no_syn_count,tar_no_same_count,state,start_time,end_time,execute_count", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)number)});
            this.showTips(execution);
        } else if (StringUtils.equals((CharSequence)"datasyn", (CharSequence)operationKey)) {
            long no_exist_count = D.l((Object)this.getModel().getDataEntity(true).get(TAR_NO_EXIST_COUNT));
            long no_syn_count = D.l((Object)this.getModel().getDataEntity(true).get(TAR_NO_SYN_COUNT));
            if (no_exist_count == 0L && no_syn_count == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6b63\u5e38\u4e0d\u9700\u8981\u6570\u636e\u8865\u507f\uff01", (String)"DataCompExecutionFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject data_comp = (DynamicObject)this.getModel().getDataEntity(true).get(DATA_COMP);
            String number = this.getModel().getDataEntity().getString(NUMBER);
            this.openForm(data_comp, number);
        }
    }

    public void openForm(DynamicObject data_comp, Object number) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.setFormId("isc_data_compst_progress");
        showParameter.setCustomParam("data_comp_id", data_comp.getPkValue());
        showParameter.setCustomParam(NUMBER, number);
        showParameter.setCustomParam("executionId", this.getModel().getDataEntity(true).getPkValue());
        showParameter.setCaption(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8865\u507f\uff1a%s", (String)"DataCompExecutionFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), StringUtil.trim((String)data_comp.getString("name"), (int)20)));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, DATA_COMP_SYN));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)DATA_COMP_SYN)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void showTips(DynamicObject execution) {
        if (execution != null) {
            String source_count = execution.getString(SOURCE_COUNT);
            this.getModel().setValue(SOURCE_COUNT, (Object)source_count);
            String tar_no_exist_count = execution.getString(TAR_NO_EXIST_COUNT);
            this.getModel().setValue(TAR_NO_EXIST_COUNT, (Object)tar_no_exist_count);
            String tar_no_syn_count = execution.getString(TAR_NO_SYN_COUNT);
            this.getModel().setValue(TAR_NO_SYN_COUNT, (Object)tar_no_syn_count);
            this.getModel().setValue(EXECUTE_COUNT, execution.get(EXECUTE_COUNT));
            String state = execution.getString(STATE);
            this.getModel().setValue(STATE, (Object)state);
            this.getModel().setValue(START_TIME, (Object)execution.getDate(START_TIME));
            this.getModel().setValue(END_TIME, (Object)execution.getDate(END_TIME));
            String content = "";
            Object executionId = execution.getPkValue();
            Object compensate_su = this.getCount(executionId, "S");
            Object compensate_fa = this.getCount(executionId, "F");
            Object compensate_no = this.getCount(executionId, "N");
            if ("F".equalsIgnoreCase(state)) {
                content = ResManager.loadKDString((String)"\u5bf9\u6bd4\u5931\u8d25\uff01", (String)"DataCompExecutionFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            } else if ("X".equalsIgnoreCase(state)) {
                content = ResManager.loadKDString((String)"\u5bf9\u6bd4\u64a4\u9500\uff01", (String)"DataCompExecutionFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            } else if ("S".equalsIgnoreCase(state) || "P".equalsIgnoreCase(state) || "N".equalsIgnoreCase(state)) {
                if (D.l((Object)source_count) == 0L) {
                    content = ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf\u6ca1\u6709\u6570\u636e\uff01", (String)"DataCompExecutionFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                }
                if (D.l((Object)tar_no_exist_count) > 0L) {
                    content = String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u4e2d\u7f3a\u5931\u884c\u6570\uff1a%s\u884c\uff1b", (String)"DataCompExecutionFormPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), tar_no_exist_count);
                }
                if (D.l((Object)tar_no_syn_count) > 0L) {
                    content = content + String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u4e2d\u672a\u66f4\u65b0\u884c\u6570\uff1a%s\u884c\uff1b", (String)"DataCompExecutionFormPlugin_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), tar_no_syn_count);
                }
                if (D.l((Object)tar_no_exist_count) == 0L && D.l((Object)tar_no_syn_count) == 0L) {
                    content = ResManager.loadKDString((String)"\u8be5\u5bf9\u6bd4\u7b56\u7565\u4e0b\uff0c\u6e90\u548c\u76ee\u6807\u6570\u636e\u4e00\u81f4\uff01", (String)"DataCompExecutionFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
                    this.getView().setVisible(Boolean.FALSE, new String[]{"datasyn"});
                }
            }
            String str = "";
            if (D.l((Object)compensate_su) > 0L) {
                str = String.format(ResManager.loadKDString((String)"\u8865\u507f\u6210\u529f\uff1a%s \u884c\uff1b", (String)"DataCompExecutionFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), compensate_su);
            }
            if (D.l((Object)compensate_fa) > 0L) {
                str = str + String.format(ResManager.loadKDString((String)"\u8865\u507f\u5931\u8d25\uff1a%s \u884c\uff1b", (String)"DataCompExecutionFormPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), compensate_fa);
            }
            if (D.l((Object)compensate_no) > 0L) {
                str = str + String.format(ResManager.loadKDString((String)"\u672a\u6267\u884c\u8865\u507f\uff1a%s \u884c\uff0c\u8bf7\u53ca\u65f6\u540c\u6b65\u3002", (String)"DataCompExecutionFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), compensate_no);
            }
            content = content + str;
            this.getView().setVisible(Boolean.TRUE, new String[]{"datasyn"});
            if (StringUtil.isEmpty((String)content)) {
                this.getModel().setValue("conclusion", (Object)" ");
            } else {
                this.getModel().setValue("conclusion", (Object)(content.substring(0, content.length() - 1) + "\u3002"));
            }
            this.getView().setStatus(OperationStatus.VIEW);
            this.getModel().updateCache();
        }
    }

    private Object getCount(Object executionId, String status) {
        List<Object> values = Collections.singletonList(executionId);
        List<Integer> types = Collections.singletonList(12);
        String sql = "select count(1) from t_isc_data_comp_exe_det where fdata_comp_exe = ? and fcompensate_state = '" + status + "'";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        Object totalCount = 0;
        try {
            totalCount = DbUtil.executeScalar((Connection)cn, (String)sql, values, types);
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u6570\u636e\u53d1\u751f\u5f02\u5e38:%s", (String)"DataCompExecutionFormPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
        return totalCount;
    }
}

