/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.comp;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.AutoMappingUtil;
import kd.isc.iscb.formplugin.util.CompareUtil;
import kd.isc.iscb.formplugin.util.CustomFunctionUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class DataCompFormPlugin
extends AbstractFormPlugin
implements CellClickListener {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("(\\(\\d+\\))");
    private static final String ISC_DATA_COMP_EXE = "isc_data_comp_exe";
    private static final String ACTION_GET_TS_FIELD = "get_ts_field";
    private static final String ACTION_GET_FILTER = "get_filter";
    private static final String ISC_DATA_COPY = "isc_data_copy";
    private static final String DATA_COPY_ID = "data_copy_id";
    private static final String TARGET_SCHEMA_ID = "target_schema_id";
    private static final String SOURCE_SCHEMA_ID = "source_schema_id";
    private static final String FILTER_VALUE_VAR = "filter_value_var";
    private static final String NUMBER = "number";
    private static final String ISC_DATA_COMP = "isc_data_comp";
    private static final String NAME = "name";
    private static final String DATA_COPY = "data_copy";
    private static final String PARAM_NAME = "param_name";
    private static final String PARAMS_ENTRYENTITY = "params_entryentity";
    private static final String STRATEGY_CHECK_UPDATE = "CheckUpdate";
    private static final String STRATEGY = "strategy";
    private static final String DATA_SCOPE = "data_scope";
    private static final String TS_EXPR = "ts_expr";
    private static final String TAR_TS_FIELD = "tar_ts_field";
    private static final String SRC_TS_FIELD = "src_ts_field";
    private static final String BTN_VECTORAP1 = "vectorap1";
    private static final String BTN_VECTORAP = "vectorap";
    private static final String FILTER_COLUMN = "filter_column";
    private static final String FILTER_LABEL = "filter_label";
    private static final String FILTER_ENTRIES = "data_scope";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid filterEntries = (EntryGrid)this.getView().getControl("data_scope");
        filterEntries.addCellClickListener((CellClickListener)this);
        this.addClickListeners(new String[]{BTN_VECTORAP, BTN_VECTORAP1});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String strategy = D.s((Object)this.getModel().getValue(STRATEGY));
        if (!STRATEGY_CHECK_UPDATE.equals(strategy)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SRC_TS_FIELD, TAR_TS_FIELD, TS_EXPR, BTN_VECTORAP, BTN_VECTORAP1});
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFilterParamsCombo();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            if (CustomFunctionUtil.isEntryDuplicate(PARAMS_ENTRYENTITY, PARAM_NAME, this.getModel(), this.getView())) {
                args.setCancel(true);
                return;
            }
            String strategy = D.s((Object)this.getModel().getValue(STRATEGY));
            if (STRATEGY_CHECK_UPDATE.equals(strategy)) {
                if (StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(SRC_TS_FIELD)))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\"\u6e90\u5355\u65f6\u95f4\u6233\u5c5e\u6027\"\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"DataCompFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(10000));
                    args.setCancel(true);
                    return;
                }
                if (StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(TAR_TS_FIELD)))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\"\u76ee\u6807\u5355\u65f6\u95f4\u6233\u5c5e\u6027\"\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"DataCompFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(10000));
                    args.setCancel(true);
                    return;
                }
                if (StringUtil.isEmpty((String)D.s((Object)this.getModel().getValue(TS_EXPR)))) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\"\u5224\u65ad\u8868\u8fbe\u5f0f\"\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"DataCompFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(10000));
                    args.setCancel(true);
                }
            }
            this.getModel().setValue("status", (Object)Character.valueOf('C'));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = null;
        int rowIndex = -1;
        if (changeSet.length > 0) {
            newValue = changeSet[0].getNewValue();
            rowIndex = e.getChangeSet()[0].getRowIndex();
        }
        if (STRATEGY.equals(name)) {
            if (STRATEGY_CHECK_UPDATE.equals(newValue)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{SRC_TS_FIELD, TAR_TS_FIELD, TS_EXPR, BTN_VECTORAP, BTN_VECTORAP1});
            } else {
                this.getView().setVisible(Boolean.FALSE, new String[]{SRC_TS_FIELD, TAR_TS_FIELD, TS_EXPR, BTN_VECTORAP, BTN_VECTORAP1});
            }
        } else if (PARAM_NAME.equals(name)) {
            this.checkSameParamName(newValue, rowIndex);
            this.initFilterParamsCombo();
        } else if (DATA_COPY.equals(name) && newValue instanceof DynamicObject) {
            DynamicObject object = (DynamicObject)newValue;
            DynamicObject schema = BusinessDataServiceHelper.loadSingle((Object)object.getPkValue(), (String)ISC_DATA_COPY);
            DynamicObject sourceSchema = (DynamicObject)schema.get("source_schema");
            DynamicObject src = BusinessDataServiceHelper.loadSingle((Object)sourceSchema.getPkValue(), (String)"isc_metadata_schema");
            String type = D.s((Object)src.get("type"));
            if (!("ENTITY".equalsIgnoreCase(type) || "TABLE".equalsIgnoreCase(type) || "VIEW".equalsIgnoreCase(type))) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6e90\u96c6\u6210\u5bf9\u8c61\u7c7b\u578b\u4e3a \"%s \" \u7684\u96c6\u6210\u65b9\u6848", (String)"DataCompFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), type), Integer.valueOf(10000));
                this.getModel().setValue(DATA_COPY, null);
                return;
            }
            DynamicObjectCollection mapping_collection = (DynamicObjectCollection)schema.get("mapping_entries");
            boolean b = false;
            for (DynamicObject obj : mapping_collection) {
                if (!obj.getBoolean("candidate_key")) continue;
                b = true;
                String srcColumn = D.s((Object)obj.get("mapping_src_column"));
                String tarColumn = D.s((Object)obj.get("mapping_tar_column"));
                if (tarColumn == null || tarColumn.indexOf(46) >= 0 || srcColumn != null) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u5019\u9009\u952e\u5b57\u6bb5\u5bf9\u5e94\u7684\u6e90\u5355\u5b57\u6bb5\u4e3a\u7a7a\u7684\u96c6\u6210\u65b9\u6848", (String)"DataCompFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(10000));
                this.getModel().setValue(DATA_COPY, null);
                return;
            }
            if (!b) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6ca1\u6709\u5019\u9009\u952e\u5b57\u6bb5\u7684\u96c6\u6210\u65b9\u6848", (String)"DataCompFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(10000));
                this.getModel().setValue(DATA_COPY, null);
                return;
            }
            this.setName(schema);
            this.setNumber(schema);
        }
    }

    private void checkSameParamName(Object newValue, int rowIndex) {
        DynamicObjectCollection param_entries = this.getModel().getEntryEntity(PARAMS_ENTRYENTITY);
        int i = -1;
        for (DynamicObject param_entry : param_entries) {
            String paramsName = param_entry.getString(PARAM_NAME);
            String s = D.s((Object)newValue);
            if (s == null || ++i == rowIndex || !s.equals(paramsName)) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u540d%s\u91cd\u590d,\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"DataCompFormPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), newValue), Integer.valueOf(5000));
            return;
        }
    }

    private void setName(DynamicObject schema) {
        String name1 = this.getModel().getValue(NAME).toString();
        if (StringUtil.isEmpty((String)name1)) {
            String schemaName = schema.getString(NAME);
            String compName = String.format(ResManager.loadKDString((String)"%s-\u6570\u636e\u5bf9\u6bd4", (String)"DataCompFormPlugin_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), schemaName);
            DynamicObject[] objects = BusinessDataServiceHelper.load((String)ISC_DATA_COMP, (String)NAME, (QFilter[])new QFilter[]{new QFilter(NAME, "like", (Object)(compName + "%"))});
            if (objects.length == 0) {
                this.getModel().setValue(NAME, (Object)compName);
            } else {
                int max = this.getMax(objects, NAME);
                this.getModel().setValue(NAME, (Object)(compName + "(" + max + ")"));
            }
        }
    }

    private void setNumber(DynamicObject schema) {
        String number = this.getModel().getValue(NUMBER).toString();
        if (StringUtil.isEmpty((String)number)) {
            String schemaNumber = schema.getString(NUMBER) + "-DATACOMP";
            DynamicObject[] objectsFN = BusinessDataServiceHelper.load((String)ISC_DATA_COMP, (String)NUMBER, (QFilter[])new QFilter[]{new QFilter(NUMBER, "like", (Object)(schemaNumber + "%"))});
            if (objectsFN.length == 0) {
                this.getModel().setValue(NUMBER, (Object)schemaNumber);
            } else {
                int max = this.getMax(objectsFN, NUMBER);
                this.getModel().setValue(NUMBER, (Object)(schemaNumber + "(" + max + ")"));
            }
        }
    }

    private int getMax(DynamicObject[] objectsFN, String number) {
        int max = 0;
        Pattern pattern = NUMBER_PATTERN;
        for (DynamicObject obj : objectsFN) {
            String name = obj.getString(number);
            Matcher matcher = pattern.matcher(name);
            if (!matcher.find()) continue;
            String group = matcher.group();
            int num = Integer.parseInt(group.substring(group.indexOf(40) + 1, group.indexOf(41)));
            max = Math.max(max, num);
        }
        return max + 1;
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        if (PARAMS_ENTRYENTITY.equals(e.getEntryProp().getName())) {
            this.initFilterParamsCombo();
        }
    }

    private void initFilterParamsCombo() {
        DynamicObjectCollection param_entries = this.getModel().getEntryEntity(PARAMS_ENTRYENTITY);
        ComboEdit filter_value_var = (ComboEdit)this.getView().getControl(FILTER_VALUE_VAR);
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        for (DynamicObject param_entry : param_entries) {
            ComboItem comboItem = new ComboItem();
            String paramsName = param_entry.getString(PARAM_NAME);
            if (StringUtil.isEmpty((String)paramsName)) continue;
            comboItem.setValue(paramsName);
            comboItem.setCaption(new LocaleString(paramsName));
            items.add(comboItem);
        }
        filter_value_var.setComboItems(items);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        String key = ((Control)src).getKey();
        if (BTN_VECTORAP.equals(key)) {
            this.getTsField(SOURCE_SCHEMA_ID, 1);
        } else if (BTN_VECTORAP1.equals(key)) {
            this.getTsField(TARGET_SCHEMA_ID, 2);
        }
    }

    private void getTsField(String schema_id, int i) {
        long srcId = (Long)this.getModel().getValue(DATA_COPY_ID);
        if (srcId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u96c6\u6210\u65b9\u6848\uff01", (String)"DataCompFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)srcId, (String)ISC_DATA_COPY);
        Object source_schema_id = object.get(schema_id);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("id", source_schema_id);
        param.put("$row", i);
        FormOpener.showForm(this, "isc_meta_properties", ResManager.loadKDString((String)"\u9009\u62e9\u5143\u6570\u636e\u5c5e\u6027", (String)"DataCompFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, ACTION_GET_TS_FIELD);
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        long srcId = D.l((Object)this.getModel().getValue(DATA_COPY_ID));
        if (srcId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u96c6\u6210\u65b9\u6848!", (String)"DataCompFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        String fieldKey = cellClickEvent.getFieldKey();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)srcId, (String)ISC_DATA_COPY);
        Object source_schema_id = object.get(SOURCE_SCHEMA_ID);
        if ((fieldKey.equals(FILTER_COLUMN) || fieldKey.equals(FILTER_LABEL)) && D.l((Object)source_schema_id) != 0L) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("id", source_schema_id);
            param.put("$row", cellClickEvent.getRow());
            FormOpener.showForm(this, "isc_meta_properties", ResManager.loadKDString((String)"\u9009\u62e9\u5143\u6570\u636e\u5c5e\u6027", (String)"DataCompFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), param, ACTION_GET_FILTER);
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if (action.equals(ACTION_GET_FILTER)) {
            Object returnData = evt.getReturnData();
            if (returnData instanceof List) {
                List data = (List)returnData;
                AutoMappingUtil.setReturnListValues(data, this.getView());
            } else {
                this.setReturnValues(returnData, action);
            }
        } else if (ACTION_GET_TS_FIELD.equals(action)) {
            Map map;
            Object rowValue;
            Object returnData = evt.getReturnData();
            if (returnData instanceof Map && (rowValue = (map = (Map)returnData).get("$row")) != null) {
                this.setTimeStamp(map, rowValue);
            }
            this.autoCreateExpr();
        } else if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"data_comp")) {
            this.getView().setStatus(OperationStatus.VIEW);
        } else if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"data_comp_param")) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }

    private void autoCreateExpr() {
        String src = D.s((Object)this.getModel().getValue(SRC_TS_FIELD));
        String tar = D.s((Object)this.getModel().getValue(TAR_TS_FIELD));
        if (src != null && tar != null) {
            int index = src.indexOf(40);
            String srcField = src.substring(0, index);
            String srcFieldType = src.substring(index + 1, src.indexOf(41));
            int endIndex = tar.indexOf(40);
            String tarField = tar.substring(0, endIndex);
            String tarFieldType = tar.substring(endIndex + 1, tar.indexOf(41));
            if (!srcFieldType.equalsIgnoreCase(tarFieldType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6e90\u5355\u65f6\u95f4\u6233\u5c5e\u6027\u7c7b\u578b\u4e0e\u76ee\u6807\u5355\u65f6\u95f4\u6233\u5c5e\u6027\u7c7b\u578b\u4e0d\u4e00\u6837\uff0c\u8bf7\u68c0\u67e5\u786e\u8ba4\uff01", (String)"DataCompFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(10000));
            }
            if ("datetime".equalsIgnoreCase(srcFieldType) && "datetime".equalsIgnoreCase(tarFieldType)) {
                this.getModel().setValue(TS_EXPR, (Object)("src." + srcField + " <= tar." + tarField));
            } else {
                this.getModel().setValue(TS_EXPR, (Object)("src." + srcField + " == tar." + tarField));
            }
        }
    }

    private void setTimeStamp(Map<?, ?> map, Object rowValue) {
        int index = Integer.parseInt(rowValue.toString());
        Object number = map.get(NUMBER);
        String dataType = D.s(map.get("data_type"));
        String field = number + "(" + dataType + ")";
        if (dataType.contains("REF") || "ml_string".equalsIgnoreCase(dataType) || "ENUM".equalsIgnoreCase(dataType) || "ENTRIES".equalsIgnoreCase(dataType)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65f6\u95f4\u6233\u5c5e\u6027\u4e0d\u652f\u6301REF\u3001\u5206\u5f55\u3001\u591a\u8bed\u8a00\u3001\u679a\u4e3e\u7684\u7c7b\u578b", (String)"DataCompFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            field = null;
        }
        if (index == 1) {
            this.getModel().setValue(SRC_TS_FIELD, (Object)field);
        } else {
            this.getModel().setValue(TAR_TS_FIELD, (Object)field);
        }
    }

    private void setReturnValues(Object data, String action) {
        Map map;
        Object rowValue;
        if (data instanceof Map && (rowValue = (map = (Map)data).get("$row")) != null) {
            int index = Integer.parseInt(rowValue.toString());
            if (action.equals(ACTION_GET_FILTER)) {
                this.setFilterColumnValues(map, index);
            }
        }
    }

    private void setFilterColumnValues(Map<?, ?> data, int index) {
        DynamicObject row = this.getModel().getEntryRowEntity("data_scope", index);
        row.set(FILTER_COLUMN, data.get(NUMBER));
        row.set(FILTER_LABEL, data.get(NAME));
        this.getView().updateView("data_scope");
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("save".equals(operateKey)) {
            this.setPageView(args);
        } else if ("exec_comp1".equals(operateKey)) {
            Object pkValue = this.getModel().getDataEntity().getPkValue();
            if (pkValue != null) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)ISC_DATA_COMP);
                CompareUtil.comp(this, dynamicObject);
            }
        } else if ("comp_result1".equals(operateKey)) {
            FormOpener.showList((AbstractFormPlugin)this, ISC_DATA_COMP_EXE, "data_comp", args);
            this.setPageView(args);
        }
    }

    private void setPageView(AfterDoOperationEventArgs args) {
        boolean success = args.getOperationResult().isSuccess();
        if (success) {
            this.getView().setStatus(OperationStatus.VIEW);
        }
    }
}

