/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.comp;

import java.sql.Timestamp;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.datacomp.DataCompTask;
import kd.isc.iscb.platform.core.datacomp.DataCompThread;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.util.DataTypeEqualsUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class DataCompParamFormPlugin
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Map params = parameter.getCustomParams();
        if (params != null && params.containsKey("dataCompId")) {
            this.initModel(params);
        }
        super.afterBindData(e);
    }

    private void initModel(Map<String, Object> params) {
        IDataModel model = this.getModel();
        DynamicObject dataComp = BusinessDataServiceHelper.loadSingle((Object)params.get("dataCompId"), (String)"isc_data_comp");
        if (!StringUtil.isEmpty((String)D.s((Object)model.getValue("state")))) {
            return;
        }
        String number = DataCompTask.generateExecutionNumber((DynamicObject)dataComp);
        String strategy = dataComp.getString("strategy");
        model.setValue("number", (Object)number);
        model.setValue("data_comp", dataComp.getPkValue());
        model.setValue("strategy", (Object)strategy);
        model.setValue("state", (Object)"C");
        model.setValue("start_time", (Object)new Timestamp(System.currentTimeMillis()));
        model.setValue("end_time", (Object)"");
        model.setValue("creator", (Object)RequestContext.get().getUserId());
        model.setValue("params_entryentity", (Object)DataCompTask.createParams((DynamicObject)dataComp, (DynamicObject)this.getModel().getDataEntity(), params));
        model.setValue("data_scope", DataCompTask.createFilterParams((DynamicObject)dataComp, (DynamicObject)this.getModel().getDataEntity(), params));
        this.getView().updateView();
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        if (StringUtils.equals((CharSequence)"btnok", (CharSequence)operationKey)) {
            this.checkAndExecute();
        }
    }

    private void checkAndExecute() {
        StringBuilder messages = new StringBuilder();
        DynamicObjectCollection c = this.getModel().getEntryEntity("params_entryentity");
        for (DynamicObject o : c) {
            String name = o.getString("param_name");
            String dataType = o.getString("param_type");
            String value = o.getString("param_value");
            if (StringUtil.isEmpty((String)value)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u53c2\u6570\u4e3a\u7a7a!", (String)"DataCompParamFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), name));
                return;
            }
            if ("*".equals(value.trim()) || DataTypeEqualsUtil.isMatchType((String)value, (String)dataType)) continue;
            messages.append(ResManager.loadKDString((String)"\u5b57\u6bb5", (String)"DataCompParamFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(name).append(ResManager.loadKDString((String)"\u503c\u683c\u5f0f\u4e0d\u6b63\u786e", (String)"DataCompParamFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        String valid = messages.toString();
        if (!StringUtil.isEmpty((String)valid)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("execute", (IFormPlugin)this);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u662f\u5426\u7ee7\u7eed\u6267\u884c\uff1f\u5b57\u6bb5\u503c\u6216\u7c7b\u578b\u4e0d\u5339\u914d\uff1a%s", (String)"DataCompParamFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), valid), MessageBoxOptions.YesNo, confirmCallBacks);
        } else {
            this.execute();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"execute", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.execute();
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        if ("close".equals(e.getActionId())) {
            this.getView().close();
        }
    }

    public void execute() {
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObject execution = DataCompTask.createExecution((DynamicObject)dataEntity);
        long id = D.l((Object)execution.getPkValue());
        List jobs = JobEngine.getJobsWithOwnerId((long)id);
        if (jobs.isEmpty()) {
            DataCompThread job = new DataCompThread(id);
            FormOpener.startJob(this, (Job)job, "close");
        } else {
            JobInfo jobInfo = (JobInfo)jobs.get(0);
            FormOpener.reopenJob(this, jobInfo.getId(), jobInfo.getTitle(), "close");
        }
    }
}

