/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.comp;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Html;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.datacomp.util.CompensateProgressRefresher;
import kd.isc.iscb.platform.core.datacomp.util.CompensateUtil;
import kd.isc.iscb.platform.core.datacomp.util.IProgressRefresher;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.LightTaskManager;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class DataCompensateProgressFormPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final String KEY_BTNSTART = "btnok";
    private static final String CANCEL = "cancel";
    private static final String KEY_PROGRESSBAR = "progressbarap";
    private static final String VIEW_LOG = "view_log";

    public void initialize() {
        super.initialize();
        ProgressBar progressBar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
        progressBar.start();
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getCustomParam("data_comp_id") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5bf9\u6bd4\u65b9\u6848\u4e3a\u7a7a\u3002", (String)"DataCompensateProgressFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_BTNSTART});
        } else {
            this.start();
        }
        this.getModel().setValue("textfield", (Object)ResManager.loadKDString((String)"\u8865\u507f\u8be6\u60c5", (String)"DataCompensateProgressFormPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if (VIEW_LOG.equals(operateKey)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long id = (Long)formShowParameter.getCustomParam("executionId");
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("showType", ShowType.Modal);
            FormOpener.showList(this, "isc_data_comp_exe_det", "data_comp_exe", D.s((Object)id), param);
        } else if (CANCEL.equals(operateKey)) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long id = (Long)formShowParameter.getCustomParam("executionId");
            DynamicObject execution = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_data_comp_exe");
            long sameCount = D.l((Object)execution.get("tar_no_same_count"));
            long existCount = D.l((Object)execution.get("tar_no_exist_count"));
            long synCount = D.l((Object)execution.get("tar_no_syn_count"));
            long executeCount = D.l((Object)execution.get("execute_count"));
            if (executeCount == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8865\u507f\u7684\u603b\u884c\u6570\u4e3a0\uff0c\u8bf7\u67e5\u770b\u5bf9\u6bd4\u65e5\u5fd7\u662f\u5426\u5df2\u7ecf\u88ab\u6e05\u7406", (String)"DataCompensateProgressFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            if (executeCount == sameCount + existCount + synCount) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u8865\u507f\u5df2\u5b8c\u6210", (String)"DataCompensateProgressFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CANCEL, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u64a4\u9500\u64cd\u4f5c\u4f1a\u9000\u51fa\u5f53\u524d\u6570\u636e\u8865\u507f\uff0c\u786e\u8ba4\u6267\u884c\uff1f", (String)"DataCompensateProgressFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent event) {
        super.confirmCallBack(event);
        MessageBoxResult result = event.getResult();
        if (result == MessageBoxResult.Yes && CANCEL.equals(event.getCallBackId())) {
            FormShowParameter formShowParameter = this.getView().getFormShowParameter();
            Long id = (Long)formShowParameter.getCustomParam("executionId");
            SignalManager.sendCancelSignal((String)D.s((Object)id));
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64a4\u9500\u4efb\u52a1\u5df2\u63d0\u4ea4", (String)"DataCompensateProgressFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(2500));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{KEY_BTNSTART});
    }

    protected void start() {
        ProgressBar progressBar = (ProgressBar)this.getView().getControl(KEY_PROGRESSBAR);
        progressBar.setPercent(0, ResManager.loadKDString((String)" \u5f00\u59cb\u6267\u884c ...", (String)"DataCompensateProgressFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        this.getPageCache().put("startprogress", "true");
        this.getPageCache().put("progress", "0");
        this.doTask(this.getView().getPageId());
    }

    private void doTask(String pageId) {
        if (pageId == null) {
            return;
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        final Long id = (Long)formShowParameter.getCustomParam("data_comp_id");
        final Object executionId = formShowParameter.getCustomParam("executionId");
        CompensateProgressRefresher refresher = new CompensateProgressRefresher(pageId);
        try {
            LightTask task = new LightTask((IProgressRefresher)refresher){
                final /* synthetic */ IProgressRefresher val$refresher;
                {
                    this.val$refresher = iProgressRefresher;
                }

                public String getId() {
                    return String.valueOf(id);
                }

                public void run() {
                    CompensateUtil.execute((long)id, (Object)executionId, (IProgressRefresher)this.val$refresher);
                }
            };
            LightTaskManager.submit((LightTask)task);
        }
        catch (Exception e) {
            this.getView().showMessage(e.getMessage());
            this.getView().close();
        }
    }

    public void onProgress(ProgressEvent progressEvent) {
        String startProgress = this.getPageCache().get("startprogress");
        if (StringUtils.isBlank((CharSequence)startProgress)) {
            progressEvent.setProgress(0);
            progressEvent.setText(ResManager.loadKDString((String)" \u672a\u5f00\u59cb ", (String)"DataCompensateProgressFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        int progress = 0;
        String text = ResManager.loadKDString((String)" \u8fdb\u884c\u4e2d ...", (String)"DataCompensateProgressFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        String cacheProgress = this.getPageCache().get("progress");
        if (StringUtils.isNotBlank((CharSequence)cacheProgress)) {
            progress = Double.valueOf(cacheProgress).intValue();
            text = cacheProgress + "%";
        }
        if (progress >= 100) {
            progress = 100;
            text = ResManager.loadKDString((String)" \u5b8c\u6210 ", (String)"DataCompensateProgressFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnstop"});
        }
        if (startProgress.equals("false")) {
            text = ResManager.loadKDString((String)" \u5df2\u53d6\u6d88\u6267\u884c ", (String)"DataCompensateProgressFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            if ("1".equals(this.getPageCache().get(CANCEL))) {
                this.getView().setEnable(Boolean.FALSE, new String[]{"btnstop"});
            }
            ProgressBar progressBar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
            progressBar.stop();
        }
        if (!StringUtil.isEmpty((String)this.getPageCache().get("text"))) {
            text = this.getPageCache().get("text");
        }
        int totalCount = D.i((Object)this.getPageCache().get("totalCount"));
        int errCount = D.i((Object)this.getPageCache().get("errCount"));
        int sucCount = D.i((Object)this.getPageCache().get("sucCount"));
        String str = "";
        if (totalCount >= 0) {
            str = str + String.format("<p>%1$s<font color = black>%2$s</font></p>", ResManager.loadKDString((String)"\u5f85\u8865\u507f\u603b\u884c\u6570 : ", (String)"DataCompensateProgressFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), totalCount);
        }
        if (errCount != 0) {
            str = str + String.format("<p>%1$s<font color = red>%2$s</font></p>", ResManager.loadKDString((String)"\u8865\u507f\u5931\u8d25\u884c\u6570 : ", (String)"DataCompensateProgressFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), errCount);
        }
        if (sucCount != 0) {
            if (sucCount > totalCount - errCount) {
                sucCount = totalCount - errCount;
            }
            str = str + String.format("<p>%1$s<font color = green>%2$s</font></p>", ResManager.loadKDString((String)"\u8865\u507f\u6210\u529f\u884c\u6570 : ", (String)"DataCompensateProgressFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), sucCount);
        }
        Html html = (Html)this.getControl("recorder");
        html.setConent(str);
        String state = this.getPageCache().get("state");
        if ("F".equals(state)) {
            ProgressBar progressBar = (ProgressBar)this.getControl(KEY_PROGRESSBAR);
            progressBar.stop();
            HashMap<String, String> map = new HashMap<String, String>(1);
            map.put("fc", "red");
            this.getView().updateControlMetadata(KEY_PROGRESSBAR, map);
        }
        progressEvent.setProgress(progress);
        progressEvent.setText(text);
    }
}

