/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import java.sql.Connection;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class AttachLogListPlugin
extends AbstractListPlugin {
    private static final long ONE_HOUR = 3600000L;
    private static final String UPDATE_SQL = "update t_isc_attach_log set fupdated_time = ?,fstate = ? where fid in (";

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    static class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (!rows.isEmpty() && ((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"elapsed_time")) {
                DecimalFormat df = new DecimalFormat(",###,##0");
                ArrayList<Long> toBeRecovered = new ArrayList<Long>(rows.size());
                long now = System.currentTimeMillis();
                for (DynamicObject row : rows) {
                    long updatedTime;
                    String state = row.getString("state");
                    if ("R".equals(state) && now - (updatedTime = D.l((Object)row.get("updated_time"))) >= 3600000L) {
                        toBeRecovered.add(row.getLong("id"));
                        row.set("state", (Object)"K");
                        row.set("updated_time", (Object)new Timestamp(now));
                    }
                    long elapseTime = this.getElapseTime(row, state);
                    row.set("bytes", (Object)this.formatDigital(df, row.getString("bytes")));
                    row.set("elapsed_time", (Object)(elapseTime < 1L ? 0L : elapseTime));
                }
                if (toBeRecovered.size() > 0) {
                    this.refreshState(toBeRecovered, now);
                }
            }
            return rows;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshState(List<Long> toBeRecovered, long now) {
            Connection cn = TX.getConnection((String)"ISCB", (boolean)false, (String[])new String[0]);
            try {
                ArrayList<Integer> types = new ArrayList<Integer>(toBeRecovered.size() + 2);
                ArrayList<Object> values = new ArrayList<Object>(toBeRecovered.size() + 2);
                types.add(93);
                values.add(new Timestamp(now));
                types.add(12);
                values.add("K");
                StringBuilder sb = this.prepareSqlAndParams(toBeRecovered, types, values);
                DbUtil.executeUpdate((Connection)cn, (String)sb.toString(), values, types);
            }
            finally {
                DbUtil.close((Connection)cn, (boolean)true);
            }
        }

        private StringBuilder prepareSqlAndParams(List<Long> toBeRecovered, List<Integer> types, List<Object> values) {
            StringBuilder sb = new StringBuilder(AttachLogListPlugin.UPDATE_SQL);
            for (int i = 0; i < toBeRecovered.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                types.add(3);
                values.add(toBeRecovered.get(i));
                sb.append('?');
            }
            sb.append(')');
            return sb;
        }

        private long getElapseTime(DynamicObject row, String state) {
            long startTime = D.l((Object)row.get("start_time"));
            long elapseTime = "I".equals(state) ? (D.l((Object)row.get("end_time")) - startTime) / 1000L : ("C".equals(state) || "R".equals(state) ? this.getRunningTime(row, startTime) : this.getFinalTime(row, startTime));
            return elapseTime;
        }

        private String formatDigital(DecimalFormat df, String bytes) {
            try {
                return df.format(D.l((Object)bytes));
            }
            catch (Exception e) {
                return bytes;
            }
        }

        private long getRunningTime(DynamicObject row, long startTime) {
            long updatedTime = D.l((Object)row.get("updated_time"));
            if (updatedTime > 0L) {
                return (updatedTime - startTime) / 1000L;
            }
            return (System.currentTimeMillis() - startTime) / 1000L;
        }

        private long getFinalTime(DynamicObject row, long startTime) {
            long endTime = D.l((Object)row.get("end_time"));
            if (endTime > 0L) {
                return (endTime - startTime) / 1000L;
            }
            long updateTime = D.l((Object)row.get("updated_time"));
            if (updateTime > 0L) {
                return (updateTime - startTime) / 1000L;
            }
            return -1L;
        }
    }
}

