/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;

public class ConnectorDcFormPlugin
extends AbstractFormPlugin
implements CellClickListener {
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String DATACENTER = "datacenter";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addCellClickListener((CellClickListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        List dcList = (List)params.get("dc_list");
        this.getModel().deleteEntryData(ENTRY_ENTITY);
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        for (String datacenter : dcList) {
            DynamicObject obj = entries.addNew();
            obj.set(DATACENTER, (Object)datacenter);
        }
        this.getView().updateView(ENTRY_ENTITY);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        int[] rowNum;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("select".equals(operateKey) && (rowNum = ((EntryGrid)this.getView().getControl(ENTRY_ENTITY)).getSelectRows()).length == 1) {
            Map<String, Object> selectedRowData = this.getSelectedRowData(rowNum[0]);
            this.getView().returnDataToParent(selectedRowData);
            this.getView().close();
        }
    }

    private Map<String, Object> getSelectedRowData(int row) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(ENTRY_ENTITY, row);
        HashMap<String, Object> data = new HashMap<String, Object>();
        String center = rowEntity.getString(DATACENTER);
        String splitTag = "\u3000(";
        int prefix = center.lastIndexOf(splitTag);
        int suffix = center.lastIndexOf(41);
        if (prefix > 0 && prefix < suffix) {
            center = center.substring(prefix + 2, suffix);
        }
        data.put(DATACENTER, center);
        return data;
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent evt) {
        Map<String, Object> data = this.getSelectedRowData(evt.getRow());
        this.getView().returnDataToParent(data);
        this.getView().close();
    }
}

