/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.filter.FilterContainer;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.isc.iscb.formplugin.trace.TraceUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.PortalFilterSettingUtil;
import kd.isc.iscb.platform.core.connector.self.ProxyUserUtil;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.trace.Caller;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.trace.TraceTask;

public class DataCopyExecutionListPlugin
extends AbstractListPlugin
implements FilterContainerInitListener {
    private static final String DATA_COPY_TRIGGER_ID = "data_copy_trigger_id";
    private static final String ISC_DATA_COPY_EXECUTION = "isc_data_copy_execution";

    public void setFilter(SetFilterEvent e) {
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (null != filterContainer) {
            filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        PortalFilterSettingUtil.hiddenFilter(args);
    }

    public void filterContainerInit(FilterContainerInitEvent filterContainerInitEvent) {
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getView().setVisible(Boolean.valueOf(TraceStack.isTraceEnabled()), new String[]{"btn_view_trace"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("view".equals(operateKey) || "view_stack_trace".equals(operateKey)) {
            Object[] primaryKeyValues = args.getListSelectedData().getPrimaryKeyValues();
            if (primaryKeyValues.length > 1) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u3002", (String)"DataCopyExecutionListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            if ("view".equals(operateKey)) {
                args.setCancel(true);
                Object id = primaryKeyValues[0];
                this.showExecutionForm(id);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        List successPkIds;
        super.afterDoOperation(e);
        String op = e.getOperateKey();
        if ("show_logs".equals(op)) {
            this.showLog(e);
        } else if ("redo".equals(op)) {
            this.redo(e, false);
        } else if ("cancel".equals(op)) {
            this.cancel(e);
        } else if ("attach_logs".equals(op)) {
            this.showAttachLog(e);
        } else if ("view_trace".equals(op)) {
            Object selectedId = FormOpener.getSelectedId((AbstractFormPlugin)this, e);
            if (selectedId != null) {
                TraceUtil.showTrace((AbstractFormPlugin)this, D.l((Object)selectedId));
            }
        } else if ("creator_redo".equals(op)) {
            this.redo(e, true);
        } else if ("time_analysis".equals(op)) {
            Object selectedId = FormOpener.getSelectedId((AbstractFormPlugin)this, e);
            if (selectedId != null) {
                HashMap<String, Object> param = new HashMap<String, Object>(1);
                param.put("id", selectedId);
                FormOpener.showTabForm((AbstractFormPlugin)this, "isc_exectime_analysis", null, param, null);
            }
        } else if ("show_tslogs".equals(op)) {
            this.showTimeStampLog(e);
        } else if ("view_stack_trace".equals(op) && (successPkIds = e.getOperationResult().getSuccessPkIds()).size() > 0) {
            QFilter filter = new QFilter("job_owner", "=", successPkIds.get(0));
            DynamicObject dataEntity = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_job_inst", (String)"id", (QFilter[])new QFilter[]{filter});
            if (dataEntity == null) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u540e\u53f0\u4efb\u52a1id:%s\uff0c\u5df2\u7ecf\u4e22\u5931\u3002", (String)"ProcessInstListPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), successPkIds.get(0)));
            }
            HashMap<String, Object> params = new HashMap<String, Object>(1);
            params.put("view_stack_trace", Boolean.TRUE);
            FormOpener.showView((AbstractFormPlugin)this, "isc_job_inst", (Object)dataEntity.getLong("id"), params);
        }
    }

    private void showTimeStampLog(AfterDoOperationEventArgs e) {
        FormOpener.showList((AbstractFormPlugin)this, "isc_data_ts_log", "task", e);
    }

    private void showAttachLog(AfterDoOperationEventArgs e) {
        FormOpener.showList((AbstractFormPlugin)this, "isc_attachment_log", "task", e);
    }

    private void cancel(AfterDoOperationEventArgs e) {
        List successPkIds = e.getOperationResult().getSuccessPkIds();
        for (Object id : successPkIds) {
            SignalManager.sendCancelSignal((String)id.toString());
        }
    }

    private void showLog(AfterDoOperationEventArgs e) {
        ControlFilters filters = ((IListView)this.getView()).getControlFilters();
        ControlFilter controlFilter = (ControlFilter)filters.getFilters().get("modifytime");
        if (controlFilter != null) {
            HashMap<String, Object> params = new HashMap<String, Object>(1);
            params.put("execution_time_filter", controlFilter.getValue());
            FormOpener.showListWithParam((AbstractFormPlugin)this, "isc_data_copy_exec_log", "data_copy_execution", e, params);
        } else {
            FormOpener.showList((AbstractFormPlugin)this, "isc_data_copy_exec_log", "data_copy_execution", e);
        }
    }

    private void redo(AfterDoOperationEventArgs e, boolean withContext) {
        int success = 0;
        int ommitted = 0;
        for (Object id : e.getOperationResult().getSuccessPkIds()) {
            DynamicObject execution = BusinessDataServiceHelper.loadSingle(id, (String)ISC_DATA_COPY_EXECUTION);
            if (DataCopyExecutionListPlugin.isTriggerRunning(execution.getLong(DATA_COPY_TRIGGER_ID))) {
                ++ommitted;
                continue;
            }
            this.retry(execution, withContext);
            ++success;
        }
        this.showResult(success, ommitted);
    }

    private void showResult(int success, int ommitted) {
        StringBuilder sb = new StringBuilder();
        if (success > 0) {
            sb.append(ResManager.loadKDString((String)"\u91cd\u8bd5\u6210\u529f\uff1a", (String)"DataCopyExecutionListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(success).append(ResManager.loadKDString((String)"\u4e2a\u3002", (String)"DataCopyExecutionListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        if (ommitted > 0) {
            sb.append(ResManager.loadKDString((String)"\u5ffd\u7565\uff1a", (String)"DataCopyExecutionListPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(ommitted).append(ResManager.loadKDString((String)"\u4e2a\u3002\u5ffd\u7565\u539f\u56e0\uff1a\u65b9\u6848\u6709\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\uff1b", (String)"DataCopyExecutionListPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        if (sb.length() > 0) {
            sb.append(ResManager.loadKDString((String)"\u8bf7\u5237\u65b0\u5217\u8868\u67e5\u770b\u8fdb\u5ea6\u3002", (String)"DataCopyExecutionListPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.getView().showSuccessNotification(sb.toString(), Integer.valueOf(5000));
        }
    }

    private void retry(DynamicObject execution, boolean withContext) {
        execution.set("state", (Object)"C");
        execution.set("total_count", (Object)-1);
        execution.set("success_count", (Object)-1);
        execution.set("failed_count", (Object)-1);
        OperationServiceHelper.executeOperate((String)"save", (String)ISC_DATA_COPY_EXECUTION, (DynamicObject[])new DynamicObject[]{execution}, (OperateOption)OperateOption.create());
        if (withContext) {
            this.innerRetryWithContext(execution);
        } else {
            this.innerRetry(execution);
        }
    }

    private void innerRetryWithContext(DynamicObject execution) {
        RequestContext currentContext = RequestContext.get();
        try {
            RequestContextCreator.restoreForMQ((RequestContext)ProxyUserUtil.createRequestContext((RequestContext)currentContext, (String)execution.getDynamicObject("creator").getPkValue().toString()));
            this.innerRetry(execution);
        }
        finally {
            RequestContextCreator.restoreForMQ((RequestContext)currentContext);
        }
    }

    private void innerRetry(final DynamicObject execution) {
        TraceStack.trace((Caller)Caller.Front, (long)TraceStack.getTraceId((long)D.l((Object)execution.get("id"))), (TraceTask)new TraceTask(){

            public void run() {
                DataCopyTask.start((DynamicObject)execution, (boolean)false);
            }
        });
    }

    public static boolean isTriggerRunning(long triggerId) {
        QFilter qFilter = new QFilter(DATA_COPY_TRIGGER_ID, "=", (Object)triggerId).and("state", "in", (Object)new String[]{"R"});
        DynamicObject[] executions = BusinessDataServiceHelper.load((String)ISC_DATA_COPY_EXECUTION, (String)"state, source_data", (QFilter[])new QFilter[]{qFilter});
        int count = 0;
        for (DynamicObject e : executions) {
            if (D.s((Object)e.get("source_data")) != null) continue;
            ++count;
        }
        return count > 0;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        ListSelectedRow selectedRowInfo = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo();
        Object id = selectedRowInfo.getPrimaryKeyValue();
        this.showExecutionForm(id);
    }

    private void showExecutionForm(Object id) {
        ControlFilters filters = ((IListView)this.getView()).getControlFilters();
        ControlFilter controlFilter = (ControlFilter)filters.getFilters().get("modifytime");
        if (controlFilter != null) {
            HashMap<String, Object> params = new HashMap<String, Object>(1);
            params.put("execution_time_filter", controlFilter.getValue());
            FormOpener.showTabViewWithParams((AbstractFormPlugin)this, ISC_DATA_COPY_EXECUTION, id, params);
        } else {
            FormOpener.showTabView((AbstractFormPlugin)this, ISC_DATA_COPY_EXECUTION, id);
        }
    }
}

