/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.container.Wizard;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.StepEvent;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.WizardStepsListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isv.ISVService;
import kd.bos.list.BillList;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.isc.iscb.formplugin.dc.TriggerType;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.cache.data.MetaDataSchema;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.meta.SyncMetaJobFactory;
import kd.isc.iscb.util.dt.D;

public class DataCopyGuideFormPlugin
extends AbstractFormPlugin
implements WizardStepsListener,
TreeNodeClickListener,
ListRowClickListener,
SearchEnterListener,
RowClickEventListener {
    private static final String SRC_DATA_SOURCE = "billlistap";
    private static final String SRC_META = "billlistap1";
    private static final String TAR_DATA_SOURCE = "billlistap3";
    private static final String TAR_META = "billlistap11";
    private static final String SEARCH_SRC_SOURCE = "searchsrcsource";
    private static final String SEARCH_SRC_META = "searchsrcmeta";
    private static final String SEARCH_TAR_SOURCE = "searchtarsource";
    private static final String SEARCH_TAR_META = "searchtarmeta";
    private static final int PAGE_ONE = 1;
    private static final int PAGE_TWO = 2;
    private static final int PAGE_THREE = 3;
    private static final int PAGE_FOUR = 4;
    private static final int PAGE_FIVE = 5;
    private static final int PAGE_SIX = 6;
    private static final String INDEX = "index";
    private static final String NEXT_STEP = "btnnext";
    private static final String PREV_STEP = "btnprev";
    private static final String BTN_OUT = "btnout";
    private static final String BTN_OVER = "btnover";
    private static final String BTN_NEW_TRIGGER = "btnnew";
    private static final String MODIFY_TRIGGER = "btnmodify";
    private static final String BAR_SAVE_TRIGGER = "barsave";
    private static final String ISC_CONNECTION_TYPE = "isc_connection_type";
    private static final String ISC_DATABASE_LINK = "isc_database_link";
    private static final String ISC_METADATA_SCHEMA = "isc_metadata_schema";
    private static final String ISC_DATA_SOURCE = "isc_data_source";
    private static final String ISC_DATA_COPY = "isc_data_copy";
    private static final String ISC_DATA_COPY_GUIDE = "isc_data_copy_guide";
    private static final String ISC_TRIGGER_GUIDE = "isc_trigger_guide";
    private static final String GROUP = "group";
    private static final String BASE_INFO = "base_info";
    private static final String FIELD_MAPPING = "field_mapping";
    private static final String ACTION = "action";
    private static final String TRIGGER = "trigger";
    private static final String TRIGGER_TYPE_ENTITY = "entryentity";
    private static final String DATA_COPY = "data_copy";
    private static final String TARGET_ACTIONS = "target_actions";
    private static final String TARGET_SCHEMA = "target_schema";
    private static final String SOURCE_SCHEMA = "source_schema";
    private static final String CLOSE_VIEW = "close_view";
    private static final String TRIGGER_TYPE = "trigger_type";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"buttonap2", "buttonap3", "buttonap4", "buttonap5", "buttonap6", "buttonap7", "buttonap71"});
        this.addClickListeners(new String[]{"buttonap51", "buttonap72", "buttonap61", "buttonap21", "buttonap31", "buttonap41", "buttonap711"});
        EntryGrid filterEntries = (EntryGrid)this.getView().getControl(TRIGGER_TYPE_ENTITY);
        filterEntries.addRowClickListener((RowClickEventListener)this);
        BillList srcDatasource = (BillList)this.getControl(SRC_DATA_SOURCE);
        srcDatasource.addListRowClickListener((ListRowClickListener)this);
        srcDatasource.setSelectedAll(false);
        BillList tarDatasource = (BillList)this.getControl(TAR_DATA_SOURCE);
        tarDatasource.addListRowClickListener((ListRowClickListener)this);
        tarDatasource.setSelectedAll(false);
        BillList src = (BillList)this.getControl(SRC_META);
        src.addListRowClickListener((ListRowClickListener)this);
        src.setSelectedAll(false);
        BillList tar = (BillList)this.getControl(TAR_META);
        tar.addListRowClickListener((ListRowClickListener)this);
        tar.setSelectedAll(false);
        this.addFilter(srcDatasource, src);
        this.addFilter(tarDatasource, tar);
        this.addClickListeners(new String[]{NEXT_STEP, PREV_STEP, BTN_OUT, BTN_OVER, BTN_NEW_TRIGGER, MODIFY_TRIGGER});
        Wizard wizard = (Wizard)this.getControl("wizardap");
        wizard.addWizardStepsListener((WizardStepsListener)this);
        Toolbar srcSourceBar = (Toolbar)this.getView().getControl("advcontoolbarap");
        srcSourceBar.addItemClickListener((ItemClickListener)this);
        Toolbar srcMetaBar = (Toolbar)this.getView().getControl("advcontoolbarap1");
        srcMetaBar.addItemClickListener((ItemClickListener)this);
        Toolbar tarSourceBar = (Toolbar)this.getView().getControl("advcontoolbarap2");
        tarSourceBar.addItemClickListener((ItemClickListener)this);
        Toolbar tarMetaBar = (Toolbar)this.getView().getControl("advcontoolbarap11");
        tarMetaBar.addItemClickListener((ItemClickListener)this);
        Search searchSrcSource = (Search)this.getControl(SEARCH_SRC_SOURCE);
        searchSrcSource.addEnterListener((SearchEnterListener)this);
        Search searchSrcMeta = (Search)this.getControl(SEARCH_SRC_META);
        searchSrcMeta.addEnterListener((SearchEnterListener)this);
        Search searchTarSource = (Search)this.getControl(SEARCH_TAR_SOURCE);
        searchTarSource.addEnterListener((SearchEnterListener)this);
        Search searchTarMeta = (Search)this.getControl(SEARCH_TAR_META);
        searchTarMeta.addEnterListener((SearchEnterListener)this);
    }

    private void addFilter(BillList datasourceList, BillList metaList) {
        ListSelectedRowCollection srcDatasourceSelectedRows = datasourceList.getSelectedRows();
        Object[] primaryKeyValues = srcDatasourceSelectedRows.getPrimaryKeyValues();
        if (primaryKeyValues.length < 1) {
            return;
        }
        QFilter filter = new QFilter(GROUP, "=", (Object)D.l((Object)primaryKeyValues[0]));
        metaList.addSetFilterListener(event -> event.getQFilters().add(filter));
    }

    public void initialize() {
        super.initialize();
        int s = D.i((Object)this.getPageCache().get(INDEX));
        if (s == 0 || s == 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{PREV_STEP, BTN_OVER, BTN_NEW_TRIGGER});
            this.getView().setVisible(Boolean.TRUE, new String[]{NEXT_STEP});
        } else if (s == 6) {
            this.getView().setVisible(Boolean.FALSE, new String[]{NEXT_STEP});
            this.getView().setVisible(Boolean.TRUE, new String[]{PREV_STEP, BTN_OVER, BTN_NEW_TRIGGER});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{BTN_OVER, BTN_NEW_TRIGGER});
            this.getView().setVisible(Boolean.TRUE, new String[]{PREV_STEP, NEXT_STEP});
        }
    }

    public void search(SearchEnterEvent evt) {
        String key;
        Search s = (Search)evt.getSource();
        switch (key = s.getKey()) {
            case "searchsrcsource": {
                this.searchSource(SRC_DATA_SOURCE, SEARCH_SRC_SOURCE);
                break;
            }
            case "searchsrcmeta": {
                this.searchMeta(SRC_META, SRC_DATA_SOURCE, SEARCH_SRC_META);
                break;
            }
            case "searchtarsource": {
                this.searchSource(TAR_DATA_SOURCE, SEARCH_TAR_SOURCE);
                break;
            }
            case "searchtarmeta": {
                this.searchMeta(TAR_META, TAR_DATA_SOURCE, SEARCH_TAR_META);
                break;
            }
            default: {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u672a\u77e5\u641c\u7d22\uff1a%s", (String)"DataCopyGuideFormPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), key));
            }
        }
    }

    private void searchMeta(String meta, String dataSource, String searchMeta) {
        BillList srcMetaList = (BillList)this.getControl(meta);
        List srcMetaFilters = srcMetaList.getFilterParameter().getQFilters();
        srcMetaFilters.clear();
        srcMetaFilters.add(this.getSearchMetaFilters(dataSource, searchMeta));
        this.getView().updateView(meta);
    }

    private void searchSource(String dataSource, String searchSource) {
        BillList srcSourceList = (BillList)this.getControl(dataSource);
        List srcFilters = srcSourceList.getFilterParameter().getQFilters();
        srcFilters.clear();
        srcFilters.add(this.getSearchFilters(searchSource));
        this.getView().updateView(dataSource);
    }

    private QFilter getSearchMetaFilters(String k1, String k2) {
        QFilter q1 = this.getDatasourceSelectRow(k1);
        QFilter q2 = this.getSearchFilters(k2);
        if (q1 == null) {
            return q2;
        }
        return q1.and(q2);
    }

    private QFilter getSearchFilters(String key) {
        String searchKey;
        Search search = (Search)this.getControl(key);
        if (search != null && (searchKey = D.s((Object)search.getSearchKey())) != null) {
            return new QFilter("name", "ilike", (Object)("%" + searchKey + "%")).or(new QFilter("number", "ilike", (Object)("%" + searchKey + "%")));
        }
        return null;
    }

    private QFilter getDatasourceSelectRow(String k1) {
        BillList srcSourceList = (BillList)this.getControl(k1);
        Object[] sources = srcSourceList.getSelectedRows().getPrimaryKeyValues();
        QFilter q1 = sources.length < 1 ? null : new QFilter(GROUP, "=", (Object)D.l((Object)sources[0]));
        return q1;
    }

    public void listRowClick(ListRowClickEvent evt) {
        ListSelectedRow currentListSelectedRow = evt.getCurrentListSelectedRow();
        if (currentListSelectedRow == null) {
            return;
        }
        Object source = evt.getSource();
        if (source instanceof BillList) {
            this.billListClick(currentListSelectedRow, (BillList)source);
        }
    }

    private void billListClick(ListSelectedRow currentListSelectedRow, BillList billList) {
        String key = billList.getKey();
        Object pk = currentListSelectedRow.getPrimaryKeyValue();
        if (SRC_DATA_SOURCE.equals(key)) {
            this.filterMetaList(pk, SRC_META, SEARCH_SRC_META);
        } else if (TAR_DATA_SOURCE.equals(key)) {
            this.filterMetaList(pk, TAR_META, SEARCH_TAR_META);
        }
    }

    private void filterMetaList(Object pk, String meta, String searchMeta) {
        BillList metaList = (BillList)this.getControl(meta);
        FilterParameter filterParameter = metaList.getFilterParameter();
        filterParameter.setFilter(new QFilter(GROUP, "=", pk));
        filterParameter.setFilter(this.getSearchFilters(searchMeta));
        this.getView().updateView(meta);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operation;
        String operateKey;
        super.beforeDoOperation(args);
        Object source = args.getSource();
        if (source instanceof AbstractOperate && BTN_OUT.equals(operateKey = (operation = (AbstractOperate)source).getOperateKey())) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CLOSE_VIEW, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u662f\u5426\u786e\u5b9a\u9000\u51fa\uff1f", (String)"DataCopyGuideFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        Object source = args.getSource();
        if (source instanceof AbstractOperate) {
            AbstractOperate operation = (AbstractOperate)source;
            String operateKey = operation.getOperateKey();
            if (BAR_SAVE_TRIGGER.equals(operateKey)) {
                this.saveTrigger();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\uff0c\u542f\u52a8\u65b9\u6848\u9700\u8981\u542f\u7528\u540e\u624d\u80fd\u4f7f\u7528\uff0c\u4f7f\u7528\u524d\u8bf7\u5230\u542f\u52a8\u65b9\u6848\u5217\u8868\u4e2d\u542f\u7528\u3002", (String)"DataCopyGuideFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else if ("msg_notify".equals(operateKey)) {
                this.createMsgNotify();
            }
        }
    }

    private void createMsgNotify() {
        long triggerId = D.l((Object)this.getSubView(TRIGGER).getModel().getValue("id"));
        if (triggerId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u542f\u52a8\u65b9\u6848\u3002", (String)"DataCopyGuideFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            param.put("guide_trigger", triggerId);
            FormOpener.showAddNew(this, "isc_message_notification", param);
        }
    }

    private void saveTrigger() {
        String triggerPageId = this.getPageCache().get(TRIGGER);
        this.saveOperation(triggerPageId);
        BillView triggerView = this.getSubView(TRIGGER);
        this.getView().sendFormAction((IFormView)triggerView);
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callback = evt.getCallBackId();
        try {
            if (evt.getResult() == MessageBoxResult.Yes) {
                this.callBackYes(callback);
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void callBackYes(String callback) {
        if (CLOSE_VIEW.equals(callback) || "createCompleted".equals(callback)) {
            this.getView().close();
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        if (evt.getRow() < 0) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)evt.getSource();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(TRIGGER_TYPE_ENTITY, entryGrid.getSelectRows()[0]);
        if (entryRowEntity != null) {
            String title = entryRowEntity.getString("title");
            String typeCode = TriggerType.getCodeByTitle(title);
            this.setTriggerType(typeCode);
        }
    }

    private void setTriggerType(String selectType) {
        BillView triggerView = this.getSubView(TRIGGER);
        IDataModel triggerModel = triggerView.getModel();
        if (!triggerModel.isDataLoaded()) {
            return;
        }
        long id = D.l((Object)triggerModel.getValue("id"));
        if (id == 0L) {
            triggerModel.setValue(TRIGGER_TYPE, (Object)selectType);
            this.getView().sendFormAction((IFormView)triggerView);
        } else {
            String oldType = D.s((Object)triggerModel.getValue(TRIGGER_TYPE));
            if (!oldType.equals(selectType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u7ecf\u521b\u5efa\u7684\u542f\u52a8\u65b9\u6848\u4e0d\u53ef\u4fee\u6539\u542f\u52a8\u7c7b\u578b\u3002", (String)"DataCopyGuideFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                this.clickTriggerType(TriggerType.getSeqByCode(oldType));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "newsrclink": 
            case "newtarlink": {
                FormOpener.showForm(this, "isc_database_link_chose", null);
                break;
            }
            case "viewsrclink": {
                this.viewLinkByDatasource(SRC_DATA_SOURCE);
                break;
            }
            case "newsrcsource": 
            case "newtarsource": {
                FormOpener.showAddNew(this, ISC_DATA_SOURCE, null);
                break;
            }
            case "viewsrcsource": {
                this.viewDatasource(SRC_DATA_SOURCE);
                break;
            }
            case "refreshsrcsource": {
                this.refreshBillList(SRC_DATA_SOURCE);
                break;
            }
            case "viewsrcmeta": {
                this.openMetaBill(SRC_META);
                break;
            }
            case "newsrcmeta": {
                this.createMetaData(SRC_DATA_SOURCE);
                break;
            }
            case "modifysrcmeta": {
                this.modifyMetaData(SRC_META);
                break;
            }
            case "syncsrcmeta": {
                this.syncMetaData(SRC_DATA_SOURCE);
                break;
            }
            case "refreshsrcmeta": {
                this.refreshBillList(SRC_META);
                break;
            }
            case "viewtarlink": {
                this.viewLinkByDatasource(TAR_DATA_SOURCE);
                break;
            }
            case "refreshtarsource": {
                this.refreshBillList(TAR_DATA_SOURCE);
                break;
            }
            case "viewtarmeta": {
                this.openMetaBill(TAR_META);
                break;
            }
            case "viewtarsource": {
                this.viewDatasource(TAR_DATA_SOURCE);
                break;
            }
            case "newtarmeta": {
                this.createMetaData(TAR_DATA_SOURCE);
                break;
            }
            case "modifytarmeta": {
                this.modifyMetaData(TAR_META);
                break;
            }
            case "synctarmeta": {
                this.syncMetaData(TAR_DATA_SOURCE);
                break;
            }
            case "refreshtarmeta": {
                this.refreshBillList(TAR_META);
                break;
            }
            default: {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65b9\u6848\u5411\u5bfc\uff0c\u672a\u77e5\u6309\u94ae\uff1a%s", (String)"DataCopyGuideFormPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), itemKey));
            }
        }
    }

    private void createMetaData(String key) {
        HashMap<String, Object> param = new HashMap<String, Object>(12);
        BillList sourceBillList = (BillList)this.getControl(key);
        ListSelectedRowCollection selectedRows = sourceBillList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"DataCopyGuideFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            param.put("guide_datasource", selectedRows.getPrimaryKeyValues()[0]);
            FormOpener.showAddNew(this, ISC_METADATA_SCHEMA, param);
        }
    }

    private void refreshBillList(String key) {
        BillList billList = (BillList)this.getControl(key);
        billList.refresh();
    }

    private void syncMetaData(String key) {
        BillList datasource = (BillList)this.getControl(key);
        Object[] pks = datasource.getSelectedRows().getPrimaryKeyValues();
        if (pks.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"DataCopyGuideFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        Job job = SyncMetaJobFactory.createJob((long)D.l((Object)pks[0]), (String)ResManager.loadKDString((String)"\u540c\u6b65\u5143\u6570\u636e", (String)"DataCopyGuideFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        FormOpener.startJob(this, job);
    }

    private void modifyMetaData(String key) {
        BillShowParameter showMetaData = new BillShowParameter();
        showMetaData.setFormId(ISC_METADATA_SCHEMA);
        showMetaData.getOpenStyle().setShowType(ShowType.Modal);
        BillList srcMeta = (BillList)this.getControl(key);
        Object[] pks = srcMeta.getSelectedRows().getPrimaryKeyValues();
        if (pks.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u96c6\u6210\u5bf9\u8c61\u3002", (String)"DataCopyGuideFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        showMetaData.setPkId(pks[0]);
        showMetaData.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showMetaData);
    }

    private void openMetaBill(String key) {
        BillList meta = (BillList)this.getControl(key);
        Object[] pks = meta.getSelectedRows().getPrimaryKeyValues();
        if (pks.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u96c6\u6210\u5bf9\u8c61\u3002", (String)"DataCopyGuideFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        FormOpener.showView(this, ISC_METADATA_SCHEMA, pks[0]);
    }

    private void viewDatasource(String key) {
        BillShowParameter showDatasource = new BillShowParameter();
        showDatasource.setFormId(ISC_DATA_SOURCE);
        showDatasource.getOpenStyle().setShowType(ShowType.Modal);
        BillList datasource = (BillList)this.getControl(key);
        Object[] pks = datasource.getSelectedRows().getPrimaryKeyValues();
        if (pks.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u6570\u636e\u6e90\u3002", (String)"DataCopyGuideFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        showDatasource.setPkId(pks[0]);
        showDatasource.setStatus(OperationStatus.EDIT);
        this.getView().showForm((FormShowParameter)showDatasource);
    }

    private void viewLinkByDatasource(String key) {
        BillShowParameter showLink = new BillShowParameter();
        showLink.getOpenStyle().setShowType(ShowType.Modal);
        BillList datasource = (BillList)this.getControl(key);
        Object[] pks = datasource.getSelectedRows().getPrimaryKeyValues();
        if (pks.length < 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u6570\u636e\u6e90\u3002", (String)"DataCopyGuideFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter filter = new QFilter("id", "=", pks[0]);
        DynamicObject source = QueryServiceHelper.queryOne((String)ISC_DATA_SOURCE, (String)"number,connection_type,dblink_id", (QFilter[])new QFilter[]{filter});
        long dblink = source.getLong("dblink_id");
        if (dblink == 0L) {
            String number = source.getString("number");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u3010%s\u3011\u7684\u6570\u636e\u6e90\u6ca1\u6709\u5173\u8054\u8fde\u63a5\u914d\u7f6e\u3002", (String)"DataCopyGuideFormPlugin_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), number));
            return;
        }
        QFilter filter1 = new QFilter("id", "=", (Object)dblink);
        DynamicObject link = QueryServiceHelper.queryOne((String)ISC_DATABASE_LINK, (String)"id,database_type", (QFilter[])new QFilter[]{filter1});
        if (link == null) {
            String number = source.getString("number");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u3010%s\u3011\u7684\u6570\u636e\u6e90\u6ca1\u6709\u5173\u8054\u8fde\u63a5\u914d\u7f6e\u3002", (String)"DataCopyGuideFormPlugin_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), number));
            return;
        }
        QFilter cnTypeFilter = new QFilter("number", "=", (Object)link.getString("database_type"));
        DynamicObject cnType = QueryServiceHelper.queryOne((String)ISC_CONNECTION_TYPE, (String)"config_form", (QFilter[])new QFilter[]{cnTypeFilter});
        showLink.setFormId(cnType.getString("config_form"));
        showLink.setPkId((Object)dblink);
        showLink.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)showLink);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String random = this.getRandom();
        this.showDataCopyView(random, "flexpanelap_base_info", BASE_INFO);
        this.showDataCopyView(random, "flexpanelap_action", ACTION);
        String fieldMappingPageId = this.showDataCopyView(random, "flexpanelap_mapping", FIELD_MAPPING);
        BillShowParameter showTrigger = new BillShowParameter();
        showTrigger.setFormId(ISC_TRIGGER_GUIDE);
        showTrigger.getOpenStyle().setShowType(ShowType.InContainer);
        showTrigger.getOpenStyle().setTargetKey("flexpanelap_trigger");
        showTrigger.setCustomParam("type", (Object)TRIGGER);
        String triggerPageId = TRIGGER + random;
        showTrigger.setCustomParam(DATA_COPY, (Object)fieldMappingPageId);
        this.getPageCache().put(TRIGGER, triggerPageId);
        showTrigger.setPageId(triggerPageId);
        this.getView().showForm((FormShowParameter)showTrigger);
    }

    private String getRandom() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private String showDataCopyView(String random, String targetKey, String type) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(ISC_DATA_COPY_GUIDE);
        showParameter.getOpenStyle().setShowType(ShowType.InContainer);
        showParameter.getOpenStyle().setTargetKey(targetKey);
        showParameter.setCustomParam("type", (Object)type);
        String pageId = type + random;
        this.getPageCache().put(type, pageId);
        showParameter.setPageId(pageId);
        this.getView().showForm((FormShowParameter)showParameter);
        return pageId;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        if (src instanceof Button) {
            int index = D.i((Object)this.getPageCache().get(INDEX));
            String key = ((Button)src).getKey();
            if (index == 1 && NEXT_STEP.equals(key)) {
                this.checkSelectMetaData(SRC_META, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u5bf9\u8c61\u3002", (String)"DataCopyGuideFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                this.getPageCache().put(INDEX, D.s((Object)2));
            } else if (index == 2 && NEXT_STEP.equals(key)) {
                this.checkSelectMetaData(TAR_META, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u5bf9\u8c61\u3002", (String)"DataCopyGuideFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                BillView baseInfoView = this.getSubView(BASE_INFO);
                IDataModel baseInfoMode = baseInfoView.getModel();
                this.setTarInfo(baseInfoMode);
                this.setSrcInfo(baseInfoMode);
                this.getView().sendFormAction((IFormView)baseInfoView);
                this.getPageCache().put(INDEX, D.s((Object)3));
            } else if (index == 3 && NEXT_STEP.equals(key)) {
                this.setDataCopyBaseInfo();
                this.getPageCache().put(INDEX, D.s((Object)4));
            } else if (index == 4 && NEXT_STEP.equals(key)) {
                this.createDataCopy();
                this.getPageCache().put(INDEX, D.s((Object)5));
            } else if (index == 5 && NEXT_STEP.equals(key)) {
                this.updateDataCopyActions();
                this.getPageCache().put(INDEX, D.s((Object)6));
            } else if (index == 6 && BTN_OVER.equals(key)) {
                IDataModel triggerModel = this.getSubView(TRIGGER).getModel();
                this.endTips(triggerModel);
            } else if (PREV_STEP.equals(key)) {
                this.getPageCache().put(INDEX, D.s((Object)(--index)));
            }
        }
    }

    private void endTips(IDataModel triggerModel) {
        this.saveTrigger();
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("createCompleted", (IFormPlugin)this);
        DynamicObject dataCopy = (DynamicObject)triggerModel.getValue(DATA_COPY);
        String dataCopyName = dataCopy.getString("name");
        String text = String.format(ResManager.loadKDString((String)"[%s]\u96c6\u6210\u65b9\u6848\u4fdd\u5b58\u6210\u529f\uff0c\u662f\u5426\u7ed3\u675f\u65b9\u6848\u8bbe\u8ba1\uff1f", (String)"DataCopyGuideFormPlugin_24", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), dataCopyName);
        this.getView().showConfirm(text, MessageBoxOptions.YesNo, confirmCallBacks);
    }

    private void updateDataCopyActions() {
        BillView fieldMappingView = this.getSubView(FIELD_MAPPING);
        IDataModel fieldMappingModel = fieldMappingView.getModel();
        fieldMappingModel.deleteEntryData(TARGET_ACTIONS);
        BillView actionView = this.getSubView(ACTION);
        IDataModel actionModel = actionView.getModel();
        DynamicObjectCollection targetActions = actionModel.getEntryEntity(TARGET_ACTIONS);
        for (int i = 0; i < targetActions.size(); ++i) {
            DynamicObject targetAction = (DynamicObject)targetActions.get(i);
            fieldMappingModel.createNewEntryRow(TARGET_ACTIONS);
            fieldMappingModel.setValue("tar_action_label", targetAction.get("tar_action_label"), i);
            fieldMappingModel.setValue("tar_action_number", targetAction.get("tar_action_number"), i);
            fieldMappingModel.setValue("tar_action_type", targetAction.get("tar_action_type"), i);
            fieldMappingModel.setValue("tar_action_params", targetAction.get("tar_action_params"), i);
        }
        Container proxyUserContainer = (Container)actionView.getControl("flexpanelap4");
        List items = proxyUserContainer.getItems();
        for (Control item : items) {
            String prop = item.getKey();
            fieldMappingModel.setValue(prop, actionModel.getValue(prop));
        }
        this.getView().sendFormAction((IFormView)fieldMappingView);
        String fieldMappingPageId = this.getPageCache().get(FIELD_MAPPING);
        this.saveOperation(fieldMappingPageId);
    }

    private void createDataCopy() {
        String fieldMappingPageId = this.getPageCache().get(FIELD_MAPPING);
        this.saveOperation(fieldMappingPageId);
        BillView dcFieldMappingView = this.getSubView(FIELD_MAPPING);
        long currentDataCopyId = D.l((Object)dcFieldMappingView.getModel().getValue("id"));
        this.getView().sendFormAction((IFormView)dcFieldMappingView);
        BillView baseInfoView = this.getSubView(BASE_INFO);
        baseInfoView.getModel().setValue("id", (Object)currentDataCopyId);
        this.getView().sendFormAction((IFormView)baseInfoView);
        IDataModel baseInfoModel = baseInfoView.getModel();
        Object targetSchema = baseInfoModel.getValue(TARGET_SCHEMA);
        Object sourceSchema = baseInfoModel.getValue(SOURCE_SCHEMA);
        BillView actionView = this.getSubView(ACTION);
        IDataModel actionModel = actionView.getModel();
        actionModel.setValue(SOURCE_SCHEMA, sourceSchema);
        actionModel.setValue(TARGET_SCHEMA, targetSchema);
        actionView.updateView();
        this.getView().sendFormAction((IFormView)actionView);
    }

    private void setDataCopyBaseInfo() {
        BillView baseInfoView = this.getSubView(BASE_INFO);
        IDataModel baseInfoModel = baseInfoView.getModel();
        Object targetSchema = baseInfoModel.getValue(TARGET_SCHEMA);
        Object sourceSchema = baseInfoModel.getValue(SOURCE_SCHEMA);
        this.checkDataCopyBaseInfo(baseInfoView, baseInfoModel, targetSchema, sourceSchema);
        BillView fieldMappingView = this.getSubView(FIELD_MAPPING);
        IDataModel fieldMappingModel = fieldMappingView.getModel();
        fieldMappingModel.setValue(SOURCE_SCHEMA, sourceSchema);
        fieldMappingModel.setValue(TARGET_SCHEMA, targetSchema);
        Container baseInfoContainer = (Container)baseInfoView.getControl("fs_baseinfo");
        List items = baseInfoContainer.getItems();
        for (Control item : items) {
            String prop = item.getKey();
            fieldMappingModel.setValue(prop, baseInfoModel.getValue(prop));
        }
        this.getView().sendFormAction((IFormView)fieldMappingView);
    }

    private void checkDataCopyBaseInfo(BillView baseInfoView, IDataModel baseInfoModel, Object targetSchema, Object sourceSchema) {
        long id;
        long dataCopyId;
        if (targetSchema == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u76ee\u6807\u5bf9\u8c61\u3002", (String)"DataCopyGuideFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        if (sourceSchema == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6e90\u5bf9\u8c61\u3002", (String)"DataCopyGuideFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        String dcNumber = D.s((Object)baseInfoModel.getValue("number"));
        if (dcNumber == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7f16\u7801\u3002", (String)"DataCopyGuideFormPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        DynamicObject dc = QueryServiceHelper.queryOne((String)ISC_DATA_COPY, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)dcNumber)});
        if (dc != null && (dataCopyId = D.l((Object)baseInfoModel.getValue("id"))) != (id = dc.getLong("id"))) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u7f16\u7801\u4e3a[%s]\u7684\u96c6\u6210\u65b9\u6848\uff0c\u8bf7\u66f4\u6362\u7f16\u7801\u3002", (String)"DataCopyGuideFormPlugin_25", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), dcNumber));
        }
        String dcName = D.s((Object)baseInfoModel.getValue("name"));
        if (dcName == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u540d\u79f0\u3002", (String)"DataCopyGuideFormPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        if (this.isInvalidIsv(baseInfoView, baseInfoModel)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5728\u3010\u5f00\u53d1\u5546\u3011\u5b57\u6bb5\u4e2d\u8865\u5145\u5b8c\u6574\u4e1a\u52a1\u4e91\u540d\u79f0\uff0c\u4e0d\u53ef\u4fee\u6539\u524d\u7f00\u5f00\u53d1\u5546\u4fe1\u606f\uff0c\u4f8b\u5982\u3010kingdee.\u67d0\u67d0\u4e1a\u52a1\u4e91\u3011\u3002", (String)"DataCopyGuideFormPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private boolean isInvalidIsv(BillView baseInfoView, IDataModel baseInfoModel) {
        String isvName = ISVService.getISVInfo().getName();
        String string = isvName = isvName == null ? "undefined" : isvName;
        if ("kingdee".equalsIgnoreCase(isvName)) {
            String isv = D.s((Object)baseInfoModel.getValue("isv"));
            String initIsvName = isvName + '.';
            if (isv == null || !isv.startsWith(initIsvName) || isv.equals(initIsvName)) {
                this.getView().sendFormAction((IFormView)baseInfoView);
                return true;
            }
        }
        return false;
    }

    private void saveOperation(String pageId) {
        String param = "[{\"key\":\"tbmain\",\"methodName\":\"itemClick\",\"args\":[\"bar_save\",\"save\"],\"postData\":[{},[]]}]";
        String actionResult = D.s((Object)DispatchServiceHelper.invokeBOSServiceByAppId((String)"iscb", (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{pageId, param}));
        List lstActRet = (List)SerializationUtils.fromJsonString((String)actionResult, List.class);
        for (Map result : lstActRet) {
            String a = D.s(result.get("a"));
            List p = (List)result.get("p");
            Map msg = (Map)p.get(0);
            if ("showErrMsg".equalsIgnoreCase(a)) {
                throw new KDBizException(String.format("%s,%s", msg.get("errorTitle"), msg.get("errorInfo")));
            }
            if (!"ShowNotificationMsg".equalsIgnoreCase(a) || "0".equals(D.s(msg.get("type")))) continue;
            throw new KDBizException(String.format("%s", msg.get("content")));
        }
    }

    private BillView getSubView(String type) {
        String key = this.getPageCache().get(type);
        return (BillView)this.getView().getView(key);
    }

    private void setTarInfo(IDataModel model) {
        BillList billList = (BillList)this.getControl(TAR_META);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        DynamicObject meta = MetaDataSchema.get((long)D.l((Object)selectedRows.getPrimaryKeyValues()[0]));
        model.setValue(TARGET_SCHEMA, (Object)meta);
    }

    private void setSrcInfo(IDataModel model) {
        BillList billList = (BillList)this.getControl(SRC_META);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        DynamicObject meta = MetaDataSchema.get((long)D.l((Object)selectedRows.getPrimaryKeyValues()[0]));
        model.setValue(SOURCE_SCHEMA, (Object)meta);
    }

    private void checkSelectMetaData(String meta, String e2) {
        if (this.notSelectMetaData(meta)) {
            throw new KDBizException(e2);
        }
    }

    private boolean notSelectMetaData(String key) {
        BillList billList = (BillList)this.getControl(key);
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        return selectedRows.isEmpty();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getPageCache().put(INDEX, D.s((Object)1));
        DynamicObjectCollection cardEntry = this.getModel().getDataEntity(true).getDynamicObjectCollection(TRIGGER_TYPE_ENTITY);
        cardEntry.clear();
        for (TriggerType typeInfo : TriggerType.values()) {
            this.setEntryValue(cardEntry, typeInfo.getTitle(), typeInfo.getUseScenario(), typeInfo.getUsePattern());
        }
        this.getView().updateView(TRIGGER_TYPE_ENTITY);
        this.clickTriggerType(TriggerType.manual.getSeq());
    }

    private void clickTriggerType(int seq) {
        EntryGrid control = (EntryGrid)this.getView().getControl(TRIGGER_TYPE_ENTITY);
        control.selectRows(seq);
    }

    private void setEntryValue(DynamicObjectCollection cardEntry, String title, String useScenario, String usePattern) {
        DynamicObject entry1 = cardEntry.addNew();
        entry1.set("title", (Object)title);
        entry1.set("scenario", (Object)useScenario);
        entry1.set("pattern", (Object)usePattern);
    }

    public void update(StepEvent stepEvent) {
        throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u96c6\u6210\u65b9\u6848\u5411\u5bfc\u6682\u4e0d\u652f\u6301update\u65b9\u6cd5\u3002", (String)"DataCopyGuideFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }
}

