/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.InitBindDataUtil;
import kd.isc.iscb.formplugin.util.ResourceIsolateUtil;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.DatabaseType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class DataSourceFormPlugin
extends AbstractFormPlugin
implements AfterF7SelectListener {
    private static final String NAME = "name";
    private static final String CONNECTION_TYPE = "connection_type";
    private static final String NUMBER = "number";
    private static final String DATABASE_TYPE = "database_type";
    private static final String ISC_DATABASE_LINK = "isc_database_link";
    private static final String DB_LINK = "dblink";

    public void registerListener(EventObject e) {
        BasedataEdit dbLink = (BasedataEdit)this.getControl(DB_LINK);
        IFormView view = this.getView();
        dbLink.addBeforeF7ViewDetailListener(evt -> {
            evt.setCancel(true);
            BillShowParameter param = new BillShowParameter();
            DynamicObject ds = BusinessDataServiceHelper.loadSingle((Object)evt.getPkId(), (String)ISC_DATABASE_LINK, (String)DATABASE_TYPE);
            param.setFormId(DatabaseType.getForm((String)ds.getString(DATABASE_TYPE)));
            param.setPkId(evt.getPkId());
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setStatus(OperationStatus.VIEW);
            view.showForm((FormShowParameter)param);
        });
        dbLink.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object dblink = params.get(DB_LINK);
        if (dblink != null) {
            this.getModel().setValue(DB_LINK, dblink);
            this.getModel().setValue(NUMBER, params.get(NUMBER));
            this.getModel().setValue(NAME, params.get(NAME));
            this.getModel().setValue(CONNECTION_TYPE, params.get(CONNECTION_TYPE));
            if (D.s(params.get("isv")) != null) {
                this.getModel().setValue("isv", params.get("isv"));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Save) {
            QFilter qFilter;
            QFilter[] filters;
            DynamicObject dynamicObject;
            String type = D.s((Object)this.getModel().getValue(CONNECTION_TYPE));
            long id = D.l((Object)this.getModel().getValue("id"));
            long dblink = D.l((Object)this.getModel().getValue("dblink_id"));
            if (dblink == 0L) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7cfb\u7edf\u8fde\u63a5!", (String)"DataSourceFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if (dblink != 0L && type == null) {
                this.getModel().setValue(CONNECTION_TYPE, (Object)this.getConnectionTypeById(dblink));
            }
            String name = D.s((Object)this.getModel().getValue(NAME));
            String number = D.s((Object)this.getModel().getValue(NUMBER));
            if (name == null || number == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0e\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199!", (String)"DataSourceFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
            if ((dynamicObject = BusinessDataServiceHelper.loadSingle((String)"isc_data_source", (String)"id", (QFilter[])(filters = new QFilter[]{(qFilter = new QFilter(NAME, "=", (Object)name).or(new QFilter(NUMBER, "=", (Object)number))).and(new QFilter("id", "!=", (Object)id))}))) != null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u540d\u79f0\u6216\u7f16\u7801\u7684\u6570\u636e\u6e90\u3002", (String)"DataSourceFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String prop = e.getProperty().getName();
        if (DB_LINK.equals(prop)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            if (newValue == null) {
                return;
            }
            DynamicObject link = BusinessDataServiceHelper.loadSingle((Object)newValue.getPkValue(), (String)ISC_DATABASE_LINK, (String)DATABASE_TYPE);
            this.changeType(link);
        }
    }

    private void changeType(DynamicObject link) {
        String databaseType = D.s((Object)link.getString(DATABASE_TYPE));
        String connectionType = D.s((Object)this.getModel().getValue(CONNECTION_TYPE));
        if (connectionType != null && !databaseType.equals(connectionType)) {
            this.getPageCache().put("selected_type", databaseType);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("change_connection_type", (IFormPlugin)this);
            String connectionTypeName = this.getConnectionTypeName(connectionType);
            String msg = StringUtil.isEmpty((String)connectionTypeName) ? ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u5f53\u524d\u6570\u636e\u6e90\u7684\u8fde\u63a5\u7c7b\u578b\u4e3a\u7a7a\uff0c\u8bf7\u786e\u4fdd\u5df2\u5efa\u7acb\u8be5\u8fde\u63a5\u7c7b\u578b!", (String)"DataSourceFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) : String.format(ResManager.loadKDString((String)"\u8b66\u544a\uff1a\u5f53\u524d\u9009\u62e9\u7684\u8fde\u63a5\u7c7b\u578b[%1$s]\u4e0e\u4e0a\u6b21\u7684[%2$s]\u4e0d\u4e00\u81f4\uff0c\u786e\u8ba4\u8981\u5207\u6362\u8fde\u63a5\u7c7b\u578b?", (String)"DataSourceFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.getConnectionTypeName(databaseType), connectionTypeName);
            this.getView().showConfirm(msg, MessageBoxOptions.YesNo, confirmCallBacks);
        } else {
            this.getModel().setValue(CONNECTION_TYPE, (Object)databaseType);
            this.setConnectionType(databaseType);
        }
    }

    private void setConnectionType(String databaseType) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_connection_type", (String)"number,name", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)databaseType)});
        if (dynamicObject == null) {
            return;
        }
        DynamicObject[] types = new DynamicObject[]{dynamicObject};
        ComboEdit combo = (ComboEdit)this.getView().getControl(CONNECTION_TYPE);
        InitBindDataUtil.initComboList(types, combo, ConnectionFactory.class);
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        ListSelectedRow selectedRow = afterF7SelectEvent.getListSelectedRow();
        if (selectedRow == null) {
            return;
        }
        DynamicObject link = BusinessDataServiceHelper.loadSingle((Object)selectedRow.getPrimaryKeyValue(), (String)ISC_DATABASE_LINK, (String)DATABASE_TYPE);
        this.changeType(link);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setConnectionType(D.s((Object)this.getModel().getValue(CONNECTION_TYPE)));
        ResourceIsolateUtil.setSourceApp(this.getView(), this.getModel());
        if (D.x((Object)this.getModel().getValue("preset"))) {
            this.getView().setStatus(OperationStatus.EDIT);
            this.getView().setEnable(Boolean.TRUE, new String[]{DB_LINK});
            this.getView().setEnable(Boolean.FALSE, new String[]{CONNECTION_TYPE, NUMBER, NAME, "isv", "preset", "source_app", "remark"});
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if ("change_connection_type".equals(evt.getCallBackId())) {
            if (evt.getResult() == MessageBoxResult.Yes) {
                this.getModel().setValue(CONNECTION_TYPE, (Object)this.getPageCache().get("selected_type"));
                this.setConnectionType(this.getPageCache().get("selected_type"));
            } else {
                this.getModel().setValue(DB_LINK, null);
            }
        }
    }

    private String getConnectionTypeById(long dblink) {
        if (dblink == 0L) {
            return null;
        }
        DynamicObject link = BusinessDataServiceHelper.loadSingle((Object)dblink, (String)ISC_DATABASE_LINK, (String)DATABASE_TYPE);
        return D.s((Object)link.getString(DATABASE_TYPE));
    }

    private String getConnectionTypeName(String databaseType) {
        if (databaseType == null) {
            return null;
        }
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"isc_connection_type", (String)NAME, (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)databaseType)});
        return obj != null ? obj.getString(NAME) : null;
    }
}

