/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.SystemProperties;
import kd.isc.iscb.formplugin.dc.InstanceInfo;
import kd.isc.iscb.formplugin.dc.LicenseInfo;
import kd.isc.iscb.formplugin.dc.RunningTasks;
import kd.isc.iscb.formplugin.dc.ScheduledTasks;
import kd.isc.iscb.formplugin.tools.AbstractScriptEditorFormPlugin;
import kd.isc.iscb.formplugin.tools.ScriptDebuggerFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.IscScript;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.connector.DatabaseType;
import kd.isc.iscb.platform.core.connector.self.BotpServiceInvoker;
import kd.isc.iscb.platform.core.connector.self.MicroServiceInvoker;
import kd.isc.iscb.platform.core.connector.self.MicroServiceInvoker2;
import kd.isc.iscb.platform.core.connector.self.SelfConnection;
import kd.isc.iscb.platform.core.connector.self.StartEventDataCopy;
import kd.isc.iscb.platform.core.connector.self.StartEventServiceFlow;
import kd.isc.iscb.platform.core.dc.e.FlatObjectToMapOrList;
import kd.isc.iscb.platform.core.dc.e.v.a.BizQueryFunction;
import kd.isc.iscb.platform.core.dc.e.v.a.CalcEasPwd;
import kd.isc.iscb.platform.core.dc.e.v.a.DecodeFunction;
import kd.isc.iscb.platform.core.dc.e.v.a.EncodeFunction;
import kd.isc.iscb.platform.core.debug.ScriptDebugCache;
import kd.isc.iscb.platform.core.fn.openapi.OpenAPIToolKit;
import kd.isc.iscb.platform.core.fn.orm.ORMToolKit;
import kd.isc.iscb.platform.core.sf.Resource;
import kd.isc.iscb.platform.core.sf.func.InvokeAction;
import kd.isc.iscb.platform.core.sf.func.InvokeActionWithParams;
import kd.isc.iscb.platform.core.sf.parser.ResourceCategory;
import kd.isc.iscb.platform.core.sf.res.DataSourceResource;
import kd.isc.iscb.platform.core.task.LightTask;
import kd.isc.iscb.platform.core.task.LightTaskManager;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.trace.Caller;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.platform.core.util.TimeUtil;
import kd.isc.iscb.util.connector.s.ExecuteBatch;
import kd.isc.iscb.util.connector.s.ExecuteCall;
import kd.isc.iscb.util.connector.s.ExecuteUpdate;
import kd.isc.iscb.util.connector.s.QueryList;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;
import kd.isc.iscb.util.script.feature.control.loop.Throw;
import kd.isc.iscb.util.script.feature.sql.SqlRuntime;
import kd.isc.iscb.util.trace.TraceTask;

public class ScriptExecuteFormPlugin
extends AbstractScriptEditorFormPlugin {
    private static final String OPER_EXECUTE = "execute";
    private static final String OPER_SHOW_LOGS = "viewlog";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit connection = (BasedataEdit)this.getView().getControl("connection");
        IFormView view = this.getView();
        connection.addBeforeF7ViewDetailListener(evt -> {
            evt.setCancel(true);
            BillShowParameter param = new BillShowParameter();
            DynamicObject ds = BusinessDataServiceHelper.loadSingle((Object)evt.getPkId(), (String)"isc_database_link", (String)"database_type");
            param.setFormId(DatabaseType.getForm((String)ds.getString("database_type")));
            param.setPkId(evt.getPkId());
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setStatus(OperationStatus.VIEW);
            view.showForm((FormShowParameter)param);
        });
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        if (StringUtils.equals((CharSequence)OPER_EXECUTE, (CharSequence)operationKey)) {
            CodeEdit editor = (CodeEdit)this.getView().getControl("script_editor");
            String script = D.s((Object)editor.getText());
            this.executeScript(script);
        } else if (StringUtils.equals((CharSequence)OPER_SHOW_LOGS, (CharSequence)operationKey)) {
            FormOpener.openExistedBillList(this, "isc_sql_exe_log", null);
        } else if ("execute_for_new".equals(operationKey)) {
            if (RequestContext.get().getUserId().equals(ScriptDebugCache.getDebugUserId())) {
                this.debugScript();
            } else {
                this.executeScript();
            }
        } else if ("debug".equals(operationKey) && ScriptDebuggerFormPlugin.enableDebug(this)) {
            this.debugScript();
        }
    }

    private void executeScript() {
        String tips = ScriptDebugCache.isDebugEnabled() ? ResManager.loadKDString((String)"\u811a\u672c\u6267\u884c\u4e2d...", (String)"ScriptExecuteFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u811a\u672c\u6267\u884c\u4e2d...", (String)"ScriptExecuteFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\r\n\r" + ResManager.loadKDString((String)"\u63d0\u793a\uff1a\u5982\u679c\u957f\u65f6\u95f4\u672a\u7ed3\u675f\u4e14\u9700\u7ec8\u6b62\u6267\u884c\uff0c\u8bf7\u901a\u8fc7\u83dc\u5355\u542f\u52a8\u811a\u672c\u8c03\u8bd5\u5668\uff0c\u70b9\u51fb\u201c\u7ec8\u6b62\u811a\u672c\u6d4b\u8bd5\u201d\u6309\u94ae\u3002", (String)"ScriptExecuteFormPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        this.getModel().setValue("result", (Object)tips);
        this.getView().invokeOperation("get_script_data");
    }

    private void debugScript() {
        FormOpener.showAppIdTabForm(this, "isc_script_debugger", ResManager.loadKDString((String)"\u811a\u672c\u8c03\u8bd5\u5668", (String)"ScriptExecuteFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), new HashMap<String, Object>());
        this.getModel().setValue("result", (Object)(ResManager.loadKDString((String)"\u811a\u672c\u6267\u884c\u4e2d...", (String)"ScriptExecuteFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\r\n\r\n" + ResManager.loadKDString((String)"\u63d0\u793a\uff1a", (String)"ScriptExecuteFormPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"1.\u5982\u679c\u8c03\u8bd5\u5668\u672a\u542f\u52a8\u8c03\u8bd5\uff0c\u8bf7\u70b9\u51fb\u201c\u5f00\u59cb\u8c03\u8bd5\u201d\u6309\u94ae\u542f\u52a8\u8c03\u8bd5\u3002", (String)"ScriptExecuteFormPlugin_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]) + "\r\n" + ResManager.loadKDString((String)"2.\u5982\u679c\u6355\u83b7\u4e0d\u5230\u811a\u672c\u65ad\u70b9\u4e14\u9700\u7ec8\u6b62\u6267\u884c\uff0c\u8bf7\u70b9\u51fb\u201c\u7ec8\u6b62\u811a\u672c\u6d4b\u8bd5\u201d\u6309\u94ae\u3002", (String)"ScriptExecuteFormPlugin_24", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])));
        this.getView().invokeOperation("get_script_data");
    }

    @Override
    protected int getHeight() {
        return 540;
    }

    @Override
    protected int getWidth() {
        return 900;
    }

    @Override
    protected void handleScript(String script) {
        this.executeScript(script);
    }

    private void executeScript(String script) {
        String password = D.s((Object)this.getModel().getValue("password"));
        if (password != null) {
            String required_password = D.s((Object)SystemProperties.getWithEnv((String)"ISC_TEST_PASSWORD"));
            if (required_password == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u96c6\u6210\u6d4b\u8bd5\u5bc6\u7801\u672a\u8bbe\u7f6e!", (String)"ScriptExecuteFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("result", null);
                this.getModel().setValue("result_tag", null);
                return;
            }
            if (!required_password.equals(password)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bc6\u7801\u4e0d\u6b63\u786e!", (String)"ScriptExecuteFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("result", null);
                this.getModel().setValue("result_tag", null);
                return;
            }
        }
        if (script == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u4e3a\u7a7a!", (String)"ScriptExecuteFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            this.execute(script, password);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String script, String password) {
        long start = System.currentTimeMillis();
        ArrayList<ConnectionWrapper> cns = new ArrayList<ConnectionWrapper>();
        try {
            final Map<String, Object> ctx = this.prepareConnections(cns, password);
            final Script p = IscScript.compile((String)script, ctx);
            this.prepareBeforeEval(password, p);
            Object result = TraceStack.trace((Caller)Caller.Front, (TraceTask)new TraceTask(){

                public Object invoke() {
                    DataSourceResource.createConnectionPool();
                    try {
                        Object object;
                        SignalManager.registerTask((String)RequestContext.get().getUserId());
                        try {
                            object = p.eval(ctx);
                        }
                        catch (Throwable throwable) {
                            SignalManager.unregisterTask((String)RequestContext.get().getUserId());
                            throw throwable;
                        }
                        SignalManager.unregisterTask((String)RequestContext.get().getUserId());
                        return object;
                    }
                    finally {
                        DataSourceResource.disposeConnectionPool();
                    }
                }
            });
            this.handleResult(start, result);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff01", (String)"ScriptExecuteFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
        catch (Throwable e) {
            long end = System.currentTimeMillis();
            String errorMsg = ShowStackTraceUtil.getErrorMsg(e);
            this.setResult(errorMsg, start, end);
            this.getModel().setValue("result_tag", (Object)errorMsg);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6267\u884c\u5931\u8d25\uff01", (String)"ScriptExecuteFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        finally {
            String links = this.closeConnections(cns);
            String resources = StringUtil.trim((String)this.collectResources(), (int)1999);
            this.saveLog(script, links, resources);
        }
    }

    private void handleResult(long start, Object result) {
        long end = System.currentTimeMillis();
        String s = Throw.toMessage((Object)result);
        this.setResult(s, start, end);
        this.getModel().setValue("result_tag", this.trim(s, 100000));
        if (D.x((Object)this.getModel().getValue("isdownload"))) {
            this.downloadResult(s, this.getView());
        }
    }

    private void downloadResult(String s, IFormView view) {
        if (this.isResultOverSize(s)) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String format = sdf.format(new Date());
        try (ByteArrayInputStream input = new ByteArrayInputStream(s.getBytes(StandardCharsets.UTF_8));){
            String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(String.format(ResManager.loadKDString((String)"\u811a\u672c\u6267\u884c\u5de5\u5177_%s.txt", (String)"ScriptExecuteFormPlugin_25", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), format), (InputStream)input, 300);
            FileUtil.addDownloadPermission((String)"isc_script_tool", (String)urls, (String)view.getFormShowParameter().getServiceAppId());
            view.openUrl(urls);
        }
        catch (Exception e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"ScriptExecuteFormPlugin_26", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), e.getMessage()), (Throwable)e);
        }
    }

    private boolean isResultOverSize(String s) {
        int maxSize;
        long objectSize = DbUtil.getObjectSize((Object)s);
        if (objectSize >= (long)(maxSize = QueryList.getResultSetMaxSize())) {
            FormOpener.showMessage(this, ResManager.loadKDString((String)"\u4e0b\u8f7d\u5185\u5bb9\u8d85\u51fa\u7cfb\u7edf\u5141\u8bb8\u4e0a\u9650", (String)"ScriptExecuteFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u811a\u672c\u6267\u884c\u7ed3\u679c\u7684\u603b\u5b57\u8282\u6570\u5df2\u7ecf\u8d85\u8fc7\u5141\u8bb8\u4e0b\u8f7d\u7684\u6700\u5927\u503c%s\u4e2a\u5b57\u8282\uff0c\u5efa\u8bae\u89e3\u51b3\u529e\u6cd5\uff1a\u4f18\u5316\u6267\u884c\u811a\u672c\uff1b\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8c03\u6574JVM\u7cfb\u7edf\u53c2\u6570 ISC_QUERY_MAX_SIZE \u589e\u52a0\u4e0a\u9650\u3002", (String)"ScriptExecuteFormPlugin_27", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), maxSize));
            return true;
        }
        return false;
    }

    private String collectResources() {
        ArrayList resources = new ArrayList();
        for (DynamicObject item : this.getModel().getEntryEntity("resources")) {
            if (StringUtils.isEmpty((CharSequence)item.getString("res_category"))) continue;
            HashMap<String, String> res = new HashMap<String, String>(3);
            res.put("type", item.getString("res_category"));
            res.put("number", item.getString("res_ref.number"));
            res.put("alias", item.getString("res_alias"));
            resources.add(res);
        }
        return Json.toString(resources);
    }

    private void prepareBeforeEval(String password, Script p) {
        if (password == null) {
            p.setTimeout(3000);
        } else {
            p.setTimeout(60000);
        }
        String debugUser = ScriptDebugCache.getDebugUserId();
        if (debugUser == null) {
            this.attachBreakpointAtAll(p);
        } else if (debugUser.equals(RequestContext.get().getUserId())) {
            this.attachBreakpointAtSome(p);
            p.setTimeout(1800000);
        }
    }

    private void attachBreakpointAtAll(Script p) {
        int lines = p.getProgram().getScriptReader().lineCount();
        for (int i = 1; i <= lines; ++i) {
            p.getProgram().attachBreakpoint(i);
        }
    }

    private void attachBreakpointAtSome(Script p) {
        int i;
        int lines = p.getProgram().getScriptReader().lineCount();
        for (i = 1; i <= lines && !p.getProgram().attachBreakpoint(i); ++i) {
        }
        for (i = 1; i <= 5; ++i) {
            p.getProgram().attachBreakpoint(i);
        }
    }

    private void setResult(String result, long start, long end) {
        SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
        String res = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u6267\u884c\u5f00\u59cb\u4e8e\uff1a%1$s\uff0c\u7ed3\u675f\u4e8e\uff1a%2$s\uff0c\r\n\u8017\u65f6\uff1a%3$s\u6beb\u79d2\uff0c\u7ed3\u679c\uff1a\r\n%4$s\r\n\r\n", (String)"ScriptExecuteFormPlugin_28", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), TimeUtil.getInteTime((Date)D.t((Object)start), (SimpleDateFormat)df), TimeUtil.getInteTime((Date)D.t((Object)end), (SimpleDateFormat)df), end - start, this.trim(result, 1024));
        this.getModel().setValue("result", (Object)res);
    }

    private Object trim(String s, int max) {
        if (s == null) {
            return "null";
        }
        if (s.length() > max) {
            return s.substring(0, max) + "...";
        }
        return s;
    }

    private void saveLog(final String script, final String links, final String resources) {
        LightTaskManager.submit((LightTask)new LightTask(){
            private String id = UUID.randomUUID().toString();

            public void run() {
                ScriptExecuteFormPlugin.this.saveExecuteLog(links, script, resources);
            }

            public String getId() {
                return this.id;
            }
        });
    }

    private String closeConnections(List<ConnectionWrapper> cns) {
        DbUtil.close((Connection)SqlRuntime.getCurrent(), (boolean)false);
        SqlRuntime.setCurrent(null);
        StringBuilder links = new StringBuilder();
        for (ConnectionWrapper cn : cns) {
            links.append(cn.getConfig().get("number")).append(';');
            ConnectorUtil.close((AutoCloseable)cn);
        }
        return links.length() == 0 ? "$this" : (links.length() <= 50 ? links.toString() : links.toString().substring(1, 48) + "..");
    }

    private Map<String, Object> prepareConnections(List<ConnectionWrapper> cns, String password) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(8);
        ctx.put("encode", new EncodeFunction());
        ctx.put("decode", new DecodeFunction());
        ctx.put("LicenseInfo", new LicenseInfo());
        ctx.put("InstanceInfo", new InstanceInfo());
        ctx.put("calc_eas_pwd", new CalcEasPwd());
        ctx.put("ScheduledTasks", new ScheduledTasks());
        ctx.put("RunningTasks", new RunningTasks());
        if (password == null) {
            return ctx;
        }
        HashSet<String> alias_set = new HashSet<String>();
        this.setConnections(cns, ctx, alias_set);
        this.setResources(ctx, alias_set);
        SelfConnection cn = new SelfConnection();
        SqlRuntime.setCurrent((Connection)cn);
        ctx.put("$this", cn);
        ctx.put("execute_update", new ExecuteUpdate(true));
        ctx.put("execute_call", new ExecuteCall());
        ctx.put("execute_batch", new ExecuteBatch());
        ctx.put("bizQuery", new BizQueryFunction());
        ctx.put("IERP_BOTP", new BotpServiceInvoker());
        ctx.put("invokeMicroService", new MicroServiceInvoker());
        ctx.put("invokeMicroService2", new MicroServiceInvoker2());
        ctx.put("flatObjectToMapOrList", new FlatObjectToMapOrList());
        ctx.put("StartEventServiceFlow", new StartEventServiceFlow());
        ctx.put("StartEventDataCopy", new StartEventDataCopy());
        ctx.put("ORM", new ORMToolKit());
        ctx.put("$action", new InvokeAction());
        ctx.put("$action2", new InvokeActionWithParams());
        ctx.put("OpenAPI", new OpenAPIToolKit());
        return ctx;
    }

    private void setResources(Map<String, Object> ctx, Set<String> alias_set) {
        for (DynamicObject item : this.getModel().getEntryEntity("resources")) {
            DynamicObject ref = item.getDynamicObject("res_ref");
            if (ref == null) continue;
            String s = ((String)item.get("res_category")).toUpperCase();
            ResourceCategory category = ResourceCategory.valueOf((String)s);
            Resource res = ScriptExecuteFormPlugin.create(ref, category);
            String alias = D.s((Object)item.getString("res_alias"));
            this.checkAndAddSet(alias_set, alias);
            ctx.put(alias, res);
        }
    }

    private void setConnections(List<ConnectionWrapper> cns, Map<String, Object> ctx, Set<String> alias_set) {
        for (DynamicObject item : this.getModel().getEntryEntity("connections")) {
            DynamicObject cfg = item.getDynamicObject("connection");
            if (cfg == null) continue;
            ConnectionWrapper cn = ConnectionManager.getConnection((long)cfg.getLong("id"));
            cns.add(cn);
            ctx.put(cfg.getString("number"), cn);
            String alias = D.s((Object)item.getString("alias"));
            this.checkAndAddSet(alias_set, alias);
            ctx.put(alias, cn);
        }
    }

    private void checkAndAddSet(Set<String> alias_set, String alias) {
        if (alias_set.contains(alias)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u3010\u7cfb\u7edf\u8fde\u63a5\u3011\u5206\u5f55\u548c\u3010\u4f9d\u8d56\u8d44\u6e90\u3011\u5206\u5f55\u4e2d\u522b\u540d\u3010%s\u3011\u5b58\u5728\u91cd\u590d\u503c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ScriptExecuteFormPlugin_31", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), alias));
        }
        alias_set.add(alias);
    }

    private static Resource create(DynamicObject ref, ResourceCategory category) {
        long id = ref.getLong("id");
        String name = ref.getString("number");
        String title = ref.getString("name");
        return category.create(id, name, title);
    }

    private void saveExecuteLog(String dataSource, String script, String resources) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"isc_sql_exe_log");
        log.set("data_source", (Object)(dataSource == null ? "{none}" : dataSource));
        log.set("sql", (Object)script);
        log.set("creator", (Object)RequestContext.get().getUserId());
        log.set("createtime", (Object)Timestamp.valueOf(LocalDateTime.now()));
        log.set("resources", (Object)resources);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }
}

