/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.cntype;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.Tips;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.dc.cntype.FieldControlModel;
import kd.isc.iscb.platform.core.api.webapi.Const;
import kd.isc.iscb.util.dt.D;

public class DynamicConfigForCnType
implements Const {
    private DynamicObjectCollection collection;
    public static final String PREFIX = "config_";
    private Map<String, FieldAp> fieldApMap;
    private Map<String, DynamicProperty> fieldPropMap;

    public DynamicConfigForCnType(DynamicObjectCollection configEntries) {
        this.collection = configEntries;
    }

    public DynamicConfigForCnType(String typeID) {
        DynamicObject cnType = BusinessDataServiceHelper.loadSingle((Object)typeID, (String)"isc_connection_type");
        this.collection = cnType.getDynamicObjectCollection("entryentity");
    }

    public void setDefaultFiledInfo(IFormView view, IDataModel model) {
        for (DynamicObject object : this.collection) {
            String number = D.s((Object)object.get("params_number"));
            if ("server_ip".equals(number) || "server_port".equals(number)) {
                TextEdit text = (TextEdit)view.getControl(number);
                Tips tips = new Tips();
                tips.setContent(new LocaleString(D.s((Object)object.get("desc"))));
                tips.setType("text");
                text.addTips(tips);
                if (D.l((Object)model.getValue("id")) != 0L || D.s((Object)object.get("default_value")) == null) continue;
                model.setValue(number, object.get("default_value"));
                continue;
            }
            if (!"http_protocal".equals(number)) continue;
            ComboEdit comboEdit = (ComboEdit)view.getControl(number);
            String desc = D.s((Object)object.get("desc"));
            if (desc != null) {
                Tips tips = new Tips();
                tips.setContent(new LocaleString(D.s((Object)object.get("desc"))));
                tips.setType("text");
                comboEdit.addTips(tips);
            }
            if (D.l((Object)model.getValue("id")) != 0L) continue;
            String str = D.s((Object)object.get("default_value"));
            if ("http".equalsIgnoreCase(str)) {
                model.setValue(number, (Object)"http");
                continue;
            }
            if (!"https".equalsIgnoreCase(str)) continue;
            model.setValue(number, (Object)"https");
        }
    }

    private Map<String, FieldControlModel> initFieldControlModelMap() {
        if (this.collection == null) {
            return new HashMap<String, FieldControlModel>();
        }
        HashMap<String, FieldControlModel> map = new HashMap<String, FieldControlModel>(this.collection.size());
        for (DynamicObject object : this.collection) {
            if (D.x((Object)object.get("params_preset"))) continue;
            map.put(D.s((Object)object.get("params_number")), new FieldControlModel(object, PREFIX));
        }
        return map;
    }

    public FlexPanelAp getFlexPanelAP() {
        FlexPanelAp headPanelAp = new FlexPanelAp();
        headPanelAp.setKey("headAp");
        if (this.collection != null) {
            this.initFieldApMap();
            for (Map.Entry<String, FieldAp> entry : this.fieldApMap.entrySet()) {
                headPanelAp.getItems().add(entry.getValue());
            }
        }
        return headPanelAp;
    }

    private void initFieldApMap() {
        this.fieldApMap = new LinkedHashMap<String, FieldAp>(this.collection.size());
        for (DynamicObject object : this.collection) {
            if (D.x((Object)object.get("params_preset"))) continue;
            FieldControlModel fieldControlModel = new FieldControlModel(object, PREFIX);
            FieldAp fieldAp = fieldControlModel.buildFieldAp();
            this.fieldApMap.put(D.s((Object)object.get("params_number")), fieldAp);
        }
    }

    public void initFieldPropMap() {
        if (this.collection == null) {
            return;
        }
        this.fieldPropMap = new HashMap<String, DynamicProperty>(this.collection.size());
        for (DynamicObject object : this.collection) {
            if (D.x((Object)object.get("params_preset"))) continue;
            if ("ref".equals(D.s((Object)object.get("params_type")))) {
                BasedataProp property = new FieldControlModel(object, PREFIX).buildRefFieldProp();
                DynamicSimpleProperty simpleProperty = new FieldControlModel(object, PREFIX).buildRefIdFieldProp(property);
                this.fieldPropMap.put(D.s((Object)object.get("params_number")), (DynamicProperty)property);
                this.fieldPropMap.put(D.s((Object)object.get("params_number")) + "_id", (DynamicProperty)simpleProperty);
                continue;
            }
            this.fieldPropMap.put(D.s((Object)object.get("params_number")), new FieldControlModel(object, PREFIX).buildFieldProp());
        }
    }

    public FieldEdit getFieldEditByKey(String key) {
        if (!key.startsWith(PREFIX)) {
            return null;
        }
        for (DynamicObject object : this.collection) {
            String tempKey = this.convertFieldNameToControlName(D.s((Object)object.get("params_number")));
            if (D.x((Object)object.get("params_preset")) || !tempKey.equals(key)) continue;
            FieldControlModel fieldControlModel = new FieldControlModel(object, PREFIX);
            return fieldControlModel.buildFieldEdit();
        }
        return null;
    }

    public Map<String, Object> collectConfigData(IDataModel object) {
        Map<String, FieldControlModel> fieldControlModelMap = this.initFieldControlModelMap();
        HashMap<String, Object> configData = new HashMap<String, Object>(fieldControlModelMap.size());
        for (Map.Entry<String, FieldControlModel> entry : fieldControlModelMap.entrySet()) {
            String fieldName = entry.getKey();
            String controlName = this.convertFieldNameToControlName(fieldName);
            FieldControlModel entryValue = entry.getValue();
            String type = entryValue.getType();
            if ("ref".equals(type)) {
                DynamicObject obj = object.getDataEntity(true).getDynamicObject(controlName);
                if (obj != null) {
                    Object pkValue = obj.getPkValue();
                    HashMap<String, Object> info = new HashMap<String, Object>(2);
                    info.put("entityPk", pkValue);
                    info.put("entityType", obj.getDataEntityType().getName());
                    configData.put(fieldName, info);
                    continue;
                }
                configData.put(fieldName, object.getValue(controlName));
                continue;
            }
            configData.put(fieldName, object.getValue(controlName));
        }
        return configData;
    }

    public void setDynamicFieldValues(IDataModel object, Map<String, Object> data) {
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String fieldName = entry.getKey();
            String controlName = this.convertFieldNameToControlName(fieldName);
            IDataEntityProperty property = object.getProperty(controlName);
            if (property == null) continue;
            Object value = entry.getValue();
            if (value instanceof Map && property instanceof BasedataProp) {
                Map info = (Map)value;
                String entityName = D.s(info.get("entityType"));
                BasedataProp basedataProp = (BasedataProp)property;
                String define_entity_type = basedataProp.getBaseEntityId();
                if (!define_entity_type.equals(entityName)) continue;
                Object pk = info.get("entityPk");
                DynamicObject item = BusinessDataServiceHelper.loadSingle(pk, (String)entityName);
                object.setValue(controlName, (Object)item);
                continue;
            }
            object.setValue(controlName, value);
        }
    }

    private String convertFieldNameToControlName(String fieldName) {
        return PREFIX + fieldName.toLowerCase();
    }

    public DynamicProperty getFieldProp(String key) {
        return this.fieldPropMap.get(key);
    }
}

