/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.dataset;

import java.sql.Timestamp;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Button;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.dc.dataset.DataSetUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class ImportMetaToDatasetPlugin
extends AbstractFormPlugin {
    private static final String DATA_TYPE = "dataType";
    private static final String NUMBER = "number";
    private static final String IS_MULTIPLE = "is_multiple";
    private static final String IS_DISTINCT = "is_distinct";
    private static final String IMPORT_META = "importMeta";
    private static final String METADATA_SCHEMA = "isc_metadata_schema";
    private static final String GROUP_ID = "group_id";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put(IMPORT_META, "false");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        if (src instanceof Button && "btnok".equals(((Button)src).getKey())) {
            Object importMetadataPK = this.getModel().getValue("import_metadata_id");
            if (this.isNotfilled(importMetadataPK)) {
                this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u96c6\u6210\u5bf9\u8c61\uff01", (String)"ImportMetaToDatasetPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject metadataSchema = BusinessDataServiceHelper.loadSingle((Object)importMetadataPK, (String)METADATA_SCHEMA);
            TreeNode rootNode = this.setTreeRootNode(metadataSchema);
            String jsonString = SerializationUtils.toJsonString((Object)rootNode);
            QFilter filter = new QFilter(NUMBER, "=", metadataSchema.get(NUMBER)).and("data_source_id", "=", metadataSchema.get(GROUP_ID));
            DynamicObject dataset = BusinessDataServiceHelper.loadSingle((String)"isc_dataset_schema", (String)"id", (QFilter[])new QFilter[]{filter});
            if (dataset != null) {
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a%s\u7684\u6570\u636e\u96c6\u65b9\u6848\u5df2\u5b58\u5728\uff0c\u5bfc\u5165\u5931\u8d25\uff01", (String)"ImportMetaToDatasetPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), metadataSchema.get(NUMBER)));
                return;
            }
            this.createNewDataSet(metadataSchema, rootNode, jsonString);
            this.getPageCache().put(IMPORT_META, "true");
            this.getView().close();
        }
    }

    private boolean isNotfilled(Object importMetadataPK) {
        return importMetadataPK == null || 0 == D.i((Object)importMetadataPK);
    }

    private void createNewDataSet(DynamicObject metadataSchema, TreeNode rootNode, String jsonString) {
        DynamicObject datasetSchema = BusinessDataServiceHelper.newDynamicObject((String)"isc_dataset_schema");
        datasetSchema.set(NUMBER, (Object)rootNode.getId());
        datasetSchema.set("name", (Object)rootNode.getText());
        datasetSchema.set("data_source", metadataSchema.get(GROUP_ID));
        datasetSchema.set("full_name", metadataSchema.get("full_name"));
        datasetSchema.set("enable", (Object)"1");
        datasetSchema.set("status", (Object)"A");
        datasetSchema.set("creator", (Object)D.l((Object)RequestContext.get().getUserId()));
        datasetSchema.set("createtime", (Object)new Timestamp(System.currentTimeMillis()));
        datasetSchema.set("modifier", (Object)D.l((Object)RequestContext.get().getUserId()));
        datasetSchema.set("modifytime", (Object)new Timestamp(System.currentTimeMillis()));
        Object data = rootNode.getData();
        if (data instanceof Map) {
            datasetSchema.set("meta_type", ((Map)data).get(DATA_TYPE));
        }
        datasetSchema.set("fdefine_json_tag", (Object)jsonString);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{datasetSchema});
    }

    private TreeNode setTreeRootNode(DynamicObject metadataSchema) {
        String number = D.s((Object)metadataSchema.get(NUMBER));
        String name = D.s((Object)metadataSchema.get("name"));
        Object group = metadataSchema.get("group");
        TreeNode rootNode = new TreeNode("", number, name);
        rootNode.setId(number);
        rootNode.setText(name);
        String type = D.s((Object)metadataSchema.get("type"));
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put(NUMBER, number);
        dataMap.put("name", name);
        dataMap.put(DATA_TYPE, type);
        dataMap.put(IS_MULTIPLE, null);
        dataMap.put(IS_DISTINCT, null);
        dataMap.put("isFromMeta", Boolean.TRUE);
        rootNode.setData(dataMap);
        DynamicObjectCollection propEntryentity = metadataSchema.getDynamicObjectCollection("prop_entryentity");
        this.addChildTreeNode(rootNode, propEntryentity, group);
        return rootNode;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        HashMap<String, String> returns = new HashMap<String, String>();
        returns.put(IMPORT_META, this.getPageCache().get(IMPORT_META));
        this.getPageCache().remove(IMPORT_META);
        this.getView().returnDataToParent(returns);
    }

    private void addChildTreeNode(TreeNode rootNode, DynamicObjectCollection propEntryentity, Object group) {
        for (DynamicObject proObj : propEntryentity) {
            Object type;
            DynamicObject propMetaData;
            String dataType = D.s((Object)proObj.get("data_type"));
            Object propNumber = proObj.get("prop_name");
            Object propName = proObj.get("prop_label");
            Object dataSchema = proObj.get("data_schema");
            String formatDataSetType = DataSetUtil.formatDataSetType(dataType);
            TreeNode newNode = new TreeNode(rootNode.getId(), rootNode.getId() + "." + D.s((Object)propNumber), D.s((Object)propName));
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put(NUMBER, propNumber);
            dataMap.put("name", propName);
            dataMap.put(DATA_TYPE, formatDataSetType);
            dataMap.put(IS_MULTIPLE, null);
            dataMap.put(IS_DISTINCT, null);
            if ("ENTRIES".equals(dataType) || "STRUCT".equals(dataType)) {
                dataMap.put(IS_MULTIPLE, Boolean.TRUE);
                if (D.s((Object)dataSchema) != null) {
                    propMetaData = this.getMetaBySchema((String)dataSchema, group);
                    type = propMetaData.get("type");
                    dataMap.put(DATA_TYPE, type);
                    DynamicObjectCollection propChildEntryentity = propMetaData.getDynamicObjectCollection("prop_entryentity");
                    this.addChildTreeNode(newNode, propChildEntryentity, group);
                } else {
                    dataMap.put(DATA_TYPE, proObj.get("prop_remark"));
                }
            } else if ("ENUM".equals(dataType)) {
                propMetaData = this.getMetaBySchema((String)dataSchema, group);
                type = propMetaData.get("type");
                dataMap.put(DATA_TYPE, type);
                dataMap.put(IS_MULTIPLE, Boolean.FALSE);
                DynamicObjectCollection propEnumEntryentity = propMetaData.getDynamicObjectCollection("consts_entryentity");
                HashMap<String, String> enumMap = new HashMap<String, String>();
                for (DynamicObject enumEntity : propEnumEntryentity) {
                    String constValue = D.s((Object)enumEntity.get("const_value"));
                    String constLabel = D.s((Object)enumEntity.get("const_label"));
                    enumMap.put(constValue, constLabel);
                }
                dataMap.put("fields", enumMap);
            } else if ("list".equals(formatDataSetType) || "set".equals(formatDataSetType)) {
                String propRemark = D.s((Object)proObj.get("prop_remark"));
                dataMap.put(DATA_TYPE, DataSetUtil.formatDataSetType(propRemark));
                dataMap.put(IS_MULTIPLE, Boolean.TRUE);
                dataMap.put(IS_DISTINCT, "set".equals(formatDataSetType));
            }
            newNode.setData(dataMap);
            rootNode.addChild(newNode);
        }
    }

    public DynamicObject getMetaBySchema(String dataSchema, Object group) {
        QFilter filter = new QFilter(NUMBER, "=", (Object)dataSchema).and(GROUP_ID, "=", ((DynamicObject)group).getPkValue());
        DynamicObject object = BusinessDataServiceHelper.loadSingle((String)METADATA_SCHEMA, (String)"id", (QFilter[])new QFilter[]{filter});
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)object.getPkValue(), (String)METADATA_SCHEMA);
        if (meta != null) {
            return meta;
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff08%s\uff09\u7684\u96c6\u6210\u5bf9\u8c61\u672a\u627e\u5230\uff0c\u8bf7\u540c\u6b65\u5168\u90e8\u5143\u6570\u636e\u6216\u4eba\u5de5\u6dfb\u52a0\u8be5\u96c6\u6210\u5bf9\u8c61\uff01", (String)"ImportMetaToDatasetPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), dataSchema));
    }
}

