/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.event;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.isc.iscb.formplugin.dc.event.EventUtils;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.ConnectorUtil;
import kd.isc.iscb.platform.core.log.EventFailTotalUtil;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.sf.ServiceFlowReleaser;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;

public class EventQueueTreeListPlugin
extends AbstractListPlugin
implements HyperLinkClickListener,
TreeNodeClickListener {
    private static final IAppCache cache = AppCache.get((String)"eve_que_ids");
    private static final String KEY_TREE = "treeviewap";
    public static final String FOCUS_ID = "focus_id";
    private static final String OP_DELETE = "delete";
    private static final String OP_REFRESH = "refresh";
    private static final String OP_RESET = "reset";
    private static final String DBLINK_ID = "dblink_id";
    private static final String TRIGGER_ID = "trigger_id";
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String DB_LINK = "dblink";
    public static final int PAGE_NUMBERS = 50;
    private static final String PAGE_NO = "page_no";
    public static final String DATABASE_LINK = "database_link";
    public static final String ID = "id";
    public static final String ENTITY = "entity";
    public static final String EVENT = "event";
    public static final String BOID = "boid";
    public static final String ISC_HUB = "isc_hub";
    public static final String TRIGGER_TYPE = "trigger_type";
    public static final String STATE = "state";
    public static final String CREATED_TIME = "created_time";
    public static final String MODIFIED_TIME = "modified_time";
    public static final String IDS = "IDS";
    public static final String NEXT = "next";
    public static final String LAST = "last";
    public static final String FIRST = "first";
    public static final String END = "end";
    public static final String SEARCH = "search";
    public static final String ENTRY_NO = "entry_no";
    public static final String SEARCH_FIELD = "search_field";
    public static final String ISC_EVENT_SEARCH_FIELD = "isc_event_search_field";
    public static final String SEARCHENTITY = "searchentity";
    public static final String SEARCHBOID = "searchboid";
    public static final String DATERANGE_STARTTIME = "daterange_starttime";
    public static final String DATERANGE_ENDTIME = "daterange_endtime";
    public static final String SEARCHSTATE = "searchstate";
    public static final String IS_SORTED_MODIFITIME = "is_sorted_modifitime";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRY_ENTITY);
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initTree();
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        String nodeId = evt.getNodeId().toString();
        if (!"ROOT".equals(nodeId)) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            params.remove(TRIGGER_ID);
            this.refresh();
        }
    }

    private void initTree() {
        String focusNodeId = this.getFocusNodeId();
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
        if (StringUtils.isEmpty((String)focusNodeId)) {
            treeView.deleteAllNodes();
            treeView.setMulti(false);
            TreeNode root = new TreeNode("", "ROOT", ResManager.loadKDString((String)"\u8fde\u63a5\u914d\u7f6e", (String)"EventQueueTreeListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            root.setExpend(true);
            List<TreeNode> nodes = this.getChildrenNodes();
            if (nodes.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7cfb\u7edf\u4e0d\u5b58\u5728\u4e8b\u4ef6\u89e6\u53d1\u76f8\u5173\u8fde\u63a5\u914d\u7f6e", (String)"EventQueueTreeListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                return;
            }
            root.setChildren(nodes);
            treeView.addNode(root);
            treeView.setRootVisible(false);
            treeView.expand("ROOT");
            treeView.focusNode(nodes.get(0));
        }
    }

    private String getFocusNodeId() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        if (StringUtils.isEmpty((String)focusNodeId)) {
            focusNodeId = this.getPageCache().get(FOCUS_ID);
        } else {
            this.getPageCache().put(FOCUS_ID, focusNodeId);
        }
        return focusNodeId;
    }

    private List<TreeNode> getChildrenNodes() {
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        DynamicObjectCollection eventLogList = this.getEventLogList();
        for (DynamicObject eventLog : eventLogList) {
            nodes.add(new TreeNode("ROOT", eventLog.getString(ID), eventLog.getString("name")));
        }
        return nodes;
    }

    private DynamicObjectCollection getEventLogList() {
        List<String> eventLogTypeList = Arrays.asList("eas", "self", "db_proxy", "ierp");
        QFilter filter = new QFilter("database_type", "in", eventLogTypeList);
        return QueryServiceHelper.query((String)"isc_database_link", (String)"id, database_type, name", (QFilter[])new QFilter[]{filter});
    }

    private void setFocusFilter() {
        String jsonStr = this.getPageCache().get(SEARCH_FIELD);
        Map formParams = this.getView().getFormShowParameter().getCustomParams();
        if (formParams != null) {
            Map<String, String> searchField = new HashMap(6);
            if (jsonStr != null) {
                searchField = (Map)Json.toObject((String)jsonStr);
            }
            String state = D.s(formParams.get(STATE));
            String startTime = D.s(formParams.get("start_time"));
            String endTime = D.s(formParams.get("end_time"));
            String dblink = D.s(formParams.get(DB_LINK));
            String name = D.s(formParams.get("name"));
            TreeView treeView = (TreeView)this.getView().getControl(KEY_TREE);
            if (StringUtils.isNotEmpty((String)dblink) && StringUtils.isNotEmpty((String)name)) {
                treeView.focusNode(new TreeNode("ROOT", dblink, name));
            }
            if (StringUtils.isEmpty((String)D.s(searchField.get(SEARCHSTATE))) && StringUtils.isNotEmpty((String)state)) {
                searchField.put(SEARCHSTATE, state);
            }
            if (D.t(searchField.get(DATERANGE_STARTTIME)) == null && StringUtils.isNotEmpty((String)startTime)) {
                searchField.put(DATERANGE_STARTTIME, startTime);
            }
            if (D.t(searchField.get(DATERANGE_ENDTIME)) == null && StringUtils.isNotEmpty((String)endTime)) {
                searchField.put(DATERANGE_ENDTIME, endTime);
            }
            this.getPageCache().put(SEARCH_FIELD, Json.toString(searchField));
        }
    }

    private void initIds() {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        Object triggerId = params.get(TRIGGER_ID);
        String dblink = this.getFocusNodeId();
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("select fid from T_ISCB_CON_EVT_QUE ");
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        if (triggerId != null) {
            this.getPageCache().put(TRIGGER_ID, D.s(triggerId));
            String type = D.s(params.get("type"));
            DynamicObject dataSource = this.getDataSource(triggerId, type);
            if (dataSource.getLong(DBLINK_ID) <= 0L) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90%s\u672a\u7ed1\u5b9a\u8fde\u63a5\u3002", (String)"EventQueueTreeListPlugin_29", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), dataSource.getString("name")));
                return;
            }
            this.getPageCache().put(DB_LINK, dataSource.getString(DBLINK_ID));
            String sqlString = this.getInitIdsSqlString(sqlBuilder, dataSource.getString(DBLINK_ID), values, types);
            this.initCache(sqlString, dataSource.getString(DBLINK_ID), values, types);
        } else if (dblink != null) {
            this.getPageCache().put(DB_LINK, D.s((Object)dblink));
            String sqlString = this.getInitIdsSqlString(sqlBuilder, D.s((Object)dblink), values, types);
            this.initCache(sqlString, D.s((Object)dblink), values, types);
        }
    }

    private DynamicObject getDataSource(Object triggerId, String type) {
        if ("D".equals(type)) {
            DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"isc_data_copy_trigger");
            if (trigger.getLong("new_source_system_id") > 0L) {
                return BusinessDataServiceHelper.loadSingle((Object)trigger.getLong("new_source_system_id"), (String)"isc_data_source", (String)DB_LINK);
            }
            DynamicObject schema = BusinessDataServiceHelper.loadSingle((Object)trigger.getLong("data_copy_id"), (String)"isc_data_copy", (String)"data_source");
            return BusinessDataServiceHelper.loadSingle((Object)schema.getLong("data_source_id"), (String)"isc_data_source", (String)DB_LINK);
        }
        if ("A".equals(type)) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"isc_call_api_by_evt", (String)"metaschema");
            DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)obj.getLong("metaschema_id"), (String)"isc_metadata_schema", (String)"group");
            return BusinessDataServiceHelper.loadSingle((Object)meta.getLong("group_id"), (String)"isc_data_source", (String)DB_LINK);
        }
        if ("E".equals(type)) {
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"isc_mq_bill_data_pub", (String)"meta_data");
            DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)obj.getLong("meta_data_id"), (String)"isc_metadata_schema", (String)"group");
            return BusinessDataServiceHelper.loadSingle((Object)meta.getLong("group_id"), (String)"isc_data_source", (String)DB_LINK);
        }
        if ("S".equals(type)) {
            long releasedFlowId = ServiceFlowParser.findReleasedFlowId((long)D.l((Object)triggerId));
            Map diagramJson = ServiceFlowReleaser.getDiagramJson((long)D.l((Object)releasedFlowId));
            long metaId = this.getMetaId(diagramJson);
            DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)metaId, (String)"isc_metadata_schema", (String)"group");
            return BusinessDataServiceHelper.loadSingle((Object)meta.getLong("group_id"), (String)"isc_data_source", (String)DB_LINK);
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4f20\u5165\u7684\u7c7b\u578b%s", (String)"EventQueueTreeListPlugin_30", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), type));
    }

    private long getMetaId(Map<String, Object> diagramJson) {
        Map nodes = (Map)diagramJson.get("nodes");
        for (Map.Entry entry : nodes.entrySet()) {
            Map node = (Map)entry.getValue();
            if (!node.get("type").equals("EventStarter")) continue;
            return D.l(node.get("data_schema"));
        }
        return 0L;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setFocusFilter();
        this.refresh();
        this.getModel().setValue("textfield", (Object)ResManager.loadKDString((String)"\u67e5\u8be2\u6761\u4ef6", (String)"EventQueueTreeListPlugin_33", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    private void initList() {
        if (!this.getIdsList().isEmpty()) {
            this.initData();
        } else {
            this.getModel().getDataEntity(true);
            DynamicObjectCollection entries = this.getModel().getEntryEntity(ENTRY_ENTITY);
            entries.clear();
            this.getView().updateView(ENTRY_ENTITY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initData() {
        String dblink = this.getPageCache().get(DB_LINK);
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        String sql = this.getListDataSql(values, types);
        try (ConnectionWrapper cn = this.getConnection(D.l((Object)dblink));
             ObjectReader reader = cn.executeQuery(sql, values, types);){
            DynamicObject link = BusinessDataServiceHelper.loadSingle((Object)dblink, (String)"isc_database_link");
            this.showEntryData(link, (ObjectReader<DataRow>)reader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionWrapper getConnection(long dblink) {
        ConnectionManager.pushResLicense((boolean)true);
        try {
            ConnectionWrapper connectionWrapper = ConnectionManager.getConnection((long)dblink);
            return connectionWrapper;
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    private void setFilterSql(StringBuilder sql, List<Object> values, List<Integer> types) {
        this.setEntityFilter(sql, values, types);
        this.setBoidFilter(sql, values, types);
        this.setStateFilter(sql, values, types);
        this.setStartTimeFilter(sql, values, types);
        this.setEndTimeFilter(sql, values, types);
    }

    private void setEntityFilter(StringBuilder sql, List<Object> values, List<Integer> types) {
        Map<String, Object> params = this.getSearchField();
        String searchEntity = D.s((Object)params.get(SEARCHENTITY));
        if (!StringUtil.isEmpty((String)searchEntity)) {
            sql.append(" and fentity = ? ");
            values.add(searchEntity);
            types.add(12);
        }
    }

    private void setEndTimeFilter(StringBuilder sql, List<Object> values, List<Integer> types) {
        Map<String, Object> params = this.getSearchField();
        Timestamp endTime = D.t((Object)params.get(DATERANGE_ENDTIME));
        if (endTime != null) {
            sql.append(" and fcreated_time < ? ");
            values.add(((Date)endTime).getTime());
            types.add(-5);
        }
    }

    private void setStartTimeFilter(StringBuilder sql, List<Object> values, List<Integer> types) {
        Map<String, Object> params = this.getSearchField();
        Timestamp starttime = D.t((Object)params.get(DATERANGE_STARTTIME));
        if (starttime != null) {
            sql.append(" and fcreated_time > ? ");
            values.add(((Date)starttime).getTime());
            types.add(-5);
        }
    }

    private void setStateFilter(StringBuilder sql, List<Object> values, List<Integer> types) {
        Map<String, Object> params = this.getSearchField();
        String searchstate = D.s((Object)params.get(SEARCHSTATE));
        if (!StringUtil.isEmpty((String)searchstate)) {
            sql.append(" and fstate = ? ");
            values.add(searchstate);
            types.add(1);
        }
    }

    private void setBoidFilter(StringBuilder sql, List<Object> values, List<Integer> types) {
        Map<String, Object> params = this.getSearchField();
        String searchboid = D.s((Object)params.get(SEARCHBOID));
        if (!StringUtil.isEmpty((String)searchboid)) {
            sql.append(" and fboid = ? ");
            values.add(searchboid);
            types.add(12);
        }
    }

    private String getListDataSql(List<Object> values, List<Integer> types) {
        StringBuilder sql = new StringBuilder();
        sql.append("select fid,fcreated_time,fentity,fevent,fboid,fisc_hub,ftrigger_type,ftrigger_id,fstate,fmodified_time from T_ISCB_CON_EVT_QUE where fid in (");
        List<String> idList = this.getIdsList();
        for (int i = 0; i < idList.size(); ++i) {
            sql.append('?');
            if (i < idList.size() - 1) {
                sql.append(',');
            }
            values.add(idList.get(i));
            types.add(12);
        }
        sql.append(')');
        return sql.toString();
    }

    private int getPageNo() {
        return D.i((Object)this.getPageCache().get(PAGE_NO));
    }

    private String[] getPageCacheIds() {
        String ids = (String)cache.get(IDS, String.class);
        if (ids != null) {
            return ids.split(",");
        }
        return new String[0];
    }

    private void setIdsToCache(ObjectReader<DataRow> reader, StringBuilder ids) {
        DataRow data = (DataRow)reader.read();
        while (data != null) {
            ids.append(data.get((Object)"fid")).append(',');
            data = (DataRow)reader.read();
        }
        if (ids.length() > 0) {
            cache.put(IDS, (Object)ids.substring(0, ids.length() - 1));
        } else {
            cache.put(IDS, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCache(String sqlString, Object dblink, List<Object> values, List<Integer> types) {
        try (ConnectionWrapper cn = this.getConnection(D.l((Object)dblink));){
            String topSql = cn.topSQL(sqlString, 10000);
            StringBuilder ids = new StringBuilder();
            try (ObjectReader reader = cn.executeQuery(topSql, values, types);){
                this.setIdsToCache((ObjectReader<DataRow>)reader, ids);
            }
        }
    }

    private void setPageCacheNo(int no) {
        this.getModel().setValue("pageno", (Object)(no + 1));
        this.getPageCache().put(PAGE_NO, String.valueOf(no));
    }

    private String getInitIdsSqlString(StringBuilder sql, Object dblink, List<Object> values, List<Integer> types) {
        this.setHubValues(sql, dblink, values, types);
        this.setFilterSql(sql, values, types);
        String triggerId = this.getPageCache().get(TRIGGER_ID);
        if (!StringUtil.isEmpty((String)triggerId)) {
            sql.append(" and ftrigger_id = ? ");
            values.add(triggerId);
            types.add(12);
        }
        return this.setSqlOrderBy(sql);
    }

    private String setSqlOrderBy(StringBuilder sql) {
        if (this.isSortByModifitime()) {
            return sql.append(" order by fmodified_time desc ").toString();
        }
        return sql.append(" order by fcreated_time desc ").toString();
    }

    private boolean isSortByModifitime() {
        Map<String, Object> data = this.getSearchField();
        return D.x((Object)data.get(IS_SORTED_MODIFITIME));
    }

    private Map<String, Object> getSearchField() {
        String jsonStr = this.getPageCache().get(SEARCH_FIELD);
        if (jsonStr == null) {
            HashMap<String, Object> data = new HashMap<String, Object>(1);
            data.put(IS_SORTED_MODIFITIME, Boolean.FALSE);
            this.getPageCache().put(SEARCH_FIELD, Json.toString(data));
            return data;
        }
        return (Map)Json.toObject((String)this.getPageCache().get(SEARCH_FIELD));
    }

    private void setHubValues(StringBuilder sql, Object dblink, List<Object> values, List<Integer> types) {
        DynamicObject link = BusinessDataServiceHelper.loadSingle((Object)dblink, (String)"isc_database_link");
        String iscHub = ConnectorUtil.getIscHub((DynamicObject)link);
        String type = link.getString("database_type");
        sql.append(" where fisc_hub = ?");
        if ("self".equals(type)) {
            iscHub = "{self}";
        }
        values.add(iscHub);
        types.add(12);
    }

    private void showEntryData(DynamicObject databaseLink, ObjectReader<DataRow> reader) {
        this.getModel().getDataEntity(true);
        DynamicObjectCollection entries = this.getModel().getEntryEntity(ENTRY_ENTITY);
        entries.clear();
        DataRow data = (DataRow)reader.read();
        while (data != null) {
            DynamicObject row = entries.addNew();
            this.setRowValues(row, databaseLink, data);
            data = (DataRow)reader.read();
        }
        this.sortCollections(entries);
        this.setIndex(entries);
        this.getView().updateView(ENTRY_ENTITY);
    }

    private void setIndex(DynamicObjectCollection entries) {
        int index = 0;
        int pageno = this.getPageNo();
        for (DynamicObject entry : entries) {
            entry.set(ENTRY_NO, (Object)(pageno * 50 + ++index));
        }
    }

    private void sortCollections(DynamicObjectCollection entries) {
        entries.sort((o1, o2) -> {
            if (this.isSortByModifitime()) {
                Date date1 = o1.getDate(MODIFIED_TIME);
                long t1 = date1 == null ? o1.getDate(CREATED_TIME).getTime() : date1.getTime();
                Date date2 = o2.getDate(MODIFIED_TIME);
                long t2 = date2 == null ? o2.getDate(CREATED_TIME).getTime() : date2.getTime();
                return Long.compare(t2, t1);
            }
            long t1 = o1.getDate(CREATED_TIME).getTime();
            long t2 = o2.getDate(CREATED_TIME).getTime();
            return Long.compare(t2, t1);
        });
    }

    private List<String> getIdsList() {
        ArrayList<String> idList = new ArrayList<String>();
        String[] ids = this.getPageCacheIds();
        int page = this.getPageNo();
        int i = 0;
        for (int index = page * 50; i < 50 && index < ids.length; ++i, ++index) {
            idList.add(ids[index]);
        }
        return idList;
    }

    private void setRowValues(DynamicObject row, DynamicObject dblink, DataRow data) {
        row.set(DATABASE_LINK, (Object)dblink);
        row.set(ID, data.getValue("fid"));
        row.set(ENTITY, data.getValue("fentity"));
        row.set(EVENT, data.getValue("fevent"));
        row.set(BOID, data.getValue("fboid"));
        row.set(ISC_HUB, data.getValue("fisc_hub"));
        row.set(TRIGGER_TYPE, data.getValue("ftrigger_type"));
        row.set(TRIGGER_ID, (Object)EventUtils.getTriggerName(data.getValue("ftrigger_id"), D.s((Object)data.getValue("ftrigger_type"))));
        row.set(STATE, data.getValue("fstate"));
        row.set(CREATED_TIME, data.getValue("fcreated_time") == null ? null : D.t((Object)data.getValue("fcreated_time")));
        row.set(MODIFIED_TIME, data.getValue("fmodified_time") == null ? null : D.t((Object)data.getValue("fmodified_time")));
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        if (ENTITY.equals(evt.getFieldName()) && evt.getRowIndex() >= 0) {
            DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
            DynamicObject currentObject = (DynamicObject)entryentity.get(evt.getRowIndex());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("database_link_id", currentObject.getString("database_link_id"));
            params.put(ID, currentObject.getString(ID));
            FormOpener.showForm((AbstractFormPlugin)this, "isc_con_evt_que_detail", null, params, null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String op = e.getOperateKey();
        if (op.equals(OP_REFRESH)) {
            this.refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"EventQueueTreeListPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else if (op.equals(OP_RESET)) {
            this.getPageCache().remove(SEARCH_FIELD);
            this.refresh();
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u6210\u529f\u3002", (String)"EventQueueTreeListPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else if (op.equals(OP_DELETE) || op.equals("retry")) {
            EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] selectRows = grid.getSelectRows();
            if (selectRows.length <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c\u3002", (String)"EventQueueTreeListPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
            } else if (op.equals(OP_DELETE)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("delete_record", (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u786e\u8ba4\u5220\u9664\uff1f", (String)"EventQueueTreeListPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
            } else {
                this.repush(this.getEventList(selectRows));
            }
        } else if (NEXT.equals(op)) {
            this.clickNext();
        } else if (LAST.equals(op)) {
            this.clickLast();
        } else if (FIRST.equals(op)) {
            this.clickFirst();
        } else if (END.equals(op)) {
            this.clickEnd();
        } else if (SEARCH.equals(op)) {
            FormOpener.showForm((AbstractFormPlugin)this, ISC_EVENT_SEARCH_FIELD, "", this.getSearchField(), SEARCH);
        }
    }

    private void refresh() {
        this.setPageCacheNo(0);
        this.setSearchField();
        try {
            this.initIds();
            this.setTotalPage();
            this.initList();
            this.updateEventFailLog();
        }
        catch (Exception e) {
            this.saveEventLogFail(StringUtil.toString((Throwable)e));
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private void updateEventFailLog() {
        if (D.l((Object)this.getPageCache().get(DB_LINK)) > 0L) {
            EventFailTotalUtil.updateEvtLogFail((long)D.l((Object)this.getPageCache().get(DB_LINK)));
        }
    }

    private void saveEventLogFail(String errorMsg) {
        long dblink = D.l((Object)this.getPageCache().get(DB_LINK));
        if (dblink > 0L) {
            String databaseType = EventFailTotalUtil.getDatabaseType((long)dblink);
            EventFailTotalUtil.saveEventLogFail((long)dblink, (String)databaseType, (int)-1, (String)errorMsg);
        }
    }

    private void setTotalPage() {
        String[] ids = this.getPageCacheIds();
        int page = ids.length % 50 == 0 ? ids.length / 50 : ids.length / 50 + 1;
        this.getModel().setValue("total_page", (Object)String.format(ResManager.loadKDString((String)"\u5171%s\u9875", (String)"EventQueueTreeListPlugin_31", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), page));
    }

    private void clickFirst() {
        int pageNo = this.getPageNo();
        if (pageNo > 0) {
            this.setPageCacheNo(0);
            this.initList();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u7b2c\u4e00\u9875\u3002", (String)"EventQueueTreeListPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
        }
    }

    private void clickEnd() {
        int pageNo;
        String[] ids = this.getPageCacheIds();
        if (ids.length <= ((pageNo = this.getPageNo()) + 1) * 50) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u6700\u540e\u4e00\u9875\u3002", (String)"EventQueueTreeListPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
        } else {
            int page = ids.length % 50 == 0 ? ids.length / 50 - 1 : ids.length / 50;
            this.setPageCacheNo(page);
            this.initList();
        }
    }

    private void clickLast() {
        int pageNo = this.getPageNo();
        if (pageNo > 0) {
            int last = pageNo - 1;
            this.setPageCacheNo(last);
            this.initList();
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u7b2c\u4e00\u9875\u3002", (String)"EventQueueTreeListPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
        }
    }

    private void clickNext() {
        int pageNo;
        String[] ids = this.getPageCacheIds();
        if (ids.length <= ((pageNo = this.getPageNo()) + 1) * 50) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u662f\u6700\u540e\u4e00\u9875\u3002", (String)"EventQueueTreeListPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(1000));
        } else {
            int next = pageNo + 1;
            this.setPageCacheNo(next);
            this.initList();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (MessageBoxResult.Yes == evt.getResult() && "delete_record".equals(evt.getCallBackId())) {
            EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
            int[] selectRows = grid.getSelectRows();
            this.deleteSelectedRows(this.getEventList(selectRows));
        }
    }

    private void deleteSelectedRows(List<Object> eventIds) {
        try (ConnectionWrapper cn = this.getConnection(D.l((Object)this.getPageCache().get(DB_LINK)));){
            ArrayList values = new ArrayList();
            ArrayList types = new ArrayList();
            String sql = EventBindingUtil.generateRemoveLogSQL(eventIds, values, types);
            cn.executeUpdate(sql, values, types);
            this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u6210\u529f\u5220\u9664%s\u6761\u6570\u636e!", (String)"EventQueueTreeListPlugin_32", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), eventIds.size()));
            this.refresh();
        }
        catch (Exception ex) {
            throw D.e((Throwable)ex);
        }
    }

    private void repush(List<Object> eventIds) {
        try (ConnectionWrapper cn = this.getConnection(D.l((Object)this.getPageCache().get(DB_LINK)));){
            ConnectionFactory factory = Objects.requireNonNull(cn).getFactory();
            factory.rePushEventData(cn, eventIds);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63a8\u9001\u6210\u529f!", (String)"EventQueueTreeListPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        catch (Exception ex) {
            throw D.e((Throwable)ex);
        }
    }

    private List<Object> getEventList(int[] selectRows) {
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection(ENTRY_ENTITY);
        ArrayList<Object> eventIds = new ArrayList<Object>(selectRows.length);
        for (int selectRow : selectRows) {
            eventIds.add(((DynamicObject)entries.get(selectRow)).getString(ID));
        }
        return eventIds;
    }

    private void setSearchField() {
        Map<String, Object> data = this.getSearchField();
        StringBuilder sb = new StringBuilder();
        if (!StringUtil.isEmpty((String)D.s((Object)data.get(SEARCHENTITY)))) {
            sb.append(ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u7801\uff1a", (String)"EventQueueTreeListPlugin_16", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(D.s((Object)data.get(SEARCHENTITY))).append("\uff1b ");
        }
        if (!StringUtil.isEmpty((String)D.s((Object)data.get(SEARCHBOID)))) {
            sb.append(ResManager.loadKDString((String)"\u5355\u636eid\uff1a", (String)"EventQueueTreeListPlugin_17", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(D.s((Object)data.get(SEARCHBOID))).append("\uff1b ");
        }
        if (D.t((Object)data.get(DATERANGE_STARTTIME)) != null) {
            sb.append(ResManager.loadKDString((String)"\u89e6\u53d1\u8d77\u59cb\u65f6\u95f4\uff1a", (String)"EventQueueTreeListPlugin_18", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(D.t((Object)data.get(DATERANGE_STARTTIME))).append("\uff1b ");
        }
        if (D.t((Object)data.get(DATERANGE_ENDTIME)) != null) {
            sb.append(ResManager.loadKDString((String)"\u89e6\u53d1\u622a\u6b62\u65f6\u95f4\uff1a", (String)"EventQueueTreeListPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(D.t((Object)data.get(DATERANGE_ENDTIME))).append("\uff1b ");
        }
        if (!StringUtil.isEmpty((String)D.s((Object)data.get(SEARCHSTATE)))) {
            sb.append(ResManager.loadKDString((String)"\u72b6\u6001\uff1a", (String)"EventQueueTreeListPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])).append(this.getStateName(D.s((Object)data.get(SEARCHSTATE)))).append("\uff1b ");
        }
        if (D.x((Object)data.get(IS_SORTED_MODIFITIME))) {
            sb.append(ResManager.loadKDString((String)"\u6309\u66f4\u65b0\u65f6\u95f4\u9006\u5e8f", (String)"EventQueueTreeListPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            sb.append(ResManager.loadKDString((String)"\u6309\u89e6\u53d1\u65f6\u95f4\u9006\u5e8f", (String)"EventQueueTreeListPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        this.getModel().setValue(SEARCH_FIELD, (Object)sb.toString());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if (SEARCH.equals(action)) {
            Map returnData = (Map)evt.getReturnData();
            if (returnData == null) {
                return;
            }
            this.getPageCache().put(SEARCH_FIELD, Json.toString((Object)returnData));
            this.refresh();
        }
    }

    private String getStateName(String state) {
        if ("F".equals(state)) {
            return ResManager.loadKDString((String)"\u5931\u8d25", (String)"EventQueueTreeListPlugin_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        if ("C".equals(state)) {
            return ResManager.loadKDString((String)"\u521b\u5efa", (String)"EventQueueTreeListPlugin_24", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        if ("S".equals(state)) {
            return ResManager.loadKDString((String)"\u6210\u529f", (String)"EventQueueTreeListPlugin_25", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        if ("R".equals(state)) {
            return ResManager.loadKDString((String)"\u91cd\u63a8", (String)"EventQueueTreeListPlugin_26", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        if ("I".equals(state)) {
            return ResManager.loadKDString((String)"\u5931\u8d25\uff08\u7a7a\u6570\u636e\uff09", (String)"EventQueueTreeListPlugin_27", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        if ("W".equals(state)) {
            return ResManager.loadKDString((String)"\u7b49\u5f85\u4e2d", (String)"EventQueueTreeListPlugin_28", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        return "";
    }
}

