/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.event;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.util.connector.EventBindingUtil;
import kd.isc.iscb.util.data.ReadLockFreeMap;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class EventUtils {
    private static final Map<String, String> cacheTrigger = new ReadLockFreeMap();

    public static String getTriggerName(Object triggerId, String type) {
        if (triggerId == null || StringUtil.isEmpty((String)triggerId.toString())) {
            return null;
        }
        if (cacheTrigger.containsKey(D.s((Object)triggerId))) {
            return cacheTrigger.get(D.s((Object)triggerId));
        }
        try {
            EventBindingUtil.TriggerType triggerType = EventBindingUtil.TriggerType.get((String)type);
            String name = EventUtils.getName(triggerId, triggerType);
            cacheTrigger.put(triggerId.toString(), name);
            return name;
        }
        catch (Exception e) {
            return String.format(ResManager.loadKDString((String)"%s\uff08\u65b9\u6848\u540d\u79f0\u4e0d\u5b58\u5728\uff09", (String)"EventUtils_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), triggerId.toString());
        }
    }

    private static String getName(Object triggerId, EventBindingUtil.TriggerType triggerType) {
        if (EventBindingUtil.TriggerType.DataCopyTrigger == triggerType) {
            DynamicObject trigger = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"isc_data_copy_trigger", (String)"name");
            return trigger.getString("name");
        }
        if (EventBindingUtil.TriggerType.EntityEventTrigger == triggerType) {
            DynamicObject pub = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"isc_mq_bill_data_pub", (String)"name");
            return pub.getString("name");
        }
        if (EventBindingUtil.TriggerType.ServiceFlowTrigger == triggerType) {
            DynamicObject pub = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"isc_service_flow", (String)"name");
            return pub.getString("name");
        }
        if (EventBindingUtil.TriggerType.APITrigger == triggerType) {
            DynamicObject pub = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"isc_call_api_by_evt", (String)"name");
            return pub.getString("name");
        }
        if (EventBindingUtil.TriggerType.ServiceFlowEventWaiting == triggerType) {
            DynamicObject pub = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"isc_sf_waiting_event", (String)"service_flow,node_title");
            DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)pub.getLong("service_flow_id"), (String)"isc_service_flow", (String)"name");
            return flow.getString("name") + ":" + pub.get("node_title");
        }
        if (EventBindingUtil.TriggerType.DataFlowTrigger == triggerType) {
            DynamicObject dataFlowTrigger = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"iscx_data_flow_trigger", (String)"name");
            return dataFlowTrigger.getString("name");
        }
        if (EventBindingUtil.TriggerType.Event_Mesh == triggerType) {
            DynamicObject eventMesh = BusinessDataServiceHelper.loadSingle((Object)triggerId, (String)"kem_subscribe", (String)"name");
            return eventMesh.getString("name");
        }
        throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u4e0d\u8bc6\u522b\u7684\u7c7b\u578b\uff1a%s", (String)"EventUtils_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), triggerType.name()));
    }

    private static String removeCache(String triggerId) {
        return cacheTrigger.remove(triggerId);
    }
}

