/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.function;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.ExportUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class CustomFunctionListPlugin
extends AbstractTreeListPlugin {
    private static final Log logger = LogFactory.getLog(CustomFunctionListPlugin.class);
    private static final String TOOLBARAP = "toolbarap";
    public static final String CUSTOM_FUNCTION_FORMID = "isc_custom_function";
    public static final String FUNCTION_TEST_FORMID = "isc_function_test";
    public static final String FUNCTION_TEST_ENTITY = "test_entity";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("exportFunction".equalsIgnoreCase(operateKey)) {
            List pkIds = args.getOperationResult().getSuccessPkIds();
            ExportUtil.exportDts((AbstractFormPlugin)this, pkIds, CUSTOM_FUNCTION_FORMID);
        } else if ("exportZip".equalsIgnoreCase(operateKey)) {
            ExportUtil.exportZip((AbstractFormPlugin)this, args, CUSTOM_FUNCTION_FORMID);
        } else if ("importFunction".equalsIgnoreCase(operateKey)) {
            FormOpener.openImportForm((IFormPlugin)this, this.getView(), CUSTOM_FUNCTION_FORMID);
        } else if ("bar_new".equalsIgnoreCase(operateKey)) {
            this.newCustomFunction();
        } else if ("bar_test".equalsIgnoreCase(operateKey)) {
            this.functionTest();
        }
    }

    private void newCustomFunction() {
        TreeView tree = (TreeView)this.getView().getControl("treeview");
        TreeView.TreeState treeState = tree.getTreeState();
        Map focusNode = treeState.getFocusNode();
        logger.info("CustomFunctionListPlugin\uff0cfocusNode\u53c2\u6570\u4e3a\uff1a" + focusNode);
        if (focusNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u6811\u975e\u6839\u8282\u70b9\u7c7b\u522b\u6570\u636e\u3002", (String)"CustomFunctionListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        if (StringUtil.isEmpty((String)D.s(focusNode.get("parentid")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de6\u6811\u975e\u6839\u8282\u70b9\u7c7b\u522b\u6570\u636e\u3002", (String)"CustomFunctionListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().invokeOperation("new", OperateOption.create());
        }
    }

    private void functionTest() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c", (String)"CustomFunctionListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        if (selectedRows.size() > 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e91\u884c\u8bb0\u5f55", (String)"CustomFunctionListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        ListSelectedRow row = selectedRows.get(0);
        QFilter qFilter = new QFilter("id", "=", row.getPrimaryKeyValue());
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)CUSTOM_FUNCTION_FORMID, (String)"name,number,remark,script_jst_tag,function_entries.function_name,function_entries.function_title,function_entries.function_type,result_entries.result_name,result_entries.result_title,result_entries.result_type", (QFilter[])new QFilter[]{qFilter});
        String name = dynamicObject.getString("name");
        String number = dynamicObject.getString("number");
        String remark = dynamicObject.getString("remark");
        String script_jst = dynamicObject.getString("script_jst_tag");
        DynamicObjectCollection function_entries = dynamicObject.getDynamicObjectCollection("function_entries");
        DynamicObjectCollection result_entries = dynamicObject.getDynamicObjectCollection("result_entries");
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        params.put("name", name);
        params.put("number", number);
        params.put("remark", remark);
        params.put("script", script_jst);
        params.put("function_entries", this.getFunctionEntry(function_entries));
        params.put("result_entries", this.getResultEntry(result_entries));
        FormOpener.showForm((AbstractFormPlugin)this, FUNCTION_TEST_FORMID, ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u51fd\u6570\u6d4b\u8bd5", (String)"CustomFunctionListPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, null);
    }

    private Map<String, Object> getResultEntry(DynamicObjectCollection result_entries) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(result_entries.size());
        for (DynamicObject dy : result_entries) {
            resultMap.put(dy.getString("result_name"), dy.getString("result_type"));
        }
        return resultMap;
    }

    private List<List<Object>> getFunctionEntry(DynamicObjectCollection function_entries) {
        ArrayList<List<Object>> entry = new ArrayList<List<Object>>(function_entries.size());
        ArrayList<String> row = null;
        for (DynamicObject dy : function_entries) {
            row = new ArrayList<String>(3);
            row.add(dy.getString("function_name"));
            row.add(dy.getString("function_title"));
            row.add(dy.getString("function_type"));
            entry.add(row);
        }
        return entry;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Object selectedId = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
        FormOpener.showTabView((AbstractFormPlugin)this, CUSTOM_FUNCTION_FORMID, selectedId);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"iscExportTaskCloseCallBack")) {
            ExportUtil.iscExportTaskCallBack((AbstractFormPlugin)this, evt.getReturnData());
        }
    }
}

