/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.function;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.util.StringUtils;
import kd.isc.iscb.platform.core.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.fn.ext.Functions;
import kd.isc.iscb.platform.core.util.CustomFunctionApplier;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;

public class CustomFunctionTestFormPlugin
extends AbstractFormPlugin {
    private static final String RESULT = "result";
    private static final String SCRIPT = "script";
    private static final String RESULT_ENTRIES = "result_entries";
    private static final String NUMBER = "number";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (!ObjectUtils.isEmpty((Object)params)) {
            this.updateFunctionEntity(params);
            this.getModel().setValue(NUMBER, params.get(NUMBER));
            this.getModel().setValue("name", params.get("name"));
            this.getModel().setValue("remark", params.get("remark"));
            this.getPageCache().put(RESULT_ENTRIES, String.valueOf(params.get(RESULT_ENTRIES)));
            this.getPageCache().put(SCRIPT, String.valueOf(params.get(SCRIPT)));
        }
    }

    private void updateFunctionEntity(Map<String, Object> params) {
        List function_entries = (List)params.get("function_entries");
        if (null == function_entries) {
            return;
        }
        this.setTestEntry(function_entries);
        this.getView().updateView("test_entity");
    }

    private void setTestEntry(List<List<Object>> function_entries) {
        IDataModel dataModel = this.getModel();
        AbstractFormDataModel model = (AbstractFormDataModel)dataModel;
        model.beginInit();
        TableValueSetter vs = new TableValueSetter(new String[0]);
        vs.addField("param_name", new Object[0]);
        vs.addField("param_title", new Object[0]);
        vs.addField("param_type", new Object[0]);
        for (List<Object> list : function_entries) {
            vs.addRow(new Object[]{list.get(0), list.get(1), list.get(2)});
        }
        model.deleteEntryData("test_entity");
        model.batchCreateNewEntryRow("test_entity", vs);
        model.endInit();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("run".equals(args.getOperateKey()) && this.checkParams()) {
            try {
                this.run();
            }
            catch (Throwable e) {
                this.getModel().setValue(RESULT, (Object)ShowStackTraceUtil.getErrorMsg((Throwable)e));
            }
        }
    }

    private void run() {
        String script = this.getPageCache().get(SCRIPT);
        if (null == script) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u811a\u672c\u4e3a\u7a7a\uff01", (String)"CustomFunctionTestFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        Map<String, Object> params = this.getScriptParams();
        Script.compile((String)script).eval(params);
        Map resultEntries = (Map)JSON.parseObject((String)this.getPageCache().get(RESULT_ENTRIES), (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
        if (ObjectUtils.isEmpty((Object)resultEntries)) {
            this.getModel().setValue(RESULT, (Object)"NULL");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff01", (String)"CustomFunctionTestFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(resultEntries.size());
        for (Map.Entry result : resultEntries.entrySet()) {
            String name = (String)result.getKey();
            Object type = result.getValue();
            Object value = params.get(name);
            if (null == value) continue;
            map.put(name, CustomFunctionApplier.transDataType(type, (Object)value));
        }
        String s = JSON.toJSONString((Object)(map.size() < 1 ? "NULL" : map), (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
        this.getModel().setValue(RESULT, (Object)StringUtil.trim((String)s, (int)300));
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f\uff01", (String)"CustomFunctionTestFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    private Map<String, Object> getScriptParams() {
        DynamicObjectCollection test_entity = (DynamicObjectCollection)this.getModel().getValue("test_entity");
        HashMap<String, Object> params = new HashMap<String, Object>(test_entity.size());
        for (DynamicObject dy : test_entity) {
            String param_name = dy.getString("param_name");
            String param_type = dy.getString("param_type");
            String param_value = dy.getString("param_value");
            Object value = CustomFunctionApplier.transDataType((Object)param_type, (Object)param_value);
            params.put(param_name, value);
        }
        return params;
    }

    private boolean checkParams() {
        DynamicObjectCollection test_entity = (DynamicObjectCollection)this.getModel().getValue("test_entity");
        for (DynamicObject dy : test_entity) {
            String param_value = dy.getString("param_value");
            if (!StringUtils.isEmpty((String)param_value)) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u53c2\u6570\u503c\uff01", (String)"CustomFunctionTestFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        Object number = this.getModel().getValue(NUMBER);
        Object name = this.getModel().getValue("name");
        if (ObjectUtils.isEmpty((Object)number) || ObjectUtils.isEmpty((Object)name)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u57fa\u672c\u4fe1\u606f\uff01", (String)"CustomFunctionTestFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    static {
        Functions.init();
    }
}

