/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.home.newpage;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.url.UrlService;
import kd.isc.iscb.platform.core.solution.PublicResourceUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.NetUtil;

public class CardFeatureFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener {
    private static Log logger = LogFactory.getLog(CardFeatureFormPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            this.showFeatureCard(1);
        }
        catch (Throwable t) {
            logger.warn("\u9996\u9875\u65b0\u589e\u7279\u6027\u5361\u7247\uff0c\u67e5\u8be2\u6570\u636e\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a", t);
        }
        String url = UrlService.getDomainContextUrl().replace("localhost", NetUtil.getLocalAddress()) + "/kingdee/isc/iscb_static/home/feature-icon.png";
        Image logo = (Image)this.getControl("logo");
        logo.setUrl(url);
    }

    private void showFeatureCard(int pageNo) {
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        entryentity.clear();
        List<Map<String, Object>> featureList = this.queryFeature(pageNo);
        HashMap cache = new HashMap(featureList.size());
        for (Map<String, Object> feature : featureList) {
            DynamicObject card = entryentity.addNew();
            card.set("build_title", feature.get("build_title"));
            card.set("buildid", feature.get("id"));
            List patchentry = (List)feature.get("patchentry");
            HashMap<String, String> subCache = new HashMap<String, String>(patchentry.size());
            for (int i = 0; i < patchentry.size(); ++i) {
                String desc = D.s(((Map)patchentry.get(i)).get("desc"));
                card.set("patch" + i, (Object)desc);
                subCache.put("patch" + i, D.s(((Map)patchentry.get(i)).get("url")));
                if (subCache.size() > 20) break;
            }
            cache.put(D.s((Object)feature.get("id")), subCache);
        }
        this.getView().updateView("entryentity");
        this.getView().getPageCache().put("url_cache", Json.toString(cache));
    }

    private List<Map<String, Object>> queryFeature(int pageNo) {
        int pageSize = 4;
        HashMap<String, Integer> param = new HashMap<String, Integer>();
        param.put("pageNo", pageNo);
        param.put("pageSize", 4);
        Map data = PublicResourceUtil.queryDataByGet((String)"kapi/v2/kdec/kdec_eip_resource/kdec_isc_new_feature/query_isc_new_feature", param);
        this.getView().getPageCache().put("page_data", Json.toString((Object)data));
        Label label = (Label)this.getControl("total_count");
        label.setText(D.s((Object)this.getTotalPage(D.i(data.get("totalCount")), 4)));
        return (List)data.get("rows");
    }

    private int getTotalPage(int totalCount, int pageSize) {
        if (totalCount % pageSize == 0) {
            return totalCount / pageSize;
        }
        return totalCount / pageSize + 1;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        CardEntry entryGrid = (CardEntry)this.getControl("entryentity");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addClickListeners(new String[]{"pre_page", "next_page"});
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if ("view_all".equals(fieldName)) {
            this.getView().openUrl("https://developer.kingdee.com/article/146134");
            return;
        }
        int rowIndex = evt.getRowIndex();
        Map cache = (Map)Json.toObject((String)this.getView().getPageCache().get("url_cache"));
        DynamicObjectCollection entryentity = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        DynamicObject card = (DynamicObject)entryentity.get(rowIndex);
        Map subCache = (Map)cache.get(card.getString("buildid"));
        String url = (String)subCache.get(fieldName);
        this.getView().openUrl(url);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        if ("pre_page".equals(c.getKey())) {
            int currPage = D.i((Object)this.getModel().getValue("page_no"));
            if (currPage > 1) {
                --currPage;
            }
            this.getModel().setValue("page_no", (Object)currPage);
        } else if ("next_page".equals(c.getKey())) {
            Map data = (Map)Json.toObject((String)this.getView().getPageCache().get("page_data"));
            int currPage = D.i((Object)this.getModel().getValue("page_no"));
            if (!D.x(data.get("lastPage"))) {
                ++currPage;
            }
            this.getModel().setValue("page_no", (Object)currPage);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("page_no".equals(e.getProperty().getName())) {
            int newPage = D.i((Object)e.getChangeSet()[0].getNewValue());
            if (newPage <= 0) {
                this.getModel().setValue("page_no", (Object)1);
            } else {
                Map data = (Map)Json.toObject((String)this.getView().getPageCache().get("page_data"));
                int totalPage = this.getTotalPage(D.i(data.get("totalCount")), D.i(data.get("pageSize")));
                if (newPage > totalPage) {
                    this.getModel().setValue("page_no", (Object)totalPage);
                } else {
                    this.showFeatureCard(newPage);
                }
            }
        }
    }
}

