/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.home.newpage;

import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.container.Container;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.log.EventFailTotalUtil;
import kd.isc.iscb.platform.core.util.TimeUtil;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class FocusViewCardFormPlugin
extends AbstractFormPlugin
implements TabSelectListener {
    private static final String START_TIME = "start_time";
    private static final String END_TIME = "end_time";
    private static final String TABAP = "tabap";
    private static final String SUC_LOG = "suc_log";
    private static final String ERR_LOG = "err_log";
    private static final String RUNNING_TASK = "running_task";
    private static final String EXEC_SELECT = "exec_select";
    private static final String DC_LOG = "dc_log";
    private static final String EVENT_LOG = "event_log";
    private static final String API_LOG = "api_log";
    private static final String MSG_LOG = "msg_log";
    private static final String FLOW_LOG = "flow_inst";
    private static final String DC_SU = "dc_su";
    private static final String API_SU = "api_su";
    private static final String MSG_SU = "msg_su";
    private static final String FLOW_SU = "flow_su";
    private static final String DC_RUN = "dc_run";
    private static final String API_RUNLOG = "api_runlog";
    private static final String FLOW_INSTRUN = "flow_instrun";
    private static final String DATE_LIST = "date_list";
    private static final String VECTORAP = "vectorap11";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl(TABAP);
        tab.addTabSelectListener((TabSelectListener)this);
        Container container = (Container)this.getView().getControl(DC_LOG);
        container.addClickListener((ClickListener)this);
        Container container1 = (Container)this.getView().getControl(EVENT_LOG);
        container1.addClickListener((ClickListener)this);
        Container container2 = (Container)this.getView().getControl(API_LOG);
        container2.addClickListener((ClickListener)this);
        Container container3 = (Container)this.getView().getControl(MSG_LOG);
        container3.addClickListener((ClickListener)this);
        Container container4 = (Container)this.getView().getControl(FLOW_LOG);
        container4.addClickListener((ClickListener)this);
        Container container5 = (Container)this.getView().getControl(DC_SU);
        container5.addClickListener((ClickListener)this);
        Container container6 = (Container)this.getView().getControl(API_SU);
        container6.addClickListener((ClickListener)this);
        Container container7 = (Container)this.getView().getControl(MSG_SU);
        container7.addClickListener((ClickListener)this);
        Container container8 = (Container)this.getView().getControl(FLOW_SU);
        container8.addClickListener((ClickListener)this);
        Container container9 = (Container)this.getView().getControl(DC_RUN);
        container9.addClickListener((ClickListener)this);
        Container container10 = (Container)this.getView().getControl(API_RUNLOG);
        container10.addClickListener((ClickListener)this);
        Container container11 = (Container)this.getView().getControl(FLOW_INSTRUN);
        container11.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{START_TIME, END_TIME, EXEC_SELECT, VECTORAP});
    }

    public void beforeBindData(EventObject e) {
        Date start_time = (Date)this.getModel().getValue(START_TIME);
        Date end_time = (Date)this.getModel().getValue(END_TIME);
        this.summaryView(start_time, end_time);
        this.refreshTimeLabel();
    }

    public void afterCreateNewData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setValue(START_TIME, (Object)this.getStartTime(36));
        this.getModel().setValue(END_TIME, (Object)this.getEndTime());
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        String type = this.getPageCache().get("type");
        String datetype = this.getPageCache().get("datetype");
        String state = "F";
        Date start_time = this.getStartTime(datetype == null ? 36 : this.convertTypeToHour(D.i((Object)datetype)));
        Date end_time = this.getEndTime();
        state = this.getState(type, state, SUC_LOG, "S", ERR_LOG, "F", RUNNING_TASK, "R");
        if (key.startsWith("dc")) {
            QFilter filter = new QFilter("state", "=", (Object)state);
            if ("R".equals(state)) {
                filter.and(new QFilter("modifytime", ">=", (Object)start_time));
                filter.and(new QFilter("modifytime", "<", (Object)end_time));
            } else {
                filter.and(new QFilter("created_time", ">=", (Object)start_time));
                filter.and(new QFilter("created_time", "<", (Object)end_time));
            }
            FormOpener.openBillListAddAppId(this, "R".equals(state) ? "isc_data_copy_execution" : "isc_data_copy_exec_log", "R".equals(state) ? this.getCaption(state, ResManager.loadKDString((String)"\u6267\u884c\u7ed3\u679c", (String)"FocusViewCardFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])) : this.getCaption(state, ResManager.loadKDString((String)"\u6267\u884c\u65e5\u5fd7", (String)"FocusViewCardFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), Collections.singletonList(filter));
        } else if (key.startsWith("event")) {
            Map maxFailedMap = EventFailTotalUtil.getMaxFailedDblink((String)this.getDateType(datetype));
            HashMap<String, Object> params = new HashMap<String, Object>(3);
            params.put("state", state);
            params.put(START_TIME, start_time);
            params.put(END_TIME, end_time);
            params.put("dblink", maxFailedMap.get("dblink"));
            params.put("name", maxFailedMap.get("dbname"));
            FormOpener.showAppIdTabFormWithAppId(this, "isc_con_evt_que", ResManager.loadKDString((String)"\u5931\u8d25\u7684\u4e8b\u4ef6\u89e6\u53d1\u65e5\u5fd7", (String)"FocusViewCardFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), params, "iscb");
        } else if (key.startsWith("api")) {
            QFilter filter = this.getqFilter(state, start_time, end_time, START_TIME);
            FormOpener.openBillListAddAppId(this, "isc_apic_log", this.getCaption(state, ResManager.loadKDString((String)"\u96c6\u6210API\u65e5\u5fd7", (String)"FocusViewCardFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), Collections.singletonList(filter));
        } else if (key.startsWith("msg")) {
            QFilter filter = this.getqFilter(state, start_time, end_time, "created_time");
            FormOpener.openBillListAddAppId(this, "isc_mq_bill_data_task", this.getCaption(state, ResManager.loadKDString((String)"\u5355\u636e\u6d88\u606f\u4efb\u52a1\u76d1\u63a7", (String)"FocusViewCardFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), Collections.singletonList(filter));
        } else if (key.startsWith("flow")) {
            state = "S".equals(state) ? "Complete" : ("F".equalsIgnoreCase(state) ? "Failed" : "Running");
            QFilter filter = this.getqFilter(state, start_time, end_time, "created_time");
            FormOpener.openBillListAddAppId(this, "isc_sf_proc_inst", this.getCaption(state, ResManager.loadKDString((String)"\u6d41\u7a0b\u5b9e\u4f8b", (String)"FocusViewCardFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), Collections.singletonList(filter));
        } else if (VECTORAP.equals(key)) {
            this.setCountByHour(type == null ? ERR_LOG : type, datetype == null ? 36 : this.convertTypeToHour(D.i((Object)datetype)));
        }
    }

    private String getDateDesc() {
        if (this.getPageCache().get("datetype") == null) {
            return ResManager.loadKDString((String)"\u8fd136\u5c0f\u65f6", (String)"FocusViewCardFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        switch (D.i((Object)this.getPageCache().get("datetype"))) {
            case 1: {
                return ResManager.loadKDString((String)"\u8fd136\u5c0f\u65f6", (String)"FocusViewCardFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            }
            case 7: {
                return ResManager.loadKDString((String)"\u8fd17\u5929", (String)"FocusViewCardFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            }
            case 30: {
                return ResManager.loadKDString((String)"\u8fd130\u5929", (String)"FocusViewCardFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private String getCaption(String state, String entityName) {
        state = this.getState(state);
        return String.format(ResManager.loadKDString((String)"%1$s%2$s\u7684%3$s", (String)"FocusViewCardFormPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.getDateDesc(), state, entityName);
    }

    private String getState(String state) {
        if ("Complete".equals(state)) {
            return ResManager.loadKDString((String)"\u5df2\u7ed3\u675f", (String)"FocusViewCardFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        if ("Failed".equals(state)) {
            return ResManager.loadKDString((String)"\u5df2\u5931\u8d25", (String)"FocusViewCardFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        if ("Running".equals(state) || "R".equals(state)) {
            return ResManager.loadKDString((String)"\u6267\u884c\u4e2d", (String)"FocusViewCardFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        if ("S".equals(state)) {
            return ResManager.loadKDString((String)"\u6210\u529f", (String)"FocusViewCardFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        if ("F".equals(state)) {
            return ResManager.loadKDString((String)"\u5931\u8d25", (String)"FocusViewCardFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        return "";
    }

    private String getState(String type, String state, String sucLog, String s, String errLog, String f, String runningTask, String r) {
        if (sucLog.equals(type)) {
            state = s;
        } else if (errLog.equals(type)) {
            state = f;
        } else if (runningTask.equals(type)) {
            state = r;
        }
        return state;
    }

    private QFilter getqFilter(String state, Date start_time, Date end_time, String created_time) {
        QFilter filter = new QFilter("state", "=", (Object)state);
        filter.and(new QFilter(created_time, ">=", (Object)start_time));
        filter.and(new QFilter(created_time, "<", (Object)end_time));
        return filter;
    }

    private Date getEndTime() {
        return new Date();
    }

    private Date getStartTime(int hour) {
        long mills = System.currentTimeMillis() / 1000L - (long)(hour * 60 * 60);
        return new Date(mills * 1000L);
    }

    public static Date getTodayEndTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (DATE_LIST.equals(name)) {
            this.changeCount(e);
        }
    }

    private void changeCount(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null) {
            String newValue = D.s((Object)changeSet[0].getNewValue());
            String dateType = this.getPageCache().get("type");
            String type = dateType == null ? ERR_LOG : dateType;
            switch (newValue) {
                case "today": {
                    this.getPageCache().put("datetype", "1");
                    this.setCountByHour(type, 36);
                    break;
                }
                case "seven": {
                    this.getPageCache().put("datetype", "7");
                    this.setCountByHour(type, 168);
                    break;
                }
                case "thirty": {
                    this.getPageCache().put("datetype", "30");
                    this.setCountByHour(type, 720);
                    break;
                }
                case "ninety": {
                    this.getPageCache().put("datetype", "90");
                    this.setCountByHour(type, 2160);
                    break;
                }
                case "year": {
                    this.getPageCache().put("datetype", "365");
                    this.setCountByHour(type, 8760);
                    break;
                }
                case "all": {
                    this.getPageCache().put("datetype", "18250");
                    this.setCountByHour(type, 18250);
                    break;
                }
                default: {
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u65e5\u671fdate_list:%s\uff0c\u8bf7\u9009\u62e9today,seven,thirty,ninety,year,all\u8fd9\u4e9b\u7c7b\u578b", (String)"FocusViewCardFormPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), newValue));
                }
            }
        }
    }

    private void summaryView(Date start_time, Date end_time) {
        ArrayList<Object> valuesDay = new ArrayList<Object>(3);
        ArrayList<Integer> typesDay = new ArrayList<Integer>(3);
        typesDay.add(93);
        typesDay.add(93);
        Timestamp tod = D.t((Object)start_time);
        Timestamp next = D.t((Object)end_time);
        valuesDay.add(tod);
        valuesDay.add(next);
        typesDay.add(12);
        valuesDay.add("F");
        this.showErrorLog(valuesDay, typesDay);
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String subTabKey = tabSelectEvent.getTabKey();
        String datetype = this.getPageCache().get("datetype");
        this.setCountByHour(subTabKey, datetype == null ? 36 : this.convertTypeToHour(D.i((Object)datetype)));
    }

    private void setCountByHour(String subTabKey, int hour) {
        Date start_time = this.getStartTime(hour);
        Date end_time = this.getEndTime();
        ArrayList<Object> valuesDay = new ArrayList<Object>(3);
        ArrayList<Integer> typesDay = new ArrayList<Integer>(3);
        typesDay.add(93);
        typesDay.add(93);
        Timestamp tod = D.t((Object)start_time);
        Timestamp next = D.t((Object)end_time);
        valuesDay.add(tod);
        valuesDay.add(next);
        switch (subTabKey) {
            case "suc_log": {
                this.getPageCache().put("type", SUC_LOG);
                typesDay.add(12);
                valuesDay.add("S");
                this.showSuccessLog(valuesDay, typesDay);
                break;
            }
            case "err_log": {
                this.getPageCache().put("type", ERR_LOG);
                typesDay.add(12);
                valuesDay.add("F");
                this.showErrorLog(valuesDay, typesDay);
                break;
            }
            case "running_task": {
                this.getPageCache().put("type", RUNNING_TASK);
                typesDay.add(12);
                valuesDay.add("R");
                this.showRunningTask(valuesDay, typesDay);
                break;
            }
            default: {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u7684\u65e5\u5fd7\u7c7b\u578b:%s", (String)"FocusViewCardFormPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), subTabKey));
            }
        }
        this.refreshTimeLabel();
    }

    private void refreshTimeLabel() {
        Label label = (Label)this.getView().getControl("refreshtimelabel");
        if (label != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            label.setText(TimeUtil.getInteTime((Date)new Date(), (SimpleDateFormat)sdf));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showErrorLog(List<Object> valuesDay, List<Integer> typesDay) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            long exec_count = this.getExecutionLog(cn, valuesDay, typesDay);
            long event_count = this.getEventLog(cn, valuesDay);
            long api_count = this.getApiLog(cn, valuesDay, typesDay);
            long mq_count = this.getMqLog(cn, valuesDay, typesDay);
            long flow_count = this.getFlowInstLog(cn, valuesDay, typesDay);
            this.getModel().setValue("exec_failed", (Object)exec_count);
            this.getModel().setValue("event_failed", (Object)event_count);
            this.getModel().setValue("api_failed", (Object)api_count);
            this.getModel().setValue("mq_failed", (Object)mq_count);
            this.getModel().setValue("flow_failed", (Object)flow_count);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showSuccessLog(List<Object> valuesDay, List<Integer> typesDay) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            long exec_count = this.getExecutionLog(cn, valuesDay, typesDay);
            long api_count = this.getApiLog(cn, valuesDay, typesDay);
            long mq_count = this.getMqLog(cn, valuesDay, typesDay);
            long flow_count = this.getFlowInstLog(cn, valuesDay, typesDay);
            this.getModel().setValue("exec_suc", (Object)exec_count);
            this.getModel().setValue("api_suc", (Object)api_count);
            this.getModel().setValue("mq_suc", (Object)mq_count);
            this.getModel().setValue("flow_suc", (Object)flow_count);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showRunningTask(List<Object> valuesDay, List<Integer> typesDay) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            long exec_count = this.getExecutionTask(cn, valuesDay, typesDay);
            long api_count = this.getApiLog(cn, valuesDay, typesDay);
            long flow_count = this.getFlowInstLog(cn, valuesDay, typesDay);
            this.getModel().setValue("exec_run", (Object)exec_count);
            this.getModel().setValue("api_run", (Object)api_count);
            this.getModel().setValue("flow_run", (Object)flow_count);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private long getFlowInstLog(Connection cn, List<Object> valuesDay, List<Integer> typesDay) {
        String type = D.s((Object)valuesDay.remove(2));
        type = this.getState(type, type, "F", "Failed", "S", "Complete", "R", "Running");
        valuesDay.add(type);
        String sql = "select  count(*) from t_isc_sf_proc_inst  where  fcreated_time >= ? and fcreated_time < ? and fstate = ? ;";
        return DbUtil.executeCount((Connection)cn, (String)sql, valuesDay, typesDay);
    }

    private long getExecutionTask(Connection cn, List<Object> valuesDay, List<Integer> typesDay) {
        String sql = "select count(*) count from t_isc_data_copy_execution where fstart_time >= ? and fstart_time < ? and FSTATE=?;";
        return DbUtil.executeCount((Connection)cn, (String)sql, valuesDay, typesDay);
    }

    private long getMqLog(Connection cn, List<Object> valuesDay, List<Integer> typesDay) {
        String sql = "select count(*) count from t_iscb_biz_execution where fcreated_time >= ? and fcreated_time < ? and FSTATE = ? ;";
        return DbUtil.executeCount((Connection)cn, (String)sql, valuesDay, typesDay);
    }

    private long getApiLog(Connection cn, List<Object> valuesDay, List<Integer> typesDay) {
        String sql = "select count(*)  from t_iscb_apic_log where  FSTART_TIME >= ? and FSTART_TIME < ? and FSTATE = ? ;";
        return DbUtil.executeCount((Connection)cn, (String)sql, valuesDay, typesDay);
    }

    private long getExecutionLog(Connection cn, List<Object> valuesDay, List<Integer> typesDay) {
        String sql = "select count(*) from t_isc_data_copy_exec_log where fcreated_time >= ? and fcreated_time <= ? and FSTATE = ?";
        return DbUtil.executeCount((Connection)cn, (String)sql, valuesDay, typesDay);
    }

    private long getEventLog(Connection cn, List<Object> valuesDay) {
        return EventFailTotalUtil.getAllEventFailLogTotal((Connection)cn, (Integer)this.getDateRange(valuesDay));
    }

    private Integer getDateRange(List<Object> valuesDay) {
        Calendar beginDate = Calendar.getInstance();
        beginDate.setTime(D.t((Object)valuesDay.get(0)));
        Calendar endDate = Calendar.getInstance();
        endDate.setTime(D.t((Object)valuesDay.get(1)));
        return Math.abs(endDate.get(6) - beginDate.get(6)) <= 3 ? 1 : 7;
    }

    private String getDateType(String dateType) {
        if (D.i((Object)dateType) >= 7) {
            return "7";
        }
        return "1";
    }

    private int convertTypeToHour(int type) {
        switch (type) {
            case 1: {
                return 36;
            }
            case 7: {
                return 168;
            }
            case 30: {
                return 720;
            }
            case 18250: {
                return 18250;
            }
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684type:%s\u8f6c\u6362\uff0c\u8bf7\u4f20\u51651,7,30,18250\u8fdb\u884c\u8f6c\u6362", (String)"FocusViewCardFormPlugin_23", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), type));
    }
}

