/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.home.newpage;

import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.Tips;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.Vector;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.license.n.TenantInfo;
import kd.isc.iscb.platform.core.util.TimeUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class LicenseNumCardFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"refreshview", "view_license"});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("refreshview".equals(key)) {
            this.showLicenseCardViews();
            this.refreshTimeLabel();
        } else if ("view_license".equals(key)) {
            HashMap params = new HashMap();
            FormShowParameter p = new FormShowParameter();
            p.setFormId("isc_license_info");
            p.setAppId("iscb");
            p.setCaption(ResManager.loadKDString((String)"\u8bb8\u53ef\u4fe1\u606f", (String)"LicenseNumCardFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            p.setCustomParams(params);
            p.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(p);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showLicenseCardViews() {
        TenantInfo tenantLicenseInfo = IscLicenseUtil.getTenantLicenseInfo();
        Label used_count_label = (Label)this.getView().getControl("used_count_label");
        int used_count = tenantLicenseInfo.getUsedLicenseCount();
        used_count_label.setText(D.s((Object)used_count));
        int total_count = tenantLicenseInfo.getTotalLicenseCount();
        Label total_count_label = (Label)this.getView().getControl("total_count_label");
        total_count_label.setText(D.s((Object)total_count));
        Label expired_date_label = (Label)this.getView().getControl("expired_date_label");
        expired_date_label.setText(D.s((Object)tenantLicenseInfo.getExpiredDate()));
        this.getView().setVisible(Boolean.FALSE, new String[]{"progressbarap_red", "no_license_pane", "progressbarap"});
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        ProgressBar bar_red = (ProgressBar)this.getView().getControl("progressbarap_red");
        if (total_count != 0) {
            int s = D.i((Object)((double)used_count * 1.0 / (double)total_count * 100.0));
            bar.setPercent(s);
            bar_red.setPercent(s);
        } else {
            bar.setPercent(0);
            this.getView().setVisible(Boolean.TRUE, new String[]{"progressbarap"});
        }
        Connection cn = TX.__getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            String sql = "select  count(*) as num  from t_isc_database_link where flicense_info='no';";
            DataRow dataRows = DbUtil.executeRow((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
            int no_license_count = D.i((Object)dataRows.get((Object)"num"));
            if (no_license_count > 0) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"no_license_pane"});
                if (used_count >= total_count && total_count != 0) {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"progressbarap_red"});
                } else {
                    this.getView().setVisible(Boolean.TRUE, new String[]{"progressbarap"});
                }
                Label label = (Label)this.getView().getControl("no_license_count");
                label.setText(D.s((Object)no_license_count));
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"progressbarap"});
            }
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private void refreshTimeLabel() {
        Vector label = (Vector)this.getView().getControl("refreshtimelabel");
        Tips tips = new Tips();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        tips.setContent(new LocaleString(TimeUtil.getInteTime((Date)new Date(), (SimpleDateFormat)sdf)));
        tips.setType("text");
        tips.setShowIcon(false);
        label.addTips(tips);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.showLicenseCardViews();
        this.refreshTimeLabel();
    }
}

