/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.home.newpage;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.util.TimeUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;

public class SuccessRateCardFormPlugin
extends AbstractFormPlugin {
    private static final String START_TIME = "start_time";
    private static final String END_TIME = "end_time";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"refreshview"});
        Container dc_success_pane = (Container)this.getView().getControl("dc_success_pane");
        dc_success_pane.addClickListener((ClickListener)this);
        Container dc_err_pane = (Container)this.getView().getControl("dc_err_pane");
        dc_err_pane.addClickListener((ClickListener)this);
        Container flow_success_pane = (Container)this.getView().getControl("flow_success_pane");
        flow_success_pane.addClickListener((ClickListener)this);
        Container flow_err_pane = (Container)this.getView().getControl("flow_err_pane");
        flow_err_pane.addClickListener((ClickListener)this);
        Container api_success_pane = (Container)this.getView().getControl("api_success_pane");
        api_success_pane.addClickListener((ClickListener)this);
        Container api_err_pane = (Container)this.getView().getControl("api_err_pane");
        api_err_pane.addClickListener((ClickListener)this);
        Container mq_success_pane = (Container)this.getView().getControl("mq_success_pane");
        mq_success_pane.addClickListener((ClickListener)this);
        Container mq_err_pane = (Container)this.getView().getControl("mq_err_pane");
        mq_err_pane.addClickListener((ClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.beforeBindData(e);
        this.getModel().setValue(START_TIME, (Object)this.getStartTime(36));
        this.getModel().setValue(END_TIME, (Object)this.getEndTime());
    }

    private Date getEndTime() {
        return new Date();
    }

    private Date getStartTime(int hour) {
        long mills = System.currentTimeMillis() / 1000L - (long)(hour * 60 * 60);
        return new Date(mills * 1000L);
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        String datetype = this.getPageCache().get("datetype");
        Date start_time = this.getStartTime(datetype == null ? 36 : this.convertTypeToHour(D.i((Object)datetype)));
        Date end_time = this.getEndTime();
        if ("refreshview".equals(key)) {
            this.showViews(start_time, end_time);
            this.refreshTimeLabel();
        } else if ("dc_success_pane".equals(key)) {
            QFilter filter = new QFilter("state", "in", Arrays.asList("S", "P"));
            this.addTimeFilter(start_time, end_time, filter, "modifytime");
            FormOpener.openBillListAddAppId(this, "isc_data_copy_execution", this.getCaption(ResManager.loadKDString((String)"\u5b8c\u6210/\u90e8\u5206\u6210\u529f\u7684\u6267\u884c\u7ed3\u679c", (String)"SuccessRateCardFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), Collections.singletonList(filter));
        } else if ("dc_err_pane".equals(key)) {
            QFilter filter = new QFilter("state", "=", (Object)"F");
            this.addTimeFilter(start_time, end_time, filter, "modifytime");
            FormOpener.openBillListAddAppId(this, "isc_data_copy_execution", this.getCaption(ResManager.loadKDString((String)"\u5df2\u5931\u8d25\u7684\u6267\u884c\u7ed3\u679c", (String)"SuccessRateCardFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), Collections.singletonList(filter));
        } else if ("flow_success_pane".equals(key)) {
            QFilter filter = new QFilter("state", "=", (Object)"Complete");
            this.addTimeFilter(start_time, end_time, filter, "created_time");
            FormOpener.openBillListAddAppId(this, "isc_sf_proc_inst", this.getCaption(ResManager.loadKDString((String)"\u5df2\u7ed3\u675f\u7684\u6d41\u7a0b\u5b9e\u4f8b", (String)"SuccessRateCardFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), Collections.singletonList(filter));
        } else if ("flow_err_pane".equals(key)) {
            QFilter filter = new QFilter("state", "=", (Object)"Failed");
            this.addTimeFilter(start_time, end_time, filter, "created_time");
            FormOpener.openBillListAddAppId(this, "isc_sf_proc_inst", this.getCaption(ResManager.loadKDString((String)"\u5df2\u5931\u8d25\u7684\u6d41\u7a0b\u5b9e\u4f8b", (String)"SuccessRateCardFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), Collections.singletonList(filter));
        } else if ("api_success_pane".equals(key) || "api_err_pane".equals(key)) {
            FormOpener.openBillListAddAppId(this, "isc_api_invoke_stat", null, null);
        } else if ("mq_success_pane".equals(key)) {
            QFilter filter = new QFilter("state", "=", (Object)"S");
            this.addTimeFilter(start_time, end_time, filter, "created_time");
            FormOpener.openBillListAddAppId(this, "isc_mq_bill_data_task", this.getCaption(ResManager.loadKDString((String)"\u6210\u529f\u7684\u5355\u636e\u6d88\u606f\u96c6\u6210\u4efb\u52a1", (String)"SuccessRateCardFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), Collections.singletonList(filter));
        } else if ("mq_err_pane".equals(key)) {
            QFilter filter = new QFilter("state", "=", (Object)"F");
            this.addTimeFilter(start_time, end_time, filter, "created_time");
            FormOpener.openBillListAddAppId(this, "isc_mq_bill_data_task", this.getCaption(ResManager.loadKDString((String)"\u5931\u8d25\u7684\u5355\u636e\u6d88\u606f\u96c6\u6210\u4efb\u52a1", (String)"SuccessRateCardFormPlugin_10", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])), Collections.singletonList(filter));
        }
    }

    private void addTimeFilter(Date start_time, Date end_time, QFilter filter, String time) {
        filter.and(new QFilter(time, ">=", (Object)start_time));
        filter.and(new QFilter(time, "<", (Object)end_time));
    }

    private String getCaption(String desc) {
        return String.format(ResManager.loadKDString((String)"%1$s%2$s", (String)"SuccessRateCardFormPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), this.getDateDesc(), desc);
    }

    private String getDateDesc() {
        if (this.getPageCache().get("datetype") == null) {
            return ResManager.loadKDString((String)"\u8fd136\u5c0f\u65f6", (String)"FocusViewCardFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        switch (D.i((Object)this.getPageCache().get("datetype"))) {
            case 1: {
                return ResManager.loadKDString((String)"\u8fd136\u5c0f\u65f6", (String)"FocusViewCardFormPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            }
            case 7: {
                return ResManager.loadKDString((String)"\u8fd17\u5929", (String)"FocusViewCardFormPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            }
            case 30: {
                return ResManager.loadKDString((String)"\u8fd130\u5929", (String)"FocusViewCardFormPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            }
            case 365: {
                return ResManager.loadKDString((String)"\u8fd1\u4e00\u5e74", (String)"FocusViewCardFormPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
            }
        }
        return "";
    }

    private int convertTypeToHour(int type) {
        switch (type) {
            case 1: {
                return 36;
            }
            case 7: {
                return 168;
            }
            case 30: {
                return 720;
            }
            case 365: {
                return 8760;
            }
        }
        throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684type:%s\u8f6c\u6362\uff0c\u8bf7\u4f20\u51651,7,30,365\u8fdb\u884c\u8f6c\u6362", (String)"SuccessRateCardFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), type));
    }

    private void refreshTimeLabel() {
        kd.bos.form.control.Label label = (kd.bos.form.control.Label)this.getView().getControl("refreshtimelabel");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        label.setText(TimeUtil.getInteTime((Date)new Date(), (SimpleDateFormat)sdf));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Date start_time = (Date)this.getModel().getValue(START_TIME);
        Date end_time = (Date)this.getModel().getValue(END_TIME);
        this.showViews(start_time, end_time);
        this.refreshTimeLabel();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("date_list".equals(name)) {
            this.refreshView(e);
        }
    }

    private void refreshViewByHour(int hour) {
        Date start_time = this.getStartTime(hour);
        Date end_time = this.getEndTime();
        this.showViews(start_time, end_time);
        this.refreshTimeLabel();
    }

    private void refreshView(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet != null) {
            String newValue;
            switch (newValue = D.s((Object)changeSet[0].getNewValue())) {
                case "today": {
                    this.getPageCache().put("datetype", "1");
                    this.refreshViewByHour(36);
                    break;
                }
                case "seven": {
                    this.getPageCache().put("datetype", "7");
                    this.refreshViewByHour(168);
                    break;
                }
                case "thirty": {
                    this.getPageCache().put("datetype", "30");
                    this.refreshViewByHour(720);
                    break;
                }
                case "year": {
                    this.getPageCache().put("datetype", "365");
                    this.refreshViewByHour(8760);
                    break;
                }
                default: {
                    throw new IscBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u65e5\u671fdate_list:%s\uff0c\u8bf7\u9009\u62e9today,seven,thirty,year\u8fd9\u4e9b\u7c7b\u578b", (String)"SuccessRateCardFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), newValue));
                }
            }
        }
    }

    private void showViews(Date start_time, Date end_time) {
        ArrayList<Object> valuesDay = new ArrayList<Object>(2);
        ArrayList<Integer> typesDay = new ArrayList<Integer>(2);
        typesDay.add(93);
        typesDay.add(93);
        Timestamp tod = D.t((Object)start_time);
        Timestamp next = D.t((Object)end_time);
        valuesDay.add(tod);
        valuesDay.add(next);
        this.showViews(valuesDay, typesDay);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showViews(List<Object> valuesDay, List<Integer> typesDay) {
        Connection cn = TX.__getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            this.showExecutionView(cn, valuesDay, typesDay);
            this.showProcInstView(cn, valuesDay, typesDay);
            this.showApiView(cn, valuesDay, typesDay);
            this.showMqView(cn, valuesDay, typesDay);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showProcInstView(Connection cn, List<Object> valuesDay, List<Integer> typesDay) {
        DataRow row;
        ObjectReader<DataRow> reader = null;
        int finishCount = 0;
        int errCount = 0;
        try {
            reader = this.getProcInstStateGroup(cn, valuesDay, typesDay);
            row = (DataRow)reader.read();
            while (row != null) {
                String state = D.s((Object)row.get((Object)"fstate"));
                if ("Failed".equals(state)) {
                    ++errCount;
                } else if ("Complete".equals(state)) {
                    ++finishCount;
                }
                row = (DataRow)reader.read();
            }
        }
        finally {
            DbUtil.close(reader);
        }
        row = this.getProcInstNum(cn, valuesDay, typesDay);
        long proc_num = D.i((Object)row.get((Object)"num"));
        this.getModel().setValue("proc_finish_count", (Object)finishCount);
        this.getModel().setValue("proc_err_count", (Object)errCount);
        this.getModel().setValue("proc_inst_count", (Object)proc_num);
        this.drawChart(finishCount, errCount, "proc_piechartap", ResManager.loadKDString((String)"\u5df2\u7ed3\u675f", (String)"SuccessRateCardFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u5931\u8d25", (String)"SuccessRateCardFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    private void showApiView(Connection cn, List<Object> valuesDay, List<Integer> typesDay) {
        DataRow dataRows = this.getApiInvokeData(cn, valuesDay, typesDay);
        int api_total_count = D.i((Object)dataRows.get((Object)"api_total_count"));
        int api_failed_count = D.i((Object)dataRows.get((Object)"api_failed_count"));
        int api_success_count = api_total_count - api_failed_count;
        this.getModel().setValue("api_success_count", (Object)api_success_count);
        this.getModel().setValue("api_err_count", (Object)api_failed_count);
        this.getModel().setValue("api_invoke_count", (Object)api_total_count);
        this.drawChart(api_success_count, api_failed_count, "api_piechartap", ResManager.loadKDString((String)"\u6210\u529f", (String)"SuccessRateCardFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5931\u8d25", (String)"SuccessRateCardFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    private void showMqView(Connection cn, List<Object> valuesDay, List<Integer> typesDay) {
        List<DataRow> dataRows = this.getMqData(cn, valuesDay, typesDay);
        int finishCount = 0;
        int errCount = 0;
        for (DataRow dataRow : dataRows) {
            String state = D.s((Object)dataRow.get((Object)"fstate"));
            if ("F".equals(state)) {
                errCount = D.i((Object)dataRow.get((Object)"num"));
                continue;
            }
            if (!"S".equals(state)) continue;
            finishCount += D.i((Object)dataRow.get((Object)"num"));
        }
        BigDecimal mqBytes = D.n((Object)DbUtil.executeScalar((Connection)cn, (String)"select SUM(fmq_published_bytes + fmq_consumed_bytes)/1048576 from T_ISCB_RUNTIME_STAT  where fcreated_time>=? and fcreated_time<?;", valuesDay, typesDay));
        this.getModel().setValue("mq_success_count", (Object)finishCount);
        this.getModel().setValue("mq_err_count", (Object)errCount);
        this.getModel().setValue("mq_sum_bytes", (Object)mqBytes);
        this.drawChart(finishCount, errCount, "mq_piechartap", ResManager.loadKDString((String)"\u6210\u529f", (String)"SuccessRateCardFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5931\u8d25", (String)"SuccessRateCardFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showExecutionView(Connection cn, List<Object> valuesDay, List<Integer> typesDay) {
        DataRow row;
        ObjectReader<DataRow> reader = null;
        int finishCount = 0;
        int errCount = 0;
        try {
            reader = this.getExecutionStateGroup(cn, valuesDay, typesDay);
            row = (DataRow)reader.read();
            while (row != null) {
                String state = D.s((Object)row.get((Object)"fstate"));
                if ("F".equals(state)) {
                    ++errCount;
                } else if ("S".equals(state) || "P".equals(state)) {
                    ++finishCount;
                }
                row = (DataRow)reader.read();
            }
        }
        finally {
            DbUtil.close(reader);
        }
        row = this.getExecutionSuccessCount(cn, valuesDay, typesDay);
        long exec_success_count = D.i((Object)row.get((Object)"success_count"));
        this.getModel().setValue("exec_finish_count", (Object)finishCount);
        this.getModel().setValue("exec_err_count", (Object)errCount);
        this.getModel().setValue("exec_success_count", (Object)exec_success_count);
        this.drawChart(finishCount, errCount, "exec_piechartap", ResManager.loadKDString((String)"\u5df2\u7ed3\u675f", (String)"SuccessRateCardFormPlugin_13", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u5df2\u5931\u8d25", (String)"SuccessRateCardFormPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    private ObjectReader<DataRow> getExecutionStateGroup(Connection cn, List<Object> valuesDay, List<Integer> typesDay) {
        String sql = "select fstate  from t_isc_data_copy_execution where fstate in ('F' , 'S' , 'P') and  fmodifytime >= ? and fmodifytime < ?  ";
        return DbUtil.executeQuery((Connection)cn, (String)sql, valuesDay, typesDay);
    }

    private DataRow getExecutionSuccessCount(Connection cn, List<Object> valuesDay, List<Integer> typesDay) {
        String sql = "select sum(fsuccess_count) as success_count  from t_isc_data_copy_execution where fmodifytime >= ? and fmodifytime < ?  ";
        return DbUtil.executeRow((Connection)cn, (String)sql, valuesDay, typesDay);
    }

    private ObjectReader<DataRow> getProcInstStateGroup(Connection cn, List<Object> valuesDay, List<Integer> typesDay) {
        String sql = "select fstate  from t_isc_sf_proc_inst where  fstate  in ('Failed' , 'Complete') and  fcreated_time >=? and fcreated_time < ?";
        return DbUtil.executeQuery((Connection)cn, (String)sql, valuesDay, typesDay);
    }

    private DataRow getProcInstNum(Connection cn, List<Object> valuesDay, List<Integer> typesDay) {
        String sql = "select count(*) as num  from t_isc_sf_proc_inst where fcreated_time >= ? and fcreated_time < ?  ";
        return DbUtil.executeRow((Connection)cn, (String)sql, valuesDay, typesDay);
    }

    private DataRow getApiInvokeData(Connection cn, List<Object> valuesDay, List<Integer> typesDay) {
        String sql = "select sum(fapi_total_count) as api_total_count ,sum(fapi_failed_count) as api_failed_count    from  t_iscb_runtime_stat where fcreated_time>=? and fcreated_time<?";
        return DbUtil.executeRow((Connection)cn, (String)sql, valuesDay, typesDay);
    }

    private List<DataRow> getMqData(Connection cn, List<Object> valuesDay, List<Integer> typesDay) {
        String sql = "select  fstate,count(*) as num from  t_iscb_biz_execution where fcreated_time>=? and fcreated_time<?  group by fstate;";
        return DbUtil.executeList((Connection)cn, (String)sql, valuesDay, typesDay);
    }

    private void drawChart(int success, int err, String key, String successDesc, String errDesc) {
        PieChart pieChart = (PieChart)this.getControl(key);
        PieSeries a = pieChart.createSeries(ResManager.loadKDString((String)"\u767e\u5206\u6bd4", (String)"SuccessRateCardFormPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        ItemValue[] itemValues = new ItemValue[3];
        itemValues[0] = new ItemValue(successDesc, (Number)success, "#40A9FF");
        itemValues[1] = new ItemValue(errDesc, (Number)err, "#F57582");
        if (success != 0) {
            a.addData(itemValues[0]);
        }
        if (err != 0) {
            a.addData(itemValues[1]);
        }
        if (success == 0 && err == 0) {
            itemValues[2] = new ItemValue(ResManager.loadKDString((String)"\u65e0\u6570\u636e", (String)"SuccessRateCardFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), (Number)0, "#999999");
            a.addData(itemValues[2]);
        }
        Label label = new Label();
        label.setShow(false);
        label.setPosition(Position.inside);
        a.setLabel(label);
        int rate = -1;
        if (success + err != 0) {
            rate = D.i((Object)((double)success * 1.0 / (double)(success + err) * 100.0));
        }
        this.setChartStyle(pieChart, a, rate);
        pieChart.refresh();
    }

    private void setChartStyle(PieChart pieChart, PieSeries a, int rate) {
        pieChart.setShowTitle(true);
        pieChart.setTitleAlign(XAlign.center, YAlign.center);
        if (rate != -1) {
            pieChart.setName(new LocaleString(rate + "%"));
        } else {
            pieChart.setName(new LocaleString(""));
        }
        HashMap<String, Object> label = new HashMap<String, Object>();
        label.put("show", Boolean.TRUE);
        label.put("fontSize", 40);
        label.put("fontWeight", "bold");
        a.setPropValue("emphasis", label);
        a.setPropValue("borderRadius", (Object)10);
        HashMap<String, Object> normal = new HashMap<String, Object>();
        normal.put("borderRadius", 20);
        normal.put("borderColor", "#fff");
        normal.put("borderWidth", 2);
        HashMap<String, Serializable> itemStyle = new HashMap<String, Serializable>();
        itemStyle.put("normal", normal);
        itemStyle.put("borderRadius", Integer.valueOf(10));
        a.setPropValue("itemStyle", itemStyle);
        a.setRadius("40%", "70%");
        pieChart.setShowTooltip(true);
        pieChart.setLegendAlign(XAlign.center, YAlign.top);
        pieChart.setShowLegend(false);
    }
}

