/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.home.newpage;

import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.util.TimeUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;

public class TaskMonitorCardFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Container run_task_pane = (Container)this.getView().getControl("run_task_pane");
        run_task_pane.addClickListener((ClickListener)this);
        Container wait_task_pane = (Container)this.getView().getControl("wait_task_pane");
        wait_task_pane.addClickListener((ClickListener)this);
        Container fail_task_pane = (Container)this.getView().getControl("fail_task_pane");
        fail_task_pane.addClickListener((ClickListener)this);
        Container plan_task_pane = (Container)this.getView().getControl("plan_task_pane");
        plan_task_pane.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"refreshview"});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        String key = source.getKey();
        if ("refreshview".equals(key)) {
            this.showTaskViews();
            this.refreshTimeLabel();
            return;
        }
        QFilter qFilter = null;
        if ("run_task_pane".equals(key)) {
            qFilter = new QFilter("state", "=", (Object)"RUNNING");
            FormOpener.openBillListAddAppId(this, "isc_job_inst", ResManager.loadKDString((String)"\u6267\u884c\u4e2d\u7684\u540e\u53f0\u4efb\u52a1", (String)"TaskMonitorCardFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Collections.singletonList(qFilter));
        } else if ("wait_task_pane".equals(key)) {
            qFilter = new QFilter("state", "=", (Object)"WAITING").or("state", "=", (Object)"READY");
            FormOpener.openBillListAddAppId(this, "isc_job_inst", ResManager.loadKDString((String)"\u6392\u961f\u4e2d\u7684\u540e\u53f0\u4efb\u52a1", (String)"TaskMonitorCardFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Collections.singletonList(qFilter));
        } else if ("fail_task_pane".equals(key)) {
            qFilter = new QFilter("state", "=", (Object)"FAILED");
            FormOpener.openBillListAddAppId(this, "isc_job_inst", ResManager.loadKDString((String)"\u5df2\u5931\u8d25\u7684\u540e\u53f0\u4efb\u52a1", (String)"TaskMonitorCardFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Collections.singletonList(qFilter));
        } else if ("plan_task_pane".equals(key)) {
            qFilter = new QFilter("state", "=", (Object)"CREATED");
            FormOpener.openBillListAddAppId(this, "isc_job_inst", ResManager.loadKDString((String)"\u8ba1\u5212\u4e2d\u7684\u540e\u53f0\u4efb\u52a1", (String)"TaskMonitorCardFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Collections.singletonList(qFilter));
        }
    }

    private void refreshTimeLabel() {
        Label label = (Label)this.getView().getControl("refreshtimelabel");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        label.setText(TimeUtil.getInteTime((Date)new Date(), (SimpleDateFormat)sdf));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.showTaskViews();
        this.refreshTimeLabel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showTaskViews() {
        Connection cn = TX.__getConnection((String)"ISCB", (boolean)true, (String[])new String[0]);
        try {
            String sql = "select  fstate, count(*) as num  from t_isc_job_inst group by fstate;";
            List dataRows = DbUtil.executeList((Connection)cn, (String)sql, Collections.emptyList(), Collections.emptyList());
            this.setTaskView(dataRows);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private void setTaskView(List<DataRow> dataRows) {
        int waitCount = 0;
        this.getModel().setValue("plan_task", (Object)0);
        this.getModel().setValue("fail_task", (Object)0);
        this.getModel().setValue("run_task", (Object)0);
        this.getModel().setValue("wait_task", (Object)0);
        for (DataRow dataRow : dataRows) {
            String state = D.s((Object)dataRow.get((Object)"fstate"));
            int num = D.i((Object)dataRow.get((Object)"num"));
            if ("CREATED".equals(state)) {
                this.getModel().setValue("plan_task", (Object)num);
                continue;
            }
            if ("FAILED".equals(state)) {
                this.getModel().setValue("fail_task", (Object)num);
                continue;
            }
            if ("RUNNING".equals(state)) {
                this.getModel().setValue("run_task", (Object)num);
                continue;
            }
            if (!"WAITING".equals(state) && !"READY".equals(state)) continue;
            waitCount += num;
        }
        this.getModel().setValue("wait_task", (Object)waitCount);
    }
}

