/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.mapping;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Save;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.CssSetter;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.syndata.MapDataUtil;
import kd.isc.iscb.platform.core.syndata.SynDataUtil;
import kd.isc.iscb.util.dt.D;

public class BaseSchemaFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String NAME_FIELD = "name_field";
    private static final String NUMBER_FIELD = "number_field";
    private static final String CUS_FIELD_3 = "cus_field3";
    private static final String CUS_FIELD_2 = "cus_field2";
    private static final String CUS_FIELD_1 = "cus_field1";
    private static final String NUMBER = "number";
    private static final String DATA_SCHEMA = "data_schema";

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            DynamicObject metaSchema;
            long data_schema_id = D.l((Object)this.getModel().getValue("data_schema_id"));
            QFilter qFilter = new QFilter(DATA_SCHEMA, "=", (Object)data_schema_id);
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"isc_base_schema", (String)"id,number,name", (QFilter[])new QFilter[]{qFilter});
            if (obj != null && !obj.get("id").equals(this.getModel().getValue("id"))) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8be5\u96c6\u6210\u5bf9\u8c61\u5df2\u5b58\u5728\u57fa\u7840\u8d44\u6599\u6a21\u578b[%s]", (String)"BaseSchemaFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), obj.getString(NUMBER)));
                args.setCancel(true);
            }
            if (!("ENUM".equals((metaSchema = BusinessDataServiceHelper.loadSingle((Object)data_schema_id, (String)"isc_metadata_schema", (String)"id,type")).getString("type")) || D.s((Object)this.getModel().getValue(NUMBER_FIELD)) != null && D.s((Object)this.getModel().getValue(NAME_FIELD)) != null)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u5f53\u524d\u53c2\u7167\u6570\u636e\u65b9\u6848\u7684\u7f16\u7801\u5b57\u6bb5\u6216\u540d\u79f0\u5b57\u6bb5\u672a\u586b\u5199\u3002", (String)"BaseSchemaFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        long dataSchemaId = (Long)this.getModel().getValue("data_schema_id");
        if (dataSchemaId > 0L) {
            DynamicObject dataSchema = BusinessDataServiceHelper.loadSingle((Object)dataSchemaId, (String)"isc_metadata_schema");
            this.initNumberNameField(dataSchema);
        }
        if (D.x((Object)this.getView().getFormShowParameter().getCustomParam("SCHEMA_NOT_EDITABLE"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{DATA_SCHEMA});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("sync_data".equals(args.getOperateKey())) {
            this.syncdata();
        } else if ("view_data".equals(args.getOperateKey())) {
            FormOpener.showList((AbstractFormPlugin)this, "isc_basic_data", "baseschema", this.getModel().getValue("id"));
        } else if ("view_log".equals(args.getOperateKey())) {
            FormOpener.showList((AbstractFormPlugin)this, "isc_sync_data_log", "base_schema", this.getModel().getValue("id"));
        }
    }

    private void syncdata() {
        long baseSchemaId = (Long)this.getModel().getValue("id");
        String number = (String)this.getModel().getValue(NUMBER);
        List jobs = JobEngine.getJobsWithOwnerId((long)baseSchemaId);
        if (!jobs.isEmpty()) {
            FormOpener.reopenJob(this, ((JobInfo)jobs.get(0)).getId(), String.format(ResManager.loadKDString((String)"\u53c2\u7167\u6570\u636e\u65b9\u6848\uff1a%s", (String)"BaseSchemaFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), number), null);
            return;
        }
        if (baseSchemaId == 0L) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u5f53\u524d\u8bb0\u5f55\u518d\u64cd\u4f5c\u540c\u6b65\u4efb\u52a1", (String)"BaseSchemaFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        Job job = SynDataUtil.createSynJob((long)baseSchemaId, (String)number);
        FormOpener.startJob(this, job, null);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        IDataEntityProperty property = e.getProperty();
        if (DATA_SCHEMA.equals(property.getName())) {
            this.doWhenSchemaFieldChange(e);
        }
        this.getView().updateView();
    }

    private void doWhenSchemaFieldChange(PropertyChangedArgs e) {
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length > 0) {
            DynamicObject newValue = (DynamicObject)changeSet[0].getNewValue();
            long schema_id = (Long)newValue.get("id");
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"isc_metadata_schema");
            DynamicObject schema = BusinessDataServiceHelper.loadSingle((Object)schema_id, (DynamicObjectType)entityType);
            DynamicObject group = schema.getDynamicObject("group");
            this.getModel().getDataEntity().set("data_source", (Object)group);
            String title = group.getString("name") + "-" + schema.getString("name");
            this.getModel().getDataEntity().set("name", (Object)title);
            this.getModel().getDataEntity().set(NUMBER, schema.get(NUMBER));
            this.initNumberNameField(schema);
        }
    }

    private void initNumberNameField(DynamicObject schema) {
        String type = schema.getString("type");
        if ("ENUM".equals(type)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{NUMBER_FIELD, NAME_FIELD, CUS_FIELD_1, CUS_FIELD_2, CUS_FIELD_3});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{NUMBER_FIELD, NAME_FIELD, CUS_FIELD_1, CUS_FIELD_2, CUS_FIELD_3});
            this.initComboValue(schema);
        }
    }

    private void initComboValue(DynamicObject schema) {
        ComboEdit number_field = (ComboEdit)this.getView().getControl(NUMBER_FIELD);
        ComboEdit name_field = (ComboEdit)this.getView().getControl(NAME_FIELD);
        ComboEdit cus_field1 = (ComboEdit)this.getView().getControl(CUS_FIELD_1);
        ComboEdit cus_field2 = (ComboEdit)this.getView().getControl(CUS_FIELD_2);
        ComboEdit cus_field3 = (ComboEdit)this.getView().getControl(CUS_FIELD_3);
        List<ComboItem> comboItems = this.getComboItems(schema);
        if (number_field != null) {
            number_field.setComboItems(comboItems);
        }
        if (name_field != null) {
            name_field.setComboItems(comboItems);
        }
        if (cus_field1 != null) {
            cus_field1.setComboItems(comboItems);
        }
        if (cus_field2 != null) {
            cus_field2.setComboItems(comboItems);
        }
        if (cus_field3 != null) {
            cus_field3.setComboItems(comboItems);
        }
        if (this.getView().getFormShowParameter().getStatus() == OperationStatus.ADDNEW) {
            Object numberField = this.getModel().getValue(NUMBER_FIELD);
            Object nameField = this.getModel().getValue(NAME_FIELD);
            if (ObjectUtils.isEmpty((Object)numberField) && ObjectUtils.isEmpty((Object)nameField)) {
                int count = 0;
                for (ComboItem comboItem : comboItems) {
                    if (MapDataUtil.existNumber((String)comboItem.getValue())) {
                        if (number_field != null) {
                            this.getModel().setValue(NUMBER_FIELD, (Object)comboItem.getValue());
                            ++count;
                        }
                    } else if (MapDataUtil.existName((String)comboItem.getValue()) && name_field != null) {
                        this.getModel().setValue(NAME_FIELD, (Object)comboItem.getValue());
                        ++count;
                    }
                    if (count != 2) continue;
                    break;
                }
            }
        }
    }

    private List<ComboItem> getComboItems(DynamicObject schema) {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        DynamicObjectCollection prop_entryentity = (DynamicObjectCollection)schema.get("prop_entryentity");
        for (DynamicObject dynamicObject : prop_entryentity) {
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(dynamicObject.getString("prop_name"));
            comboItem.setCaption(new LocaleString(dynamicObject.getString("prop_name")));
            items.add(comboItem);
        }
        return items;
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String field = evt.getProperty().getName();
        if (field.equalsIgnoreCase(DATA_SCHEMA)) {
            CssSetter.setF7WindowSize(evt);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit dataSchema = (BasedataEdit)this.getView().getControl(DATA_SCHEMA);
        dataSchema.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }
}

