/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.mapping;

import java.io.IOException;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.export.MappingResultXlsDownload;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.vc.MappingResultImportJob;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class MappingDataListPlugin
extends AbstractListPlugin {
    private static final String MAPPING_RULE = "mapping_rule";

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        if (e.getParameter().getBillStatus() == BillOperationStatus.ADDNEW) {
            ListShowParameter source = (ListShowParameter)this.getView().getFormShowParameter();
            ListFilterParameter listFilterParameter = source.getListFilterParameter();
            List qFilters = listFilterParameter.getQFilters();
            for (QFilter qFilter : qFilters) {
                String property = qFilter.getProperty();
                if (!MAPPING_RULE.equals(property)) continue;
                e.getParameter().setCustomParam(MAPPING_RULE, qFilter.getValue());
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map params;
        super.closedCallBack(closedCallBackEvent);
        if ("startJob".equals(closedCallBackEvent.getActionId()) && (params = (Map)closedCallBackEvent.getReturnData()) != null && params.get("excel_tmp_id") != null) {
            MappingResultImportJob job = new MappingResultImportJob(Json.toString((Object)params), ResManager.loadKDString((String)"\u503c\u8f6c\u6362\u6570\u636e\u5bfc\u5165", (String)"MappingDataListPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            List jobs = JobEngine.getJobsWithOwnerId((long)job.getOwnerId());
            if (jobs.isEmpty()) {
                FormOpener.startJob((AbstractFormPlugin)this, (Job)job, "MappingResultImportJob");
            } else {
                FormOpener.reopenJob((AbstractFormPlugin)this, ((JobInfo)jobs.get(0)).getId(), job.getTitle(), "MappingResultImportJob");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String op = e.getOperateKey();
        if (e.getOperationResult() != null) {
            List successPkIds = e.getOperationResult().getSuccessPkIds();
            try {
                if ("downloadxls".equals(op)) {
                    this.downLoadExcelData(successPkIds);
                } else if ("importexcel".equals(op)) {
                    this.importExcelData();
                }
            }
            catch (Exception ex) {
                FormOpener.showErrorMessage(this.getView(), ex);
            }
        }
    }

    private void downLoadExcelData(List<Object> successPkIds) throws IOException {
        Object id = this.getMappingFilterId();
        if (id == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u6307\u5b9a\u503c\u8f6c\u6362\u89c4\u5219\u7684\u503c\u8f6c\u6362\u6570\u636e\u5217\u8868\u4e2d\u7684\u6570\u636e\u5bfc\u51fa", (String)"MappingDataListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().openUrl(new MappingResultXlsDownload(successPkIds, id).download());
        }
    }

    private void importExcelData() {
        Object id = this.getMappingFilterId();
        if (id == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u652f\u6301\u6307\u5b9a\u503c\u8f6c\u6362\u89c4\u5219\u7684\u503c\u8f6c\u6362\u6570\u636e\u5217\u8868\u4e2d\u7684\u6570\u636e\u5bfc\u5165", (String)"MappingDataListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>(1);
            map.put("ID", id);
            map.put("sourceType", "isc_value_conver_rule");
            FormOpener.showForm((AbstractFormPlugin)this, "isc_excel_tmp", ResManager.loadKDString((String)"\u4eba\u5de5\u6620\u5c04\u503c\u8f6c\u6362\u6570\u636e\u5bfc\u5165", (String)"MappingDataListPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), map, "startJob");
        }
    }

    private Object getMappingFilterId() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        List qFilter = listShowParameter.getListFilterParameter().getQFilters();
        for (QFilter filter : qFilter) {
            Object id;
            if (!MAPPING_RULE.equals(filter.getProperty()) || !((id = filter.getValue()) instanceof Long)) continue;
            return id;
        }
        return null;
    }

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"_toolbar_"});
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("tblrefresh".equals(key)) {
            String ruleId = MappingDataListPlugin.getMappingRuleId(this);
            QFilter q1 = new QFilter(MAPPING_RULE, "=", (Object)D.l((Object)ruleId));
            QFilter q2 = new QFilter("source_id", "<>", (Object)Character.valueOf(' '));
            QFilter q3 = new QFilter("target_id", "<>", (Object)Character.valueOf(' '));
            QFilter q4 = new QFilter("source_name", "=", (Object)Character.valueOf(' '));
            QFilter q5 = new QFilter("target_name", "=", (Object)Character.valueOf(' '));
            DynamicObject[] mappingData = BusinessDataServiceHelper.load((String)"isc_mapping_data", (String)"source_id,source_name,source_number,target_id,target_name,target_number", (QFilter[])new QFilter[]{q1, q2, q3, q4, q5});
            if (mappingData.length == 0) {
                return;
            }
            this.updateMappingData(mappingData);
        }
        this.getView().updateView();
    }

    private void updateMappingData(DynamicObject[] mappingData) {
        for (DynamicObject md : mappingData) {
            String source_id = md.getString("source_id");
            String target_id = md.getString("target_id");
            DynamicObject sourceData = this.getBasicData(source_id);
            DynamicObject targetData = this.getBasicData(target_id);
            if (null == sourceData || null == targetData) continue;
            md.set("source_name", (Object)sourceData.getString("name"));
            md.set("source_number", (Object)sourceData.getString("number"));
            md.set("target_name", (Object)targetData.getString("name"));
            md.set("target_number", (Object)targetData.getString("number"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{md});
        }
    }

    private DynamicObject getBasicData(String id) {
        QFilter qFilter = new QFilter("oid", "=", (Object)id);
        DynamicObject dynamicObject3 = BusinessDataServiceHelper.loadSingle((String)"isc_basic_data", (String)"name,number", (QFilter[])new QFilter[]{qFilter});
        return dynamicObject3;
    }

    private static String getMappingRuleId(MappingDataListPlugin mappingDataListPlugin) {
        ListShowParameter source = (ListShowParameter)mappingDataListPlugin.getView().getFormShowParameter();
        ListFilterParameter listFilterParameter = source.getListFilterParameter();
        List qFilters = listFilterParameter.getQFilters();
        String value = null;
        for (QFilter qFilter : qFilters) {
            String property = qFilter.getProperty();
            if (!MAPPING_RULE.equals(property)) continue;
            value = D.s((Object)qFilter.getValue());
            break;
        }
        return value;
    }
}

