/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.meta;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.util.DynamicObjectUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class MetaPropertiesF7FormPlugin
extends AbstractFormPlugin
implements SearchEnterListener,
RowClickEventListener {
    private static final String PARAM_ROW = "$row";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String PARAM_TYPE = "$type";
    private static final String KEY_ENTRY_ENTITY = "entryentity";
    private static final String KEY_BTN_OK = "btn_ok";

    public void afterCreateNewData(EventObject e) {
        Object type;
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map filters = formShowParameter.getCustomParams();
        if (!filters.containsKey("id")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5143\u6570\u636eID\u3002", (String)"MetaPropertiesF7FormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        Object row = filters.get(PARAM_ROW);
        if (row != null) {
            this.getPageCache().put(PARAM_ROW, D.s(row));
        }
        if ((type = filters.get(PARAM_TYPE)) != null) {
            this.getPageCache().put(PARAM_TYPE, D.s(type));
        }
        this.initProperties(Long.parseLong(filters.get("id").toString()));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_OK});
        EntryGrid entry = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        entry.addRowClickListener((RowClickEventListener)this);
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
    }

    public void search(SearchEnterEvent event) {
        String searchText = event.getText();
        this.innerSearch(searchText);
    }

    private void innerSearch(String searchText) {
        this.getView().updateView(KEY_ENTRY_ENTITY);
        if (StringUtil.isEmpty((String)searchText)) {
            return;
        }
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(KEY_ENTRY_ENTITY);
        DynamicObjectCollection collection = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ENTRY_ENTITY);
        ArrayList<Integer> rows = new ArrayList<Integer>();
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject o = (DynamicObject)collection.get(i);
            if (!o.getString(NUMBER).contains(searchText) && !o.getString(NAME).contains(searchText)) continue;
            rows.add(i);
        }
        if (rows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\u3002", (String)"MetaPropertiesF7FormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        int[] rowArrays = rows.stream().mapToInt(Integer::valueOf).toArray();
        entryGrid.setRowBackcolor("#eff3fd", rowArrays);
        entryGrid.focusCell(rowArrays[0], NUMBER);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (KEY_BTN_OK.equals(key)) {
            EntryGrid entry = (EntryGrid)this.getControl(KEY_ENTRY_ENTITY);
            int[] rows = entry.getSelectRows();
            if (rows.length == 1) {
                this.getView().returnDataToParent(this.getSelectedRowData(rows[0]));
                this.getView().close();
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u62e9\u6570\u636e\u6216\u9009\u62e9\u8d85\u8fc71\u884c\u3002", (String)"MetaPropertiesF7FormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private Map<String, Object> getSelectedRowData(int row) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(KEY_ENTRY_ENTITY, row);
        Map map = DynamicObjectUtil.object2Map((DynamicObject)rowEntity);
        map.put(PARAM_ROW, this.getPageCache().get(PARAM_ROW));
        map.put(PARAM_TYPE, this.getPageCache().get(PARAM_TYPE));
        return map;
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        Map<String, Object> data = this.getSelectedRowData(evt.getRow());
        this.getView().returnDataToParent(data);
        this.getView().close();
    }

    private void initProperties(long metaId) {
        DynamicObject meta = BusinessDataServiceHelper.loadSingle((Object)metaId, (String)"isc_metadata_schema");
        this.getModel().deleteEntryData(KEY_ENTRY_ENTITY);
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_ENTRY_ENTITY);
        DynamicObjectCollection properties = meta.getDynamicObjectCollection("prop_entryentity");
        for (DynamicObject p : properties) {
            DynamicObject row = entry.addNew();
            row.set(NUMBER, (Object)p.getString("prop_name"));
            row.set(NAME, (Object)p.getString("prop_label"));
            row.set("data_type", (Object)p.getString("data_type"));
            row.set("data_schema", (Object)p.getString("data_schema"));
            row.set("is_primary_key", p.get("is_primary_key"));
            row.set("required", p.get("required"));
            row.set("remark", p.get("prop_remark"));
        }
        this.getView().updateView(KEY_ENTRY_ENTITY);
    }
}

