/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.meta;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.ListColumnCompareTypesSetEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ITreeListView;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.TreeListModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.common.topology.TopologyFormUtil;
import kd.isc.iscb.formplugin.dc.meta.MetadataSchemaFormPlugin;
import kd.isc.iscb.formplugin.util.ExportUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.formplugin.util.ShowStackTraceUtil;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.meta.doc.ExportMetaXML;
import kd.isc.iscb.platform.core.connector.meta.doc.TypeHandlers;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.platform.core.connector.self.TableInfo;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.meta.MetaSchemaUtil;
import kd.isc.iscb.platform.core.meta.SyncMetaJobFactory;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.encoding.Hex;
import kd.isc.iscb.util.script.misc.SystemContext;

public class MetadataSchemaListPlugin
extends AbstractTreeListPlugin {
    private static final String SYNC_META_SCHEMA = "sync_meta_schema";
    private static final String SYNC_META_LIST = "sync_meta_list";
    private static final String ISC_METADATA_SCHEMA2 = "isc_metadata_schema";
    public static final String ISC_METADATA_SCHEMA = "isc_metadata_schema";
    public static final String BOS_TEM_LIST = "bos_templatetreelist";
    private static final Log LOG = LogFactory.getLog(MetadataSchemaListPlugin.class);

    public void initializeTree(EventObject e) {
        super.initializeTree(e);
        ((TreeListModel)this.getTreeModel()).getQueryParas().put("order", "name asc");
    }

    public void initialize() {
        super.initialize();
        ITreeListView treeListView = this.getTreeListView();
        if (treeListView == null) {
            return;
        }
        ITreeModel model = treeListView.getTreeModel();
        if (model == null) {
            return;
        }
        List qFilters = model.getTreeFilter();
        if (qFilters == null) {
            return;
        }
        Iterator filterIterator = qFilters.iterator();
        while (filterIterator.hasNext()) {
            QFilter qFilter = (QFilter)filterIterator.next();
            if (qFilter == null || !"enable".equalsIgnoreCase(qFilter.getProperty())) continue;
            filterIterator.remove();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{SYNC_META_LIST});
        this.getView().setVisible(Boolean.TRUE, new String[]{SYNC_META_SCHEMA});
        this.getView().setVisible(Boolean.FALSE, new String[]{"show_log"});
        this.getView().setVisible(Boolean.valueOf(!SystemContext.isProcEnv()), new String[]{"reset_attachmenttag_cache"});
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        if (D.s((Object)e.getParentNodeId()) != null && D.s((Object)e.getNodeId()) != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{SYNC_META_LIST});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{SYNC_META_LIST});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        ListSelectedRowCollection pkIds;
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        String operateKey = operate.getOperateKey();
        if ("syncmetaschema".equals(operateKey) && (pkIds = evt.getListSelectedData()).size() > 100) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0d\u8981\u9009\u62e9\u8d85\u8fc7100\u6761\uff0c\u5927\u6279\u91cf\u540c\u6b65\u5efa\u8bae\u9009\u62e9\u6279\u91cf\u540c\u6b65\u5143\u6570\u636e\u3002", (String)"MetadataSchemaListPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operationKey = evt.getOperateKey();
        if ("syncmetalist".equalsIgnoreCase(operationKey)) {
            this.executeSyncMetaList();
        } else if ("syncmetaschema".equals(operationKey)) {
            this.executeMetaSchema(evt);
        } else if ("exportschema".equals(operationKey)) {
            List pkIds = evt.getOperationResult().getSuccessPkIds();
            ExportUtil.exportDts((AbstractFormPlugin)this, pkIds, "isc_metadata_schema");
        } else if ("importschema".equals(operationKey)) {
            FormOpener.openImportForm((IFormPlugin)this, this.getView(), "isc_metadata_schema");
        } else if ("exportzip".equals(operationKey)) {
            ExportUtil.exportZip((AbstractFormPlugin)this, evt, "isc_metadata_schema");
        } else if ("relation_query".equals(operationKey)) {
            this.relationQuery(this, evt);
        } else if ("open_log".equals(operationKey)) {
            this.openLogForm();
        } else if ("exportword".equals(operationKey)) {
            try {
                DynamicObject[] metas;
                List pkIds = evt.getOperationResult().getSuccessPkIds();
                for (DynamicObject meta : metas = BusinessDataServiceHelper.load((Object[])pkIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"isc_metadata_schema"))) {
                    new ExportMetaXML(meta, TypeHandlers.buildInfo((DynamicObject)meta)).export(this.getView());
                }
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(this.getView(), e);
            }
        } else if ("topology".equals(operationKey)) {
            this.showTopologyView(evt);
        } else if ("reset_attachmenttag_cache".equals(operationKey)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("reset_attachmenttag_cache", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u8be5\u64cd\u4f5c\u53ef\u80fd\u5f71\u54cd\u5230\u6b63\u5728\u8fd0\u884c\u7684\u65b9\u6848\uff0c\u6b63\u5f0f\u73af\u5883\u8bf7\u8c28\u614e\u64cd\u4f5c\uff0c\u5efa\u8bae\u53ea\u5728\u5f00\u53d1\u9636\u6bb5\u8fdb\u884c\u3002\u662f\u5426\u7ee7\u7eed\uff1f", (String)"MetadataSchemaListPlugin_22", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    private void clearEntityPanelCache() {
        AttachmentUtil.resetCache();
        this.saveResetCacheLog();
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u91cd\u7f6e\u5f53\u524d\u8d26\u5957\u9644\u4ef6\u9762\u677f/\u9644\u4ef6\u5b57\u6bb5\u5143\u6570\u636e\u6807\u8bc6\u7f13\u5b58\u6210\u529f\u3002", (String)"MetadataSchemaListPlugin_33", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
    }

    private void saveResetCacheLog() {
        try {
            DynamicObject opLog = BusinessDataServiceHelper.newDynamicObject((String)"isc_operation_log");
            opLog.set("number", (Object)"-");
            opLog.set("name", (Object)"-");
            opLog.set("schemaid", (Object)"0");
            opLog.set("desc", (Object)ResManager.loadKDString((String)"\u91cd\u7f6e\u5f53\u524d\u8d26\u5957\u9644\u4ef6\u9762\u677f/\u9644\u4ef6\u5b57\u6bb5\u5143\u6570\u636e\u6807\u8bc6\u7f13\u5b58\u6210\u529f\u3002", (String)"MetadataSchemaListPlugin_33", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            opLog.set("type", (Object)"isc_metadata_schema");
            opLog.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
            opLog.set("created_time", (Object)new Timestamp(System.currentTimeMillis()));
            opLog.set("operation_code", (Object)"reset_attachmenttag_cache");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{opLog});
        }
        catch (Exception e) {
            LOG.warn("\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25\uff0c\u64cd\u4f5c\uff1areset_attachmenttag_cache\uff0c\u5b9e\u4f53\uff1a\u96c6\u6210\u5bf9\u8c61\u5217\u8868\uff0c \u539f\u56e0\uff1a" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
        }
    }

    private void showTopologyView(AfterDoOperationEventArgs args) {
        long id = D.l((Object)FormOpener.getSelectedId((AbstractFormPlugin)this, args));
        if (id > 0L) {
            HashMap<String, Object> params = new HashMap<String, Object>(2);
            params.put("type", "isc_metadata_schema");
            params.put("id", id);
            FormOpener.showTabForm((AbstractFormPlugin)this, "isc_topology_view", TopologyFormUtil.getName("isc_metadata_schema," + id), params, "");
        }
    }

    private void openLogForm() {
        String dataSourceId = this.getTreeModel().getCurrentNodeId().toString();
        if (Hex.isNumber((String)dataSourceId)) {
            List jobs = JobEngine.getAllJobsWithOwnerId((long)D.l((Object)dataSourceId));
            if (jobs.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u540c\u6b65\u65e5\u5fd7\u3002", (String)"MetadataSchemaListPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else {
                FormOpener.showTabView((AbstractFormPlugin)this, "isc_job_inst", ((JobInfo)jobs.get(0)).getId());
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u6570\u636e\u6e90\u3002", (String)"MetadataSchemaListPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
    }

    private void relationQuery(MetadataSchemaListPlugin form, AfterDoOperationEventArgs evt) {
        List successPkIds = evt.getOperationResult().getSuccessPkIds();
        String pk = null;
        if (successPkIds.size() != 1) {
            form.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c\uff01", (String)"MetadataSchemaListPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        pk = D.s(successPkIds.get(0));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"isc_metadata_schema", (String)"group");
        long dataSourceId = D.l((Object)dynamicObject.getString("group_id"));
        if (dataSourceId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u4e3a\u7a7a\uff01", (String)"MetadataSchemaListPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        String dataSchema = (String)evt.getOperationResult().getBillNos().get(pk);
        if (StringUtils.isEmpty((CharSequence)dataSchema)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u96c6\u6210\u5bf9\u8c61\u7f16\u7801\u4e3a\u7a7a\uff01", (String)"MetadataSchemaListPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        QFilter qFilter = new QFilter("group", "=", (Object)dataSourceId).and(new QFilter("prop_entryentity.data_schema", "=", (Object)dataSchema));
        FormOpener.openBillList((AbstractFormPlugin)this, "isc_metadata_schema", "isc_related_metadata", ResManager.loadKDString((String)"\u5173\u8054\u96c6\u6210\u5bf9\u8c61", (String)"MetadataSchemaListPlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Collections.singletonList(qFilter));
    }

    public void listRowClick(ListRowClickEvent evt) {
        super.listRowClick(evt);
        if (evt.getCurrentListSelectedRow() == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SYNC_META_SCHEMA});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{SYNC_META_SCHEMA});
        }
    }

    private void executeSyncMetaList() {
        String dataSourceId = this.getTreeModel().getCurrentNodeId().toString();
        String rootId = this.getTreeModel().getRoot().getId();
        if (rootId.equals(dataSourceId)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u4e2a\u6570\u636e\u6e90\uff01", (String)"MetadataSchemaListPlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        List jobs = JobEngine.getJobsWithOwnerId((long)D.l((Object)dataSourceId));
        if (!jobs.isEmpty()) {
            FormOpener.reopenJob((AbstractFormPlugin)this, ((JobInfo)jobs.get(0)).getId(), ResManager.loadKDString((String)"\u540c\u6b65\u5143\u6570\u636e", (String)"MetadataSchemaListPlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        } else {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("syncmetalist", (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6279\u91cf\u540c\u6b65\u5c06\u540c\u6b65\u8be5\u6570\u636e\u6e90\u4e0b\u6240\u6709\u5143\u6570\u636e\u4fe1\u606f\uff0c\u4f46\u4e0d\u4f1a\u8986\u76d6\u5217\u8868\u4e2d\u5df2\u5b58\u5728\u7684\u5143\u6570\u636e\uff0c\u4e14\u8017\u65f6\u53ef\u80fd\u8f83\u957f\uff0c\u6b63\u5f0f\u73af\u5883\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002\u662f\u5426\u7ee7\u7eed\u540c\u6b65\uff1f", (String)"MetadataSchemaListPlugin_9", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    private void saveLog(long dataSourceId) {
        try {
            DynamicObject opLog = BusinessDataServiceHelper.newDynamicObject((String)"isc_operation_log");
            DynamicObject datasource = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)"isc_data_source");
            opLog.set("number", datasource.get("number"));
            opLog.set("name", datasource.get("name"));
            opLog.set("schemaid", datasource.get("id"));
            opLog.set("desc", (Object)"");
            opLog.set("type", (Object)"isc_data_source");
            opLog.set("creator", (Object)Long.parseLong(RequestContext.get().getUserId()));
            opLog.set("created_time", (Object)new Timestamp(System.currentTimeMillis()));
            opLog.set("operation_code", (Object)"syncmetalist");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{opLog});
        }
        catch (Exception e) {
            LOG.warn("\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u5931\u8d25\uff0c\u64cd\u4f5c\uff1asyncmetalist\uff0c\u5b9e\u4f53\uff1a\u96c6\u6210\u5bf9\u8c61\u5217\u8868\uff0c \u539f\u56e0\uff1a" + StringUtil.getCascadeMessage((Throwable)e), (Throwable)e);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        try {
            if (StringUtils.equals((CharSequence)"syncmetalist", (CharSequence)callBackId) && e.getResult() == MessageBoxResult.Yes) {
                this.innerExecuteSyncMetaList();
            } else if (StringUtils.equals((CharSequence)"syncmetaschema", (CharSequence)callBackId) && e.getResult() == MessageBoxResult.Yes) {
                this.innerExecuteMetaSchema();
            }
        }
        catch (Exception err) {
            FormOpener.showErrorMessage(this.getView(), "syncmetalist".equals(callBackId) ? StringUtil.getMessage((Throwable)err) : ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\uff01", (String)"MetadataSchemaListPlugin_11", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), ShowStackTraceUtil.getErrorMsg(err));
        }
        if ("reset_attachmenttag_cache".equals(callBackId) && e.getResult() == MessageBoxResult.Yes) {
            this.clearEntityPanelCache();
        }
    }

    private void innerExecuteMetaSchema() {
        Object[] primaryKeyValues = this.getSelectedRows().getPrimaryKeyValues();
        StringBuilder sb = new StringBuilder();
        for (Object id : primaryKeyValues) {
            DynamicObject metaObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"isc_metadata_schema");
            if (this.isSyncEnabled(metaObj)) {
                MetaSchemaUtil.syncMetaSchema((Object)id);
                MetadataSchemaFormPlugin.saveHistories(BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"isc_metadata_schema"));
                continue;
            }
            String type = MetaDataType.valueOf(metaObj.getString("type")).getName();
            String number = metaObj.getString("number");
            sb.append(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u5bf9\u8c61\u4e0d\u652f\u6301\u540c\u6b65\uff0c\u7c7b\u578b\uff1a[%1$s], \u7f16\u7801\uff1a[%2$s];\n", (String)"MetadataSchemaListPlugin_12", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), type, number));
        }
        if (sb.length() > 0) {
            this.getView().showTipNotification(sb.toString(), Integer.valueOf(3000));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\uff01", (String)"MetadataSchemaListPlugin_14", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        }
        this.getView().invokeOperation("refresh");
    }

    private void innerExecuteSyncMetaList() {
        long dataSourceId = D.l((Object)this.getTreeModel().getCurrentNodeId());
        DynamicObject ds = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)"isc_data_source", (String)"dblink");
        long dblinkId = ds.getLong("dblink_id");
        String dsTitle = ds.getString("name") + '(' + ds.getString("number") + ')';
        if (dblinkId == 0L) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u201c%s\u201d\u6ca1\u6709\u914d\u7f6e\u7cfb\u7edf\u8fde\u63a5\u3002", (String)"MetadataSchemaListPlugin_15", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), dsTitle));
        }
        List jobs = JobEngine.getJobsWithOwnerId((long)dataSourceId);
        dsTitle = StringUtil.trim((String)dsTitle, (int)30);
        if (jobs.isEmpty()) {
            this.saveLog(dataSourceId);
            Job job = SyncMetaJobFactory.createJob((long)dataSourceId, (String)String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5143\u6570\u636e\uff1a%s", (String)"MetadataSchemaListPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), dsTitle));
            FormOpener.startJob((AbstractFormPlugin)this, job);
        } else {
            FormOpener.reopenJob((AbstractFormPlugin)this, ((JobInfo)jobs.get(0)).getId(), String.format(ResManager.loadKDString((String)"\u540c\u6b65\u5143\u6570\u636e\uff1a%s", (String)"MetadataSchemaListPlugin_19", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), dsTitle));
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)SYNC_META_LIST)) {
            this.getView().invokeOperation("refresh");
        } else if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"iscExportTaskCloseCallBack")) {
            ExportUtil.iscExportTaskCallBack((AbstractFormPlugin)this, evt.getReturnData());
        }
    }

    private void executeMetaSchema(AfterDoOperationEventArgs evt) {
        List pkIds = evt.getOperationResult().getSuccessPkIds();
        if (pkIds.size() > 100) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4e0d\u8981\u9009\u62e9\u8d85\u8fc7100\u6761\uff0c\u5927\u6279\u91cf\u540c\u6b65\u5efa\u8bae\u9009\u62e9\u6279\u91cf\u540c\u6b65\u5143\u6570\u636e\u3002", (String)"MetadataSchemaListPlugin_20", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("syncmetaschema", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u8986\u76d6\u9009\u5b9a\u7684\u5143\u6570\u636e\u4fe1\u606f\uff0c\u5e76\u540c\u6b65\u65b0\u589e\uff08\u4f46\u4e0d\u8986\u76d6\uff09\u6240\u5f15\u7528\u7684\u6570\u636e\u6a21\u578b\uff0c\u53ef\u80fd\u5f71\u54cd\u5230\u6b63\u5728\u8fd0\u884c\u7684\u65b9\u6848\uff0c\u6b63\u5f0f\u73af\u5883\u8bf7\u8c28\u614e\u64cd\u4f5c\u3002\u662f\u5426\u7ee7\u7eed\u540c\u6b65\uff1f", (String)"MetadataSchemaListPlugin_21", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
    }

    /*
     * Loose catch block
     */
    private boolean isSyncEnabled(DynamicObject metaObj) {
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)metaObj.get("group_id"), (String)"isc_data_source");
        ConnectionManager.checkConnection((DynamicObject)dataSource);
        ConnectionManager.pushResLicense((boolean)true);
        try {
            try (ConnectionWrapper connectionWrapper = ConnectionManager.getConnection((long)D.l((Object)dataSource.get("dblink_id")));){
                ConnectionFactory factory = connectionWrapper.getFactory();
                boolean bl = factory.hasMetaData(D.s((Object)metaObj.get("full_name")), D.s((Object)metaObj.get("type")), connectionWrapper);
                return bl;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            ConnectionManager.popResLicense();
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
        long id = D.l((Object)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue());
        if (id > 0L) {
            FormOpener.showTabView((AbstractFormPlugin)this, "isc_metadata_schema", id);
        }
    }

    public void listColumnCompareTypesSet(ListColumnCompareTypesSetEvent args) {
        super.listColumnCompareTypesSet(args);
        String originFormId = D.s(this.getView().getFormShowParameter().getCustomParams().get("originFormId"));
        if ("iscx_import_meta2resource".equals(originFormId) && args.getListFieldKey().equals("type")) {
            List comboItems = args.getComboItems();
            ArrayList<ValueMapItem> newComboItems = new ArrayList<ValueMapItem>();
            for (ValueMapItem item : comboItems) {
                if (!item.getValue().equals("ENTITY") && !item.getValue().equals("VIEW") && !item.getValue().equals("TABLE")) continue;
                newComboItems.add(item);
            }
            args.setComboItems(newComboItems);
        }
    }

    static {
        TableInfo.initTableMapping();
    }

    private static enum MetaDataType {
        TABLE(new MultiLangEnumBridge("\u6570\u636e\u8868", "DataCopyExecutionTimeAnalysisPlugin_42", "isc-iscb-platform-formplugin")),
        ENTITY(new MultiLangEnumBridge("\u5b9e\u4f53", "DataCopyExecutionTimeAnalysisPlugin_43", "isc-iscb-platform-formplugin")),
        ENUM(new MultiLangEnumBridge("\u679a\u4e3e", "DataCopyExecutionTimeAnalysisPlugin_44", "isc-iscb-platform-formplugin")),
        VIEW(new MultiLangEnumBridge("\u89c6\u56fe", "DataCopyExecutionTimeAnalysisPlugin_45", "isc-iscb-platform-formplugin")),
        SERVICE(new MultiLangEnumBridge("\u52a0\u8f7d\u670d\u52a1", "DataCopyExecutionTimeAnalysisPlugin_46", "isc-iscb-platform-formplugin")),
        QUERY(new MultiLangEnumBridge("\u67e5\u8be2\u670d\u52a1", "DataCopyExecutionTimeAnalysisPlugin_47", "isc-iscb-platform-formplugin")),
        STRUCT(new MultiLangEnumBridge("\u7ed3\u6784", "DataCopyExecutionTimeAnalysisPlugin_48", "isc-iscb-platform-formplugin")),
        ELEMENT(new MultiLangEnumBridge("\u5143\u7d20", "DataCopyExecutionTimeAnalysisPlugin_49", "isc-iscb-platform-formplugin")),
        EVT_RSC(new MultiLangEnumBridge("\u4e8b\u4ef6\u6e90", "DataCopyExecutionTimeAnalysisPlugin_50", "isc-iscb-platform-formplugin"));

        private final MultiLangEnumBridge name;

        private MetaDataType(MultiLangEnumBridge name) {
            this.name = name;
        }

        private String getName() {
            return this.name.loadKDString();
        }
    }
}

