/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.meta;

import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.filter.FilterContainer;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.util.CollectionUtils;
import kd.isc.iscb.util.dt.D;

public class RelatedMetaFormPlugin
extends AbstractListPlugin {
    private static final String ISC_METADATA_SCHEMA = "isc_metadata_schema";

    public void initialize() {
        super.initialize();
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.setBillFormId(ISC_METADATA_SCHEMA);
        fc.setTitle(new LocaleString(ResManager.loadKDString((String)"\u5173\u8054\u96c6\u6210\u5bf9\u8c61", (String)"RelatedMetaFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0])));
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter parameter = this.getView().getFormShowParameter();
        Object filter = parameter.getCustomParam("filter");
        if (filter != null) {
            QFilter qFilter = QFilter.of((String)filter.toString(), (Object[])new Object[0]);
            BillList billList = (BillList)this.getControl("billlistap");
            FilterParameter fp = new FilterParameter();
            billList.setFilterParameter(fp);
            billList.addSetFilterListener(event -> event.getQFilters().add(qFilter));
            billList.refresh();
            billList.clearSelection();
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        if ("donothing".equals(evt.getOperateKey())) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectedRows = billList.getSelectedRows();
            if (CollectionUtils.isEmpty((Collection)selectedRows)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c!", (String)"RelatedMetaFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else if (selectedRows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u884c!", (String)"RelatedMetaFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            } else {
                this.showRelatedMeta(selectedRows);
            }
        }
    }

    private void showRelatedMeta(ListSelectedRowCollection selectedRows) {
        String number = selectedRows.get(0).getNumber();
        if (D.s((Object)number) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u96c6\u6210\u5bf9\u8c61\u7f16\u7801\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5173\u8054\u67e5\u8be2!", (String)"RelatedMetaFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            return;
        }
        Object pk = selectedRows.get(0).getPrimaryKeyValue();
        DynamicObject current = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)ISC_METADATA_SCHEMA, (String)"group");
        Object dataSourceId = current.get("group_id");
        QFilter qFilter = new QFilter("group", "=", dataSourceId).and(new QFilter("prop_entryentity.data_schema", "=", (Object)number));
        FormOpener.openBillList((AbstractFormPlugin)this, ISC_METADATA_SCHEMA, "isc_related_metadata", ResManager.loadKDString((String)"\u5173\u8054\u96c6\u6210\u5bf9\u8c61", (String)"RelatedMetaFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Collections.singletonList(qFilter));
    }
}

