/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.meta;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.dc.meta.AbstractProgressBarFormPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.meta.SyncMetaListTask;
import kd.isc.iscb.util.dt.D;

public class SyncMetaProgressFormPlugin
extends AbstractProgressBarFormPlugin {
    private static final String DATA_SOURCE_ID2 = "datasourceid";
    private static final String DATA_SOURCE_ID = "datasourceid";
    private static final String KEY_SYNC_ALL = "btnsync_all";
    private static final String IS_SYNC_ALL = "is_sync_all";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter.getCustomParam("datasourceid") == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u6e90ID\u4e3a\u7a7a\uff01", (String)"SyncMetaProgressFormPlugin_0", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnok", "btnstop", "sync_all"});
            return;
        }
        this.getModel().setValue("datasourceid", formShowParameter.getCustomParam("datasourceid"));
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getView().getControl("progressbarap");
        progressBar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{"btnok", "btnstop", "btnexit", KEY_SYNC_ALL});
    }

    @Override
    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equals((CharSequence)"btnok", (CharSequence)source.getKey())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnok", KEY_SYNC_ALL});
            super.start();
        } else if (StringUtils.equals((CharSequence)"btnstop", (CharSequence)source.getKey())) {
            super.stop();
        } else if (StringUtils.equals((CharSequence)"btnexit", (CharSequence)source.getKey())) {
            this.getView().invokeOperation("close");
        } else if (StringUtils.equals((CharSequence)KEY_SYNC_ALL, (CharSequence)source.getKey())) {
            this.getModel().setValue(IS_SYNC_ALL, (Object)Boolean.TRUE);
            this.getView().setEnable(Boolean.FALSE, new String[]{"btnok", KEY_SYNC_ALL});
            super.start();
        }
    }

    @Override
    public void doTask(String pageId) {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("execute", (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u540c\u6b65\u5143\u6570\u636e\u5217\u8868\u65f6\u95f4\u53ef\u80fd\u8f83\u957f,\u662f\u5426\u7ee7\u7eed\uff1f", (String)"SyncMetaProgressFormPlugin_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBacks);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        try {
            if (StringUtils.equals((CharSequence)"execute", (CharSequence)messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                long dataSource = D.l((Object)this.getModel().getValue("datasourceid"));
                if (!this.hasLicense(dataSource)) {
                    this.getPageCache().put("text", ResManager.loadKDString((String)"\u8fde\u63a5\u6ca1\u6709\u8bb8\u53ef", (String)"SyncMetaProgressFormPlugin_2", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    this.getPageCache().put("startprogress", "false");
                    this.getPageCache().put("progress", "100");
                    return;
                }
                if (IscLicenseUtil.getTenantLicenseInfo().isExpired()) {
                    this.getPageCache().put("text", ResManager.loadKDString((String)"\u8bb8\u53ef\u5931\u6548\u7981\u540c\u6b65", (String)"SyncMetaProgressFormPlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    this.getPageCache().put("startprogress", "false");
                    this.getPageCache().put("progress", "100");
                    return;
                }
                boolean started = SyncMetaListTask.start((long)dataSource, (boolean)D.x((Object)this.getModel().getValue(IS_SYNC_ALL)), (String)this.getView().getPageId());
                if (!started) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u6e90\u6b63\u5728\u540c\u6b65\uff0c\u8bf7\u7a0d\u540e\u518d\u8fdb\u884c\u540c\u6b65...", (String)"SyncMetaProgressFormPlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                    this.resetState();
                } else {
                    this.getPageCache().put("text", ResManager.loadKDString((String)"\u540c\u6b65\u4e2d\uff0c\u8bf7\u7a0d\u5019.", (String)"SyncMetaProgressFormPlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
                }
            } else {
                this.resetState();
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private boolean hasLicense(long dataSourceId) {
        DynamicObject dataSource = BusinessDataServiceHelper.loadSingle((Object)dataSourceId, (String)"isc_data_source", (String)"dblink");
        if (dataSource != null) {
            long dblinkId = dataSource.getLong("dblink_id");
            return IscLicenseUtil.hasLicense((long)dblinkId);
        }
        return false;
    }

    public void resetState() {
        this.getModel().setValue(IS_SYNC_ALL, (Object)Boolean.FALSE);
        this.getView().setEnable(Boolean.TRUE, new String[]{"btnok", KEY_SYNC_ALL});
    }
}

