/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.tree;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.control.Control;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.list.BillList;
import kd.bos.list.events.QueryRealCountEvent;
import kd.bos.list.events.QueryRealCountListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.form.FormDataModel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.isc.iscb.util.dt.D;

public abstract class AbstractTemplateTreePlugin
extends AbstractListPlugin
implements TreeNodeClickListener,
SearchEnterListener {
    public static final String KEY_TREEVIEW = "treeviewap";
    public static final String KEY_BILLLIST = "billlistap";
    public static final String KEY_SEARCHE = "searchap";
    public static final String KEY_FILTER_CONTAINER = "filtercontainerap";
    public static final String KEY_CLASSIFICATION = "classification";
    public static final String APPID = "TV3/VDJ86RC";
    public static final String SRCSYSTEM = "srcsystem";
    public static final String TARSYSTEM = "tarsystem";
    public static final String CUSTOMSYSTEM = "customsystem";
    private static final Set<String> cateGoryName = new LinkedHashSet<String>(13);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.registerListener();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.refreshBillListCount();
    }

    private void registerListener() {
        this.addItemClickListeners(new String[]{KEY_CLASSIFICATION});
        TreeView treeView = (TreeView)this.getControl(KEY_TREEVIEW);
        treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        Search search = (Search)this.getControl(KEY_SEARCHE);
        search.addEnterListener((SearchEnterListener)this);
        BillList billList = (BillList)this.getControl(KEY_BILLLIST);
        billList.addQueryRealCountListener(new QueryRealCountListener(){

            public void queryRealCount(QueryRealCountEvent queryRealCountEvent) {
                AbstractTemplateTreePlugin.this.getPageCache().remove("filter");
            }
        });
    }

    private void refreshBillListCount() {
        String filter = D.s((Object)this.getPageCache().get("filter"));
        if (filter == null) {
            return;
        }
        BillList billList = (BillList)this.getControl(KEY_BILLLIST);
        QFilter qfilter = (QFilter)SerializationUtils.fromJsonString((String)filter, QFilter.class);
        billList.addSetFilterListener(event -> event.getQFilters().add(qfilter));
    }

    public void setFilter(QFilter filter) {
        this.getPageCache().put("filter", SerializationUtils.toJsonString((Object)filter));
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormDataModel source = (FormDataModel)e.getSource();
        String name = source.getDataEntityType().getName();
        if (this.isCateGory(name)) {
            this.initTree(null, this.getSystemCateGoryName(), this.getEntityTypeName());
        } else {
            this.initTree(null);
        }
    }

    private String getSystemCateGoryName() {
        AppParam apm = new AppParam();
        apm.setAppId(APPID);
        apm.setOrgId(Long.valueOf(OrgUnitServiceHelper.getRootOrgId()));
        try {
            String cateGoryName = D.s((Object)SystemParamServiceHelper.loadAppParameterFromCache((AppParam)apm, (String)"radiogroupfield"));
            return cateGoryName == null ? SRCSYSTEM : cateGoryName;
        }
        catch (Exception e) {
            return SRCSYSTEM;
        }
    }

    public void search(SearchEnterEvent event) {
        Search source = (Search)event.getSource();
        IDataModel model = source.getModel();
        String name = model.getDataEntityType().getName();
        String searchText = event.getText();
        if (this.isCateGory(name)) {
            this.initTreeBySearch(searchText);
        } else {
            this.initTree(searchText);
        }
    }

    private void initTreeBySearch(String searchText) {
        String category = D.s((Object)this.getModel().getValue(KEY_CLASSIFICATION));
        if (StringUtils.isEmpty((CharSequence)searchText)) {
            this.initTree(searchText, category, this.getEntityTypeName());
            return;
        }
        TreeNode treeNode = (TreeNode)JSON.parseObject((String)this.getPageCache().get(category), TreeNode.class);
        List children = treeNode.getChildren();
        ArrayList<TreeNode> searchNodes = new ArrayList<TreeNode>(1);
        this.getSearchNode(searchNodes, searchText, children);
        if (searchNodes.size() < 1) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5217\u8868\u4e2d\u6ca1\u6709\u627e\u5230\u5305\u542b (%s) \u5b57\u6bb5\u7684\u6570\u636e", (String)"AbstractTemplateTreePlugin_7", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), searchText));
            return;
        }
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        TreeNode searchNode = (TreeNode)searchNodes.get(0);
        tree.showNode(searchNode.getId());
        tree.treeNodeClick(searchNode.getParentid(), searchNode.getId());
        tree.focusNode(searchNode);
        this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u5217\u8868\u4e2d\u5df2\u627e\u5230\u5305\u542b (%s) \u5b57\u6bb5\u7684\u6570\u636e", (String)"AbstractTemplateTreePlugin_8", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), searchText));
    }

    private void getSearchNode(List<TreeNode> searchNodes, String searchText, List<TreeNode> children) {
        if (children != null && children.size() > 0) {
            for (TreeNode t : children) {
                if (searchNodes.size() > 0) break;
                List child = t.getChildren();
                String text = t.getText();
                if (text.contains(searchText)) {
                    searchNodes.add(t);
                    continue;
                }
                this.getSearchNode(searchNodes, searchText, child);
            }
        }
    }

    private void cleanCateGoryName() {
        cateGoryName.clear();
    }

    private boolean isCateGory(String name) {
        return cateGoryName.contains(name);
    }

    protected void initTree(String searchText) {
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        tree.deleteAllNodes();
        QFilter filter = null;
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            filter = new QFilter("name", "like", (Object)("%" + searchText + "%"));
        }
        DynamicObject[] dataSources = BusinessDataServiceHelper.load((String)"isc_data_source", (String)"id, number, name", (QFilter[])new QFilter[]{filter}, null);
        TreeNode rootNode = new TreeNode("", "root", ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf", (String)"AbstractTemplateTreePlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]));
        tree.addNode(rootNode);
        for (DynamicObject ds : dataSources) {
            TreeNode node = new TreeNode(rootNode.getId(), ds.getPkValue().toString(), ds.getString("name"));
            tree.addNode(node);
        }
        tree.expand(rootNode.getId());
        tree.focusNode(rootNode);
    }

    public void treeNodeClick(TreeNodeEvent evt) {
        Control source = (Control)evt.getSource();
        String name = source.getModel().getDataEntityType().getName();
        if (StringUtils.equals((CharSequence)source.getKey(), (CharSequence)KEY_TREEVIEW)) {
            Object nodeId = evt.getNodeId();
            this.getPageCache().put("focusnodeid", nodeId.toString());
            if (this.isCateGory(name)) {
                String category = D.s((Object)this.getModel().getValue(KEY_CLASSIFICATION));
                this.refreshBillList(nodeId, category);
            } else {
                this.refreshBillList(nodeId);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        if (KEY_CLASSIFICATION.equals(propName)) {
            String category = D.s((Object)this.getModel().getValue(KEY_CLASSIFICATION));
            this.initTree(null, category, this.getEntityTypeName());
        }
    }

    protected void initTree(String searchText, String category, String entityName) {
        TreeView tree = (TreeView)this.getControl(KEY_TREEVIEW);
        tree.deleteAllNodes();
        TreeNode rootNode = null;
        rootNode = SRCSYSTEM.equals(category) ? this.initTreeForSrcAndTar(tree, searchText, this.getSourceName(category, entityName)) : (TARSYSTEM.equals(category) ? this.initTreeForSrcAndTar(tree, searchText, this.getSourceName(category, entityName)) : this.initTreeForCategory(tree, searchText));
        this.getPageCache().put(category, SerializationUtils.toJsonString((Object)rootNode));
        tree.expand(rootNode.getId());
        tree.focusNode(rootNode);
        tree.treeNodeClick(rootNode.getParentid(), rootNode.getId());
        this.getModel().setValue(KEY_CLASSIFICATION, (Object)this.getCategoryValue(category));
        this.getView().updateView(KEY_CLASSIFICATION);
    }

    private String getCategoryValue(String category) {
        String entityName = this.getEntityTypeName();
        if (this.isExternalOrMetaschema(entityName)) {
            return TARSYSTEM.equals(category) ? SRCSYSTEM : category;
        }
        return category;
    }

    private String getEntityTypeName() {
        MainEntityType dataEntityType = this.getView().getModel().getDataEntityType();
        return dataEntityType.getName();
    }

    private String getSourceName(String category, String entityName) {
        if (StringUtils.isEmpty((CharSequence)entityName)) {
            return AbstractTemplateTreePlugin.getOtherClassification();
        }
        if ((this.isSrc(category) || this.isTar(category)) && this.isExternalOrMetaschema(entityName)) {
            return ResManager.loadKDString((String)"\u6570\u636e\u6e90", (String)"AbstractTemplateTreePlugin_4", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        if (SRCSYSTEM.equals(category)) {
            return ResManager.loadKDString((String)"\u6e90\u7cfb\u7edf", (String)"AbstractTemplateTreePlugin_3", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        if (TARSYSTEM.equals(category)) {
            return ResManager.loadKDString((String)"\u76ee\u6807\u7cfb\u7edf", (String)"AbstractTemplateTreePlugin_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
        }
        return AbstractTemplateTreePlugin.getOtherClassification();
    }

    private boolean isSrc(String category) {
        boolean b = false;
        if (SRCSYSTEM.equals(category)) {
            b = true;
        }
        return b;
    }

    private boolean isTar(String category) {
        boolean b = false;
        if (TARSYSTEM.equals(category)) {
            b = true;
        }
        return b;
    }

    private boolean isExternalOrMetaschema(String entityName) {
        boolean b = false;
        if ("isc_external_api".equals(entityName) || "isc_metaschema_api".equals(entityName)) {
            b = true;
        }
        return b;
    }

    private TreeNode initTreeForCategory(TreeView tree, String searchText) {
        String sortName = AbstractTemplateTreePlugin.getOtherClassification();
        QFilter filter = null;
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            filter = new QFilter("name", "like", (Object)("%" + searchText + "%"));
        }
        DynamicObject[] schemaSort = BusinessDataServiceHelper.load((String)"isc_schema_category", (String)"id, number, name, parent", (QFilter[])new QFilter[]{filter}, null);
        TreeNode rootNode = new TreeNode("", "root", sortName);
        tree.addNode(rootNode);
        for (DynamicObject dy : schemaSort) {
            if (!StringUtils.isBlank((CharSequence)dy.getString("parent")) && !"0".equals(dy.getString("parent"))) continue;
            TreeNode treeNode = new TreeNode(rootNode.getId(), dy.getPkValue().toString(), dy.getString("name"));
            this.recursiveAddChild(treeNode, schemaSort, dy);
            rootNode.addChild(treeNode);
        }
        return rootNode;
    }

    private void recursiveAddChild(TreeNode treeNode, DynamicObject[] schemaSort, DynamicObject ss) {
        String id = ss.getString("id");
        List childrenArea = Arrays.stream(schemaSort).filter(area -> id.equals(area.getString("parent.id"))).collect(Collectors.toList());
        if (!childrenArea.isEmpty()) {
            ArrayList<TreeNode> children = new ArrayList<TreeNode>(childrenArea.size());
            for (DynamicObject childClass : childrenArea) {
                TreeNode treeNodeTmp = new TreeNode(treeNode.getId(), childClass.getPkValue().toString(), childClass.getString("name"));
                this.recursiveAddChild(treeNodeTmp, schemaSort, childClass);
                children.add(treeNodeTmp);
            }
            treeNode.addChildren(children);
        }
    }

    private TreeNode initTreeForSrcAndTar(TreeView tree, String searchText, String sortName) {
        QFilter filter = null;
        if (StringUtils.isNotEmpty((CharSequence)searchText)) {
            filter = new QFilter("name", "like", (Object)("%" + searchText + "%"));
        }
        DynamicObject[] schemaSort = BusinessDataServiceHelper.load((String)"isc_data_source", (String)"id, number, name", (QFilter[])new QFilter[]{filter}, null);
        TreeNode rootNode = new TreeNode("", "root", sortName);
        tree.addNode(rootNode);
        for (DynamicObject ss : schemaSort) {
            TreeNode node = new TreeNode(rootNode.getId(), ss.getPkValue().toString(), ss.getString("name"));
            rootNode.addChild(node);
        }
        return rootNode;
    }

    private void refreshBillList(Object nodeId) {
        BillList billList = (BillList)this.getControl(KEY_BILLLIST);
        this.filterBillList(billList, nodeId.toString());
        billList.refresh();
        billList.clearSelection();
    }

    private void refreshBillList(Object nodeId, String category) {
        BillList billList = (BillList)this.getControl(KEY_BILLLIST);
        this.filterBillList(billList, nodeId.toString(), category);
        billList.refresh();
        billList.clearSelection();
    }

    abstract void filterBillList(BillList var1, String var2);

    abstract void filterBillList(BillList var1, String var2, String var3);

    private static String getOtherClassification() {
        return ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5206\u7c7b", (String)"AbstractTemplateTreePlugin_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]);
    }

    static {
        cateGoryName.add("isc_integration_schema");
        cateGoryName.add("isc_trigger_schema");
        cateGoryName.add("isc_service_flow_tree");
        cateGoryName.add("isc_converrule_api");
        cateGoryName.add("isc_external_api");
        cateGoryName.add("isc_schema_api");
        cateGoryName.add("isc_trigger_api");
        cateGoryName.add("isc_metaschema_api");
        cateGoryName.add("isc_external_api_f7");
        cateGoryName.add("isc_metaschema_api_f7");
        cateGoryName.add("isc_converrule_api_f7");
        cateGoryName.add("isc_schema_api_f7");
        cateGoryName.add("isc_trigger_api_f7");
    }
}

