/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.dc.tree;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.eas.Util;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class ApiTreeUtil {
    public static void setCategory(IFormView view) {
        Map params = view.getFormShowParameter().getCustomParams();
        Object nodeId = params.get("schema_category_id");
        if (!ObjectUtils.isEmpty(nodeId)) {
            view.getModel().setValue("schema_category", nodeId);
        }
    }

    public static void createApiForm(AbstractFormPlugin form, String entityName) {
        Map focusNode;
        String id = null;
        Control treeviewap = form.getView().getControl("treeviewap");
        id = null == treeviewap ? "root" : ((focusNode = ((TreeView)treeviewap).getTreeState().getFocusNode()) == null ? "root" : focusNode.get("id"));
        long nodeId = "root".equals(id) ? 0L : D.l((Object)id);
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("schema_category_id", nodeId);
        ApiTreeUtil.showBillByType(form, params, entityName);
    }

    private static void showBillByType(AbstractFormPlugin form, Map<String, Object> params, String entityName) {
        switch (entityName) {
            case "isc_apic_for_external_api": {
                FormOpener.showTabBill(form, entityName, null, params, null);
                break;
            }
            case "isc_apic_by_meta_schema": {
                FormOpener.showTabBill(form, entityName, null, params, null);
                break;
            }
            case "isc_apic_by_vc": 
            case "isc_apic_by_dc_trigger": 
            case "isc_apic_by_dc_schema": 
            case "isc_apic_by_sf": {
                FormOpener.showTabBill(form, entityName, null, params, null);
                break;
            }
            default: {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u53c2\u6570\uff1a%s", (String)"ApiTreeUtil_5", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), entityName));
            }
        }
    }

    public static void modifyCategory(ClosedCallBackEvent evt, IFormView view, String entityName) {
        Object result;
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"importschema")) {
            view.invokeOperation("refresh");
        } else if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"modify_category") && (result = evt.getReturnData()) instanceof ListSelectedRowCollection) {
            try {
                ListSelectedRowCollection listSelectedRowCollection = (ListSelectedRowCollection)result;
                if (!listSelectedRowCollection.isEmpty()) {
                    ApiTreeUtil.modifyCategory(listSelectedRowCollection.get(0).getPrimaryKeyValue(), view, entityName);
                    view.showSuccessNotification(ResManager.loadKDString((String)"\u6279\u91cf\u4fee\u6539\u5206\u7c7b\u6210\u529f\u3002", (String)"ApiTreeUtil_1", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), Integer.valueOf(3000));
                    view.invokeOperation("refresh");
                }
            }
            catch (Exception e) {
                FormOpener.showErrorMessage(view, e);
            }
        }
    }

    private static void modifyCategory(Object categoryPk, IFormView view, String entityName) {
        ListSelectedRowCollection selectedRows = ((IListView)view).getSelectedRows();
        for (ListSelectedRow selectedRow : selectedRows) {
            Object schemaPk = selectedRow.getPrimaryKeyValue();
            DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)schemaPk, (String)entityName);
            String properties = ApiTreeUtil.getPropertiesByEntityType(entityName);
            if (null != data && null != data.getDataEntityType().getProperties().get((Object)properties)) {
                if (D.l((Object)data.get(properties + "_id")) == D.l((Object)categoryPk)) continue;
                data.set(properties + "_id", categoryPk);
                data.set("modifier", (Object)RequestContext.get().getUserId());
                data.set("modifytime", (Object)Timestamp.valueOf(LocalDateTime.now()));
                Util.save((DynamicObject)data);
                continue;
            }
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u5b9e\u4f53\u5bf9\u8c61(%1$s)\u662f\u5426\u5b58\u5728id\u4e3a\uff1a%2$s\u7684\u6570\u636e\uff0c\u6216\u8005\u68c0\u67e5\u8be5\u5bf9\u8c61\u662f\u5426\u5b58\u5728\u5c5e\u6027\uff1a%3$s", (String)"ApiTreeUtil_6", (String)"isc-iscb-platform-formplugin", (Object[])new Object[0]), entityName, schemaPk, properties));
        }
    }

    public static String getPropertiesByEntityType(String entityName) {
        String properties = "schema_category";
        if ("isc_apic_by_sf".equals(entityName) || "isc_apic_script".equals(entityName) || "isc_apic_script_x".equals(entityName)) {
            properties = "group";
        }
        return properties;
    }
}

